/*
 * Decompiled with CFR 0.152.
 */
package me.TreeOfSelf.PandaCommandWhitelist.mixin;

import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.LiteralCommandNode;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.List;
import java.util.Map;
import me.TreeOfSelf.PandaCommandWhitelist.CommandWhiteListConfig;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_2170.class})
public class CommandManagerMixin {
    private static final ThreadLocal<Deque<String>> COMMAND_PATH = ThreadLocal.withInitial(ArrayDeque::new);

    @Inject(method={"deepCopyNodes"}, at={@At(value="HEAD")})
    private static <S> void beforeDeepCopy(CommandNode<S> root, CommandNode<S> newRoot, S source, Map<CommandNode<S>, CommandNode<S>> nodes, CallbackInfo ci) {
        if (newRoot instanceof LiteralCommandNode) {
            COMMAND_PATH.get().addLast(((LiteralCommandNode)newRoot).getLiteral());
        }
    }

    @Inject(method={"deepCopyNodes"}, at={@At(value="RETURN")})
    private static <S> void afterDeepCopy(CommandNode<S> root, CommandNode<S> newRoot, S source, Map<CommandNode<S>, CommandNode<S>> nodes, CallbackInfo ci) {
        if (newRoot instanceof LiteralCommandNode && !COMMAND_PATH.get().isEmpty()) {
            COMMAND_PATH.get().removeLast();
        }
    }

    @Redirect(method={"deepCopyNodes"}, at=@At(value="INVOKE", target="Lcom/mojang/brigadier/tree/CommandNode;canUse(Ljava/lang/Object;)Z"))
    private static <S> boolean checkCanUse(CommandNode<S> commandNode, Object source) {
        if (!commandNode.canUse(source)) {
            return false;
        }
        if (!(source instanceof class_2168)) {
            return true;
        }
        class_2168 serverSource = (class_2168)source;
        if (serverSource.method_9259(4)) {
            return true;
        }
        if (!(commandNode instanceof LiteralCommandNode)) {
            return true;
        }
        ArrayList<String> pathParts = new ArrayList<String>((Collection)COMMAND_PATH.get());
        pathParts.add(((LiteralCommandNode)commandNode).getLiteral());
        if (pathParts.isEmpty()) {
            return true;
        }
        String fullPath = String.join((CharSequence)" ", pathParts);
        List<String> allowedCommands = CommandWhiteListConfig.getWhitelistedCommands();
        for (String whitelisted : allowedCommands) {
            String baseCommand;
            if (whitelisted.equals(fullPath)) {
                return true;
            }
            if (!whitelisted.endsWith(" *") || !fullPath.equals(baseCommand = whitelisted.substring(0, whitelisted.length() - 2)) && !fullPath.startsWith(baseCommand + " ")) continue;
            return true;
        }
        return false;
    }
}

