/*
 * Decompiled with CFR 0.152.
 */
package lc.cit.list;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import lc.cit.list.BundleWrapper;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3298;
import net.minecraft.class_3300;

@Environment(value=EnvType.CLIENT)
public class CitScanner {
    private static final Gson GSON = new Gson();

    public static BundleWrapper getAllCustomNameCITs() {
        ArrayList<String> result = new ArrayList<String>();
        ArrayList<String> resultItem = new ArrayList<String>();
        class_3300 rm = class_310.method_1551().method_1478();
        ArrayList<String> nameList = new ArrayList<String>();
        ArrayList<String> conditionList = new ArrayList<String>();
        ArrayList<String> packList = new ArrayList<String>();
        try {
            Map resources = rm.method_14488("items", id -> id.method_12832().endsWith(".json"));
            for (Map.Entry entry : resources.entrySet()) {
                class_2960 id2 = (class_2960)entry.getKey();
                class_3298 res = (class_3298)entry.getValue();
                try (InputStreamReader reader = new InputStreamReader(res.method_14482(), StandardCharsets.UTF_8);){
                    JsonObject root = (JsonObject)GSON.fromJson((Reader)reader, JsonObject.class);
                    if (root == null) continue;
                    List<JsonObject> selectBlocks = CitScanner.findSelectBlocks((JsonElement)root);
                    for (JsonObject model : selectBlocks) {
                        if (!model.has("property") || !model.has("component")) continue;
                        String property = model.get("property").getAsString();
                        String component = model.get("component").getAsString();
                        if (!"minecraft:component".equals(property) || !"minecraft:custom_name".equals(component) || !model.has("cases") || !model.get("cases").isJsonArray()) continue;
                        JsonArray cases = model.getAsJsonArray("cases");
                        String itemName = id2.method_12832().replace("items/", "").replace(".json", "");
                        String packName = res.method_45304().method_56926().comp_2330().toString();
                        packName = packName.replace("literal{", "").replace("}", "");
                        for (JsonElement el : cases) {
                            JsonObject caseObj;
                            if (!el.isJsonObject() || !(caseObj = el.getAsJsonObject()).has("when")) continue;
                            String when = caseObj.get("when").getAsString();
                            nameList.add(itemName);
                            conditionList.add(when);
                            packList.add(packName);
                            String ite = id2.method_12832().replace(".json", "");
                            ite = ite.replaceFirst(".*/", "");
                            resultItem.add(ite);
                        }
                    }
                }
                catch (Exception e) {
                    System.err.println("[CIT Scanner] Error parsing " + String.valueOf(id2) + ": " + e.getMessage());
                }
            }
            if (nameList.size() > 0) {
                int itemNameLenght = Collections.max(nameList, Comparator.comparing(String::length)).length();
                int conditionListLenght = Collections.max(conditionList, Comparator.comparing(String::length)).length();
                int packListLenght = Collections.max(packList, Comparator.comparing(String::length)).length();
                for (int i = 0; i < packList.size(); ++i) {
                    result.add(String.format("%-" + itemNameLenght + "s", nameList.get(i)) + " - " + String.format("%-" + conditionListLenght + "s", conditionList.get(i)) + " - " + String.format("%-" + packListLenght + "s", packList.get(i)));
                }
            }
        }
        catch (Exception e) {
            System.err.println("[CIT Scanner] Resource scan error: " + e.getMessage());
        }
        System.out.println("[CIT Scanner] Scan Finished");
        return new BundleWrapper(resultItem, result, conditionList);
    }

    private static List<JsonObject> findSelectBlocks(JsonElement element) {
        ArrayList<JsonObject> found;
        block5: {
            block4: {
                found = new ArrayList<JsonObject>();
                if (element == null || element.isJsonNull()) {
                    return found;
                }
                if (!element.isJsonObject()) break block4;
                JsonObject obj = element.getAsJsonObject();
                if (obj.has("type") && "minecraft:select".equals(obj.get("type").getAsString())) {
                    found.add(obj);
                }
                for (Map.Entry e : obj.entrySet()) {
                    found.addAll(CitScanner.findSelectBlocks((JsonElement)e.getValue()));
                }
                break block5;
            }
            if (!element.isJsonArray()) break block5;
            for (JsonElement e : element.getAsJsonArray()) {
                found.addAll(CitScanner.findSelectBlocks(e));
            }
        }
        return found;
    }
}

