/*
 * Decompiled with CFR 0.152.
 */
package com.pixelindiedev.faster_copper_golem;

import com.pixelindiedev.faster_copper_golem.config.ConfigSyncPayload;
import com.pixelindiedev.faster_copper_golem.config.InteractionTime;
import com.pixelindiedev.faster_copper_golem.config.ModModConfig;
import com.pixelindiedev.faster_copper_golem.config.RememberCountEnum;
import com.pixelindiedev.faster_copper_golem.config.SearchRadiusEnum;
import com.pixelindiedev.faster_copper_golem.mixin.MoveItemsTaskAccessor;
import java.lang.runtime.SwitchBootstraps;
import java.util.Collections;
import java.util.Set;
import java.util.WeakHashMap;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.fabricmc.fabric.api.networking.v1.PayloadTypeRegistry;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_11568;
import net.minecraft.class_3222;
import net.minecraft.class_8710;
import net.minecraft.server.MinecraftServer;

public class Faster_copper_golem
implements ModInitializer {
    private static final Set<class_11568> loadedMoveItemTasks = Collections.newSetFromMap(new WeakHashMap());
    public static ModModConfig CONFIG;
    private static int interactionTimeCache;
    private static int cooldownTimeCache;

    public static void onServerTick(MinecraftServer server) {
        if (CONFIG.hasExternalChange()) {
            CONFIG = ModModConfig.load();
            Faster_copper_golem.clearCache();
            Faster_copper_golem.UpdateTasks();
            for (class_3222 player : server.method_3760().method_14571()) {
                Faster_copper_golem.sendConfigToPlayer(player);
            }
        }
    }

    private static void clearCache() {
        interactionTimeCache = -1;
        cooldownTimeCache = -1;
    }

    public static float getSpeedMultiplier() {
        InteractionTime interactionTime = Faster_copper_golem.CONFIG.gollemInteractionTime;
        int n = 0;
        return switch (SwitchBootstraps.enumSwitch("enumSwitch", new Object[]{"Fast", "Faster", "Fastest"}, (InteractionTime)interactionTime, n)) {
            case 0 -> 0.5f;
            case 1 -> 0.25f;
            case 2 -> 0.05f;
            default -> 1.0f;
        };
    }

    public static int getInteractionTime(int originalTime) {
        if (interactionTimeCache == -1) {
            interactionTimeCache = Math.round((float)originalTime * Faster_copper_golem.getSpeedMultiplier());
        }
        return interactionTimeCache;
    }

    public static int getCooldownTime(int originalTime) {
        if (cooldownTimeCache == -1) {
            cooldownTimeCache = Math.round((float)originalTime * Faster_copper_golem.getSpeedMultiplier());
        }
        return cooldownTimeCache;
    }

    public static int getInteractionTime() {
        if (interactionTimeCache == -1) {
            interactionTimeCache = Math.round(60.0f * Faster_copper_golem.getSpeedMultiplier());
        }
        return interactionTimeCache;
    }

    public static int getCooldownTime() {
        if (cooldownTimeCache == -1) {
            cooldownTimeCache = Math.round(140.0f * Faster_copper_golem.getSpeedMultiplier());
        }
        return cooldownTimeCache;
    }

    public static float getMovementSpeed() {
        InteractionTime interactionTime = Faster_copper_golem.CONFIG.gollemMovingSpeed;
        int n = 0;
        return switch (SwitchBootstraps.enumSwitch("enumSwitch", new Object[]{"Fast", "Faster", "Fastest"}, (InteractionTime)interactionTime, n)) {
            case 0 -> 1.2f;
            case 1 -> 1.5f;
            case 2 -> 2.0f;
            default -> 1.0f;
        };
    }

    public static int getMaxStackSize() {
        return Faster_copper_golem.CONFIG.gollemMaxStackSize;
    }

    public static int getMaxChestsRemembered(int originalCount) {
        RememberCountEnum rememberCountEnum = Faster_copper_golem.CONFIG.gollemAmountChestRemembered;
        int n = 0;
        return switch (SwitchBootstraps.enumSwitch("enumSwitch", new Object[]{"Many", "More", "Most", "Extreme"}, (RememberCountEnum)rememberCountEnum, n)) {
            case 0 -> (int)((float)originalCount * 2.5f);
            case 1 -> originalCount * 5;
            case 2 -> originalCount * 12;
            case 3 -> (int)((float)originalCount * 102.4f);
            default -> 10;
        };
    }

    public static int getMaxChestsRemembered() {
        RememberCountEnum rememberCountEnum = Faster_copper_golem.CONFIG.gollemAmountChestRemembered;
        int n = 0;
        return switch (SwitchBootstraps.enumSwitch("enumSwitch", new Object[]{"Many", "More", "Most", "Extreme"}, (RememberCountEnum)rememberCountEnum, n)) {
            case 0 -> 25;
            case 1 -> 50;
            case 2 -> 120;
            case 3 -> 1024;
            default -> 10;
        };
    }

    public static int getHorizontalSearchRadius() {
        SearchRadiusEnum searchRadiusEnum = Faster_copper_golem.CONFIG.gollemSearchRadius;
        int n = 0;
        return switch (SwitchBootstraps.enumSwitch("enumSwitch", new Object[]{"Large", "Larger", "Largest", "Extreme"}, (SearchRadiusEnum)searchRadiusEnum, n)) {
            case 0 -> 64;
            case 1 -> 80;
            case 2 -> 100;
            case 3 -> 500;
            default -> 32;
        };
    }

    public static int getVerticalSearchRadius() {
        SearchRadiusEnum searchRadiusEnum = Faster_copper_golem.CONFIG.gollemSearchRadius;
        int n = 0;
        return switch (SwitchBootstraps.enumSwitch("enumSwitch", new Object[]{"Large", "Larger", "Largest", "Extreme"}, (SearchRadiusEnum)searchRadiusEnum, n)) {
            case 0 -> 16;
            case 1 -> 25;
            case 2 -> 50;
            case 3 -> 100;
            default -> 8;
        };
    }

    public static void UpdateTasks() {
        int hori = Faster_copper_golem.getHorizontalSearchRadius();
        int verti = Faster_copper_golem.getVerticalSearchRadius();
        float speed = Faster_copper_golem.getMovementSpeed();
        for (class_11568 task : loadedMoveItemTasks) {
            ((MoveItemsTaskAccessor)task).setHorizontalRange(hori);
            ((MoveItemsTaskAccessor)task).setVerticalRange(verti);
            ((MoveItemsTaskAccessor)task).setSpeed(speed);
            Faster_copper_golem.AddTask(task);
        }
    }

    public static void AddTask(class_11568 task) {
        loadedMoveItemTasks.add(task);
    }

    public static void sendConfigToPlayer(class_3222 player) {
        if (ServerPlayNetworking.canSend((class_3222)player, ConfigSyncPayload.ID)) {
            ConfigSyncPayload payload = new ConfigSyncPayload(Faster_copper_golem.getSpeedMultiplier(), Faster_copper_golem.getMovementSpeed(), Faster_copper_golem.getInteractionTime(), Faster_copper_golem.getCooldownTime(), Faster_copper_golem.getMaxStackSize(), Faster_copper_golem.getMaxChestsRemembered(), Faster_copper_golem.getHorizontalSearchRadius(), Faster_copper_golem.getVerticalSearchRadius());
            ServerPlayNetworking.send((class_3222)player, (class_8710)payload);
        }
    }

    public void onInitialize() {
        CONFIG = ModModConfig.load();
        if (Faster_copper_golem.CONFIG.lastModified == 0L) {
            Faster_copper_golem.CONFIG.lastModified = ModModConfig.configFile.lastModified();
        }
        ServerTickEvents.START_SERVER_TICK.register(Faster_copper_golem::onServerTick);
        PayloadTypeRegistry.playS2C().register(ConfigSyncPayload.ID, ConfigSyncPayload.CODEC);
        ServerPlayConnectionEvents.JOIN.register((handler, sender, server) -> Faster_copper_golem.sendConfigToPlayer(handler.field_14140));
    }

    static {
        interactionTimeCache = -1;
        cooldownTimeCache = -1;
    }
}

