/*
 * Decompiled with CFR 0.152.
 */
package com.pixelindiedev.faster_copper_golem.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.pixelindiedev.faster_copper_golem.config.InteractionTime;
import com.pixelindiedev.faster_copper_golem.config.RememberCountEnum;
import com.pixelindiedev.faster_copper_golem.config.SearchRadiusEnum;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import net.fabricmc.loader.api.FabricLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModModConfig {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final String FILE_NAME = "faster_copper_golem.json";
    public static final File configFile = new File(FabricLoader.getInstance().getConfigDir().toFile(), "faster_copper_golem.json");
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"fasterCopperGolem");
    public InteractionTime gollemInteractionTime = InteractionTime.Fast;
    public int gollemMaxStackSize = 24;
    public RememberCountEnum gollemAmountChestRemembered = RememberCountEnum.Many;
    public SearchRadiusEnum gollemSearchRadius = SearchRadiusEnum.Vanilla;
    public InteractionTime gollemMovingSpeed = InteractionTime.Vanilla;
    public transient long lastModified = 0L;

    public static ModModConfig load() {
        ModModConfig config = new ModModConfig();
        JsonObject obj = new JsonObject();
        boolean changed = false;
        if (configFile.exists()) {
            try (FileReader reader = new FileReader(configFile);){
                JsonElement element = JsonParser.parseReader((Reader)reader);
                if (element.isJsonObject()) {
                    obj = element.getAsJsonObject();
                }
            }
            catch (IOException e) {
                LOGGER.error("Failed to read config, restoring defaults.", (Throwable)e);
                config = new ModModConfig();
            }
        } else {
            LOGGER.warn("Config file not found, creating a new one.");
            config = new ModModConfig();
            changed = true;
        }
        if (!obj.has("gollemInteractionTime")) {
            LOGGER.warn("Missing option 'gollemInteractionTime', adding default (Fast).");
            obj.addProperty("gollemInteractionTime", InteractionTime.Fast.name());
            changed = true;
        }
        if (!obj.has("gollemMaxStackSize")) {
            LOGGER.warn("Missing option 'gollemMaxStackSize', adding default (24).");
            obj.addProperty("gollemMaxStackSize", (Number)24);
            changed = true;
        }
        if (!obj.has("gollemAmountChestRemembered")) {
            LOGGER.warn("Missing option 'gollemAmountChestRemembered', adding default (Many).");
            obj.addProperty("gollemAmountChestRemembered", RememberCountEnum.Many.name());
            changed = true;
        }
        if (!obj.has("gollemSearchRadius")) {
            LOGGER.warn("Missing option 'gollemSearchRadius', adding default (Vanilla).");
            obj.addProperty("gollemSearchRadius", SearchRadiusEnum.Vanilla.name());
            changed = true;
        }
        if (!obj.has("gollemMovingSpeed")) {
            LOGGER.warn("Missing option 'gollemMovingSpeed', adding default (Vanilla).");
            obj.addProperty("gollemMovingSpeed", InteractionTime.Vanilla.name());
            changed = true;
        }
        config = (ModModConfig)GSON.fromJson((JsonElement)obj, ModModConfig.class);
        if (changed) {
            config.save();
        }
        config.lastModified = configFile.lastModified();
        return config;
    }

    public void save() {
        File configFile = new File(FabricLoader.getInstance().getConfigDir().toFile(), FILE_NAME);
        try (FileWriter writer = new FileWriter(configFile);){
            GSON.toJson((Object)this, (Appendable)writer);
            this.lastModified = configFile.lastModified();
        }
        catch (IOException e) {
            LOGGER.error("Failed to save config:", (Throwable)e);
        }
    }

    public boolean hasExternalChange() {
        return configFile.exists() && configFile.lastModified() != this.lastModified;
    }
}

