/*
 * Decompiled with CFR 0.152.
 */
package com.github.quiltservertools.ledger.actions;

import com.github.quiltservertools.ledger.actions.AbstractActionType;
import com.github.quiltservertools.ledger.actionutils.Preview;
import com.github.quiltservertools.ledger.utility.ExtensionsKt;
import com.github.quiltservertools.ledger.utility.InspectionManagerKt;
import com.github.quiltservertools.ledger.utility.ItemChangeLogicKt;
import com.github.quiltservertools.ledger.utility.NbtUtils;
import com.github.quiltservertools.ledger.utility.TextColorPallet;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.class_1263;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2168;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2281;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_2583;
import net.minecraft.class_2586;
import net.minecraft.class_2595;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3715;
import net.minecraft.class_3722;
import net.minecraft.class_3954;
import net.minecraft.class_5250;
import net.minecraft.class_5455;
import net.minecraft.class_7225;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b&\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000f\u0010\u0005\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0017\u0010\n\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\u0007H\u0002\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0017\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\r\u001a\u00020\fH\u0016\u00a2\u0006\u0004\b\u000f\u0010\u0010J'\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u0015H\u0004\u00a2\u0006\u0004\b\u0018\u0010\u0019J/\u0010\u001c\u001a\u00020\u00172\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\u0016\u001a\u00020\u0015H\u0002\u00a2\u0006\u0004\b\u001c\u0010\u001dJ\u0019\u0010!\u001a\u0004\u0018\u00010 2\u0006\u0010\u001f\u001a\u00020\u001eH\u0002\u00a2\u0006\u0004\b!\u0010\"J\u0017\u0010#\u001a\u00020\u00152\u0006\u0010\b\u001a\u00020\u0007H\u0004\u00a2\u0006\u0004\b#\u0010$J\u0017\u0010%\u001a\u00020\u00152\u0006\u0010\b\u001a\u00020\u0007H\u0004\u00a2\u0006\u0004\b%\u0010$\u00a8\u0006&"}, d2={"Lcom/github/quiltservertools/ledger/actions/ItemChangeActionType;", "Lcom/github/quiltservertools/ledger/actions/AbstractActionType;", "<init>", "()V", "", "getTranslationType", "()Ljava/lang/String;", "Lnet/minecraft/server/MinecraftServer;", "server", "Lnet/minecraft/class_1799;", "getStack", "(Lnet/minecraft/server/MinecraftServer;)Lnet/minecraft/class_1799;", "Lnet/minecraft/class_2168;", "source", "Lnet/minecraft/class_2561;", "getObjectMessage", "(Lnet/minecraft/class_2168;)Lnet/minecraft/class_2561;", "Lcom/github/quiltservertools/ledger/actionutils/Preview;", "preview", "Lnet/minecraft/class_3222;", "player", "", "insert", "", "previewItemChange", "(Lcom/github/quiltservertools/ledger/actionutils/Preview;Lnet/minecraft/class_3222;Z)V", "Lnet/minecraft/class_2338;", "pos", "addPreview", "(Lcom/github/quiltservertools/ledger/actionutils/Preview;Lnet/minecraft/class_3222;Lnet/minecraft/class_2338;Z)V", "Lnet/minecraft/class_3218;", "world", "Lnet/minecraft/class_1263;", "getInventory", "(Lnet/minecraft/class_3218;)Lnet/minecraft/class_1263;", "removeMatchingItem", "(Lnet/minecraft/server/MinecraftServer;)Z", "addItem", "ledger"})
@SourceDebugExtension(value={"SMAP\nItemChangeActionType.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ItemChangeActionType.kt\ncom/github/quiltservertools/ledger/actions/ItemChangeActionType\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,133:1\n1#2:134\n*E\n"})
public abstract class ItemChangeActionType
extends AbstractActionType {
    @Override
    @NotNull
    public String getTranslationType() {
        return "item";
    }

    private final class_1799 getStack(MinecraftServer server) {
        String string = this.getExtraData();
        class_2960 class_29602 = this.getObjectIdentifier();
        class_5455.class_6890 class_68902 = server.method_30611();
        Intrinsics.checkNotNullExpressionValue((Object)class_68902, (String)"getRegistryManager(...)");
        return NbtUtils.INSTANCE.itemFromProperties(string, class_29602, (class_7225.class_7874)class_68902);
    }

    @Override
    @NotNull
    public class_2561 getObjectMessage(@NotNull class_2168 source) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        MinecraftServer minecraftServer = source.method_9211();
        Intrinsics.checkNotNullExpressionValue((Object)minecraftServer, (String)"getServer(...)");
        class_1799 stack = this.getStack(minecraftServer);
        class_5250 class_52502 = ExtensionsKt.literal(stack.method_7947() + " ").method_10852(stack.method_63693()).method_10862(TextColorPallet.INSTANCE.getSecondaryVariant()).method_27694(arg_0 -> ItemChangeActionType.getObjectMessage$lambda$0(stack, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)class_52502, (String)"styled(...)");
        return (class_2561)class_52502;
    }

    protected final void previewItemChange(@NotNull Preview preview2, @NotNull class_3222 player, boolean insert) {
        class_2680 state;
        class_3218 world;
        Intrinsics.checkNotNullParameter((Object)preview2, (String)"preview");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        MinecraftServer minecraftServer = player.method_51469().method_8503();
        Intrinsics.checkNotNullExpressionValue((Object)minecraftServer, (String)"getServer(...)");
        class_3218 class_32182 = world = ExtensionsKt.getWorld(minecraftServer, this.getWorld());
        class_2680 class_26802 = state = class_32182 != null ? class_32182.method_8320(this.getPos()) : null;
        if (class_26802 != null) {
            class_2338 otherPos;
            boolean it = class_26802.method_27852(class_2246.field_10034);
            boolean bl = false;
            if (it && (otherPos = InspectionManagerKt.getOtherChestSide(state, this.getPos())) != null) {
                this.addPreview(preview2, player, otherPos, insert);
            }
        }
        this.addPreview(preview2, player, this.getPos(), insert);
    }

    private final void addPreview(Preview preview2, class_3222 player, class_2338 pos, boolean insert) {
        List list = preview2.getModifiedItems().compute(pos, (arg_0, arg_1) -> ItemChangeActionType.addPreview$lambda$3(ItemChangeActionType::addPreview$lambda$2, arg_0, arg_1));
        if (list != null) {
            MinecraftServer minecraftServer = player.method_51469().method_8503();
            Intrinsics.checkNotNullExpressionValue((Object)minecraftServer, (String)"getServer(...)");
            list.add(new Pair((Object)this.getStack(minecraftServer), (Object)insert));
        }
    }

    private final class_1263 getInventory(class_3218 world) {
        class_1263 inventory = null;
        class_2680 blockState = world.method_8320(this.getPos());
        class_2248 block = blockState.method_26204();
        if (block instanceof class_3954) {
            inventory = (class_1263)((class_3954)block).method_17680(blockState, (class_1936)world, this.getPos());
        } else if (world.method_8321(this.getPos()) != null) {
            class_2586 class_25862 = world.method_8321(this.getPos());
            Intrinsics.checkNotNull((Object)class_25862);
            class_2586 blockEntity = class_25862;
            if (blockEntity instanceof class_1263 && (inventory = (class_1263)blockEntity) instanceof class_2595 && block instanceof class_2281) {
                inventory = class_2281.method_17458((class_2281)((class_2281)block), (class_2680)blockState, (class_1937)((class_1937)world), (class_2338)this.getPos(), (boolean)true);
            }
        }
        return inventory;
    }

    protected final boolean removeMatchingItem(@NotNull MinecraftServer server) {
        class_1263 inventory;
        class_3218 world;
        Intrinsics.checkNotNullParameter((Object)server, (String)"server");
        class_3218 class_32182 = world = ExtensionsKt.getWorld(server, this.getWorld());
        if (class_32182 != null) {
            class_3218 it = class_32182;
            boolean bl = false;
            v1 = this.getInventory(it);
        } else {
            v1 = inventory = null;
        }
        if (world != null) {
            class_2586 blockEntity;
            class_1799 rollbackStack = this.getStack(server);
            if (inventory != null) {
                return ItemChangeLogicKt.removeMatchingItem(rollbackStack, inventory);
            }
            if ((rollbackStack.method_31574(class_1802.field_8674) || rollbackStack.method_31574(class_1802.field_8360)) && (blockEntity = world.method_8321(this.getPos())) instanceof class_3722) {
                ((class_3722)blockEntity).method_17513(class_1799.field_8037);
                class_3715.method_17473(null, (class_1937)((class_1937)world), (class_2338)this.getPos(), (class_2680)((class_3722)blockEntity).method_11010(), (boolean)false);
                return true;
            }
        }
        return false;
    }

    protected final boolean addItem(@NotNull MinecraftServer server) {
        class_1263 inventory;
        class_3218 world;
        Intrinsics.checkNotNullParameter((Object)server, (String)"server");
        class_3218 class_32182 = world = ExtensionsKt.getWorld(server, this.getWorld());
        if (class_32182 != null) {
            class_3218 it = class_32182;
            boolean bl = false;
            v1 = this.getInventory(it);
        } else {
            v1 = inventory = null;
        }
        if (world != null) {
            class_2586 blockEntity;
            class_1799 rollbackStack = this.getStack(server);
            if (inventory != null) {
                return ItemChangeLogicKt.addItem(rollbackStack, inventory);
            }
            if ((rollbackStack.method_31574(class_1802.field_8674) || rollbackStack.method_31574(class_1802.field_8360)) && (blockEntity = world.method_8321(this.getPos())) instanceof class_3722 && !((class_3722)blockEntity).method_17522()) {
                ((class_3722)blockEntity).method_17513(rollbackStack);
                class_3715.method_17473(null, (class_1937)((class_1937)world), (class_2338)this.getPos(), (class_2680)((class_3722)blockEntity).method_11010(), (boolean)true);
                return true;
            }
        }
        return false;
    }

    private static final class_2583 getObjectMessage$lambda$0(class_1799 $stack, class_2583 it) {
        return it.method_10949((class_2568)new class_2568.class_10612($stack));
    }

    private static final List addPreview$lambda$2(class_2338 class_23382, List list) {
        Intrinsics.checkNotNullParameter((Object)class_23382, (String)"<unused var>");
        List list2 = list;
        if (list2 == null) {
            list2 = new ArrayList();
        }
        return list2;
    }

    private static final List addPreview$lambda$3(Function2 $tmp0, Object p0, Object p1) {
        return (List)$tmp0.invoke(p0, p1);
    }
}

