/*
 * Decompiled with CFR 0.152.
 */
package com.github.quiltservertools.ledger.actionutils;

import com.github.quiltservertools.ledger.actions.ActionType;
import com.github.quiltservertools.ledger.actionutils.ActionSearchParams;
import com.github.quiltservertools.ledger.commands.subcommands.RestoreCommand;
import com.github.quiltservertools.ledger.commands.subcommands.RollbackCommand;
import com.github.quiltservertools.ledger.mixin.preview.EntityTrackerEntryAccessor;
import com.github.quiltservertools.ledger.utility.TextColorPallet;
import com.mojang.brigadier.context.CommandContext;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.class_1297;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_2168;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2596;
import net.minecraft.class_2626;
import net.minecraft.class_3222;
import net.minecraft.class_3231;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010%\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001:\u00010B-\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\u0006\u0010\n\u001a\u00020\t\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0015\u0010\u000e\u001a\u00020\r2\u0006\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0017\u0010\u0010\u001a\u00020\r2\u0006\u0010\b\u001a\u00020\u0007H\u0002\u00a2\u0006\u0004\b\u0010\u0010\u000fJ\u0017\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0012\u001a\u00020\u0011H\u0002\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u001f\u0010\u001a\u001a\u00020\r2\u0010\u0010\u0019\u001a\f\u0012\u0004\u0012\u00020\u00170\u0016j\u0002`\u0018\u00a2\u0006\u0004\b\u001a\u0010\u001bR\u0014\u0010\u0003\u001a\u00020\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u0010\u001cR\u0014\u0010\n\u001a\u00020\t8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\n\u0010\u001dR\u001d\u0010 \u001a\b\u0012\u0004\u0012\u00020\u001f0\u001e8\u0006\u00a2\u0006\f\n\u0004\b \u0010!\u001a\u0004\b\"\u0010#R\u001d\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00110\u001e8\u0006\u00a2\u0006\f\n\u0004\b$\u0010!\u001a\u0004\b%\u0010#R\u001d\u0010&\u001a\b\u0012\u0004\u0012\u00020\u00110\u001e8\u0006\u00a2\u0006\f\n\u0004\b&\u0010!\u001a\u0004\b'\u0010#R5\u0010,\u001a \u0012\u0004\u0012\u00020\u001f\u0012\u0016\u0012\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020+\u0012\u0004\u0012\u00020\u00130*0)0(8\u0006\u00a2\u0006\f\n\u0004\b,\u0010-\u001a\u0004\b.\u0010/\u00a8\u00061"}, d2={"Lcom/github/quiltservertools/ledger/actionutils/Preview;", "", "Lcom/github/quiltservertools/ledger/actionutils/ActionSearchParams;", "params", "", "Lcom/github/quiltservertools/ledger/actions/ActionType;", "actions", "Lnet/minecraft/class_3222;", "player", "Lcom/github/quiltservertools/ledger/actionutils/Preview$Type;", "type", "<init>", "(Lcom/github/quiltservertools/ledger/actionutils/ActionSearchParams;Ljava/util/List;Lnet/minecraft/class_3222;Lcom/github/quiltservertools/ledger/actionutils/Preview$Type;)V", "", "cancel", "(Lnet/minecraft/class_3222;)V", "cleanup", "Lnet/minecraft/class_3231;", "entityTrackerEntry", "", "isEntityPresent", "(Lnet/minecraft/class_3231;)Z", "Lcom/mojang/brigadier/context/CommandContext;", "Lnet/minecraft/class_2168;", "Lcom/github/quiltservertools/ledger/utility/Context;", "context", "apply", "(Lcom/mojang/brigadier/context/CommandContext;)V", "Lcom/github/quiltservertools/ledger/actionutils/ActionSearchParams;", "Lcom/github/quiltservertools/ledger/actionutils/Preview$Type;", "", "Lnet/minecraft/class_2338;", "positions", "Ljava/util/Set;", "getPositions", "()Ljava/util/Set;", "spawnedEntityTrackers", "getSpawnedEntityTrackers", "removedEntityTrackers", "getRemovedEntityTrackers", "", "", "Lkotlin/Pair;", "Lnet/minecraft/class_1799;", "modifiedItems", "Ljava/util/Map;", "getModifiedItems", "()Ljava/util/Map;", "Type", "ledger"})
@SourceDebugExtension(value={"SMAP\nPreview.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Preview.kt\ncom/github/quiltservertools/ledger/actionutils/Preview\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,89:1\n1869#2,2:90\n1869#2,2:92\n*S KotlinDebug\n*F\n+ 1 Preview.kt\ncom/github/quiltservertools/ledger/actionutils/Preview\n*L\n59#1:90,2\n64#1:92,2\n*E\n"})
public final class Preview {
    @NotNull
    private final ActionSearchParams params;
    @NotNull
    private final Type type;
    @NotNull
    private final Set<class_2338> positions;
    @NotNull
    private final Set<class_3231> spawnedEntityTrackers;
    @NotNull
    private final Set<class_3231> removedEntityTrackers;
    @NotNull
    private final Map<class_2338, List<Pair<class_1799, Boolean>>> modifiedItems;

    public Preview(@NotNull ActionSearchParams params, @NotNull List<? extends ActionType> actions, @NotNull class_3222 player, @NotNull Type type) {
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        Intrinsics.checkNotNullParameter(actions, (String)"actions");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        this.params = params;
        this.type = type;
        this.positions = new LinkedHashSet();
        this.spawnedEntityTrackers = new LinkedHashSet();
        this.removedEntityTrackers = new LinkedHashSet();
        this.modifiedItems = new LinkedHashMap();
        Object[] objectArray = new Object[]{actions.size()};
        player.method_7353((class_2561)class_2561.method_43469((String)"text.ledger.preview.start", (Object[])objectArray).method_10862(TextColorPallet.INSTANCE.getPrimary()), false);
        block4: for (ActionType actionType : actions) {
            switch (WhenMappings.$EnumSwitchMapping$0[this.type.ordinal()]) {
                case 1: {
                    actionType.previewRollback(this, player);
                    continue block4;
                }
                case 2: {
                    actionType.previewRestore(this, player);
                    continue block4;
                }
            }
            throw new NoWhenBranchMatchedException();
        }
    }

    @NotNull
    public final Set<class_2338> getPositions() {
        return this.positions;
    }

    @NotNull
    public final Set<class_3231> getSpawnedEntityTrackers() {
        return this.spawnedEntityTrackers;
    }

    @NotNull
    public final Set<class_3231> getRemovedEntityTrackers() {
        return this.removedEntityTrackers;
    }

    @NotNull
    public final Map<class_2338, List<Pair<class_1799, Boolean>>> getModifiedItems() {
        return this.modifiedItems;
    }

    public final void cancel(@NotNull class_3222 player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        for (class_2338 pos : this.positions) {
            player.field_13987.method_14364((class_2596)new class_2626((class_1922)player.method_51469(), pos));
        }
        this.cleanup(player);
    }

    private final void cleanup(class_3222 player) {
        class_3231 it;
        Iterable $this$forEach$iv = this.spawnedEntityTrackers;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (class_3231)element$iv;
            boolean bl = false;
            if (this.isEntityPresent(it)) continue;
            it.method_14302(player);
        }
        $this$forEach$iv = this.removedEntityTrackers;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (class_3231)element$iv;
            boolean bl = false;
            if (!this.isEntityPresent(it)) continue;
            it.method_18760(player);
        }
    }

    private final boolean isEntityPresent(class_3231 entityTrackerEntry) {
        Intrinsics.checkNotNull((Object)entityTrackerEntry, (String)"null cannot be cast to non-null type com.github.quiltservertools.ledger.mixin.preview.EntityTrackerEntryAccessor");
        class_1297 entity = ((EntityTrackerEntryAccessor)entityTrackerEntry).getEntity();
        return entity.method_73183().method_8469(entity.method_5628()) != null;
    }

    public final void apply(@NotNull CommandContext<class_2168> context) {
        Intrinsics.checkNotNullParameter(context, (String)"context");
        class_3222 class_32222 = ((class_2168)context.getSource()).method_9207();
        Intrinsics.checkNotNullExpressionValue((Object)class_32222, (String)"getPlayerOrThrow(...)");
        this.cleanup(class_32222);
        switch (WhenMappings.$EnumSwitchMapping$0[this.type.ordinal()]) {
            case 1: {
                int n = RollbackCommand.INSTANCE.rollback(context, this.params);
                break;
            }
            case 2: {
                int n = RestoreCommand.INSTANCE.restore(context, this.params);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lcom/github/quiltservertools/ledger/actionutils/Preview$Type;", "", "<init>", "(Ljava/lang/String;I)V", "ROLLBACK", "RESTORE", "ledger"})
    public static final class Type
    extends Enum<Type> {
        public static final /* enum */ Type ROLLBACK = new Type();
        public static final /* enum */ Type RESTORE = new Type();
        private static final /* synthetic */ Type[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static Type[] values() {
            return (Type[])$VALUES.clone();
        }

        public static Type valueOf(String value) {
            return Enum.valueOf(Type.class, value);
        }

        @NotNull
        public static EnumEntries<Type> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = typeArray = new Type[]{Type.ROLLBACK, Type.RESTORE};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Type.values().length];
            try {
                nArray[Type.ROLLBACK.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Type.RESTORE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

