/*
 * Decompiled with CFR 0.152.
 */
package com.github.quiltservertools.ledger.api;

import com.github.quiltservertools.ledger.Ledger;
import com.github.quiltservertools.ledger.api.CommandExtension;
import com.github.quiltservertools.ledger.api.DatabaseExtension;
import com.github.quiltservertools.ledger.api.LedgerExtension;
import com.github.quiltservertools.ledger.config.DatabaseSpecKt;
import com.github.quiltservertools.ledger.config.LedgerConfigKt;
import com.uchuhimo.konf.ConfigSpec;
import com.uchuhimo.konf.Spec;
import java.util.ArrayList;
import java.util.List;
import javax.sql.DataSource;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0015\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0017\u0010\r\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\tH\u0000\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0017\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u000e\u0010\bJ\u000f\u0010\u0010\u001a\u0004\u0018\u00010\u000f\u00a2\u0006\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00040\u00128\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0013\u0010\u0014R\u0017\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00040\u00158F\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\u0018\u0010\u0019\u001a\u0004\u0018\u00010\u000f8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u0019\u0010\u001aR\u001d\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001b0\u00128\u0006\u00a2\u0006\f\n\u0004\b\u001c\u0010\u0014\u001a\u0004\b\u001d\u0010\u0017\u00a8\u0006\u001e"}, d2={"Lcom/github/quiltservertools/ledger/api/ExtensionManager;", "", "<init>", "()V", "Lcom/github/quiltservertools/ledger/api/LedgerExtension;", "extension", "", "registerExtension", "(Lcom/github/quiltservertools/ledger/api/LedgerExtension;)V", "Lnet/minecraft/server/MinecraftServer;", "server", "serverStarting$ledger", "(Lnet/minecraft/server/MinecraftServer;)V", "serverStarting", "failExtensionRegistration", "Ljavax/sql/DataSource;", "getDataSource", "()Ljavax/sql/DataSource;", "", "_extensions", "Ljava/util/List;", "", "getExtensions", "()Ljava/util/List;", "extensions", "dataSource", "Ljavax/sql/DataSource;", "Lcom/github/quiltservertools/ledger/api/CommandExtension;", "commands", "getCommands", "ledger"})
@SourceDebugExtension(value={"SMAP\nExtensionManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ExtensionManager.kt\ncom/github/quiltservertools/ledger/api/ExtensionManager\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,47:1\n1869#2,2:48\n1869#2,2:50\n*S KotlinDebug\n*F\n+ 1 ExtensionManager.kt\ncom/github/quiltservertools/ledger/api/ExtensionManager\n*L\n24#1:48,2\n30#1:50,2\n*E\n"})
public final class ExtensionManager {
    @NotNull
    public static final ExtensionManager INSTANCE = new ExtensionManager();
    @NotNull
    private static final List<LedgerExtension> _extensions = new ArrayList();
    @Nullable
    private static DataSource dataSource;
    @NotNull
    private static final List<CommandExtension> commands;

    private ExtensionManager() {
    }

    @NotNull
    public final List<LedgerExtension> getExtensions() {
        return _extensions;
    }

    @NotNull
    public final List<CommandExtension> getCommands() {
        return commands;
    }

    public final void registerExtension(@NotNull LedgerExtension extension) {
        Intrinsics.checkNotNullParameter((Object)extension, (String)"extension");
        _extensions.add(extension);
        if (extension instanceof CommandExtension) {
            commands.add((CommandExtension)extension);
        }
        Iterable $this$forEach$iv = extension.getConfigSpecs();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ConfigSpec it = (ConfigSpec)element$iv;
            boolean bl = false;
            LedgerConfigKt.getConfig().addSpec((Spec)it);
        }
    }

    public final void serverStarting$ledger(@NotNull MinecraftServer server) {
        Intrinsics.checkNotNullParameter((Object)server, (String)"server");
        Iterable $this$forEach$iv = this.getExtensions();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            LedgerExtension it = (LedgerExtension)element$iv;
            boolean bl = false;
            if (!(it instanceof DatabaseExtension)) continue;
            if (dataSource == null) {
                dataSource = ((DatabaseExtension)it).getDataSource(DatabaseSpecKt.getDatabasePath(LedgerConfigKt.getConfig()));
                continue;
            }
            INSTANCE.failExtensionRegistration(it);
        }
    }

    private final void failExtensionRegistration(LedgerExtension extension) {
        Ledger.INSTANCE.getLogger().error("Unable to load extension " + extension.getIdentifier());
    }

    @Nullable
    public final DataSource getDataSource() {
        return dataSource;
    }

    static {
        commands = new ArrayList();
    }
}

