/*
 * Decompiled with CFR 0.152.
 */
package com.github.quiltservertools.ledger;

import com.github.quiltservertools.ledger.LedgerKt;
import com.github.quiltservertools.ledger.actionutils.ActionSearchParams;
import com.github.quiltservertools.ledger.actionutils.Preview;
import com.github.quiltservertools.ledger.api.ExtensionManager;
import com.github.quiltservertools.ledger.api.LedgerApi;
import com.github.quiltservertools.ledger.api.LedgerApiImpl;
import com.github.quiltservertools.ledger.commands.LedgerCommandKt;
import com.github.quiltservertools.ledger.config.DatabaseSpec;
import com.github.quiltservertools.ledger.config.LedgerConfigKt;
import com.github.quiltservertools.ledger.database.ActionQueueService;
import com.github.quiltservertools.ledger.database.DatabaseManager;
import com.github.quiltservertools.ledger.listeners.BlockEventListenerKt;
import com.github.quiltservertools.ledger.listeners.EntityCallbackListenerKt;
import com.github.quiltservertools.ledger.listeners.PlayerEventListenerKt;
import com.github.quiltservertools.ledger.listeners.WorldEventListenerKt;
import com.github.quiltservertools.ledger.network.packet.action.ActionS2CPacket;
import com.github.quiltservertools.ledger.network.packet.handshake.HandshakeS2CPacket;
import com.github.quiltservertools.ledger.network.packet.response.ResponseS2CPacket;
import com.github.quiltservertools.ledger.registry.ActionRegistry;
import com.mojang.brigadier.CommandDispatcher;
import com.uchuhimo.konf.Config;
import com.uchuhimo.konf.Item;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.SetsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineName;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.DelayKt;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.TimeoutCancellationException;
import kotlinx.coroutines.TimeoutKt;
import net.fabricmc.api.DedicatedServerModInitializer;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.networking.v1.PayloadTypeRegistry;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.fabricmc.loader.api.Version;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2960;
import net.minecraft.class_7157;
import net.minecraft.class_7923;
import net.minecraft.server.MinecraftServer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.exposed.v1.core.vendors.SQLiteDialect;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u000f\u0010\u0006\u001a\u00020\u0005H\u0016\u00a2\u0006\u0004\b\u0006\u0010\u0004J\u0017\u0010\t\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\u0007H\u0002\u00a2\u0006\u0004\b\t\u0010\nJ\u0017\u0010\u000b\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\u0007H\u0002\u00a2\u0006\u0004\b\u000b\u0010\nJ\u000f\u0010\f\u001a\u00020\u0005H\u0002\u00a2\u0006\u0004\b\f\u0010\u0004J\u001d\u0010\u0011\u001a\n \u0010*\u0004\u0018\u00010\u000f0\u000f2\u0006\u0010\u000e\u001a\u00020\r\u00a2\u0006\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0013\u001a\u00020\r8\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\u0013\u0010\u0014R\u0017\u0010\u0015\u001a\u00020\r8\u0006\u00a2\u0006\f\n\u0004\b\u0015\u0010\u0014\u001a\u0004\b\u0016\u0010\u0017R \u0010\u0019\u001a\u00020\u00188\u0006X\u0087\u0004\u00a2\u0006\u0012\n\u0004\b\u0019\u0010\u001a\u0012\u0004\b\u001d\u0010\u0004\u001a\u0004\b\u001b\u0010\u001cR\u0017\u0010\u001f\u001a\u00020\u001e8\u0006\u00a2\u0006\f\n\u0004\b\u001f\u0010 \u001a\u0004\b!\u0010\"R\"\u0010$\u001a\u00020#8\u0006@\u0006X\u0086.\u00a2\u0006\u0012\n\u0004\b$\u0010%\u001a\u0004\b&\u0010'\"\u0004\b(\u0010)R\"\u0010\b\u001a\u00020\u00078\u0006@\u0006X\u0086.\u00a2\u0006\u0012\n\u0004\b\b\u0010*\u001a\u0004\b+\u0010,\"\u0004\b-\u0010\nR#\u00100\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020/0.8\u0006\u00a2\u0006\f\n\u0004\b0\u00101\u001a\u0004\b2\u00103R \u00106\u001a\u000e\u0012\u0004\u0012\u000204\u0012\u0004\u0012\u0002050.8\u0006X\u0087\u0004\u00a2\u0006\u0006\n\u0004\b6\u00101R\u001a\u00108\u001a\u0002078\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b8\u00109\u001a\u0004\b:\u0010;\u00a8\u0006<"}, d2={"Lcom/github/quiltservertools/ledger/Ledger;", "Lnet/fabricmc/api/DedicatedServerModInitializer;", "Lkotlinx/coroutines/CoroutineScope;", "<init>", "()V", "", "onInitializeServer", "Lnet/minecraft/server/MinecraftServer;", "server", "serverStarting", "(Lnet/minecraft/server/MinecraftServer;)V", "serverStopped", "initListeners", "", "path", "Lnet/minecraft/class_2960;", "kotlin.jvm.PlatformType", "identifier", "(Ljava/lang/String;)Lnet/minecraft/class_2960;", "MOD_ID", "Ljava/lang/String;", "DEFAULT_DATABASE", "getDEFAULT_DATABASE", "()Ljava/lang/String;", "Lcom/github/quiltservertools/ledger/api/LedgerApi;", "api", "Lcom/github/quiltservertools/ledger/api/LedgerApi;", "getApi", "()Lcom/github/quiltservertools/ledger/api/LedgerApi;", "getApi$annotations", "Lorg/apache/logging/log4j/Logger;", "logger", "Lorg/apache/logging/log4j/Logger;", "getLogger", "()Lorg/apache/logging/log4j/Logger;", "Lcom/uchuhimo/konf/Config;", "config", "Lcom/uchuhimo/konf/Config;", "getConfig", "()Lcom/uchuhimo/konf/Config;", "setConfig", "(Lcom/uchuhimo/konf/Config;)V", "Lnet/minecraft/server/MinecraftServer;", "getServer", "()Lnet/minecraft/server/MinecraftServer;", "setServer", "Ljava/util/concurrent/ConcurrentHashMap;", "Lcom/github/quiltservertools/ledger/actionutils/ActionSearchParams;", "searchCache", "Ljava/util/concurrent/ConcurrentHashMap;", "getSearchCache", "()Ljava/util/concurrent/ConcurrentHashMap;", "Ljava/util/UUID;", "Lcom/github/quiltservertools/ledger/actionutils/Preview;", "previewCache", "Lkotlin/coroutines/CoroutineContext;", "coroutineContext", "Lkotlin/coroutines/CoroutineContext;", "getCoroutineContext", "()Lkotlin/coroutines/CoroutineContext;", "ledger"})
public final class Ledger
implements DedicatedServerModInitializer,
CoroutineScope {
    @NotNull
    public static final Ledger INSTANCE = new Ledger();
    @NotNull
    public static final String MOD_ID = "ledger";
    @NotNull
    private static final String DEFAULT_DATABASE = SQLiteDialect.Companion.getDialectName();
    @NotNull
    private static final LedgerApi api = LedgerApiImpl.INSTANCE;
    @NotNull
    private static final Logger logger;
    public static Config config;
    public static MinecraftServer server;
    @NotNull
    private static final ConcurrentHashMap<String, ActionSearchParams> searchCache;
    @JvmField
    @NotNull
    public static final ConcurrentHashMap<UUID, Preview> previewCache;
    @NotNull
    private static final CoroutineContext coroutineContext;

    private Ledger() {
    }

    @NotNull
    public final String getDEFAULT_DATABASE() {
        return DEFAULT_DATABASE;
    }

    @NotNull
    public static final LedgerApi getApi() {
        return api;
    }

    @JvmStatic
    public static /* synthetic */ void getApi$annotations() {
    }

    @NotNull
    public final Logger getLogger() {
        return logger;
    }

    @NotNull
    public final Config getConfig() {
        Config config = Ledger.config;
        if (config != null) {
            return config;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"config");
        return null;
    }

    public final void setConfig(@NotNull Config config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"<set-?>");
        Ledger.config = config;
    }

    @NotNull
    public final MinecraftServer getServer() {
        MinecraftServer minecraftServer = server;
        if (minecraftServer != null) {
            return minecraftServer;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"server");
        return null;
    }

    public final void setServer(@NotNull MinecraftServer minecraftServer) {
        Intrinsics.checkNotNullParameter((Object)minecraftServer, (String)"<set-?>");
        server = minecraftServer;
    }

    @NotNull
    public final ConcurrentHashMap<String, ActionSearchParams> getSearchCache() {
        return searchCache;
    }

    @NotNull
    public CoroutineContext getCoroutineContext() {
        return coroutineContext;
    }

    public void onInitializeServer() {
        Version version = ((ModContainer)FabricLoader.getInstance().getModContainer(MOD_ID).get()).getMetadata().getVersion();
        LedgerKt.logInfo("Initializing Ledger " + version.getFriendlyString());
        if (!Files.exists(FabricLoader.getInstance().getConfigDir().resolve("ledger.toml"), new LinkOption[0])) {
            LedgerKt.logInfo("No config file, Creating");
            Files.copy((Path)((ModContainer)FabricLoader.getInstance().getModContainer(MOD_ID).get()).findPath("ledger.toml").get(), FabricLoader.getInstance().getConfigDir().resolve("ledger.toml"), new CopyOption[0]);
        }
        LedgerConfigKt.getConfig().validateRequired();
        this.setConfig(LedgerConfigKt.getConfig());
        ServerLifecycleEvents.SERVER_STARTING.register(this::serverStarting);
        ServerLifecycleEvents.SERVER_STOPPED.register(this::serverStopped);
        CommandRegistrationCallback.EVENT.register(Ledger::onInitializeServer$lambda$0);
        PayloadTypeRegistry.playS2C().register(ActionS2CPacket.Companion.getID(), ActionS2CPacket.Companion.getCODEC());
        PayloadTypeRegistry.playS2C().register(HandshakeS2CPacket.Companion.getID(), HandshakeS2CPacket.Companion.getCODEC());
        PayloadTypeRegistry.playS2C().register(ResponseS2CPacket.Companion.getID(), ResponseS2CPacket.Companion.getCODEC());
    }

    private final void serverStarting(MinecraftServer server) {
        this.setServer(server);
        ExtensionManager.INSTANCE.serverStarting$ledger(server);
        DatabaseManager.INSTANCE.setup(ExtensionManager.INSTANCE.getDataSource());
        DatabaseManager.INSTANCE.ensureTables();
        ActionRegistry.INSTANCE.registerDefaultTypes();
        this.initListeners();
        BuildersKt.launch$default((CoroutineScope)INSTANCE, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(null){
            Object L$0;
            int label;

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object $result) {
                var3_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = SetsKt.emptySet();
                        v1 = class_7923.field_41175.method_10235();
                        Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"getIds(...)");
                        v2 = SetsKt.plus((Set)v0, (Iterable)v1);
                        v3 = class_7923.field_41178.method_10235();
                        Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"getIds(...)");
                        v4 = SetsKt.plus((Set)v2, (Iterable)v3);
                        v5 = class_7923.field_41177.method_10235();
                        Intrinsics.checkNotNullExpressionValue((Object)v5, (String)"getIds(...)");
                        idSet = SetsKt.plus((Set)v4, (Iterable)v5);
                        LedgerKt.logInfo("Inserting " + idSet.size() + " registry keys into the database...");
                        this.L$0 = SpillingKt.nullOutSpilledVariable((Object)idSet);
                        this.label = 1;
                        v6 = DatabaseManager.INSTANCE.insertIdentifiers(idSet, (Continuation<? super Unit>)((Continuation)this));
                        if (v6 == var3_2) {
                            return var3_2;
                        }
                        ** GOTO lbl26
                    }
                    case 1: {
                        idSet = (Set)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v6 = $result;
lbl26:
                        // 2 sources

                        LedgerKt.logInfo("Registry insert complete");
                        this.L$0 = SpillingKt.nullOutSpilledVariable((Object)idSet);
                        this.label = 2;
                        v7 = DatabaseManager.INSTANCE.setupCache((Continuation<? super Unit>)((Continuation)this));
                        if (v7 == var3_2) {
                            return var3_2;
                        }
                        ** GOTO lbl37
                    }
                    case 2: {
                        idSet = (Set)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v7 = $result;
lbl37:
                        // 2 sources

                        this.L$0 = SpillingKt.nullOutSpilledVariable((Object)idSet);
                        this.label = 3;
                        v8 = DatabaseManager.INSTANCE.autoPurge((Continuation<? super Unit>)((Continuation)this));
                        if (v8 == var3_2) {
                            return var3_2;
                        }
                        ** GOTO lbl47
                    }
                    case 3: {
                        idSet = (Set)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v8 = $result;
lbl47:
                        // 2 sources

                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null).invokeOnCompletion(Ledger::serverStarting$lambda$1);
    }

    private final void serverStopped(MinecraftServer server) {
        BuildersKt.runBlocking$default(null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(null){
            int label;

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.label = 1;
                        Object object2 = TimeoutKt.withTimeout-KLykuaI((long)DurationKt.toDuration((long)((Number)Ledger.INSTANCE.getConfig().get((Item)DatabaseSpec.INSTANCE.getQueueTimeoutMin())).longValue(), (DurationUnit)DurationUnit.MINUTES), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(null){
                            int label;

                            /*
                             * Unable to fully structure code
                             */
                            public final Object invokeSuspend(Object $result) {
                                var2_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)$result);
                                        BuildersKt.launch$default((CoroutineScope)Ledger.INSTANCE, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(null){
                                            int label;

                                            /*
                                             * Unable to fully structure code
                                             */
                                            public final Object invokeSuspend(Object $result) {
                                                var2_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                                switch (this.label) {
                                                    case 0: {
                                                        ResultKt.throwOnFailure((Object)$result);
lbl5:
                                                        // 3 sources

                                                        while (ActionQueueService.INSTANCE.getSize() > 0) {
                                                            LedgerKt.logInfo("Database is still busy. If you exit now data WILL be lost. Actions in queue: " + ActionQueueService.INSTANCE.getSize());
                                                            this.label = 1;
                                                            v0 = DelayKt.delay-VtjQ1oo((long)DurationKt.toDuration((long)((Number)Ledger.INSTANCE.getConfig().get((Item)DatabaseSpec.INSTANCE.getQueueCheckDelaySec())).longValue(), (DurationUnit)DurationUnit.SECONDS), (Continuation)((Continuation)this));
                                                            if (v0 != var2_2) continue;
                                                            return var2_2;
                                                        }
                                                        break;
                                                    }
                                                    case 1: {
                                                        ResultKt.throwOnFailure((Object)$result);
                                                        v0 = $result;
                                                        ** GOTO lbl5
                                                    }
                                                }
                                                return Unit.INSTANCE;
                                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                            }

                                            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                                            }

                                            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                            }
                                        }), (int)3, null);
                                        this.label = 1;
                                        v0 = ActionQueueService.INSTANCE.drainAll((Continuation<? super Unit>)((Continuation)this));
                                        if (v0 == var2_2) {
                                            return var2_2;
                                        }
                                        ** GOTO lbl15
                                    }
                                    case 1: {
                                        ResultKt.throwOnFailure((Object)$result);
                                        v0 = $result;
lbl15:
                                        // 2 sources

                                        LedgerKt.logInfo("Successfully drained database queue");
                                        return Unit.INSTANCE;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                            }

                            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }), (Continuation)((Continuation)this));
                        if (object2 != object) return Unit.INSTANCE;
                        return object;
                    }
                    case 1: {
                        Object object2;
                        try {
                            ResultKt.throwOnFailure((Object)$result);
                            object2 = $result;
                            return Unit.INSTANCE;
                        }
                        catch (TimeoutCancellationException e) {
                            LedgerKt.logWarn("Database drain timed out. " + ActionQueueService.INSTANCE.getSize() + " actions still in queue. Data may be lost.");
                        }
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)1, null);
    }

    private final void initListeners() {
        WorldEventListenerKt.registerWorldEventListeners();
        PlayerEventListenerKt.registerPlayerListeners();
        BlockEventListenerKt.registerBlockListeners();
        EntityCallbackListenerKt.registerEntityListeners();
    }

    public final class_2960 identifier(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        return class_2960.method_60655((String)MOD_ID, (String)path);
    }

    private static final void onInitializeServer$lambda$0(CommandDispatcher dispatcher, class_7157 class_71572, class_2170.class_5364 class_53642) {
        Intrinsics.checkNotNull((Object)dispatcher);
        LedgerCommandKt.registerCommands((CommandDispatcher<class_2168>)dispatcher);
    }

    private static final Unit serverStarting$lambda$1(Throwable it) {
        ActionQueueService.INSTANCE.start();
        return Unit.INSTANCE;
    }

    static {
        Logger logger = LogManager.getLogger((String)"Ledger");
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        Ledger.logger = logger;
        searchCache = new ConcurrentHashMap();
        previewCache = new ConcurrentHashMap();
        coroutineContext = Dispatchers.getDefault().plus((CoroutineContext)new CoroutineName("Ledger"));
    }
}

