/*
 * Decompiled with CFR 0.152.
 */
package com.github.quiltservertools.ledger.actions;

import com.github.quiltservertools.ledger.actions.AbstractActionType;
import com.github.quiltservertools.ledger.utility.ExtensionsKt;
import com.github.quiltservertools.ledger.utility.NbtUtilsKt;
import com.github.quiltservertools.ledger.utility.TextColorPallet;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.Optional;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.class_11352;
import net.minecraft.class_11368;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1530;
import net.minecraft.class_1533;
import net.minecraft.class_156;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2168;
import net.minecraft.class_2487;
import net.minecraft.class_2522;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_4844;
import net.minecraft.class_5250;
import net.minecraft.class_5455;
import net.minecraft.class_7225;
import net.minecraft.class_7923;
import net.minecraft.class_8942;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000f\u0010\u0005\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0017\u0010\n\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\u0007H\u0002\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0017\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\r\u001a\u00020\fH\u0016\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u0017\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0012\u001a\u00020\u0011H\u0016\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u0017\u0010\u0016\u001a\u00020\u00132\u0006\u0010\u0012\u001a\u00020\u0011H\u0016\u00a2\u0006\u0004\b\u0016\u0010\u0015R\u001a\u0010\u0017\u001a\u00020\u00048\u0016X\u0096D\u00a2\u0006\f\n\u0004\b\u0017\u0010\u0018\u001a\u0004\b\u0019\u0010\u0006\u00a8\u0006\u001a"}, d2={"Lcom/github/quiltservertools/ledger/actions/EntityChangeActionType;", "Lcom/github/quiltservertools/ledger/actions/AbstractActionType;", "<init>", "()V", "", "getTranslationType", "()Ljava/lang/String;", "Lnet/minecraft/class_5455;", "registryManager", "Lnet/minecraft/class_1799;", "getStack", "(Lnet/minecraft/class_5455;)Lnet/minecraft/class_1799;", "Lnet/minecraft/class_2168;", "source", "Lnet/minecraft/class_2561;", "getObjectMessage", "(Lnet/minecraft/class_2168;)Lnet/minecraft/class_2561;", "Lnet/minecraft/server/MinecraftServer;", "server", "", "rollback", "(Lnet/minecraft/server/MinecraftServer;)Z", "restore", "identifier", "Ljava/lang/String;", "getIdentifier", "ledger"})
public final class EntityChangeActionType
extends AbstractActionType {
    @NotNull
    private final String identifier;

    public EntityChangeActionType() {
        this.identifier = "entity-change";
    }

    @Override
    @NotNull
    public String getIdentifier() {
        return this.identifier;
    }

    @Override
    @NotNull
    public String getTranslationType() {
        class_5455.class_6890 class_68902 = class_5455.field_40585;
        Intrinsics.checkNotNullExpressionValue((Object)class_68902, (String)"EMPTY");
        class_1792 item = this.getStack((class_5455)class_68902).method_7909();
        return item instanceof class_1747 ? "block" : "item";
    }

    private final class_1799 getStack(class_5455 registryManager) {
        if (this.getExtraData() == null) {
            class_1799 class_17992 = class_1799.field_8037;
            Intrinsics.checkNotNullExpressionValue((Object)class_17992, (String)"EMPTY");
            return class_17992;
        }
        try {
            class_11368 readView = class_11352.method_71417((class_8942)class_8942.field_60348, (class_7225.class_7874)((class_7225.class_7874)registryManager), (class_2487)class_2522.method_67315((String)this.getExtraData()));
            class_1799 class_17993 = readView.method_71418(class_1799.field_55709).orElse(class_1799.field_8037);
            Intrinsics.checkNotNullExpressionValue((Object)class_17993, (String)"orElse(...)");
            return class_17993;
        }
        catch (CommandSyntaxException commandSyntaxException) {
            Object object = class_7923.field_41178.method_63535(class_2960.method_60654((String)this.getExtraData()));
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
            class_1792 item = (class_1792)object;
            class_1799 class_17994 = item.method_7854();
            Intrinsics.checkNotNullExpressionValue((Object)class_17994, (String)"getDefaultStack(...)");
            return class_17994;
        }
    }

    @Override
    @NotNull
    public class_2561 getObjectMessage(@NotNull class_2168 source) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        class_5250 text = class_2561.method_43470((String)"");
        text.method_10852((class_2561)class_2561.method_43471((String)class_156.method_646((String)"entity", (class_2960)this.getObjectIdentifier())).method_10862(TextColorPallet.INSTANCE.getSecondaryVariant()).method_27694(arg_0 -> EntityChangeActionType.getObjectMessage$lambda$0(this, arg_0)));
        class_5455 class_54552 = source.method_30497();
        Intrinsics.checkNotNullExpressionValue((Object)class_54552, (String)"getRegistryManager(...)");
        class_1799 stack = this.getStack(class_54552);
        if (!stack.method_7960()) {
            text.method_10852((class_2561)class_2561.method_43470((String)" ").method_10852((class_2561)class_2561.method_43471((String)"text.ledger.action_message.with")).method_27693(" "));
            text.method_10852((class_2561)class_2561.method_43471((String)stack.method_7909().method_7876()).method_10862(TextColorPallet.INSTANCE.getSecondaryVariant()).method_27694(arg_0 -> EntityChangeActionType.getObjectMessage$lambda$1(stack, arg_0)));
        }
        Intrinsics.checkNotNull((Object)text);
        return (class_2561)text;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean rollback(@NotNull MinecraftServer server) {
        class_1297 entity;
        Intrinsics.checkNotNullParameter((Object)server, (String)"server");
        class_3218 world = ExtensionsKt.getWorld(server, this.getWorld());
        class_2487 oldEntity = class_2522.method_67315((String)this.getOldObjectState());
        Optional optionalUUID = oldEntity.method_67491("UUID", class_4844.field_25122);
        if (optionalUUID.isEmpty()) {
            return false;
        }
        class_3218 class_32182 = world;
        class_1297 class_12972 = entity = class_32182 != null ? class_32182.method_66347((UUID)optionalUUID.get()) : null;
        if (entity != null) {
            AutoCloseable autoCloseable = (AutoCloseable)new class_8942.class_11340(() -> EntityChangeActionType.rollback$lambda$2(this), NbtUtilsKt.getLOGGER());
            Throwable throwable = null;
            try {
                class_1297 class_12973;
                class_8942.class_11340 it = (class_8942.class_11340)autoCloseable;
                boolean bl = false;
                class_11368 readView = class_11352.method_71417((class_8942)((class_8942)it), (class_7225.class_7874)((class_7225.class_7874)server.method_30611()), (class_2487)oldEntity);
                if (entity instanceof class_1533) {
                    ((class_1533)entity).method_6935(class_1799.field_8037);
                }
                if ((class_12973 = entity) instanceof class_1309) {
                    ((class_1309)entity).method_5651(readView);
                } else if (class_12973 instanceof class_1530) {
                    ((class_1530)entity).method_5651(readView);
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean restore(@NotNull MinecraftServer server) {
        class_1297 entity;
        Intrinsics.checkNotNullParameter((Object)server, (String)"server");
        class_3218 world = ExtensionsKt.getWorld(server, this.getWorld());
        class_2487 newEntity = class_2522.method_67315((String)this.getObjectState());
        Optional optionalUUID = newEntity.method_67491("UUID", class_4844.field_25122);
        if (optionalUUID.isEmpty()) {
            return false;
        }
        class_3218 class_32182 = world;
        class_1297 class_12972 = entity = class_32182 != null ? class_32182.method_66347((UUID)optionalUUID.get()) : null;
        if (entity != null) {
            AutoCloseable autoCloseable = (AutoCloseable)new class_8942.class_11340(() -> EntityChangeActionType.restore$lambda$4(this), NbtUtilsKt.getLOGGER());
            Throwable throwable = null;
            try {
                class_1297 class_12973;
                class_8942.class_11340 it = (class_8942.class_11340)autoCloseable;
                boolean bl = false;
                class_11368 readView = class_11352.method_71417((class_8942)((class_8942)it), (class_7225.class_7874)((class_7225.class_7874)server.method_30611()), (class_2487)newEntity);
                if (entity instanceof class_1533) {
                    ((class_1533)entity).method_6935(class_1799.field_8037);
                }
                if ((class_12973 = entity) instanceof class_1309) {
                    ((class_1309)entity).method_5651(readView);
                } else if (class_12973 instanceof class_1530) {
                    ((class_1530)entity).method_5651(readView);
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
            }
            return true;
        }
        return false;
    }

    private static final class_2583 getObjectMessage$lambda$0(EntityChangeActionType this$0, class_2583 it) {
        String string = this$0.getObjectIdentifier().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return it.method_10949((class_2568)new class_2568.class_10613((class_2561)ExtensionsKt.literal(string)));
    }

    private static final class_2583 getObjectMessage$lambda$1(class_1799 $stack, class_2583 it) {
        return it.method_10949((class_2568)new class_2568.class_10612($stack));
    }

    private static final String rollback$lambda$2(EntityChangeActionType this$0) {
        return "ledger:rollback:entity-change@" + this$0.getPos();
    }

    private static final String restore$lambda$4(EntityChangeActionType this$0) {
        return "ledger:restore:entity-change@" + this$0.getPos();
    }
}

