/*
 * Decompiled with CFR 0.152.
 */
package com.github.quiltservertools.ledger.actions;

import com.github.quiltservertools.ledger.actions.AbstractActionType;
import com.github.quiltservertools.ledger.actionutils.Preview;
import com.github.quiltservertools.ledger.utility.ExtensionsKt;
import com.github.quiltservertools.ledger.utility.NbtUtilsKt;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Predicate;
import kotlin.Metadata;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.class_11352;
import net.minecraft.class_11368;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2522;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3231;
import net.minecraft.class_3730;
import net.minecraft.class_4844;
import net.minecraft.class_7225;
import net.minecraft.class_7923;
import net.minecraft.class_8942;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000f\u0010\u0005\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u0005\u0010\u0006J!\u0010\f\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\tH\u0002\u00a2\u0006\u0004\b\f\u0010\rJ\u001f\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u0010H\u0016\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u001f\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u0010H\u0016\u00a2\u0006\u0004\b\u0015\u0010\u0014J\u0017\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u0017\u001a\u00020\u0016H\u0016\u00a2\u0006\u0004\b\u0019\u0010\u001aJ\u0017\u0010\u001b\u001a\u00020\u00182\u0006\u0010\u0017\u001a\u00020\u0016H\u0016\u00a2\u0006\u0004\b\u001b\u0010\u001aR\u001a\u0010\u001c\u001a\u00020\u00048\u0016X\u0096D\u00a2\u0006\f\n\u0004\b\u001c\u0010\u001d\u001a\u0004\b\u001e\u0010\u0006R\u0017\u0010 \u001a\u00020\u001f8\u0006\u00a2\u0006\f\n\u0004\b \u0010!\u001a\u0004\b\"\u0010#\u00a8\u0006$"}, d2={"Lcom/github/quiltservertools/ledger/actions/EntityKillActionType;", "Lcom/github/quiltservertools/ledger/actions/AbstractActionType;", "<init>", "()V", "", "getTranslationType", "()Ljava/lang/String;", "Lnet/minecraft/class_3218;", "world", "Lnet/minecraft/class_8942;", "reporter", "Lnet/minecraft/class_1297;", "getEntity", "(Lnet/minecraft/class_3218;Lnet/minecraft/class_8942;)Lnet/minecraft/class_1297;", "Lcom/github/quiltservertools/ledger/actionutils/Preview;", "preview", "Lnet/minecraft/class_3222;", "player", "", "previewRollback", "(Lcom/github/quiltservertools/ledger/actionutils/Preview;Lnet/minecraft/class_3222;)V", "previewRestore", "Lnet/minecraft/server/MinecraftServer;", "server", "", "rollback", "(Lnet/minecraft/server/MinecraftServer;)Z", "restore", "identifier", "Ljava/lang/String;", "getIdentifier", "Lnet/minecraft/class_3231$class_12004;", "noopPacketSender", "Lnet/minecraft/class_3231$class_12004;", "getNoopPacketSender", "()Lnet/minecraft/class_3231$class_12004;", "ledger"})
public final class EntityKillActionType
extends AbstractActionType {
    @NotNull
    private final String identifier;
    @NotNull
    private final class_3231.class_12004 noopPacketSender = new class_3231.class_12004(){

        public void method_18730(class_2596<? super class_2602> packet) {
        }

        public void method_18734(class_2596<? super class_2602> packet) {
        }

        public void method_74531(class_2596<? super class_2602> packet, Predicate<class_3222> predicate) {
        }
    };

    public EntityKillActionType() {
        this.identifier = "entity-kill";
    }

    @Override
    @NotNull
    public String getIdentifier() {
        return this.identifier;
    }

    @NotNull
    public final class_3231.class_12004 getNoopPacketSender() {
        return this.noopPacketSender;
    }

    @Override
    @NotNull
    public String getTranslationType() {
        return "entity";
    }

    private final class_1297 getEntity(class_3218 world, class_8942 reporter) {
        Optional entityType = class_7923.field_41177.method_17966(this.getObjectIdentifier());
        if (entityType.isEmpty()) {
            return null;
        }
        class_1297 class_12972 = ((class_1299)entityType.get()).method_5883((class_1937)world, class_3730.field_16462);
        Intrinsics.checkNotNull((Object)class_12972);
        class_1297 entity = class_12972;
        class_11368 readView = class_11352.method_71417((class_8942)reporter, (class_7225.class_7874)((class_7225.class_7874)world.method_30349()), (class_2487)class_2522.method_67315((String)this.getExtraData()));
        entity.method_5651(readView);
        entity.method_18799(class_243.field_1353);
        entity.method_20803(0);
        if (entity instanceof class_1309) {
            ((class_1309)entity).method_6033((float)((class_1309)entity).field_6269);
        }
        return entity;
    }

    @Override
    public void previewRollback(@NotNull Preview preview2, @NotNull class_3222 player) {
        Intrinsics.checkNotNullParameter((Object)preview2, (String)"preview");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        MinecraftServer minecraftServer = player.method_51469().method_8503();
        Intrinsics.checkNotNullExpressionValue((Object)minecraftServer, (String)"getServer(...)");
        class_3218 class_32182 = ExtensionsKt.getWorld(minecraftServer, this.getWorld());
        Intrinsics.checkNotNull((Object)class_32182);
        class_3218 world = class_32182;
        class_8942 class_89422 = class_8942.field_60348;
        Intrinsics.checkNotNullExpressionValue((Object)class_89422, (String)"EMPTY");
        class_1297 entity = this.getEntity(world, class_89422);
        class_3231 entityTrackerEntry = new class_3231(world, entity, 1, false, this.noopPacketSender);
        entityTrackerEntry.method_18760(player);
        preview2.getSpawnedEntityTrackers().add(entityTrackerEntry);
    }

    @Override
    public void previewRestore(@NotNull Preview preview2, @NotNull class_3222 player) {
        block1: {
            class_1297 entity;
            Intrinsics.checkNotNullParameter((Object)preview2, (String)"preview");
            Intrinsics.checkNotNullParameter((Object)player, (String)"player");
            MinecraftServer minecraftServer = player.method_51469().method_8503();
            Intrinsics.checkNotNullExpressionValue((Object)minecraftServer, (String)"getServer(...)");
            class_3218 world = ExtensionsKt.getWorld(minecraftServer, this.getWorld());
            class_2487 tag = class_2522.method_67315((String)this.getExtraData());
            Optional optionalUuid = tag.method_67491("UUID", class_4844.field_25122);
            if (!optionalUuid.isPresent()) break block1;
            Object t = optionalUuid.get();
            Intrinsics.checkNotNullExpressionValue(t, (String)"get(...)");
            UUID uuid = (UUID)t;
            class_3218 class_32182 = world;
            class_1297 class_12972 = entity = class_32182 != null ? class_32182.method_66347(uuid) : null;
            if (class_12972 != null) {
                class_1297 it = class_12972;
                boolean bl = false;
                class_3231 entityTrackerEntry = new class_3231(world, entity, 1, false, this.noopPacketSender);
                entityTrackerEntry.method_14302(player);
                preview2.getRemovedEntityTrackers().add(entityTrackerEntry);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean rollback(@NotNull MinecraftServer server) {
        Intrinsics.checkNotNullParameter((Object)server, (String)"server");
        class_3218 class_32182 = ExtensionsKt.getWorld(server, this.getWorld());
        Intrinsics.checkNotNull((Object)class_32182);
        class_3218 world = class_32182;
        AutoCloseable autoCloseable = (AutoCloseable)new class_8942.class_11340(() -> EntityKillActionType.rollback$lambda$1(this), NbtUtilsKt.getLOGGER());
        Throwable throwable = null;
        try {
            class_1297 class_12972;
            class_8942.class_11340 it = (class_8942.class_11340)autoCloseable;
            boolean bl = false;
            if (this.getEntity(world, (class_8942)it) == null) {
                boolean bl2 = false;
                return bl2;
            }
            class_1297 entity = class_12972;
            boolean bl3 = world.method_8649(entity);
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
        return true;
    }

    @Override
    public boolean restore(@NotNull MinecraftServer server) {
        class_1297 entity;
        Intrinsics.checkNotNullParameter((Object)server, (String)"server");
        class_3218 world = ExtensionsKt.getWorld(server, this.getWorld());
        class_2487 class_24872 = class_2522.method_67315((String)this.getExtraData());
        Intrinsics.checkNotNull((Object)class_24872);
        Optional optionalUUID = class_24872.method_67491("UUID", class_4844.field_25122);
        if (optionalUUID.isEmpty()) {
            return false;
        }
        class_3218 class_32182 = world;
        class_1297 class_12972 = entity = class_32182 != null ? class_32182.method_66347((UUID)optionalUUID.get()) : null;
        if (entity != null) {
            entity.method_5650(class_1297.class_5529.field_26999);
            return true;
        }
        return false;
    }

    private static final String rollback$lambda$1(EntityKillActionType this$0) {
        return "ledger:rollback:entity-kill@" + this$0.getPos();
    }
}

