/*
 * Decompiled with CFR 0.152.
 */
package com.github.quiltservertools.ledger.commands.parameters;

import com.github.quiltservertools.ledger.commands.parameters.SimpleParameter;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Locale;
import java.util.concurrent.CompletableFuture;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.class_2168;
import net.minecraft.class_2172;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0019\u0010\u0007\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0006\u001a\u00020\u0005H\u0016\u00a2\u0006\u0004\b\u0007\u0010\bJ+\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\r\u001a\u00020\fH\u0016\u00a2\u0006\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0012"}, d2={"Lcom/github/quiltservertools/ledger/commands/parameters/RangeParameter;", "Lcom/github/quiltservertools/ledger/commands/parameters/SimpleParameter;", "", "<init>", "()V", "Lcom/mojang/brigadier/StringReader;", "stringReader", "parse", "(Lcom/mojang/brigadier/StringReader;)Ljava/lang/Integer;", "Lcom/mojang/brigadier/context/CommandContext;", "Lnet/minecraft/class_2168;", "context", "Lcom/mojang/brigadier/suggestion/SuggestionsBuilder;", "builder", "Ljava/util/concurrent/CompletableFuture;", "Lcom/mojang/brigadier/suggestion/Suggestions;", "getSuggestions", "(Lcom/mojang/brigadier/context/CommandContext;Lcom/mojang/brigadier/suggestion/SuggestionsBuilder;)Ljava/util/concurrent/CompletableFuture;", "ledger"})
public final class RangeParameter
extends SimpleParameter<Integer> {
    @Override
    @Nullable
    public Integer parse(@NotNull StringReader stringReader) {
        Intrinsics.checkNotNullParameter((Object)stringReader, (String)"stringReader");
        int start2 = stringReader.getCursor();
        while (stringReader.canRead() && stringReader.peek() != ' ') {
            stringReader.skip();
        }
        String string = stringReader.getString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getString(...)");
        String string2 = string;
        int n = stringReader.getCursor();
        String string3 = string2.substring(start2, n);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
        String argument = string3;
        if (Intrinsics.areEqual((Object)argument, (Object)"@global")) {
            return null;
        }
        stringReader.setCursor(start2);
        return IntegerArgumentType.integer((int)1).parse(stringReader);
    }

    @NotNull
    public CompletableFuture<Suggestions> getSuggestions(@NotNull CommandContext<class_2168> context, @NotNull SuggestionsBuilder builder) {
        Intrinsics.checkNotNullParameter(context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        String string = builder.getRemaining();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getRemaining(...)");
        String string2 = string.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
        String remaining = string2;
        StringReader reader = new StringReader(remaining);
        class_2172.method_9265((Iterable)CollectionsKt.listOf((Object)"@global"), (SuggestionsBuilder)builder);
        boolean suggestNumber = false;
        try {
            reader.readInt();
            suggestNumber = true;
        }
        catch (CommandSyntaxException commandSyntaxException) {
            boolean bl = suggestNumber = ((CharSequence)remaining).length() == 0;
        }
        if (suggestNumber) {
            for (int i = 1; i < 10; ++i) {
                builder.suggest(remaining + i);
            }
        }
        CompletableFuture completableFuture = builder.buildFuture();
        Intrinsics.checkNotNullExpressionValue((Object)completableFuture, (String)"buildFuture(...)");
        return completableFuture;
    }
}

