/*
 * Decompiled with CFR 0.152.
 */
package com.github.quiltservertools.ledger.commands.parameters;

import com.github.quiltservertools.ledger.commands.parameters.SimpleParameter;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.time.Duration;
import java.time.Instant;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.CompletableFuture;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import net.minecraft.class_2168;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\f\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0017\u0010\u0007\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u0005H\u0016\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0017\u0010\f\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\tH\u0002\u00a2\u0006\u0004\b\f\u0010\rJ+\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\u0012\u001a\u00020\u0011H\u0016\u00a2\u0006\u0004\b\u0015\u0010\u0016R\u001a\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\t0\u00178\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0018\u0010\u0019\u00a8\u0006\u001a"}, d2={"Lcom/github/quiltservertools/ledger/commands/parameters/TimeParameter;", "Lcom/github/quiltservertools/ledger/commands/parameters/SimpleParameter;", "Ljava/time/Instant;", "<init>", "()V", "Lcom/mojang/brigadier/StringReader;", "stringReader", "parse", "(Lcom/mojang/brigadier/StringReader;)Ljava/time/Instant;", "", "c", "", "isCharValid", "(C)Z", "Lcom/mojang/brigadier/context/CommandContext;", "Lnet/minecraft/class_2168;", "context", "Lcom/mojang/brigadier/suggestion/SuggestionsBuilder;", "builder", "Ljava/util/concurrent/CompletableFuture;", "Lcom/mojang/brigadier/suggestion/Suggestions;", "getSuggestions", "(Lcom/mojang/brigadier/context/CommandContext;Lcom/mojang/brigadier/suggestion/SuggestionsBuilder;)Ljava/util/concurrent/CompletableFuture;", "", "units", "Ljava/util/List;", "ledger"})
public final class TimeParameter
extends SimpleParameter<Instant> {
    @NotNull
    private final List<Character> units;

    public TimeParameter() {
        Object[] objectArray = new Character[]{Character.valueOf('s'), Character.valueOf('m'), Character.valueOf('h'), Character.valueOf('d'), Character.valueOf('w')};
        this.units = CollectionsKt.listOf((Object[])objectArray);
    }

    @Override
    @NotNull
    public Instant parse(@NotNull StringReader stringReader) {
        Intrinsics.checkNotNullParameter((Object)stringReader, (String)"stringReader");
        int i = stringReader.getCursor();
        while (stringReader.canRead() && this.isCharValid(stringReader.peek())) {
            stringReader.skip();
        }
        String string = stringReader.getString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getString(...)");
        String string2 = string;
        int n = stringReader.getCursor();
        String string3 = string2.substring(i, n);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
        String string4 = string3.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"toLowerCase(...)");
        String input = string4;
        Regex timeRegex = new Regex("([0-9]+)([smhdw])");
        Sequence times = Regex.findAll$default((Regex)timeRegex, (CharSequence)input, (int)0, (int)2, null);
        Duration duration = Duration.ZERO;
        for (MatchResult time : times) {
            String timeUnit;
            if (time.getGroups().size() != 3) continue;
            long timeValue = Long.parseLong((String)time.getGroupValues().get(1));
            switch (timeUnit = (String)time.getGroupValues().get(2)) {
                case "s": {
                    duration = duration.plusSeconds(timeValue);
                    break;
                }
                case "m": {
                    duration = duration.plusMinutes(timeValue);
                    break;
                }
                case "h": {
                    duration = duration.plusHours(timeValue);
                    break;
                }
                case "d": {
                    duration = duration.plusDays(timeValue);
                    break;
                }
                case "w": {
                    duration = duration.plusDays(timeValue * (long)7);
                }
            }
        }
        Instant instant = Instant.now().minus(duration);
        Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"minus(...)");
        return instant;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isCharValid(char c) {
        boolean bl;
        if ('0' <= c) {
            if (c < ':') {
                return true;
            }
            bl = false;
        } else {
            bl = false;
        }
        if (bl) return true;
        if ('a' > c) return false;
        if (c >= '{') return false;
        return true;
    }

    @NotNull
    public CompletableFuture<Suggestions> getSuggestions(@NotNull CommandContext<class_2168> context, @NotNull SuggestionsBuilder builder) {
        Intrinsics.checkNotNullParameter(context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        String string = builder.getRemaining();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getRemaining(...)");
        String string2 = string.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
        String remaining = string2;
        for (char unit : this.units) {
            if (((CharSequence)remaining).length() == 0) {
                for (int i = 1; i < 10; ++i) {
                    builder.suggest("" + i + unit);
                }
                continue;
            }
            char end = StringsKt.last((CharSequence)remaining);
            boolean bl = '1' <= end ? end < ':' : false;
            if (!bl) continue;
            builder.suggest(remaining + unit);
        }
        CompletableFuture completableFuture = builder.buildFuture();
        Intrinsics.checkNotNullExpressionValue((Object)completableFuture, (String)"buildFuture(...)");
        return completableFuture;
    }
}

