/*
 * Decompiled with CFR 0.152.
 */
package com.github.quiltservertools.ledger.database;

import com.github.quiltservertools.ledger.Ledger;
import com.github.quiltservertools.ledger.LedgerKt;
import com.github.quiltservertools.ledger.actions.ActionType;
import com.github.quiltservertools.ledger.actionutils.ActionSearchParams;
import com.github.quiltservertools.ledger.actionutils.Preview;
import com.github.quiltservertools.ledger.actionutils.SearchResults;
import com.github.quiltservertools.ledger.config.DatabaseSpec;
import com.github.quiltservertools.ledger.config.DatabaseSpecKt;
import com.github.quiltservertools.ledger.config.LedgerConfigKt;
import com.github.quiltservertools.ledger.config.SearchSpec;
import com.github.quiltservertools.ledger.database.DatabaseCacheService;
import com.github.quiltservertools.ledger.database.DatabaseManager;
import com.github.quiltservertools.ledger.database.Tables;
import com.github.quiltservertools.ledger.registry.ActionRegistry;
import com.github.quiltservertools.ledger.utility.Negatable;
import com.github.quiltservertools.ledger.utility.PlayerResult;
import com.google.common.collect.BiMap;
import com.uchuhimo.konf.Item;
import java.nio.file.Path;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.function.Function;
import javax.sql.DataSource;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.CoroutineName;
import kotlinx.coroutines.DelayKt;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.ThreadPoolDispatcherKt;
import net.minecraft.class_11560;
import net.minecraft.class_2338;
import net.minecraft.class_2960;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.exposed.v1.core.AbstractQuery;
import org.jetbrains.exposed.v1.core.Column;
import org.jetbrains.exposed.v1.core.ColumnSet;
import org.jetbrains.exposed.v1.core.Expression;
import org.jetbrains.exposed.v1.core.ExpressionWithColumnType;
import org.jetbrains.exposed.v1.core.FieldSet;
import org.jetbrains.exposed.v1.core.Op;
import org.jetbrains.exposed.v1.core.OpBuilderKt;
import org.jetbrains.exposed.v1.core.ResultRow;
import org.jetbrains.exposed.v1.core.SortOrder;
import org.jetbrains.exposed.v1.core.SqlLogger;
import org.jetbrains.exposed.v1.core.Table;
import org.jetbrains.exposed.v1.core.Transaction;
import org.jetbrains.exposed.v1.core.dao.id.EntityID;
import org.jetbrains.exposed.v1.core.dao.id.IdTable;
import org.jetbrains.exposed.v1.core.dao.id.IntIdTable;
import org.jetbrains.exposed.v1.core.statements.BatchInsertStatement;
import org.jetbrains.exposed.v1.core.statements.InsertStatement;
import org.jetbrains.exposed.v1.core.statements.StatementContext;
import org.jetbrains.exposed.v1.core.statements.StatementKt;
import org.jetbrains.exposed.v1.core.statements.UpdateBuilder;
import org.jetbrains.exposed.v1.core.statements.UpdateStatement;
import org.jetbrains.exposed.v1.dao.Entity;
import org.jetbrains.exposed.v1.dao.EntityClass;
import org.jetbrains.exposed.v1.dao.IntEntity;
import org.jetbrains.exposed.v1.dao.IntEntityClass;
import org.jetbrains.exposed.v1.jdbc.Database;
import org.jetbrains.exposed.v1.jdbc.JdbcTransaction;
import org.jetbrains.exposed.v1.jdbc.QueriesKt;
import org.jetbrains.exposed.v1.jdbc.Query;
import org.jetbrains.exposed.v1.jdbc.QueryKt;
import org.jetbrains.exposed.v1.jdbc.SchemaUtils;
import org.jetbrains.exposed.v1.jdbc.SizedIterable;
import org.jetbrains.exposed.v1.jdbc.transactions.TransactionManagerKt;
import org.jetbrains.exposed.v1.jdbc.transactions.experimental.SuspendedKt;
import org.sqlite.SQLiteConfig;
import org.sqlite.SQLiteDataSource;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u008a\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000f\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0010#\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0019\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\b\u0004*\u0002\u00a2\u0001\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\u0007\u001a\u00020\u00062\b\u0010\u0005\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\u0004\b\u0007\u0010\bJ\u000f\u0010\t\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\t\u0010\nJ\r\u0010\u000b\u001a\u00020\u0006\u00a2\u0006\u0004\b\u000b\u0010\u0003J\u0010\u0010\f\u001a\u00020\u0006H\u0086@\u00a2\u0006\u0004\b\f\u0010\rJ\u0010\u0010\u000e\u001a\u00020\u0006H\u0086@\u00a2\u0006\u0004\b\u000e\u0010\rJ \u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u0011H\u0086@\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u0018\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0010\u001a\u00020\u000fH\u0086@\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u001e\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00192\u0006\u0010\u0010\u001a\u00020\u000fH\u0086@\u00a2\u0006\u0004\b\u001b\u0010\u0018J\u001e\u0010\u001b\u001a\u00020\u00062\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00110\u001cH\u0086@\u00a2\u0006\u0004\b\u001b\u0010\u001eJ\u001e\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00192\u0006\u0010\u0010\u001a\u00020\u000fH\u0086@\u00a2\u0006\u0004\b\u001f\u0010\u0018J\u001e\u0010\u001f\u001a\u00020\u00062\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00110\u001cH\u0086@\u00a2\u0006\u0004\b\u001f\u0010\u001eJ\u001e\u0010 \u001a\b\u0012\u0004\u0012\u00020\u001a0\u00192\u0006\u0010\u0010\u001a\u00020\u000fH\u0086@\u00a2\u0006\u0004\b \u0010\u0018J\u001e\u0010!\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00192\u0006\u0010\u0010\u001a\u00020\u000fH\u0086@\u00a2\u0006\u0004\b!\u0010\u0018J&\u0010$\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00192\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010#\u001a\u00020\"H\u0086@\u00a2\u0006\u0004\b$\u0010%J\u001d\u0010(\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00192\u0006\u0010'\u001a\u00020&H\u0002\u00a2\u0006\u0004\b(\u0010)J\u001d\u0010,\u001a\b\u0012\u0004\u0012\u00020+0*2\u0006\u0010\u0010\u001a\u00020\u000fH\u0002\u00a2\u0006\u0004\b,\u0010-J\u0097\u0001\u0010<\u001a\b\u0012\u0004\u0012\u00020+0*\"\u000e\b\u0000\u0010/*\b\u0012\u0004\u0012\u00028\u00000.\"\u0010\b\u0001\u00101*\n\u0012\u0004\u0012\u00028\u0000\u0018\u000100\"\u0004\b\u0002\u001022\f\u00103\u001a\b\u0012\u0004\u0012\u00020+0*2\u0014\u00106\u001a\u0010\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u000205\u0018\u0001042\u0014\u00108\u001a\u0010\u0012\u0004\u0012\u00028\u0002\u0012\u0006\u0012\u0004\u0018\u00018\u0000072\f\u0010:\u001a\b\u0012\u0004\u0012\u00028\u0001092\u0010\b\u0002\u0010;\u001a\n\u0012\u0004\u0012\u00028\u0001\u0018\u000109H\u0002\u00a2\u0006\u0004\b<\u0010=J{\u0010<\u001a\b\u0012\u0004\u0012\u00020+0*\"\u000e\b\u0000\u0010/*\b\u0012\u0004\u0012\u00028\u00000.\"\u0010\b\u0001\u00101*\n\u0012\u0004\u0012\u00028\u0000\u0018\u0001002\f\u00103\u001a\b\u0012\u0004\u0012\u00020+0*2\u0014\u00106\u001a\u0010\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u000005\u0018\u0001042\f\u0010:\u001a\b\u0012\u0004\u0012\u00028\u0001092\u0010\b\u0002\u0010;\u001a\n\u0012\u0004\u0012\u00028\u0001\u0018\u000109H\u0002\u00a2\u0006\u0004\b<\u0010>J\u001e\u0010@\u001a\u00020\u00062\f\u0010?\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0019H\u0086@\u00a2\u0006\u0004\b@\u0010AJ\u0018\u0010D\u001a\u00020\u00062\u0006\u0010C\u001a\u00020BH\u0086@\u00a2\u0006\u0004\bD\u0010EJ\u0018\u0010H\u001a\u00020\u00062\u0006\u0010G\u001a\u00020FH\u0086@\u00a2\u0006\u0004\bH\u0010IJ \u0010M\u001a\u00020\u00062\u0006\u0010K\u001a\u00020J2\u0006\u0010L\u001a\u00020FH\u0086@\u00a2\u0006\u0004\bM\u0010NJ\u001e\u0010P\u001a\u00020\u00062\f\u0010O\u001a\b\u0012\u0004\u0012\u00020B04H\u0086@\u00a2\u0006\u0004\bP\u0010QJE\u0010W\u001a\u00028\u0000\"\n\b\u0000\u00102*\u0004\u0018\u00010\u00012'\u0010V\u001a#\b\u0001\u0012\u0004\u0012\u00020S\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000T\u0012\u0006\u0012\u0004\u0018\u00010\u00010R\u00a2\u0006\u0002\bUH\u0082@\u00a2\u0006\u0004\bW\u0010XJ\u0018\u0010Y\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u000fH\u0086@\u00a2\u0006\u0004\bY\u0010\u0018J$\u0010]\u001a\b\u0012\u0004\u0012\u00020\\0\u00192\f\u0010[\u001a\b\u0012\u0004\u0012\u00020Z0\u001cH\u0086@\u00a2\u0006\u0004\b]\u0010\u001eJ\u001b\u0010^\u001a\u00020\u0006*\u00020S2\u0006\u0010G\u001a\u00020FH\u0002\u00a2\u0006\u0004\b^\u0010_J\u001b\u0010`\u001a\u00020\u0006*\u00020S2\u0006\u0010C\u001a\u00020BH\u0002\u00a2\u0006\u0004\b`\u0010aJ!\u0010b\u001a\u00020\u0006*\u00020S2\f\u0010O\u001a\b\u0012\u0004\u0012\u00020B04H\u0002\u00a2\u0006\u0004\bb\u0010cJ!\u0010d\u001a\u00020\u0006*\u00020S2\f\u0010?\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0019H\u0002\u00a2\u0006\u0004\bd\u0010eJ#\u0010f\u001a\u00020\u0006*\u00020S2\u0006\u0010K\u001a\u00020J2\u0006\u0010L\u001a\u00020FH\u0002\u00a2\u0006\u0004\bf\u0010gJ#\u0010h\u001a\u00020\u0013*\u00020S2\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u0011H\u0002\u00a2\u0006\u0004\bh\u0010iJ\u001b\u0010\u0017\u001a\u00020\u0016*\u00020S2\u0006\u0010\u0010\u001a\u00020\u000fH\u0002\u00a2\u0006\u0004\b\u0017\u0010jJ!\u0010\u001b\u001a\u00020\u0006*\u00020S2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00110\u001cH\u0002\u00a2\u0006\u0004\b\u001b\u0010kJ!\u0010\u001f\u001a\u00020\u0006*\u00020S2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00110\u001cH\u0002\u00a2\u0006\u0004\b\u001f\u0010kJ\u001b\u0010n\u001a\u0010\u0012\f\u0012\n m*\u0004\u0018\u00010F0F0l\u00a2\u0006\u0004\bn\u0010oJ[\u0010v\u001a\u0004\u0018\u00010\u0011\"\u0004\b\u0000\u001022\u0006\u0010p\u001a\u00028\u00002\u0012\u0010r\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u00110q2\u0018\u0010u\u001a\u0014\u0012\u0004\u0012\u00020\u0011\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00110t0s2\f\u0010:\u001a\b\u0012\u0004\u0012\u00028\u000009H\u0002\u00a2\u0006\u0004\bv\u0010wJu\u0010v\u001a\u0004\u0018\u00010\u0011\"\u0004\b\u0000\u00102\"\u0004\b\u0001\u0010x2\u0006\u0010p\u001a\u00028\u00002\u0012\u0010y\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001072\u0012\u0010r\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u00110q2\u0018\u0010u\u001a\u0014\u0012\u0004\u0012\u00020\u0011\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00110t0s2\f\u0010:\u001a\b\u0012\u0004\u0012\u00028\u000109H\u0002\u00a2\u0006\u0004\bv\u0010zJS\u0010~\u001a\u00020\u0011\"\u0004\b\u0000\u001022\u0006\u0010p\u001a\u00028\u00002\u0012\u0010r\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u00110q2\n\u0010|\u001a\u0006\u0012\u0002\b\u00030{2\u0006\u0010u\u001a\u00020}2\f\u0010:\u001a\b\u0012\u0004\u0012\u00028\u000009H\u0002\u00a2\u0006\u0004\b~\u0010\u007fJn\u0010~\u001a\u00020\u0011\"\u0004\b\u0000\u00102\"\u0004\b\u0001\u0010x2\u0006\u0010p\u001a\u00028\u00002\u0012\u0010y\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001072\u0012\u0010r\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u00110q2\n\u0010|\u001a\u0006\u0012\u0002\b\u00030{2\u0006\u0010u\u001a\u00020}2\f\u0010:\u001a\b\u0012\u0004\u0012\u00028\u000109H\u0002\u00a2\u0006\u0005\b~\u0010\u0080\u0001J\u001b\u0010\u0082\u0001\u001a\u00020\u00112\u0007\u0010\u0081\u0001\u001a\u00020JH\u0002\u00a2\u0006\u0006\b\u0082\u0001\u0010\u0083\u0001J\u001b\u0010\u0085\u0001\u001a\u00020\u00112\u0007\u0010\u0084\u0001\u001a\u00020FH\u0002\u00a2\u0006\u0006\b\u0085\u0001\u0010\u0086\u0001J\u001b\u0010\u0088\u0001\u001a\u00020\u00112\u0007\u0010\u0087\u0001\u001a\u00020FH\u0002\u00a2\u0006\u0006\b\u0088\u0001\u0010\u0086\u0001J\u001a\u0010\u0089\u0001\u001a\u00020\u00112\u0006\u0010C\u001a\u00020BH\u0002\u00a2\u0006\u0006\b\u0089\u0001\u0010\u008a\u0001J\u001a\u0010\u008b\u0001\u001a\u00020\u00112\u0006\u0010C\u001a\u00020BH\u0002\u00a2\u0006\u0006\b\u008b\u0001\u0010\u008a\u0001J\u001d\u0010\u008c\u0001\u001a\u0004\u0018\u00010\u00112\u0007\u0010\u0081\u0001\u001a\u00020JH\u0002\u00a2\u0006\u0006\b\u008c\u0001\u0010\u008d\u0001J\u001d\u0010\u008e\u0001\u001a\u0004\u0018\u00010\u00112\u0007\u0010\u0084\u0001\u001a\u00020FH\u0002\u00a2\u0006\u0006\b\u008e\u0001\u0010\u008f\u0001J\u001d\u0010\u0090\u0001\u001a\u0004\u0018\u00010\u00112\u0007\u0010\u0087\u0001\u001a\u00020FH\u0002\u00a2\u0006\u0006\b\u0090\u0001\u0010\u008f\u0001J\u001c\u0010\u0091\u0001\u001a\u0004\u0018\u00010\u00112\u0006\u0010C\u001a\u00020BH\u0002\u00a2\u0006\u0006\b\u0091\u0001\u0010\u0092\u0001J\u001c\u0010\u0093\u0001\u001a\u0004\u0018\u00010\u00112\u0006\u0010C\u001a\u00020BH\u0002\u00a2\u0006\u0006\b\u0093\u0001\u0010\u0092\u0001J\u001c\u0010Y\u001a\u00020\u0011*\u00020S2\u0006\u0010\u0010\u001a\u00020\u000fH\u0002\u00a2\u0006\u0005\bY\u0010\u0094\u0001J*\u0010\u0095\u0001\u001a\b\u0012\u0004\u0012\u00020\\0\u0019*\u00020S2\f\u0010[\u001a\b\u0012\u0004\u0012\u00020Z0\u001cH\u0002\u00a2\u0006\u0006\b\u0095\u0001\u0010\u0096\u0001R\u001a\u0010\u0098\u0001\u001a\u00030\u0097\u00018\u0002@\u0002X\u0082.\u00a2\u0006\b\n\u0006\b\u0098\u0001\u0010\u0099\u0001R\u0014\u0010\u009c\u0001\u001a\u00020F8F\u00a2\u0006\b\u001a\u0006\b\u009a\u0001\u0010\u009b\u0001R\u0016\u0010r\u001a\u00030\u009d\u00018\u0002X\u0082\u0004\u00a2\u0006\u0007\n\u0005\br\u0010\u009e\u0001R\u001a\u0010\u00a0\u0001\u001a\u00030\u009f\u00018\u0002@\u0002X\u0082\u000e\u00a2\u0006\b\n\u0006\b\u00a0\u0001\u0010\u00a1\u0001R\u0018\u0010\u00a3\u0001\u001a\u00030\u00a2\u00018\u0002X\u0082\u0004\u00a2\u0006\b\n\u0006\b\u00a3\u0001\u0010\u00a4\u0001\u00a8\u0006\u00a5\u0001"}, d2={"Lcom/github/quiltservertools/ledger/database/DatabaseManager;", "", "<init>", "()V", "Ljavax/sql/DataSource;", "dataSource", "", "setup", "(Ljavax/sql/DataSource;)V", "getDefaultDatasource", "()Ljavax/sql/DataSource;", "ensureTables", "setupCache", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "autoPurge", "Lcom/github/quiltservertools/ledger/actionutils/ActionSearchParams;", "params", "", "page", "Lcom/github/quiltservertools/ledger/actionutils/SearchResults;", "searchActions", "(Lcom/github/quiltservertools/ledger/actionutils/ActionSearchParams;ILkotlin/coroutines/Continuation;)Ljava/lang/Object;", "", "countActions", "(Lcom/github/quiltservertools/ledger/actionutils/ActionSearchParams;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "", "Lcom/github/quiltservertools/ledger/actions/ActionType;", "rollbackActions", "", "actionIds", "(Ljava/util/Set;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "restoreActions", "selectRollback", "selectRestore", "Lcom/github/quiltservertools/ledger/actionutils/Preview$Type;", "type", "previewActions", "(Lcom/github/quiltservertools/ledger/actionutils/ActionSearchParams;Lcom/github/quiltservertools/ledger/actionutils/Preview$Type;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "Lorg/jetbrains/exposed/v1/jdbc/Query;", "query", "getActionsFromQuery", "(Lorg/jetbrains/exposed/v1/jdbc/Query;)Ljava/util/List;", "Lorg/jetbrains/exposed/v1/core/Op;", "", "buildQueryParams", "(Lcom/github/quiltservertools/ledger/actionutils/ActionSearchParams;)Lorg/jetbrains/exposed/v1/core/Op;", "", "E", "Lorg/jetbrains/exposed/v1/core/dao/id/EntityID;", "C", "T", "op", "", "Lcom/github/quiltservertools/ledger/utility/Negatable;", "paramSet", "Ljava/util/function/Function;", "objectToId", "Lorg/jetbrains/exposed/v1/core/Column;", "column", "orColumn", "addParameters", "(Lorg/jetbrains/exposed/v1/core/Op;Ljava/util/Collection;Ljava/util/function/Function;Lorg/jetbrains/exposed/v1/core/Column;Lorg/jetbrains/exposed/v1/core/Column;)Lorg/jetbrains/exposed/v1/core/Op;", "(Lorg/jetbrains/exposed/v1/core/Op;Ljava/util/Collection;Lorg/jetbrains/exposed/v1/core/Column;Lorg/jetbrains/exposed/v1/core/Column;)Lorg/jetbrains/exposed/v1/core/Op;", "actions", "logActionBatch", "(Ljava/util/List;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "Lnet/minecraft/class_2960;", "identifier", "registerWorld", "(Lnet/minecraft/class_2960;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "", "id", "registerActionType", "(Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "Ljava/util/UUID;", "uuid", "name", "logPlayer", "(Ljava/util/UUID;Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "identifiers", "insertIdentifiers", "(Ljava/util/Collection;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "Lkotlin/Function2;", "Lorg/jetbrains/exposed/v1/core/Transaction;", "Lkotlin/coroutines/Continuation;", "Lkotlin/ExtensionFunctionType;", "body", "execute", "(Lkotlin/jvm/functions/Function2;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "purgeActions", "Lnet/minecraft/class_11560;", "players", "Lcom/github/quiltservertools/ledger/utility/PlayerResult;", "searchPlayers", "insertActionType", "(Lorg/jetbrains/exposed/v1/core/Transaction;Ljava/lang/String;)V", "insertWorld", "(Lorg/jetbrains/exposed/v1/core/Transaction;Lnet/minecraft/class_2960;)V", "insertRegKeys", "(Lorg/jetbrains/exposed/v1/core/Transaction;Ljava/util/Collection;)V", "insertActions", "(Lorg/jetbrains/exposed/v1/core/Transaction;Ljava/util/List;)V", "insertOrUpdatePlayer", "(Lorg/jetbrains/exposed/v1/core/Transaction;Ljava/util/UUID;Ljava/lang/String;)V", "selectActionsSearch", "(Lorg/jetbrains/exposed/v1/core/Transaction;Lcom/github/quiltservertools/ledger/actionutils/ActionSearchParams;I)Lcom/github/quiltservertools/ledger/actionutils/SearchResults;", "(Lorg/jetbrains/exposed/v1/core/Transaction;Lcom/github/quiltservertools/ledger/actionutils/ActionSearchParams;)J", "(Lorg/jetbrains/exposed/v1/core/Transaction;Ljava/util/Set;)V", "", "kotlin.jvm.PlatformType", "getKnownSources", "()Ljava/util/Set;", "obj", "Lcom/google/common/collect/BiMap;", "cache", "Lorg/jetbrains/exposed/v1/dao/EntityClass;", "Lorg/jetbrains/exposed/v1/dao/Entity;", "table", "getObjectId", "(Ljava/lang/Object;Lcom/google/common/collect/BiMap;Lorg/jetbrains/exposed/v1/dao/EntityClass;Lorg/jetbrains/exposed/v1/core/Column;)Ljava/lang/Integer;", "S", "mapper", "(Ljava/lang/Object;Ljava/util/function/Function;Lcom/google/common/collect/BiMap;Lorg/jetbrains/exposed/v1/dao/EntityClass;Lorg/jetbrains/exposed/v1/core/Column;)Ljava/lang/Integer;", "Lorg/jetbrains/exposed/v1/dao/IntEntityClass;", "entity", "Lorg/jetbrains/exposed/v1/core/dao/id/IntIdTable;", "getOrCreateObjectId", "(Ljava/lang/Object;Lcom/google/common/collect/BiMap;Lorg/jetbrains/exposed/v1/dao/IntEntityClass;Lorg/jetbrains/exposed/v1/core/dao/id/IntIdTable;Lorg/jetbrains/exposed/v1/core/Column;)I", "(Ljava/lang/Object;Ljava/util/function/Function;Lcom/google/common/collect/BiMap;Lorg/jetbrains/exposed/v1/dao/IntEntityClass;Lorg/jetbrains/exposed/v1/core/dao/id/IntIdTable;Lorg/jetbrains/exposed/v1/core/Column;)I", "playerId", "getOrCreatePlayerId", "(Ljava/util/UUID;)I", "source", "getOrCreateSourceId", "(Ljava/lang/String;)I", "actionTypeId", "getOrCreateActionId", "getOrCreateRegistryKeyId", "(Lnet/minecraft/class_2960;)I", "getOrCreateWorldId", "getPlayerId", "(Ljava/util/UUID;)Ljava/lang/Integer;", "getSourceId", "(Ljava/lang/String;)Ljava/lang/Integer;", "getActionId", "getRegistryKeyId", "(Lnet/minecraft/class_2960;)Ljava/lang/Integer;", "getWorldId", "(Lorg/jetbrains/exposed/v1/core/Transaction;Lcom/github/quiltservertools/ledger/actionutils/ActionSearchParams;)I", "selectPlayers", "(Lorg/jetbrains/exposed/v1/core/Transaction;Ljava/util/Set;)Ljava/util/List;", "Lorg/jetbrains/exposed/v1/jdbc/Database;", "database", "Lorg/jetbrains/exposed/v1/jdbc/Database;", "getDatabaseType", "()Ljava/lang/String;", "databaseType", "Lcom/github/quiltservertools/ledger/database/DatabaseCacheService;", "Lcom/github/quiltservertools/ledger/database/DatabaseCacheService;", "Lkotlin/coroutines/CoroutineContext;", "databaseContext", "Lkotlin/coroutines/CoroutineContext;", "com/github/quiltservertools/ledger/database/DatabaseManager.ledgerLogger.1", "ledgerLogger", "Lcom/github/quiltservertools/ledger/database/DatabaseManager$ledgerLogger$1;", "ledger"})
@SourceDebugExtension(value={"SMAP\nDatabaseManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DatabaseManager.kt\ncom/github/quiltservertools/ledger/database/DatabaseManager\n+ 2 OpBuilder.kt\norg/jetbrains/exposed/v1/core/OpBuilderKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,676:1\n68#2:677\n68#2:678\n68#2:679\n68#2:680\n68#2:681\n68#2:682\n68#2:683\n71#2:705\n71#2:706\n68#2:707\n68#2:708\n68#2:709\n68#2:710\n1869#3,2:684\n774#3:686\n865#3,2:687\n1563#3:689\n1634#3,3:690\n827#3:693\n855#3,2:694\n1563#3:696\n1634#3,3:697\n1563#3:701\n1634#3,3:702\n1#4:700\n*S KotlinDebug\n*F\n+ 1 DatabaseManager.kt\ncom/github/quiltservertools/ledger/database/DatabaseManager\n*L\n259#1:677\n260#1:678\n261#1:679\n265#1:680\n269#1:681\n271#1:682\n275#1:683\n357#1:705\n359#1:706\n363#1:707\n380#1:708\n382#1:709\n386#1:710\n325#1:684,2\n392#1:686\n392#1:687,2\n392#1:689\n392#1:690,3\n393#1:693\n393#1:694,2\n393#1:696\n393#1:697,3\n673#1:701\n673#1:702,3\n*E\n"})
public final class DatabaseManager {
    @NotNull
    public static final DatabaseManager INSTANCE = new DatabaseManager();
    private static Database database;
    @NotNull
    private static final DatabaseCacheService cache;
    @NotNull
    private static CoroutineContext databaseContext;
    @NotNull
    private static final ledgerLogger.1 ledgerLogger;

    private DatabaseManager() {
    }

    @NotNull
    public final String getDatabaseType() {
        Database database = DatabaseManager.database;
        if (database == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"database");
            database = null;
        }
        return database.getDialect().getName();
    }

    public final void setup(@Nullable DataSource dataSource) {
        if (dataSource == null) {
            database = Database.Companion.connect$default((Database.Companion)Database.Companion, (DataSource)this.getDefaultDatasource(), null, null, null, null, (int)30, null);
            databaseContext = (CoroutineContext)ThreadPoolDispatcherKt.newSingleThreadContext((String)"Ledger Database");
        } else {
            database = Database.Companion.connect$default((Database.Companion)Database.Companion, (DataSource)dataSource, null, null, null, null, (int)30, null);
        }
    }

    private final DataSource getDefaultDatasource() {
        SQLiteConfig sQLiteConfig;
        Path path = DatabaseSpecKt.getDatabasePath(LedgerConfigKt.getConfig()).resolve("ledger.sqlite");
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
        String dbFilepath = ((Object)path).toString();
        SQLiteConfig $this$getDefaultDatasource_u24lambda_u240 = sQLiteConfig = new SQLiteConfig();
        boolean bl = false;
        $this$getDefaultDatasource_u24lambda_u240.setJournalMode(SQLiteConfig.JournalMode.WAL);
        SQLiteConfig sQLiteConfig2 = sQLiteConfig;
        SQLiteConfig $this$getDefaultDatasource_u24lambda_u241 = sQLiteConfig = new SQLiteDataSource(sQLiteConfig2);
        boolean bl2 = false;
        $this$getDefaultDatasource_u24lambda_u241.setUrl("jdbc:sqlite:" + dbFilepath);
        return (DataSource)sQLiteConfig;
    }

    public final void ensureTables() {
        TransactionManagerKt.transaction$default(null, DatabaseManager::ensureTables$lambda$2, (int)1, null);
    }

    @Nullable
    public final Object setupCache(@NotNull Continuation<? super Unit> $completion) {
        Object object = this.execute((Function2)new Function2<Transaction, Continuation<? super Unit>, Object>(null){
            int label;

            public final Object invokeSuspend(Object $result) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        IntEntity it;
                        ResultKt.throwOnFailure((Object)$result);
                        Iterable $this$forEach$iv = (Iterable)Tables.ActionIdentifier.Companion.all();
                        boolean $i$f$forEach = false;
                        for (T element$iv : $this$forEach$iv) {
                            it = (Tables.ActionIdentifier)((Object)element$iv);
                            boolean bl = false;
                            DatabaseManager.access$getCache$p().getActionIdentifierKeys().put((Object)it.getIdentifier(), it.getId().getValue());
                        }
                        $this$forEach$iv = (Iterable)Tables.World.Companion.all();
                        $i$f$forEach = false;
                        for (T element$iv : $this$forEach$iv) {
                            it = (Tables.World)((Object)element$iv);
                            boolean bl = false;
                            DatabaseManager.access$getCache$p().getWorldIdentifierKeys().put((Object)it.getIdentifier(), it.getId().getValue());
                        }
                        $this$forEach$iv = (Iterable)Tables.ObjectIdentifier.Companion.all();
                        $i$f$forEach = false;
                        for (T element$iv : $this$forEach$iv) {
                            it = (Tables.ObjectIdentifier)((Object)element$iv);
                            boolean bl = false;
                            DatabaseManager.access$getCache$p().getObjectIdentifierKeys().put((Object)it.getIdentifier(), it.getId().getValue());
                        }
                        $this$forEach$iv = (Iterable)Tables.Source.Companion.all();
                        $i$f$forEach = false;
                        for (T element$iv : $this$forEach$iv) {
                            it = (Tables.Source)((Object)element$iv);
                            boolean bl = false;
                            DatabaseManager.access$getCache$p().getSourceKeys().put((Object)it.getName(), it.getId().getValue());
                        }
                        $this$forEach$iv = (Iterable)Tables.Player.Companion.all();
                        $i$f$forEach = false;
                        for (T element$iv : $this$forEach$iv) {
                            it = (Tables.Player)((Object)element$iv);
                            boolean bl = false;
                            DatabaseManager.access$getCache$p().getPlayerKeys().put((Object)it.getPlayerId(), it.getId().getValue());
                        }
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(Transaction p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }, $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    @Nullable
    public final Object autoPurge(@NotNull Continuation<? super Unit> $completion) {
        if (((Number)LedgerConfigKt.getConfig().get((Item)DatabaseSpec.INSTANCE.getAutoPurgeDays())).intValue() > 0) {
            Object object = this.execute((Function2)new Function2<Transaction, Continuation<? super Unit>, Object>(null){
                int label;

                public final Object invokeSuspend(Object $result) {
                    IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)$result);
                            Ledger.INSTANCE.getLogger().info("Purging actions older than " + LedgerConfigKt.getConfig().get((Item)DatabaseSpec.INSTANCE.getAutoPurgeDays()) + " days");
                            int deleted = QueriesKt.deleteWhere$default((Table)((Table)Tables.Actions.INSTANCE), null, autoPurge.2::invokeSuspend$lambda$0, (int)1, null);
                            Ledger.INSTANCE.getLogger().info("Successfully purged " + deleted + " actions");
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                public final Object invoke(Transaction p1, Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }

                private static final Op invokeSuspend$lambda$0(Tables.Actions $this$deleteWhere) {
                    ExpressionWithColumnType expressionWithColumnType = (ExpressionWithColumnType)$this$deleteWhere.getTimestamp();
                    Instant instant = Instant.now().minus(((Number)LedgerConfigKt.getConfig().get((Item)DatabaseSpec.INSTANCE.getAutoPurgeDays())).intValue(), ChronoUnit.DAYS);
                    Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"minus(...)");
                    return (Op)OpBuilderKt.lessEq((ExpressionWithColumnType)expressionWithColumnType, (Comparable)instant);
                }
            }, $completion);
            if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                return object;
            }
            return Unit.INSTANCE;
        }
        return Unit.INSTANCE;
    }

    @Nullable
    public final Object searchActions(@NotNull ActionSearchParams params, int page2, @NotNull Continuation<? super SearchResults> $completion) {
        return this.execute((Function2)new Function2<Transaction, Continuation<? super SearchResults>, Object>(params, page2, null){
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ ActionSearchParams $params;
            final /* synthetic */ int $page;
            {
                this.$params = $params;
                this.$page = $page;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             */
            public final Object invokeSuspend(Object $result) {
                Transaction transaction = (Transaction)this.L$0;
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        void $this$execute;
                        ResultKt.throwOnFailure((Object)$result);
                        return DatabaseManager.access$selectActionsSearch(DatabaseManager.INSTANCE, (Transaction)$this$execute, this.$params, this.$page);
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.L$0 = value;
                return (Continuation)var3_3;
            }

            public final Object invoke(Transaction p1, Continuation<? super SearchResults> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }, $completion);
    }

    @Nullable
    public final Object countActions(@NotNull ActionSearchParams params, @NotNull Continuation<? super Long> $completion) {
        return this.execute((Function2)new Function2<Transaction, Continuation<? super Long>, Object>(params, null){
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ ActionSearchParams $params;
            {
                this.$params = $params;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             */
            public final Object invokeSuspend(Object $result) {
                Transaction transaction = (Transaction)this.L$0;
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        void $this$execute;
                        ResultKt.throwOnFailure((Object)$result);
                        return Boxing.boxLong((long)DatabaseManager.access$countActions(DatabaseManager.INSTANCE, (Transaction)$this$execute, this.$params));
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.L$0 = value;
                return (Continuation)var3_3;
            }

            public final Object invoke(Transaction p1, Continuation<? super Long> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }, $completion);
    }

    @Nullable
    public final Object rollbackActions(@NotNull ActionSearchParams params, @NotNull Continuation<? super List<? extends ActionType>> $completion) {
        return this.execute((Function2)new Function2<Transaction, Continuation<? super List<? extends ActionType>>, Object>(params, null){
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ ActionSearchParams $params;
            {
                this.$params = $params;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object $result) {
                var2_2 = (Transaction)this.L$0;
                var15_3 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.L$0 = $this$execute;
                        this.label = 1;
                        v0 = DatabaseManager.INSTANCE.selectRollback(this.$params, (Continuation<? super List<? extends ActionType>>)((Continuation)this));
                        if (v0 == var15_3) {
                            return var15_3;
                        }
                        ** GOTO lbl15
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl15:
                        // 2 sources

                        actions = (List)v0;
                        $this$map$iv = actions;
                        $i$f$map = false;
                        var7_7 = $this$map$iv;
                        destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                        $i$f$mapTo = false;
                        for (T item$iv$iv : $this$mapTo$iv$iv) {
                            var12_12 = (ActionType)item$iv$iv;
                            var14_14 = destination$iv$iv;
                            $i$a$-map-DatabaseManager$rollbackActions$2$actionIds$1 = false;
                            var14_14.add(Boxing.boxInt((int)it.getId()));
                        }
                        actionIds = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
                        DatabaseManager.access$rollbackActions(DatabaseManager.INSTANCE, (Transaction)$this$execute, actionIds);
                        return actions;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.L$0 = value;
                return (Continuation)var3_3;
            }

            public final Object invoke(Transaction p1, Continuation<? super List<? extends ActionType>> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }, $completion);
    }

    @Nullable
    public final Object rollbackActions(@NotNull Set<Integer> actionIds, @NotNull Continuation<? super Unit> $completion) {
        Object object = this.execute((Function2)new Function2<Transaction, Continuation<? super Unit>, Object>(actionIds, null){
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ Set<Integer> $actionIds;
            {
                this.$actionIds = $actionIds;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             */
            public final Object invokeSuspend(Object $result) {
                Transaction transaction = (Transaction)this.L$0;
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        void $this$execute;
                        ResultKt.throwOnFailure((Object)$result);
                        DatabaseManager.access$rollbackActions(DatabaseManager.INSTANCE, (Transaction)$this$execute, this.$actionIds);
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.L$0 = value;
                return (Continuation)var3_3;
            }

            public final Object invoke(Transaction p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }, $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    @Nullable
    public final Object restoreActions(@NotNull ActionSearchParams params, @NotNull Continuation<? super List<? extends ActionType>> $completion) {
        return this.execute((Function2)new Function2<Transaction, Continuation<? super List<? extends ActionType>>, Object>(params, null){
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ ActionSearchParams $params;
            {
                this.$params = $params;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object $result) {
                var2_2 = (Transaction)this.L$0;
                var15_3 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.L$0 = $this$execute;
                        this.label = 1;
                        v0 = DatabaseManager.INSTANCE.selectRestore(this.$params, (Continuation<? super List<? extends ActionType>>)((Continuation)this));
                        if (v0 == var15_3) {
                            return var15_3;
                        }
                        ** GOTO lbl15
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl15:
                        // 2 sources

                        actions = (List)v0;
                        $this$map$iv = actions;
                        $i$f$map = false;
                        var7_7 = $this$map$iv;
                        destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                        $i$f$mapTo = false;
                        for (T item$iv$iv : $this$mapTo$iv$iv) {
                            var12_12 = (ActionType)item$iv$iv;
                            var14_14 = destination$iv$iv;
                            $i$a$-map-DatabaseManager$restoreActions$2$actionIds$1 = false;
                            var14_14.add(Boxing.boxInt((int)it.getId()));
                        }
                        actionIds = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
                        DatabaseManager.access$restoreActions(DatabaseManager.INSTANCE, (Transaction)$this$execute, actionIds);
                        return actions;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.L$0 = value;
                return (Continuation)var3_3;
            }

            public final Object invoke(Transaction p1, Continuation<? super List<? extends ActionType>> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }, $completion);
    }

    @Nullable
    public final Object restoreActions(@NotNull Set<Integer> actionIds, @NotNull Continuation<? super Unit> $completion) {
        Object object = this.execute((Function2)new Function2<Transaction, Continuation<? super Unit>, Object>(actionIds, null){
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ Set<Integer> $actionIds;
            {
                this.$actionIds = $actionIds;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             */
            public final Object invokeSuspend(Object $result) {
                Transaction transaction = (Transaction)this.L$0;
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        void $this$execute;
                        ResultKt.throwOnFailure((Object)$result);
                        DatabaseManager.access$restoreActions(DatabaseManager.INSTANCE, (Transaction)$this$execute, this.$actionIds);
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.L$0 = value;
                return (Continuation)var3_3;
            }

            public final Object invoke(Transaction p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }, $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    @Nullable
    public final Object selectRollback(@NotNull ActionSearchParams params, @NotNull Continuation<? super List<? extends ActionType>> $completion) {
        return this.execute((Function2)new Function2<Transaction, Continuation<? super List<? extends ActionType>>, Object>(params, null){
            int label;
            final /* synthetic */ ActionSearchParams $params;
            {
                this.$params = $params;
                super(2, $completion);
            }

            public final Object invokeSuspend(Object $result) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        Query query = QueriesKt.selectAll((FieldSet)((FieldSet)Tables.Actions.INSTANCE)).where(OpBuilderKt.and((Expression)((Expression)DatabaseManager.access$buildQueryParams(DatabaseManager.INSTANCE, this.$params)), (Expression)((Expression)OpBuilderKt.eq((ExpressionWithColumnType)((ExpressionWithColumnType)Tables.Actions.INSTANCE.getRolledBack()), (Object)Boxing.boxBoolean((boolean)false))))).orderBy((Expression)Tables.Actions.INSTANCE.getId(), SortOrder.DESC);
                        return DatabaseManager.access$getActionsFromQuery(DatabaseManager.INSTANCE, query);
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(Transaction p1, Continuation<? super List<? extends ActionType>> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }, $completion);
    }

    @Nullable
    public final Object selectRestore(@NotNull ActionSearchParams params, @NotNull Continuation<? super List<? extends ActionType>> $completion) {
        return this.execute((Function2)new Function2<Transaction, Continuation<? super List<? extends ActionType>>, Object>(params, null){
            int label;
            final /* synthetic */ ActionSearchParams $params;
            {
                this.$params = $params;
                super(2, $completion);
            }

            public final Object invokeSuspend(Object $result) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        Query query = QueriesKt.selectAll((FieldSet)((FieldSet)Tables.Actions.INSTANCE)).where(OpBuilderKt.and((Expression)((Expression)DatabaseManager.access$buildQueryParams(DatabaseManager.INSTANCE, this.$params)), (Expression)((Expression)OpBuilderKt.eq((ExpressionWithColumnType)((ExpressionWithColumnType)Tables.Actions.INSTANCE.getRolledBack()), (Object)Boxing.boxBoolean((boolean)true))))).orderBy((Expression)Tables.Actions.INSTANCE.getId(), SortOrder.ASC);
                        return DatabaseManager.access$getActionsFromQuery(DatabaseManager.INSTANCE, query);
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(Transaction p1, Continuation<? super List<? extends ActionType>> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }, $completion);
    }

    @Nullable
    public final Object previewActions(@NotNull ActionSearchParams params, @NotNull Preview.Type type, @NotNull Continuation<? super List<? extends ActionType>> $completion) {
        return this.execute((Function2)new Function2<Transaction, Continuation<? super List<? extends ActionType>>, Object>(type, params, null){
            int label;
            final /* synthetic */ Preview.Type $type;
            final /* synthetic */ ActionSearchParams $params;
            {
                this.$type = $type;
                this.$params = $params;
                super(2, $completion);
            }

            /*
             * Recovered potentially malformed switches.  Disable with '--allowmalformedswitch false'
             * Enabled aggressive block sorting
             */
            public final Object invokeSuspend(Object $result) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        Object object2;
                        ResultKt.throwOnFailure((Object)$result);
                        switch (previewActions.WhenMappings.$EnumSwitchMapping$0[this.$type.ordinal()]) {
                            case 1: {
                                this.label = 1;
                                Object object3 = DatabaseManager.INSTANCE.selectRollback(this.$params, (Continuation<? super List<? extends ActionType>>)((Continuation)this));
                                if (object3 != object) return object3;
                                return object;
                            }
                            case 1: {
                                ResultKt.throwOnFailure((Object)$result);
                                Object object3 = $result;
                                return object3;
                            }
                            case 2: {
                                this.label = 2;
                                object2 = DatabaseManager.INSTANCE.selectRestore(this.$params, (Continuation<? super List<? extends ActionType>>)((Continuation)this));
                                if (object2 != object) return object2;
                                return object;
                            }
                            default: {
                                throw new NoWhenBranchMatchedException();
                            }
                        }
                    }
                    case 2: {
                        ResultKt.throwOnFailure((Object)$result);
                        Object object2 = $result;
                        return object2;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(Transaction p1, Continuation<? super List<? extends ActionType>> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }, $completion);
    }

    /*
     * Unable to fully structure code
     */
    private final List<ActionType> getActionsFromQuery(Query query) {
        actions = new ArrayList<E>();
        actionIdentifierCache = DatabaseCacheService.INSTANCE.getActionIdentifierKeys().inverse();
        worldCache = DatabaseCacheService.INSTANCE.getWorldIdentifierKeys().inverse();
        objectIdentifierCache = DatabaseCacheService.INSTANCE.getObjectIdentifierKeys().inverse();
        sourceCache = DatabaseCacheService.INSTANCE.getSourceKeys().inverse();
        playerCache = DatabaseCacheService.INSTANCE.getPlayerKeys().inverse();
        for (ResultRow action : query) {
            block5: {
                block4: {
                    v0 = actionIdentifierCache.get(((EntityID)action.get((Expression)Tables.Actions.INSTANCE.getActionIdentifier())).getValue());
                    Intrinsics.checkNotNull((Object)v0);
                    typeSupplier = ActionRegistry.INSTANCE.getType((String)v0);
                    if (typeSupplier == null) {
                        LedgerKt.logWarn("Unknown action type " + actionIdentifierCache.get(((EntityID)action.get((Expression)Tables.Actions.INSTANCE.getActionIdentifier())).getValue()));
                        continue;
                    }
                    Intrinsics.checkNotNullExpressionValue((Object)typeSupplier.get(), (String)"get(...)");
                    type.setId(((Number)((EntityID)action.get((Expression)Tables.Actions.INSTANCE.getId())).getValue()).intValue());
                    type.setTimestamp((Instant)action.get((Expression)Tables.Actions.INSTANCE.getTimestamp()));
                    type.setPos(new class_2338(((Number)action.get((Expression)Tables.Actions.INSTANCE.getX())).intValue(), ((Number)action.get((Expression)Tables.Actions.INSTANCE.getY())).intValue(), ((Number)action.get((Expression)Tables.Actions.INSTANCE.getZ())).intValue()));
                    type.setWorld((class_2960)worldCache.get(((EntityID)action.get((Expression)Tables.Actions.INSTANCE.getWorld())).getValue()));
                    v1 = objectIdentifierCache.get(((EntityID)action.get((Expression)Tables.Actions.INSTANCE.getObjectId())).getValue());
                    Intrinsics.checkNotNull((Object)v1);
                    type.setObjectIdentifier((class_2960)v1);
                    v2 = objectIdentifierCache.get(((EntityID)action.get((Expression)Tables.Actions.INSTANCE.getOldObjectId())).getValue());
                    Intrinsics.checkNotNull((Object)v2);
                    type.setOldObjectIdentifier((class_2960)v2);
                    type.setObjectState((String)action.get((Expression)Tables.Actions.INSTANCE.getBlockState()));
                    type.setOldObjectState((String)action.get((Expression)Tables.Actions.INSTANCE.getOldBlockState()));
                    v3 = sourceCache.get(((EntityID)action.get((Expression)Tables.Actions.INSTANCE.getSourceName())).getValue());
                    Intrinsics.checkNotNull((Object)v3);
                    type.setSourceName((String)v3);
                    v4 = type;
                    if ((EntityID)action.getOrNull((Expression)Tables.Actions.INSTANCE.getSourcePlayer()) == null) break block4;
                    var14_14 = v4;
                    $i$a$-let-DatabaseManager$getActionsFromQuery$1 = false;
                    v5 = Ledger.INSTANCE.getServer().method_73550().comp_4407();
                    if (v5 == null) ** GOTO lbl-1000
                    v6 = playerCache.get(it.getValue());
                    Intrinsics.checkNotNull((Object)v6);
                    if ((v5 = v5.method_14512((UUID)v6)) != null) {
                        v7 = v5.orElse(null);
                    } else lbl-1000:
                    // 2 sources

                    {
                        v7 = null;
                    }
                    v8 = v7;
                    v4 = var14_14;
                    break block5;
                }
                v8 = null;
            }
            v4.setSourceProfile(v8);
            type.setExtraData((String)action.get((Expression)Tables.Actions.INSTANCE.getExtraData()));
            type.setRolledBack((Boolean)action.get((Expression)Tables.Actions.INSTANCE.getRolledBack()));
            actions.add(type);
        }
        return actions;
    }

    private final Op<Boolean> buildQueryParams(ActionSearchParams params) {
        Expression expression;
        boolean $i$f$and;
        Expression $this$and$iv;
        Op op = (Op)Op.TRUE.INSTANCE;
        if (params.getBounds() != null && !Intrinsics.areEqual((Object)params.getBounds(), (Object)ActionSearchParams.Companion.getGLOBAL())) {
            $this$and$iv = (Expression)op;
            $i$f$and = false;
            expression = $this$and$iv;
            boolean bl = false;
            op = OpBuilderKt.and((Expression)expression, (Expression)((Expression)((Op)OpBuilderKt.between((ExpressionWithColumnType)((ExpressionWithColumnType)Tables.Actions.INSTANCE.getX()), (Object)params.getBounds().method_35415(), (Object)params.getBounds().method_35418()))));
            $this$and$iv = (Expression)op;
            $i$f$and = false;
            expression = $this$and$iv;
            boolean bl2 = false;
            op = OpBuilderKt.and((Expression)expression, (Expression)((Expression)((Op)OpBuilderKt.between((ExpressionWithColumnType)((ExpressionWithColumnType)Tables.Actions.INSTANCE.getY()), (Object)params.getBounds().method_35416(), (Object)params.getBounds().method_35419()))));
            $this$and$iv = (Expression)op;
            $i$f$and = false;
            expression = $this$and$iv;
            boolean bl3 = false;
            op = OpBuilderKt.and((Expression)expression, (Expression)((Expression)((Op)OpBuilderKt.between((ExpressionWithColumnType)((ExpressionWithColumnType)Tables.Actions.INSTANCE.getZ()), (Object)params.getBounds().method_35417(), (Object)params.getBounds().method_35420()))));
        }
        if (params.getBefore() != null && params.getAfter() != null) {
            $this$and$iv = (Expression)op;
            $i$f$and = false;
            expression = $this$and$iv;
            boolean bl = false;
            op = OpBuilderKt.and((Expression)expression, (Expression)((Expression)OpBuilderKt.and((Expression)((Expression)OpBuilderKt.greaterEq((ExpressionWithColumnType)((ExpressionWithColumnType)Tables.Actions.INSTANCE.getTimestamp()), (Comparable)params.getAfter())), (Expression)((Expression)OpBuilderKt.lessEq((ExpressionWithColumnType)((ExpressionWithColumnType)Tables.Actions.INSTANCE.getTimestamp()), (Comparable)params.getBefore())))));
        } else if (params.getBefore() != null) {
            $this$and$iv = (Expression)op;
            $i$f$and = false;
            expression = $this$and$iv;
            boolean bl = false;
            op = OpBuilderKt.and((Expression)expression, (Expression)((Expression)((Op)OpBuilderKt.lessEq((ExpressionWithColumnType)((ExpressionWithColumnType)Tables.Actions.INSTANCE.getTimestamp()), (Comparable)params.getBefore()))));
        } else if (params.getAfter() != null) {
            $this$and$iv = (Expression)op;
            $i$f$and = false;
            expression = $this$and$iv;
            boolean bl = false;
            op = OpBuilderKt.and((Expression)expression, (Expression)((Expression)((Op)OpBuilderKt.greaterEq((ExpressionWithColumnType)((ExpressionWithColumnType)Tables.Actions.INSTANCE.getTimestamp()), (Comparable)params.getAfter()))));
        }
        if (params.getRolledBack() != null) {
            $this$and$iv = (Expression)op;
            $i$f$and = false;
            expression = $this$and$iv;
            boolean bl = false;
            op = OpBuilderKt.and((Expression)expression, (Expression)((Expression)OpBuilderKt.eq((ExpressionWithColumnType)((ExpressionWithColumnType)Tables.Actions.INSTANCE.getRolledBack()), (Object)params.getRolledBack())));
        }
        op = DatabaseManager.addParameters$default(this, op, params.getSourceNames(), INSTANCE::getSourceId, Tables.Actions.INSTANCE.getSourceName(), null, 16, null);
        op = DatabaseManager.addParameters$default(this, op, params.getActions(), INSTANCE::getActionId, Tables.Actions.INSTANCE.getActionIdentifier(), null, 16, null);
        op = DatabaseManager.addParameters$default(this, op, params.getWorlds(), INSTANCE::getWorldId, Tables.Actions.INSTANCE.getWorld(), null, 16, null);
        op = this.addParameters((Op<Boolean>)op, (Collection)params.getObjects(), INSTANCE::getRegistryKeyId, Tables.Actions.INSTANCE.getObjectId(), Tables.Actions.INSTANCE.getOldObjectId());
        op = DatabaseManager.addParameters$default(this, op, params.getSourcePlayerIds(), INSTANCE::getPlayerId, Tables.Actions.INSTANCE.getSourcePlayer(), null, 16, null);
        return op;
    }

    private final <E extends Comparable<? super E>, C extends EntityID<E>, T> Op<Boolean> addParameters(Op<Boolean> op, Collection<Negatable<T>> paramSet, Function<T, E> objectToId, Column<C> column, Column<C> orColumn) {
        Set idParamSet;
        block2: {
            idParamSet = new LinkedHashSet();
            Collection<Negatable<T>> collection = paramSet;
            if (collection == null) break block2;
            Iterable $this$forEach$iv = collection;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Negatable it = (Negatable)element$iv;
                boolean bl = false;
                Comparable paramId = (Comparable)objectToId.apply(it.getProperty());
                if (paramId != null) {
                    idParamSet.add(new Negatable<Comparable>(paramId, it.getAllowed()));
                    continue;
                }
                return (Op)Op.FALSE.INSTANCE;
            }
        }
        return this.addParameters(op, idParamSet, column, orColumn);
    }

    static /* synthetic */ Op addParameters$default(DatabaseManager databaseManager, Op op, Collection collection, Function function, Column column, Column column2, int n, Object object) {
        if ((n & 0x10) != 0) {
            column2 = null;
        }
        return databaseManager.addParameters((Op<Boolean>)op, collection, function, column, column2);
    }

    /*
     * WARNING - void declaration
     */
    private final <E extends Comparable<? super E>, C extends EntityID<E>> Op<Boolean> addParameters(Op<Boolean> op, Collection<Negatable<E>> paramSet, Column<C> column, Column<C> orColumn) {
        Iterable $this$filterNotTo$iv$iv;
        Iterable $this$filterNot$iv;
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        Negatable it;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        Collection<Negatable<E>> collection = paramSet;
        if (collection == null || collection.isEmpty()) {
            return op;
        }
        Op<Boolean> newOp = op;
        Iterable iterable = paramSet;
        Column<C> column2 = column;
        Column<C> column3 = orColumn;
        boolean $i$f$filter = false;
        void var8_10 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (Negatable)element$iv$iv;
            boolean bl = false;
            if (!it.getAllowed()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Collection<Comparable> collection2 = (List)destination$iv$iv;
        $this$filter$iv = collection2;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (Negatable)item$iv$iv;
            collection2 = destination$iv$iv;
            boolean bl = false;
            collection2.add((Comparable)it.getProperty());
        }
        collection2 = (List)destination$iv$iv;
        newOp = DatabaseManager.addParameters$addAllowedParameters(column3, column2, (Collection)collection2, newOp);
        $this$map$iv = paramSet;
        column2 = column;
        column3 = orColumn;
        boolean $i$f$filterNot = false;
        $this$mapTo$iv$iv = $this$filterNot$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            it = (Negatable)element$iv$iv;
            boolean bl = false;
            if (it.getAllowed()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        collection2 = (List)destination$iv$iv;
        $this$filterNot$iv = collection2;
        $i$f$map = false;
        $this$filterNotTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (Negatable)item$iv$iv;
            collection2 = destination$iv$iv;
            boolean bl = false;
            collection2.add((Comparable)it.getProperty());
        }
        collection2 = (List)destination$iv$iv;
        newOp = DatabaseManager.addParameters$addDeniedParameters(column3, column2, collection2, newOp);
        return newOp;
    }

    static /* synthetic */ Op addParameters$default(DatabaseManager databaseManager, Op op, Collection collection, Column column, Column column2, int n, Object object) {
        if ((n & 8) != 0) {
            column2 = null;
        }
        return databaseManager.addParameters((Op<Boolean>)op, collection, column, column2);
    }

    @Nullable
    public final Object logActionBatch(@NotNull List<? extends ActionType> actions, @NotNull Continuation<? super Unit> $completion) {
        Object object = this.execute((Function2)new Function2<Transaction, Continuation<? super Unit>, Object>(actions, null){
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ List<ActionType> $actions;
            {
                this.$actions = $actions;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             */
            public final Object invokeSuspend(Object $result) {
                Transaction transaction = (Transaction)this.L$0;
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        void $this$execute;
                        ResultKt.throwOnFailure((Object)$result);
                        DatabaseManager.access$insertActions(DatabaseManager.INSTANCE, (Transaction)$this$execute, this.$actions);
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.L$0 = value;
                return (Continuation)var3_3;
            }

            public final Object invoke(Transaction p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }, $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    @Nullable
    public final Object registerWorld(@NotNull class_2960 identifier, @NotNull Continuation<? super Unit> $completion) {
        Object object = this.execute((Function2)new Function2<Transaction, Continuation<? super Unit>, Object>(identifier, null){
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ class_2960 $identifier;
            {
                this.$identifier = $identifier;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             */
            public final Object invokeSuspend(Object $result) {
                Transaction transaction = (Transaction)this.L$0;
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        void $this$execute;
                        ResultKt.throwOnFailure((Object)$result);
                        DatabaseManager.access$insertWorld(DatabaseManager.INSTANCE, (Transaction)$this$execute, this.$identifier);
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.L$0 = value;
                return (Continuation)var3_3;
            }

            public final Object invoke(Transaction p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }, $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    @Nullable
    public final Object registerActionType(@NotNull String id, @NotNull Continuation<? super Unit> $completion) {
        Object object = this.execute((Function2)new Function2<Transaction, Continuation<? super Unit>, Object>(id, null){
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ String $id;
            {
                this.$id = $id;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             */
            public final Object invokeSuspend(Object $result) {
                Transaction transaction = (Transaction)this.L$0;
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        void $this$execute;
                        ResultKt.throwOnFailure((Object)$result);
                        DatabaseManager.access$insertActionType(DatabaseManager.INSTANCE, (Transaction)$this$execute, this.$id);
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.L$0 = value;
                return (Continuation)var3_3;
            }

            public final Object invoke(Transaction p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }, $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    @Nullable
    public final Object logPlayer(@NotNull UUID uuid, @NotNull String name, @NotNull Continuation<? super Unit> $completion) {
        Object object = this.execute((Function2)new Function2<Transaction, Continuation<? super Unit>, Object>(uuid, name, null){
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ UUID $uuid;
            final /* synthetic */ String $name;
            {
                this.$uuid = $uuid;
                this.$name = $name;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             */
            public final Object invokeSuspend(Object $result) {
                Transaction transaction = (Transaction)this.L$0;
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        void $this$execute;
                        ResultKt.throwOnFailure((Object)$result);
                        DatabaseManager.access$insertOrUpdatePlayer(DatabaseManager.INSTANCE, (Transaction)$this$execute, this.$uuid, this.$name);
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.L$0 = value;
                return (Continuation)var3_3;
            }

            public final Object invoke(Transaction p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }, $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    @Nullable
    public final Object insertIdentifiers(@NotNull Collection<class_2960> identifiers, @NotNull Continuation<? super Unit> $completion) {
        Object object = this.execute((Function2)new Function2<Transaction, Continuation<? super Unit>, Object>(identifiers, null){
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ Collection<class_2960> $identifiers;
            {
                this.$identifiers = $identifiers;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             */
            public final Object invokeSuspend(Object $result) {
                Transaction transaction = (Transaction)this.L$0;
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        void $this$execute;
                        ResultKt.throwOnFailure((Object)$result);
                        DatabaseManager.access$insertRegKeys(DatabaseManager.INSTANCE, (Transaction)$this$execute, this.$identifiers);
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.L$0 = value;
                return (Continuation)var3_3;
            }

            public final Object invoke(Transaction p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }, $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    /*
     * Unable to fully structure code
     */
    private final <T> Object execute(Function2<? super Transaction, ? super Continuation<? super T>, ? extends Object> body, Continuation<? super T> $completion) {
        if (!($completion instanceof execute.1)) ** GOTO lbl-1000
        var4_3 = $completion;
        if ((var4_3.label & -2147483648) != 0) {
            var4_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                /* synthetic */ Object result;
                final /* synthetic */ DatabaseManager this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return DatabaseManager.access$execute(this.this$0, null, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var5_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        block0 : switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
lbl12:
                // 2 sources

                while (true) {
                    v0 = Ledger.INSTANCE.getServer().method_30002();
                    if (v0 != null ? !v0.field_13957 : false) break block0;
                    $continuation.L$0 = body;
                    $continuation.label = 1;
                    v1 = DelayKt.delay((long)1000L, $continuation);
                    if (v1 != var5_5) continue;
                    return var5_5;
                }
            }
            case 1: {
                body = (Function2)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v1 = $result;
                ** continue;
            }
        }
        v2 = DatabaseManager.database;
        if (v2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"database");
            v2 = null;
        }
        $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)body);
        $continuation.label = 2;
        v3 = SuspendedKt.newSuspendedTransaction$default((CoroutineContext)DatabaseManager.databaseContext, (Database)v2, null, null, (Function2)((Function2)new Function2<JdbcTransaction, Continuation<? super T>, Object>(body, null){
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ Function2<Transaction, Continuation<? super T>, Object> $body;
            {
                this.$body = $body;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                JdbcTransaction jdbcTransaction = (JdbcTransaction)this.L$0;
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        void $this$newSuspendedTransaction;
                        ResultKt.throwOnFailure((Object)$result);
                        $this$newSuspendedTransaction.setMaxAttempts(10);
                        $this$newSuspendedTransaction.setMinRetryDelay(1000L);
                        $this$newSuspendedTransaction.setMaxRetryDelay(300000L);
                        if (((Boolean)Ledger.INSTANCE.getConfig().get((Item)DatabaseSpec.INSTANCE.getLogSQL())).booleanValue()) {
                            SqlLogger[] sqlLoggerArray = new SqlLogger[]{DatabaseManager.access$getLedgerLogger$p()};
                            $this$newSuspendedTransaction.addLogger(sqlLoggerArray);
                        }
                        this.L$0 = SpillingKt.nullOutSpilledVariable((Object)$this$newSuspendedTransaction);
                        this.label = 1;
                        Object object2 = this.$body.invoke((Object)$this$newSuspendedTransaction, (Object)((Object)this));
                        if (object2 != object) return object2;
                        return object;
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        Object object2 = $result;
                        return object2;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.L$0 = value;
                return (Continuation)var3_3;
            }

            public final Object invoke(JdbcTransaction p1, Continuation<? super T> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), $continuation, (int)12, null);
        if (v3 == var5_5) {
            return var5_5;
        }
        ** GOTO lbl39
        {
            case 2: {
                body = (Function2)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v3 = $result;
lbl39:
                // 2 sources

                return v3;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    @Nullable
    public final Object purgeActions(@NotNull ActionSearchParams params, @NotNull Continuation<? super Unit> $completion) {
        Object object = this.execute((Function2)new Function2<Transaction, Continuation<? super Integer>, Object>(params, null){
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ ActionSearchParams $params;
            {
                this.$params = $params;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             */
            public final Object invokeSuspend(Object $result) {
                Transaction transaction = (Transaction)this.L$0;
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        void $this$execute;
                        ResultKt.throwOnFailure((Object)$result);
                        return Boxing.boxInt((int)DatabaseManager.access$purgeActions(DatabaseManager.INSTANCE, (Transaction)$this$execute, this.$params));
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.L$0 = value;
                return (Continuation)var3_3;
            }

            public final Object invoke(Transaction p1, Continuation<? super Integer> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }, $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    @Nullable
    public final Object searchPlayers(@NotNull Set<class_11560> players, @NotNull Continuation<? super List<PlayerResult>> $completion) {
        return this.execute((Function2)new Function2<Transaction, Continuation<? super List<? extends PlayerResult>>, Object>(players, null){
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ Set<class_11560> $players;
            {
                this.$players = $players;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             */
            public final Object invokeSuspend(Object $result) {
                Transaction transaction = (Transaction)this.L$0;
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        void $this$execute;
                        ResultKt.throwOnFailure((Object)$result);
                        return DatabaseManager.access$selectPlayers(DatabaseManager.INSTANCE, (Transaction)$this$execute, this.$players);
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.L$0 = value;
                return (Continuation)var3_3;
            }

            public final Object invoke(Transaction p1, Continuation<? super List<PlayerResult>> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }, $completion);
    }

    private final void insertActionType(Transaction $this$insertActionType, String id) {
        QueriesKt.insertIgnore((Table)((Table)Tables.ActionIdentifiers.INSTANCE), (arg_0, arg_1) -> DatabaseManager.insertActionType$lambda$26(id, arg_0, arg_1));
    }

    private final void insertWorld(Transaction $this$insertWorld, class_2960 identifier) {
        QueriesKt.insertIgnore((Table)((Table)Tables.Worlds.INSTANCE), (arg_0, arg_1) -> DatabaseManager.insertWorld$lambda$27(identifier, arg_0, arg_1));
    }

    private final void insertRegKeys(Transaction $this$insertRegKeys, Collection<class_2960> identifiers) {
        QueriesKt.batchInsert$default((Table)((Table)Tables.ObjectIdentifiers.INSTANCE), (Iterable)identifiers, (boolean)true, (boolean)false, DatabaseManager::insertRegKeys$lambda$28, (int)4, null);
    }

    private final void insertActions(Transaction $this$insertActions, List<? extends ActionType> actions) {
        QueriesKt.batchInsert$default((Table)((Table)Tables.Actions.INSTANCE), (Iterable)actions, (boolean)false, (boolean)false, DatabaseManager::insertActions$lambda$30, (int)2, null);
    }

    private final void insertOrUpdatePlayer(Transaction $this$insertOrUpdatePlayer, UUID uuid, String name) {
        Tables.Player player = (Tables.Player)((Object)CollectionsKt.firstOrNull((Iterable)((Iterable)Tables.Player.Companion.find(() -> DatabaseManager.insertOrUpdatePlayer$lambda$31(uuid)))));
        if (player != null) {
            Instant instant = Instant.now();
            Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"now(...)");
            player.setLastJoin(instant);
            player.setPlayerName(name);
        } else {
            Tables.Player.Companion.new(arg_0 -> DatabaseManager.insertOrUpdatePlayer$lambda$32(uuid, name, arg_0));
        }
    }

    private final SearchResults selectActionsSearch(Transaction $this$selectActionsSearch, ActionSearchParams params, int page2) {
        List actions = new ArrayList();
        Query query = QueryKt.andWhere((Query)QueriesKt.selectAll((FieldSet)((FieldSet)Tables.Actions.INSTANCE)), () -> DatabaseManager.selectActionsSearch$lambda$33(params));
        long totalActions = this.countActions($this$selectActionsSearch, params);
        if (totalActions == 0L) {
            return new SearchResults(actions, params, page2, 0);
        }
        query = query.orderBy((Expression)Tables.Actions.INSTANCE.getId(), SortOrder.DESC);
        query = query.limit(((Number)LedgerConfigKt.getConfig().get((Item)SearchSpec.INSTANCE.getPageSize())).intValue()).offset((long)(((Number)LedgerConfigKt.getConfig().get((Item)SearchSpec.INSTANCE.getPageSize())).intValue() * (page2 - 1)));
        actions.addAll((Collection)this.getActionsFromQuery(query));
        int totalPages = (int)Math.ceil((double)totalActions / (double)((Number)LedgerConfigKt.getConfig().get((Item)SearchSpec.INSTANCE.getPageSize())).intValue());
        return new SearchResults(actions, params, page2, totalPages);
    }

    private final long countActions(Transaction $this$countActions, ActionSearchParams params) {
        return QueryKt.andWhere((Query)QueriesKt.selectAll((FieldSet)((FieldSet)Tables.Actions.INSTANCE)), () -> DatabaseManager.countActions$lambda$34(params)).count();
    }

    private final void rollbackActions(Transaction $this$rollbackActions, Set<Integer> actionIds) {
        QueriesKt.update$default((Table)((Table)Tables.Actions.INSTANCE), () -> DatabaseManager.rollbackActions$lambda$35(actionIds), null, DatabaseManager::rollbackActions$lambda$36, (int)2, null);
    }

    private final void restoreActions(Transaction $this$restoreActions, Set<Integer> actionIds) {
        QueriesKt.update$default((Table)((Table)Tables.Actions.INSTANCE), () -> DatabaseManager.restoreActions$lambda$37(actionIds), null, DatabaseManager::restoreActions$lambda$38, (int)2, null);
    }

    @NotNull
    public final Set<String> getKnownSources() {
        return cache.getSourceKeys().keySet();
    }

    private final <T> Integer getObjectId(T obj, BiMap<T, Integer> cache, EntityClass<Integer, ? extends Entity<Integer>> table, Column<T> column) {
        Function function = Function.identity();
        Intrinsics.checkNotNullExpressionValue(function, (String)"identity(...)");
        return this.getObjectId(obj, function, cache, table, column);
    }

    private final <T, S> Integer getObjectId(T obj, Function<T, S> mapper, BiMap<T, Integer> cache, EntityClass<Integer, ? extends Entity<Integer>> table, Column<S> column) {
        Integer n;
        if (cache.containsKey(obj)) {
            return (Integer)cache.get(obj);
        }
        Entity entity = (Entity)CollectionsKt.firstOrNull((Iterable)((Iterable)table.find(() -> DatabaseManager.getObjectId$lambda$39(column, mapper, obj))));
        if (entity != null && (entity = entity.getId()) != null) {
            Integer n2 = ((Number)entity.getValue()).intValue();
            int it = ((Number)n2).intValue();
            boolean bl = false;
            cache.put(obj, (Object)it);
            n = n2;
        } else {
            n = null;
        }
        return n;
    }

    private final <T> int getOrCreateObjectId(T obj, BiMap<T, Integer> cache, IntEntityClass<?> entity, IntIdTable table, Column<T> column) {
        Function function = Function.identity();
        Intrinsics.checkNotNullExpressionValue(function, (String)"identity(...)");
        return this.getOrCreateObjectId(obj, function, cache, entity, table, column);
    }

    private final <T, S> int getOrCreateObjectId(T obj, Function<T, S> mapper, BiMap<T, Integer> cache, IntEntityClass<?> entity, IntIdTable table, Column<S> column) {
        Integer n = this.getObjectId(obj, mapper, cache, (EntityClass<Integer, ? extends Entity<Integer>>)((EntityClass)entity), column);
        if (n != null) {
            int it = ((Number)n).intValue();
            boolean bl = false;
            return it;
        }
        Object object = ((IntEntity)entity.get(QueriesKt.insertAndGetId((IdTable)((IdTable)table), (arg_0, arg_1) -> DatabaseManager.getOrCreateObjectId$lambda$42(column, mapper, obj, arg_0, arg_1)))).getId().getValue();
        int it = ((Number)object).intValue();
        boolean bl = false;
        T t = obj;
        Intrinsics.checkNotNull(t);
        cache.put(t, (Object)it);
        return ((Number)object).intValue();
    }

    private final int getOrCreatePlayerId(UUID playerId) {
        return this.getOrCreateObjectId(playerId, cache.getPlayerKeys(), Tables.Player.Companion, Tables.Players.INSTANCE, Tables.Players.INSTANCE.getPlayerId());
    }

    private final int getOrCreateSourceId(String source) {
        return this.getOrCreateObjectId(source, cache.getSourceKeys(), Tables.Source.Companion, Tables.Sources.INSTANCE, Tables.Sources.INSTANCE.getName());
    }

    private final int getOrCreateActionId(String actionTypeId) {
        return this.getOrCreateObjectId(actionTypeId, cache.getActionIdentifierKeys(), Tables.ActionIdentifier.Companion, Tables.ActionIdentifiers.INSTANCE, Tables.ActionIdentifiers.INSTANCE.getActionIdentifier());
    }

    private final int getOrCreateRegistryKeyId(class_2960 identifier) {
        return this.getOrCreateObjectId(identifier, class_2960::toString, cache.getObjectIdentifierKeys(), Tables.ObjectIdentifier.Companion, Tables.ObjectIdentifiers.INSTANCE, Tables.ObjectIdentifiers.INSTANCE.getIdentifier());
    }

    private final int getOrCreateWorldId(class_2960 identifier) {
        return this.getOrCreateObjectId(identifier, class_2960::toString, cache.getWorldIdentifierKeys(), Tables.World.Companion, Tables.Worlds.INSTANCE, Tables.Worlds.INSTANCE.getIdentifier());
    }

    private final Integer getPlayerId(UUID playerId) {
        return this.getObjectId(playerId, cache.getPlayerKeys(), (EntityClass<Integer, ? extends Entity<Integer>>)((EntityClass)Tables.Player.Companion), Tables.Players.INSTANCE.getPlayerId());
    }

    private final Integer getSourceId(String source) {
        return this.getObjectId(source, cache.getSourceKeys(), (EntityClass<Integer, ? extends Entity<Integer>>)((EntityClass)Tables.Source.Companion), Tables.Sources.INSTANCE.getName());
    }

    private final Integer getActionId(String actionTypeId) {
        return this.getObjectId(actionTypeId, cache.getActionIdentifierKeys(), (EntityClass<Integer, ? extends Entity<Integer>>)((EntityClass)Tables.ActionIdentifier.Companion), Tables.ActionIdentifiers.INSTANCE.getActionIdentifier());
    }

    private final Integer getRegistryKeyId(class_2960 identifier) {
        return this.getObjectId(identifier, class_2960::toString, cache.getObjectIdentifierKeys(), (EntityClass<Integer, ? extends Entity<Integer>>)((EntityClass)Tables.ObjectIdentifier.Companion), Tables.ObjectIdentifiers.INSTANCE.getIdentifier());
    }

    private final Integer getWorldId(class_2960 identifier) {
        return this.getObjectId(identifier, class_2960::toString, cache.getWorldIdentifierKeys(), (EntityClass<Integer, ? extends Entity<Integer>>)((EntityClass)Tables.World.Companion), Tables.Worlds.INSTANCE.getIdentifier());
    }

    private final int purgeActions(Transaction $this$purgeActions, ActionSearchParams params) {
        return QueriesKt.deleteWhere$default((Table)((Table)Tables.Actions.INSTANCE), null, arg_0 -> DatabaseManager.purgeActions$lambda$44(params, arg_0), (int)1, null);
    }

    /*
     * WARNING - void declaration
     */
    private final List<PlayerResult> selectPlayers(Transaction $this$selectPlayers, Set<class_11560> players) {
        void $this$mapTo$iv$iv;
        Query query = QueriesKt.selectAll((FieldSet)((FieldSet)Tables.Players.INSTANCE));
        for (class_11560 player : players) {
            QueryKt.orWhere((Query)query, () -> DatabaseManager.selectPlayers$lambda$45(player));
        }
        Iterable $this$map$iv = CollectionsKt.toList((Iterable)((Iterable)Tables.Player.Companion.wrapRows((SizedIterable)query)));
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Tables.Player player = (Tables.Player)((Object)item$iv$iv);
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(PlayerResult.Companion.fromRow((Tables.Player)it));
        }
        return (List)destination$iv$iv;
    }

    private static final Unit ensureTables$lambda$2(JdbcTransaction $this$transaction) {
        Intrinsics.checkNotNullParameter((Object)$this$transaction, (String)"$this$transaction");
        SqlLogger[] sqlLoggerArray = new SqlLogger[]{ledgerLogger};
        $this$transaction.addLogger(sqlLoggerArray);
        sqlLoggerArray = new IntIdTable[]{Tables.Players.INSTANCE, Tables.Actions.INSTANCE, Tables.ActionIdentifiers.INSTANCE, Tables.ObjectIdentifiers.INSTANCE, Tables.Sources.INSTANCE, Tables.Worlds.INSTANCE};
        SchemaUtils.create$default((SchemaUtils)SchemaUtils.INSTANCE, (Table[])((Table[])sqlLoggerArray), (boolean)false, (int)2, null);
        LedgerKt.logInfo("Tables created");
        return Unit.INSTANCE;
    }

    private static final Unit addParameters$addAllowedParameters$lambda$14(Ref.ObjectRef $operator, Column $orColumn, Column $column, Comparable param) {
        Op op;
        Ref.ObjectRef objectRef = $operator;
        if ($orColumn != null) {
            Expression $this$or$iv = (Expression)$operator.element;
            boolean $i$f$or = false;
            Expression expression = $this$or$iv;
            Ref.ObjectRef objectRef2 = objectRef;
            boolean bl = false;
            Op op2 = OpBuilderKt.or((Expression)((Expression)OpBuilderKt.eqEntityIDValue((ExpressionWithColumnType)((ExpressionWithColumnType)$column), (Object)param)), (Expression)((Expression)OpBuilderKt.eqEntityIDValue((ExpressionWithColumnType)((ExpressionWithColumnType)$orColumn), (Object)param)));
            v1 = objectRef2;
            op = OpBuilderKt.or((Expression)expression, (Expression)((Expression)op2));
        } else {
            Expression $this$or$iv = (Expression)$operator.element;
            boolean $i$f$or = false;
            Expression expression = $this$or$iv;
            Ref.ObjectRef objectRef3 = objectRef;
            boolean bl = false;
            Op op3 = OpBuilderKt.eqEntityIDValue((ExpressionWithColumnType)((ExpressionWithColumnType)$column), (Object)param);
            v1 = objectRef3;
            op = OpBuilderKt.or((Expression)expression, (Expression)((Expression)op3));
        }
        v1.element = op;
        return Unit.INSTANCE;
    }

    private static final void addParameters$addAllowedParameters$lambda$15(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final <E extends Comparable<? super E>, C extends EntityID<E>> Op<Boolean> addParameters$addAllowedParameters(Column<C> $orColumn, Column<C> $column, Collection<? extends E> allowed, Op<Boolean> op) {
        if (allowed.isEmpty()) {
            return op;
        }
        Ref.ObjectRef operator = new Ref.ObjectRef();
        operator.element = $orColumn != null ? OpBuilderKt.or((Expression)((Expression)OpBuilderKt.eqEntityIDValue((ExpressionWithColumnType)((ExpressionWithColumnType)$column), (Object)CollectionsKt.first((Iterable)allowed))), (Expression)((Expression)OpBuilderKt.eqEntityIDValue((ExpressionWithColumnType)((ExpressionWithColumnType)$orColumn), (Object)CollectionsKt.first((Iterable)allowed)))) : OpBuilderKt.eqEntityIDValue((ExpressionWithColumnType)((ExpressionWithColumnType)$column), (Object)CollectionsKt.first((Iterable)allowed));
        allowed.stream().skip(1L).forEach(arg_0 -> DatabaseManager.addParameters$addAllowedParameters$lambda$15(arg_0 -> DatabaseManager.addParameters$addAllowedParameters$lambda$14(operator, $orColumn, $column, arg_0), arg_0));
        Expression $this$and$iv = (Expression)op;
        boolean $i$f$and = false;
        Expression expression = $this$and$iv;
        boolean bl = false;
        return OpBuilderKt.and((Expression)expression, (Expression)((Expression)((Op)operator.element)));
    }

    private static final Unit addParameters$addDeniedParameters$lambda$19(Ref.ObjectRef $operator, Column $orColumn, Column $column, Comparable param) {
        Op op;
        Ref.ObjectRef objectRef = $operator;
        if ($orColumn != null) {
            Expression $this$and$iv = (Expression)$operator.element;
            boolean $i$f$and = false;
            Expression expression = $this$and$iv;
            Ref.ObjectRef objectRef2 = objectRef;
            boolean bl = false;
            Op op2 = OpBuilderKt.and((Expression)((Expression)OpBuilderKt.neqEntityIDValue((ExpressionWithColumnType)((ExpressionWithColumnType)$column), (Object)param)), (Expression)((Expression)OpBuilderKt.neqEntityIDValue((ExpressionWithColumnType)((ExpressionWithColumnType)$orColumn), (Object)param)));
            v1 = objectRef2;
            op = OpBuilderKt.and((Expression)expression, (Expression)((Expression)op2));
        } else {
            Expression $this$and$iv = (Expression)$operator.element;
            boolean $i$f$and = false;
            Expression expression = $this$and$iv;
            Ref.ObjectRef objectRef3 = objectRef;
            boolean bl = false;
            Op op3 = OpBuilderKt.or((Expression)((Expression)OpBuilderKt.neqEntityIDValue((ExpressionWithColumnType)((ExpressionWithColumnType)$column), (Object)param)), (Expression)((Expression)OpBuilderKt.isNull((Expression)((Expression)$column))));
            v1 = objectRef3;
            op = OpBuilderKt.and((Expression)expression, (Expression)((Expression)op3));
        }
        v1.element = op;
        return Unit.INSTANCE;
    }

    private static final void addParameters$addDeniedParameters$lambda$20(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final <E extends Comparable<? super E>, C extends EntityID<E>> Op<Boolean> addParameters$addDeniedParameters(Column<C> $orColumn, Column<C> $column, Collection<? extends E> denied, Op<Boolean> op) {
        if (denied.isEmpty()) {
            return op;
        }
        Ref.ObjectRef operator = new Ref.ObjectRef();
        operator.element = $orColumn != null ? OpBuilderKt.and((Expression)((Expression)OpBuilderKt.neqEntityIDValue((ExpressionWithColumnType)((ExpressionWithColumnType)$column), (Object)CollectionsKt.first((Iterable)denied))), (Expression)((Expression)OpBuilderKt.neqEntityIDValue((ExpressionWithColumnType)((ExpressionWithColumnType)$orColumn), (Object)CollectionsKt.first((Iterable)denied)))) : OpBuilderKt.or((Expression)((Expression)OpBuilderKt.neqEntityIDValue((ExpressionWithColumnType)((ExpressionWithColumnType)$column), (Object)CollectionsKt.first((Iterable)denied))), (Expression)((Expression)OpBuilderKt.isNull((Expression)((Expression)$column))));
        denied.stream().skip(1L).forEach(arg_0 -> DatabaseManager.addParameters$addDeniedParameters$lambda$20(arg_0 -> DatabaseManager.addParameters$addDeniedParameters$lambda$19(operator, $orColumn, $column, arg_0), arg_0));
        Expression $this$and$iv = (Expression)op;
        boolean $i$f$and = false;
        Expression expression = $this$and$iv;
        boolean bl = false;
        return OpBuilderKt.and((Expression)expression, (Expression)((Expression)((Op)operator.element)));
    }

    private static final Unit insertActionType$lambda$26(String $id, Tables.ActionIdentifiers $this$insertIgnore, UpdateBuilder it) {
        Intrinsics.checkNotNullParameter((Object)((Object)$this$insertIgnore), (String)"$this$insertIgnore");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        it.set($this$insertIgnore.getActionIdentifier(), (Object)$id);
        return Unit.INSTANCE;
    }

    private static final Unit insertWorld$lambda$27(class_2960 $identifier, Tables.Worlds $this$insertIgnore, UpdateBuilder it) {
        Intrinsics.checkNotNullParameter((Object)((Object)$this$insertIgnore), (String)"$this$insertIgnore");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        it.set($this$insertIgnore.getIdentifier(), (Object)$identifier.toString());
        return Unit.INSTANCE;
    }

    private static final Unit insertRegKeys$lambda$28(BatchInsertStatement $this$batchInsert, class_2960 identifier) {
        Intrinsics.checkNotNullParameter((Object)$this$batchInsert, (String)"$this$batchInsert");
        Intrinsics.checkNotNullParameter((Object)identifier, (String)"identifier");
        $this$batchInsert.set(Tables.ObjectIdentifiers.INSTANCE.getIdentifier(), (Object)identifier.toString());
        return Unit.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit insertActions$lambda$30(BatchInsertStatement $this$batchInsert, ActionType action) {
        Integer n;
        Intrinsics.checkNotNullParameter((Object)$this$batchInsert, (String)"$this$batchInsert");
        Intrinsics.checkNotNullParameter((Object)action, (String)"action");
        $this$batchInsert.setWithEntityIdValue(Tables.Actions.INSTANCE.getActionIdentifier(), (Object)INSTANCE.getOrCreateActionId(action.getIdentifier()));
        $this$batchInsert.set(Tables.Actions.INSTANCE.getTimestamp(), (Object)action.getTimestamp());
        $this$batchInsert.set(Tables.Actions.INSTANCE.getX(), (Object)action.getPos().method_10263());
        $this$batchInsert.set(Tables.Actions.INSTANCE.getY(), (Object)action.getPos().method_10264());
        $this$batchInsert.set(Tables.Actions.INSTANCE.getZ(), (Object)action.getPos().method_10260());
        $this$batchInsert.setWithEntityIdValue(Tables.Actions.INSTANCE.getObjectId(), (Object)INSTANCE.getOrCreateRegistryKeyId(action.getObjectIdentifier()));
        $this$batchInsert.setWithEntityIdValue(Tables.Actions.INSTANCE.getOldObjectId(), (Object)INSTANCE.getOrCreateRegistryKeyId(action.getOldObjectIdentifier()));
        Column<EntityID<Integer>> column = Tables.Actions.INSTANCE.getWorld();
        class_2960 class_29602 = action.getWorld();
        if (class_29602 == null) {
            class_29602 = Ledger.INSTANCE.getServer().method_30002().method_27983().method_29177();
        }
        class_2960 class_29603 = class_29602;
        Intrinsics.checkNotNull((Object)class_29603);
        $this$batchInsert.setWithEntityIdValue(column, (Object)INSTANCE.getOrCreateWorldId(class_29603));
        $this$batchInsert.set(Tables.Actions.INSTANCE.getBlockState(), (Object)action.getObjectState());
        $this$batchInsert.set(Tables.Actions.INSTANCE.getOldBlockState(), (Object)action.getOldObjectState());
        $this$batchInsert.setWithEntityIdValue(Tables.Actions.INSTANCE.getSourceName(), (Object)INSTANCE.getOrCreateSourceId(action.getSourceName()));
        BatchInsertStatement batchInsertStatement = $this$batchInsert;
        Column<EntityID<Integer>> column2 = Tables.Actions.INSTANCE.getSourcePlayer();
        class_11560 class_115602 = action.getSourceProfile();
        if (class_115602 != null) {
            void it;
            class_11560 class_115603 = class_115602;
            Column<EntityID<Integer>> column3 = column2;
            BatchInsertStatement batchInsertStatement2 = batchInsertStatement;
            boolean bl = false;
            UUID uUID = it.comp_4422();
            Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"id(...)");
            Integer n2 = INSTANCE.getOrCreatePlayerId(uUID);
            batchInsertStatement = batchInsertStatement2;
            column2 = column3;
            n = n2;
        } else {
            n = null;
        }
        batchInsertStatement.setWithNullableEntityIdValue(column2, n);
        $this$batchInsert.set(Tables.Actions.INSTANCE.getExtraData(), (Object)action.getExtraData());
        return Unit.INSTANCE;
    }

    private static final Op insertOrUpdatePlayer$lambda$31(UUID $uuid) {
        return OpBuilderKt.eq((ExpressionWithColumnType)((ExpressionWithColumnType)Tables.Players.INSTANCE.getPlayerId()), (Object)$uuid);
    }

    private static final Unit insertOrUpdatePlayer$lambda$32(UUID $uuid, String $name, Tables.Player $this$new) {
        Intrinsics.checkNotNullParameter((Object)((Object)$this$new), (String)"$this$new");
        $this$new.setPlayerId($uuid);
        $this$new.setPlayerName($name);
        return Unit.INSTANCE;
    }

    private static final Op selectActionsSearch$lambda$33(ActionSearchParams $params) {
        return INSTANCE.buildQueryParams($params);
    }

    private static final Op countActions$lambda$34(ActionSearchParams $params) {
        return INSTANCE.buildQueryParams($params);
    }

    private static final Op rollbackActions$lambda$35(Set $actionIds) {
        return (Op)OpBuilderKt.inListIds((Column)Tables.Actions.INSTANCE.getId(), (Iterable)$actionIds);
    }

    private static final Unit rollbackActions$lambda$36(Tables.Actions $this$update, UpdateStatement it) {
        Intrinsics.checkNotNullParameter((Object)((Object)$this$update), (String)"$this$update");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        it.set($this$update.getRolledBack(), (Object)true);
        return Unit.INSTANCE;
    }

    private static final Op restoreActions$lambda$37(Set $actionIds) {
        return (Op)OpBuilderKt.inListIds((Column)Tables.Actions.INSTANCE.getId(), (Iterable)$actionIds);
    }

    private static final Unit restoreActions$lambda$38(Tables.Actions $this$update, UpdateStatement it) {
        Intrinsics.checkNotNullParameter((Object)((Object)$this$update), (String)"$this$update");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        it.set($this$update.getRolledBack(), (Object)false);
        return Unit.INSTANCE;
    }

    private static final Op getObjectId$lambda$39(Column $column, Function $mapper, Object $obj) {
        return OpBuilderKt.eq((ExpressionWithColumnType)((ExpressionWithColumnType)$column), $mapper.apply($obj));
    }

    private static final Unit getOrCreateObjectId$lambda$42(Column $column, Function $mapper, Object $obj, IntIdTable $this$insertAndGetId, InsertStatement it) {
        Intrinsics.checkNotNullParameter((Object)$this$insertAndGetId, (String)"$this$insertAndGetId");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        it.set($column, $mapper.apply($obj));
        return Unit.INSTANCE;
    }

    private static final Op purgeActions$lambda$44(ActionSearchParams $params, Tables.Actions $this$deleteWhere) {
        Intrinsics.checkNotNullParameter((Object)((Object)$this$deleteWhere), (String)"$this$deleteWhere");
        return (Op)OpBuilderKt.inSubQuery((Expression)((Expression)$this$deleteWhere.getId()), (AbstractQuery)((AbstractQuery)QueriesKt.select((ColumnSet)((ColumnSet)Tables.Actions.INSTANCE), (Expression)((Expression)$this$deleteWhere.getId()), (Expression[])new Expression[0]).where(INSTANCE.buildQueryParams($params))));
    }

    private static final Op selectPlayers$lambda$45(class_11560 $player) {
        return OpBuilderKt.eq((ExpressionWithColumnType)((ExpressionWithColumnType)Tables.Players.INSTANCE.getPlayerId()), (Object)$player.comp_4422());
    }

    public static final /* synthetic */ DatabaseCacheService access$getCache$p() {
        return cache;
    }

    public static final /* synthetic */ SearchResults access$selectActionsSearch(DatabaseManager $this, Transaction $receiver, ActionSearchParams params, int page2) {
        return $this.selectActionsSearch($receiver, params, page2);
    }

    public static final /* synthetic */ long access$countActions(DatabaseManager $this, Transaction $receiver, ActionSearchParams params) {
        return $this.countActions($receiver, params);
    }

    public static final /* synthetic */ void access$rollbackActions(DatabaseManager $this, Transaction $receiver, Set actionIds) {
        $this.rollbackActions($receiver, actionIds);
    }

    public static final /* synthetic */ void access$restoreActions(DatabaseManager $this, Transaction $receiver, Set actionIds) {
        $this.restoreActions($receiver, actionIds);
    }

    public static final /* synthetic */ Op access$buildQueryParams(DatabaseManager $this, ActionSearchParams params) {
        return $this.buildQueryParams(params);
    }

    public static final /* synthetic */ List access$getActionsFromQuery(DatabaseManager $this, Query query) {
        return $this.getActionsFromQuery(query);
    }

    public static final /* synthetic */ void access$insertActions(DatabaseManager $this, Transaction $receiver, List actions) {
        $this.insertActions($receiver, actions);
    }

    public static final /* synthetic */ void access$insertWorld(DatabaseManager $this, Transaction $receiver, class_2960 identifier) {
        $this.insertWorld($receiver, identifier);
    }

    public static final /* synthetic */ void access$insertActionType(DatabaseManager $this, Transaction $receiver, String id) {
        $this.insertActionType($receiver, id);
    }

    public static final /* synthetic */ void access$insertOrUpdatePlayer(DatabaseManager $this, Transaction $receiver, UUID uuid, String name) {
        $this.insertOrUpdatePlayer($receiver, uuid, name);
    }

    public static final /* synthetic */ void access$insertRegKeys(DatabaseManager $this, Transaction $receiver, Collection identifiers) {
        $this.insertRegKeys($receiver, identifiers);
    }

    public static final /* synthetic */ Object access$execute(DatabaseManager $this, Function2 body, Continuation $completion) {
        return $this.execute(body, $completion);
    }

    public static final /* synthetic */ ledgerLogger.1 access$getLedgerLogger$p() {
        return ledgerLogger;
    }

    public static final /* synthetic */ int access$purgeActions(DatabaseManager $this, Transaction $receiver, ActionSearchParams params) {
        return $this.purgeActions($receiver, params);
    }

    public static final /* synthetic */ List access$selectPlayers(DatabaseManager $this, Transaction $receiver, Set players) {
        return $this.selectPlayers($receiver, players);
    }

    static {
        cache = DatabaseCacheService.INSTANCE;
        databaseContext = Dispatchers.getIO().plus((CoroutineContext)new CoroutineName("Ledger Database"));
        ledgerLogger = new SqlLogger(){

            public void log(StatementContext context, Transaction transaction) {
                Intrinsics.checkNotNullParameter((Object)context, (String)"context");
                Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
                Ledger.INSTANCE.getLogger().info("SQL: " + StatementKt.expandArgs((StatementContext)context, (Transaction)transaction));
            }
        };
    }
}

