/*
 * Decompiled with CFR 0.152.
 */
package com.github.quiltservertools.ledger.mixin;

import com.github.quiltservertools.ledger.callbacks.ItemInsertCallback;
import com.github.quiltservertools.ledger.callbacks.ItemRemoveCallback;
import com.github.quiltservertools.ledger.utility.HandledSlot;
import com.github.quiltservertools.ledger.utility.HandlerWithContext;
import com.github.quiltservertools.ledger.utility.ItemData;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_1263;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1703;
import net.minecraft.class_1713;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_7923;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_1703.class})
public abstract class ScreenHandlerMixin
implements HandlerWithContext {
    @Unique
    Map<ItemData, Integer> changedStacks = new HashMap<ItemData, Integer>();
    @Unique
    private class_3222 player = null;
    @Unique
    private class_2338 pos = null;

    @Inject(method={"addSlot"}, at={@At(value="HEAD")})
    private void ledgerGiveSlotHandlerReference(class_1735 slot, CallbackInfoReturnable<class_1735> cir) {
        ((HandledSlot)slot).setHandler((class_1703)this);
    }

    @Inject(method={"onButtonClick"}, at={@At(value="HEAD")})
    private void ledgerButtonClickGetPlayer(class_1657 player, int id, CallbackInfoReturnable<Boolean> cir) {
        this.player = (class_3222)player;
    }

    @Inject(method={"internalOnSlotClick"}, at={@At(value="HEAD")})
    private void internalOnSlotClickGetPlayer(int slotIndex, int button, class_1713 actionType, class_1657 player, CallbackInfo ci) {
        this.player = (class_3222)player;
    }

    @Inject(method={"onSlotClick"}, at={@At(value="HEAD")})
    private void ledgerSlotClickGetPlayer(int slotIndex, int button, class_1713 actionType, class_1657 player, CallbackInfo ci) {
        this.player = (class_3222)player;
    }

    @Inject(method={"dropInventory"}, at={@At(value="HEAD")})
    private void ledgerDropInventoryGetPlayer(class_1657 player, class_1263 inventory, CallbackInfo ci) {
        this.player = (class_3222)player;
    }

    @Inject(method={"onClosed"}, at={@At(value="RETURN")})
    private void ledgerCloseScreenLogChanges(class_1657 player, CallbackInfo ci) {
        if (!player.method_73183().method_8608() && this.pos != null) {
            for (ItemData pair : this.changedStacks.keySet()) {
                class_1799 addStack;
                class_1799 stack = new class_1799(class_7923.field_41178.method_47983((Object)pair.getItem()), 1, pair.getChanges());
                if (stack.method_7960()) continue;
                int count = this.changedStacks.get(pair);
                ArrayList<class_1799> splitStacks = new ArrayList<class_1799>();
                for (int countAbs = Math.abs(count); countAbs > 0; countAbs -= addStack.method_7947()) {
                    addStack = stack.method_46651(Math.min(countAbs, stack.method_7914()));
                    splitStacks.add(addStack);
                }
                if (count > 0) {
                    for (class_1799 splitStack : splitStacks) {
                        ((ItemInsertCallback)ItemInsertCallback.EVENT.invoker()).insert(splitStack, this.pos, (class_3218)player.method_73183(), "player", (class_1309)((class_3222)player));
                    }
                    continue;
                }
                for (class_1799 splitStack : splitStacks) {
                    ((ItemRemoveCallback)ItemRemoveCallback.EVENT.invoker()).remove(splitStack, this.pos, (class_3218)player.method_73183(), "player", (class_1309)((class_3222)player));
                }
            }
        }
    }

    @Override
    @Nullable
    public class_3222 getPlayer() {
        return this.player;
    }

    @Override
    @Nullable
    public class_2338 getPos() {
        return this.pos;
    }

    @Override
    public void setPos(@NotNull class_2338 pos) {
        this.pos = pos;
    }

    @Override
    public void onStackChanged(@NotNull class_1799 old, @NotNull class_1799 itemStack, @NotNull class_2338 pos) {
        if (old.method_7960() && !itemStack.method_7960()) {
            ItemData key = new ItemData(itemStack.method_7909(), itemStack.method_57380());
            if (this.changedStacks.containsKey(key)) {
                this.changedStacks.put(key, this.changedStacks.get(key) + itemStack.method_7947());
            } else {
                this.changedStacks.put(key, itemStack.method_7947());
            }
        } else if (!old.method_7960() && itemStack.method_7960()) {
            ItemData key = new ItemData(old.method_7909(), old.method_57380());
            if (this.changedStacks.containsKey(key)) {
                this.changedStacks.put(key, this.changedStacks.get(key) - old.method_7947());
            } else {
                this.changedStacks.put(key, -old.method_7947());
            }
        } else if (!old.method_7960() && !itemStack.method_7960()) {
            this.onStackChanged(old, class_1799.field_8037, pos);
            this.onStackChanged(class_1799.field_8037, itemStack, pos);
        }
    }
}

