/*
 * Decompiled with CFR 0.152.
 */
package com.github.quiltservertools.ledger.network.packet.receiver;

import com.github.quiltservertools.ledger.LedgerKt;
import com.github.quiltservertools.ledger.network.Networking;
import com.github.quiltservertools.ledger.network.packet.LedgerPacketTypes;
import com.github.quiltservertools.ledger.network.packet.handshake.HandshakeContent;
import com.github.quiltservertools.ledger.network.packet.handshake.HandshakeS2CPacket;
import com.github.quiltservertools.ledger.network.packet.handshake.ModInfo;
import com.github.quiltservertools.ledger.registry.ActionRegistry;
import java.util.Optional;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import me.lucko.fabric.api.permissions.v0.Permissions;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.minecraft.class_1297;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_8710;
import net.minecraft.class_9139;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\b\u0086\b\u0018\u0000 \u001a2\u00020\u0001:\u0001\u001aB\u0011\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0015\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00000\u0006H\u0016\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0012\u0010\t\u001a\u0004\u0018\u00010\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\t\u0010\nJ\u001c\u0010\u000b\u001a\u00020\u00002\n\b\u0002\u0010\u0003\u001a\u0004\u0018\u00010\u0002H\u00c6\u0001\u00a2\u0006\u0004\b\u000b\u0010\fJ\u001a\u0010\u0010\u001a\u00020\u000f2\b\u0010\u000e\u001a\u0004\u0018\u00010\rH\u00d6\u0003\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0010\u0010\u0013\u001a\u00020\u0012H\u00d6\u0001\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u0010\u0010\u0016\u001a\u00020\u0015H\u00d6\u0001\u00a2\u0006\u0004\b\u0016\u0010\u0017R\u0019\u0010\u0003\u001a\u0004\u0018\u00010\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\u0018\u001a\u0004\b\u0019\u0010\n\u00a8\u0006\u001b"}, d2={"Lcom/github/quiltservertools/ledger/network/packet/receiver/HandshakeC2SPacket;", "Lnet/minecraft/class_8710;", "Lnet/minecraft/class_2487;", "nbt", "<init>", "(Lnet/minecraft/class_2487;)V", "Lnet/minecraft/class_8710$class_9154;", "getId", "()Lnet/minecraft/class_8710$class_9154;", "component1", "()Lnet/minecraft/class_2487;", "copy", "(Lnet/minecraft/class_2487;)Lcom/github/quiltservertools/ledger/network/packet/receiver/HandshakeC2SPacket;", "", "other", "", "equals", "(Ljava/lang/Object;)Z", "", "hashCode", "()I", "", "toString", "()Ljava/lang/String;", "Lnet/minecraft/class_2487;", "getNbt", "Companion", "ledger"})
public final class HandshakeC2SPacket
implements class_8710 {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final class_2487 nbt;
    @NotNull
    private static final class_8710.class_9154<HandshakeC2SPacket> ID = new class_8710.class_9154(LedgerPacketTypes.HANDSHAKE.getId());
    @NotNull
    private static final class_9139<class_2540, HandshakeC2SPacket> CODEC;

    public HandshakeC2SPacket(@Nullable class_2487 nbt) {
        this.nbt = nbt;
    }

    @Nullable
    public final class_2487 getNbt() {
        return this.nbt;
    }

    @NotNull
    public class_8710.class_9154<HandshakeC2SPacket> method_56479() {
        return ID;
    }

    @Nullable
    public final class_2487 component1() {
        return this.nbt;
    }

    @NotNull
    public final HandshakeC2SPacket copy(@Nullable class_2487 nbt) {
        return new HandshakeC2SPacket(nbt);
    }

    public static /* synthetic */ HandshakeC2SPacket copy$default(HandshakeC2SPacket handshakeC2SPacket, class_2487 class_24872, int n, Object object) {
        if ((n & 1) != 0) {
            class_24872 = handshakeC2SPacket.nbt;
        }
        return handshakeC2SPacket.copy(class_24872);
    }

    @NotNull
    public String toString() {
        return "HandshakeC2SPacket(nbt=" + this.nbt + ")";
    }

    public int hashCode() {
        return this.nbt == null ? 0 : this.nbt.hashCode();
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof HandshakeC2SPacket)) {
            return false;
        }
        HandshakeC2SPacket handshakeC2SPacket = (HandshakeC2SPacket)other;
        return Intrinsics.areEqual((Object)this.nbt, (Object)handshakeC2SPacket.nbt);
    }

    private static final void CODEC$lambda$0(HandshakeC2SPacket handshakeC2SPacket, class_2540 class_25402) {
        throw new NotImplementedError(null, 1, null);
    }

    private static final HandshakeC2SPacket CODEC$lambda$1(class_2540 it) {
        return new HandshakeC2SPacket(it.method_10798());
    }

    static {
        class_9139 class_91392 = class_8710.method_56484(HandshakeC2SPacket::CODEC$lambda$0, HandshakeC2SPacket::CODEC$lambda$1);
        Intrinsics.checkNotNullExpressionValue((Object)class_91392, (String)"codecOf(...)");
        CODEC = class_91392;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u001f\u0010\t\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\t\u0010\nJ\u001f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\b\u0010\f\u001a\u0004\u0018\u00010\u000bH\u0002\u00a2\u0006\u0004\b\u000f\u0010\u0010R\u001d\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00020\u00118\u0006\u00a2\u0006\f\n\u0004\b\u0012\u0010\u0013\u001a\u0004\b\u0014\u0010\u0015R#\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u00020\u00168\u0006\u00a2\u0006\f\n\u0004\b\u0018\u0010\u0019\u001a\u0004\b\u001a\u0010\u001b\u00a8\u0006\u001c"}, d2={"Lcom/github/quiltservertools/ledger/network/packet/receiver/HandshakeC2SPacket$Companion;", "Lnet/fabricmc/fabric/api/networking/v1/ServerPlayNetworking$PlayPayloadHandler;", "Lcom/github/quiltservertools/ledger/network/packet/receiver/HandshakeC2SPacket;", "<init>", "()V", "payload", "Lnet/fabricmc/fabric/api/networking/v1/ServerPlayNetworking$Context;", "context", "", "receive", "(Lcom/github/quiltservertools/ledger/network/packet/receiver/HandshakeC2SPacket;Lnet/fabricmc/fabric/api/networking/v1/ServerPlayNetworking$Context;)V", "Lnet/minecraft/class_2487;", "nbt", "Ljava/util/Optional;", "Lcom/github/quiltservertools/ledger/network/packet/handshake/ModInfo;", "readInfo", "(Lnet/minecraft/class_2487;)Ljava/util/Optional;", "Lnet/minecraft/class_8710$class_9154;", "ID", "Lnet/minecraft/class_8710$class_9154;", "getID", "()Lnet/minecraft/class_8710$class_9154;", "Lnet/minecraft/class_9139;", "Lnet/minecraft/class_2540;", "CODEC", "Lnet/minecraft/class_9139;", "getCODEC", "()Lnet/minecraft/class_9139;", "ledger"})
    public static final class Companion
    implements ServerPlayNetworking.PlayPayloadHandler<HandshakeC2SPacket> {
        private Companion() {
        }

        @NotNull
        public final class_8710.class_9154<HandshakeC2SPacket> getID() {
            return ID;
        }

        @NotNull
        public final class_9139<class_2540, HandshakeC2SPacket> getCODEC() {
            return CODEC;
        }

        public void receive(@NotNull HandshakeC2SPacket payload, @NotNull ServerPlayNetworking.Context context) {
            Intrinsics.checkNotNullParameter((Object)payload, (String)"payload");
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            class_3222 player = context.player();
            if (!Permissions.check((class_1297)((class_1297)player), (String)"ledger.networking", (int)3)) {
                return;
            }
            Optional<ModInfo> info = this.readInfo(payload.getNbt());
            if (info.isPresent()) {
                String modid = info.get().getModid();
                String modVersion = info.get().getVersion();
                String ledgerVersion = ((ModContainer)FabricLoader.getInstance().getModContainer("ledger").get()).getMetadata().getVersion().getFriendlyString();
                if (3 == info.get().getProtocolVersion()) {
                    LedgerKt.logInfo(player.method_5477().getString() + " joined the server with a Ledger compatible client mod");
                    LedgerKt.logInfo("Mod: " + modid + ", Version: " + modVersion);
                    Intrinsics.checkNotNull((Object)ledgerVersion);
                    HandshakeS2CPacket packet = new HandshakeS2CPacket(new HandshakeContent(3, ledgerVersion, CollectionsKt.toList((Iterable)((Iterable)ActionRegistry.INSTANCE.getTypes()))));
                    ServerPlayNetworking.send((class_3222)player, (class_8710)packet);
                    Intrinsics.checkNotNull((Object)player);
                    Networking.INSTANCE.enableNetworking(player);
                } else {
                    Object[] objectArray = new Object[]{3, info.get().getProtocolVersion()};
                    player.method_7353((class_2561)class_2561.method_43469((String)"text.ledger.network.protocols_mismatched", (Object[])objectArray), false);
                    LedgerKt.logInfo(player.method_5477().getString() + " joined the server with a Ledger compatible client mod, but has a mismatched protocol: Ledger protocol version: 3, Client mod protocol version " + info.get().getProtocolVersion());
                }
            } else {
                player.method_7353((class_2561)class_2561.method_43471((String)"text.ledger.network.no_mod_info"), false);
            }
        }

        private final Optional<ModInfo> readInfo(class_2487 nbt) {
            if (nbt == null) {
                Optional<ModInfo> optional2 = Optional.empty();
                Intrinsics.checkNotNullExpressionValue(optional2, (String)"empty(...)");
                return optional2;
            }
            Object t = nbt.method_10558("modid").orElseThrow();
            Intrinsics.checkNotNullExpressionValue(t, (String)"orElseThrow(...)");
            String string = (String)t;
            Object t2 = nbt.method_10558("version").orElseThrow();
            Intrinsics.checkNotNullExpressionValue(t2, (String)"orElseThrow(...)");
            String string2 = (String)t2;
            Object t3 = nbt.method_10550("protocol_version").orElseThrow();
            Intrinsics.checkNotNullExpressionValue(t3, (String)"orElseThrow(...)");
            Optional<ModInfo> optional3 = Optional.of(new ModInfo(string, string2, ((Number)t3).intValue()));
            Intrinsics.checkNotNullExpressionValue(optional3, (String)"of(...)");
            return optional3;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

