/*
 * Decompiled with CFR 0.152.
 */
package com.anthus.videotape;

import com.anthus.Amaranthus;
import com.anthus.videotape.ModConfig;
import com.anthus.videotape.config.ConfigReloadHandler;
import com.anthus.videotape.config.ConfigWatcher;
import java.nio.file.Path;
import java.util.List;
import java.util.function.Consumer;
import net.fabricmc.api.ModInitializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Videotape
implements ModInitializer {
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"videotape");
    public static volatile ModConfig CONFIG;
    private static ConfigWatcher configWatcher;

    public void onInitialize() {
        LOGGER.info("Initializing Videotape...");
        Path configPath = Path.of("config", "videotape.cfg");
        CONFIG = (ModConfig)Amaranthus.load((Path)configPath, ModConfig.class);
        Amaranthus.save((Object)CONFIG, (Path)configPath);
        if (Videotape.CONFIG.debug.enableHotReload) {
            ConfigWatcher configWatcher;
            LOGGER.info("Hot-reload enabled, starting configuration watcher...");
            Videotape.configWatcher = new ConfigWatcher((Path)((Object)configWatcher), ModConfig.class, CONFIG);
            Consumer<ModConfig> consumer = newConfig -> {
                ModConfig modConfig;
                ConfigReloadHandler.onConfigReload(CONFIG, modConfig);
            };
            configWatcher = Videotape.configWatcher;
            List<Consumer<ModConfig>> list = Videotape.configWatcher.listeners;
            synchronized (list) {
                configWatcher.listeners.add(consumer);
            }
            Videotape.configWatcher.start();
        } else {
            LOGGER.info("Hot-reload disabled");
        }
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            if (configWatcher != null) {
                LOGGER.info("Shutting down configuration watcher...");
                configWatcher.close();
            }
        }, "Videotape-Shutdown"));
    }
}

