/*
 * Decompiled with CFR 0.152.
 */
package com.anthus.videotape.config;

import com.anthus.Amaranthus;
import com.anthus.videotape.ModConfig;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigWatcher
implements AutoCloseable {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConfigWatcher.class);
    private final Path configPath;
    private final Class<ModConfig> configClass;
    public final List<Consumer<ModConfig>> listeners = new ArrayList<Consumer<ModConfig>>();
    private final AtomicBoolean running = new AtomicBoolean(false);
    private final AtomicLong lastModified = new AtomicLong(0L);
    private Thread watchThread;
    private WatchService watchService;
    private volatile ModConfig currentConfig;

    /*
     * WARNING - void declaration
     */
    public ConfigWatcher(Path configPath, Class<ModConfig> configClass, ModConfig initialConfig) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.configPath = var1_1;
        this.configClass = var2_2;
        this.currentConfig = var3_3;
    }

    /*
     * WARNING - void declaration
     */
    public final void start() {
        if (this.running.getAndSet(true)) {
            LOGGER.warn("[Videotape][ConfigWatcher] Already running");
            return;
        }
        try {
            Path configDir = this.configPath.getParent();
            if (configDir == null) {
                configDir = Paths.get(".", new String[0]);
            }
            if (!Files.exists(configDir, new LinkOption[0])) {
                Files.createDirectories(configDir, new FileAttribute[0]);
            }
            this.watchService = FileSystems.getDefault().newWatchService();
            configDir.register(this.watchService, StandardWatchEventKinds.ENTRY_MODIFY, StandardWatchEventKinds.ENTRY_CREATE);
            this.watchThread = new Thread(this::watchLoop, "ConfigWatcher");
            this.watchThread.setDaemon(true);
            this.watchThread.start();
            LOGGER.info("[Videotape][ConfigWatcher] Started watching {}", (Object)this.configPath);
            return;
        }
        catch (IOException e) {
            void var1_2;
            LOGGER.error("[Videotape][ConfigWatcher] Failed to start watching", (Throwable)var1_2);
            this.running.set(false);
            return;
        }
    }

    @Override
    public void close() {
        ConfigWatcher configWatcher = this;
        if (configWatcher.running.getAndSet(false)) {
            if (configWatcher.watchThread != null) {
                configWatcher.watchThread.interrupt();
                try {
                    configWatcher.watchThread.join(1000L);
                }
                catch (InterruptedException interruptedException) {
                    Thread.currentThread().interrupt();
                }
            }
            if (configWatcher.watchService != null) {
                try {
                    configWatcher.watchService.close();
                }
                catch (IOException iOException) {
                    LOGGER.error("[Videotape][ConfigWatcher] Error closing watch service", (Throwable)iOException);
                }
            }
            LOGGER.info("[Videotape][ConfigWatcher] Stopped");
        }
    }

    /*
     * WARNING - void declaration
     */
    private void watchLoop() {
        while (this.running.get()) {
            try {
                WatchKey key = this.watchService.take();
                for (WatchEvent<?> event : key.pollEvents()) {
                    Object object;
                    if (event.kind() == StandardWatchEventKinds.OVERFLOW || !((Path)object.context()).equals(this.configPath.getFileName())) continue;
                    object = this;
                    long l = System.currentTimeMillis();
                    ((ConfigWatcher)object).lastModified.set(l);
                    object = new Thread(() -> {
                        try {
                            void var1_1;
                            Thread.sleep(500L);
                            if (this.lastModified.get() == var1_1) {
                                ConfigWatcher configWatcher = this;
                                try {
                                    boolean bl;
                                    ModConfig modConfig;
                                    LOGGER.info("[Videotape][ConfigWatcher] Reloading configuration from {}", (Object)configWatcher.configPath);
                                    ModConfig cfr_ignored_0 = configWatcher.currentConfig;
                                    ModConfig modConfig2 = modConfig = (ModConfig)Amaranthus.load((Path)configWatcher.configPath, configWatcher.configClass);
                                    if (modConfig.debug.metricsInterval <= 0) {
                                        LOGGER.error("[Videotape][ConfigWatcher] Invalid metricsInterval: {}", (Object)modConfig2.debug.metricsInterval);
                                        bl = false;
                                    } else {
                                        bl = true;
                                    }
                                    if (!bl) {
                                        LOGGER.error("[Videotape][ConfigWatcher] Configuration validation failed, keeping old config");
                                        return;
                                    }
                                    configWatcher.currentConfig = modConfig;
                                    configWatcher.notifyListeners$ac9dbcd(modConfig);
                                    LOGGER.info("[Videotape][ConfigWatcher] Configuration reloaded successfully");
                                    return;
                                }
                                catch (Exception exception) {
                                    LOGGER.error("[Videotape][ConfigWatcher] Failed to reload configuration, keeping old config", (Throwable)exception);
                                }
                            }
                            return;
                        }
                        catch (InterruptedException interruptedException) {
                            Thread.currentThread().interrupt();
                            return;
                        }
                    }, "ConfigWatcher-Debounce");
                    ((Thread)object).setDaemon(true);
                    ((Thread)object).start();
                }
                key.reset();
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
                return;
            }
            catch (Exception e) {
                void var1_2;
                LOGGER.error("[Videotape][ConfigWatcher] Error in watch loop", (Throwable)var1_2);
            }
        }
    }

    private void notifyListeners$ac9dbcd(ModConfig newConfig) {
        ArrayList<Consumer<ModConfig>> arrayList;
        List<Consumer<ModConfig>> list = this.listeners;
        synchronized (list) {
            arrayList = new ArrayList<Consumer<ModConfig>>(this.listeners);
        }
        for (Consumer consumer : arrayList) {
            try {
                consumer.accept(newConfig);
            }
            catch (Exception exception) {
                LOGGER.error("[Videotape][ConfigWatcher] Listener threw exception", (Throwable)exception);
            }
        }
    }
}

