/*
 * Decompiled with CFR 0.152.
 */
package com.anthus.videotape.system;

import com.anthus.videotape.Videotape;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.platform.TextureUtil;
import java.lang.ref.Cleaner;
import java.util.AbstractCollection;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class LeakDetector {
    static final Logger LOGGER = LoggerFactory.getLogger((String)"Videotape");
    public static final Cleaner CLEANER = Cleaner.create();
    static final ConcurrentLinkedQueue<LeakNode> QUEUE = new ConcurrentLinkedQueue();
    private static final StackWalker WALKER = StackWalker.getInstance(StackWalker.Option.RETAIN_CLASS_REFERENCE);
    private static final List<String> IGNORED = List.of("java.", "net.minecraft.", "com.mojang.", "org.lwjgl.", "com.anthus.videotape.");

    /*
     * WARNING - void declaration
     */
    public static void onClientTick() {
        LeakNode node;
        int processed = 0;
        while (processed++ < 20 && (node = QUEUE.poll()) != null) {
            void var0_1;
            if (var0_1.color >= 0) {
                TextureUtil.releaseTextureId((int)var0_1.color);
            }
            if (var0_1.depth >= 0) {
                TextureUtil.releaseTextureId((int)var0_1.depth);
            }
            if (var0_1.frame >= 0) {
                GlStateManager._glBindFramebuffer((int)36160, (int)0);
                GlStateManager._glDeleteFramebuffers((int)var0_1.frame);
            }
            if (var0_1.blame == null) continue;
            LOGGER.warn("Videotape recovered video memory allocated by: {}", (Object)var0_1.blame);
        }
    }

    static String resolveCaller() {
        return WALKER.walk(frames -> frames.map(StackWalker.StackFrame::getClassName).filter(name -> {
            String string;
            return IGNORED.stream().noneMatch(string::startsWith);
        }).findFirst().map(LeakDetector::simplifyName).orElse("Unknown/Vanilla"));
    }

    /*
     * WARNING - void declaration
     */
    private static String simplifyName(String name) {
        String string;
        int first = name.indexOf(46);
        int second = name.indexOf(46, first + 1);
        if (first != -1 && second != -1) {
            void var2_2;
            void var1_1;
            return name.substring((int)(var1_1 + true), (int)var2_2);
        }
        return string;
    }

    public static class LeakNode
    implements Runnable {
        final int color;
        final int depth;
        final int frame;
        final String blame;
        public volatile boolean active = true;

        /*
         * WARNING - void declaration
         */
        public LeakNode(int color, int depth, int frame) {
            void var3_3;
            void var2_2;
            void var1_1;
            this.color = var1_1;
            this.depth = var2_2;
            this.frame = var3_3;
            this.blame = Videotape.CONFIG.debug.traceLeaks ? LeakDetector.resolveCaller() : null;
        }

        @Override
        public void run() {
            if (this.active) {
                ((AbstractCollection)QUEUE).add(this);
            }
        }
    }
}

