/*
 * Decompiled with CFR 0.152.
 */
package bluestar;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.attribute.Attribute;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityRegainHealthEvent;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.player.PlayerItemConsumeEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public class SharedLife
extends JavaPlugin
implements Listener,
CommandExecutor {
    private boolean isEnabled = false;
    private final Map<UUID, Set<UUID>> groups = new HashMap<UUID, Set<UUID>>();
    private final Map<UUID, UUID> playerToLeader = new HashMap<UUID, UUID>();
    private boolean isSyncing = false;

    public void onEnable() {
        this.getCommand("sharedlife").setExecutor((CommandExecutor)this);
        this.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this);
        this.getLogger().info("[BlueStar] SharedLife enabled!");
    }

    public void onDisable() {
        this.groups.clear();
        this.playerToLeader.clear();
        this.getLogger().info("[BlueStar] SharedLife disabled.");
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (args.length == 0) {
            return false;
        }
        String subCmd = args[0].toLowerCase();
        if (subCmd.equals("on")) {
            if (!sender.hasPermission("sharedlife.admin")) {
                sender.sendMessage(String.valueOf(ChatColor.GRAY) + "[" + String.valueOf(ChatColor.DARK_RED) + "SharedLife" + String.valueOf(ChatColor.GRAY) + "]" + String.valueOf(ChatColor.RED) + " You do not have permission.");
                return true;
            }
            this.isEnabled = true;
            Bukkit.broadcastMessage((String)(String.valueOf(ChatColor.GRAY) + "[" + String.valueOf(ChatColor.DARK_RED) + "SharedLife" + String.valueOf(ChatColor.GRAY) + "]" + String.valueOf(ChatColor.GREEN) + " Plugin is now enabled."));
            for (Player p : Bukkit.getOnlinePlayers()) {
                this.syncToPlayer(p);
            }
            return true;
        }
        if (subCmd.equals("off")) {
            if (!sender.hasPermission("sharedlife.admin")) {
                sender.sendMessage(String.valueOf(ChatColor.GRAY) + "[" + String.valueOf(ChatColor.DARK_RED) + "SharedLife" + String.valueOf(ChatColor.GRAY) + "]" + String.valueOf(ChatColor.RED) + " You do not have permission.");
                return true;
            }
            this.isEnabled = false;
            Bukkit.broadcastMessage((String)(String.valueOf(ChatColor.GRAY) + "[" + String.valueOf(ChatColor.DARK_RED) + "SharedLife" + String.valueOf(ChatColor.GRAY) + "]" + String.valueOf(ChatColor.RED) + " Plugin is now disabled."));
            return true;
        }
        if (!(sender instanceof Player)) {
            sender.sendMessage(String.valueOf(ChatColor.GRAY) + "[" + String.valueOf(ChatColor.DARK_RED) + "SharedLife" + String.valueOf(ChatColor.GRAY) + "]" + String.valueOf(ChatColor.RED) + " Only players can use group commands.");
            return true;
        }
        Player player = (Player)sender;
        if (subCmd.equals("link")) {
            if (args.length < 2) {
                player.sendMessage(String.valueOf(ChatColor.GRAY) + "[" + String.valueOf(ChatColor.DARK_RED) + "SharedLife" + String.valueOf(ChatColor.GRAY) + "]" + String.valueOf(ChatColor.RED) + " Usage: /sharedlife link <player>");
                return true;
            }
            Player target = Bukkit.getPlayer((String)args[1]);
            if (target == null) {
                player.sendMessage(String.valueOf(ChatColor.GRAY) + "[" + String.valueOf(ChatColor.DARK_RED) + "SharedLife" + String.valueOf(ChatColor.GRAY) + "]" + String.valueOf(ChatColor.RED) + " Player not found.");
                return true;
            }
            if (target.getUniqueId().equals(player.getUniqueId())) {
                player.sendMessage(String.valueOf(ChatColor.GRAY) + "[" + String.valueOf(ChatColor.DARK_RED) + "SharedLife" + String.valueOf(ChatColor.GRAY) + "]" + String.valueOf(ChatColor.RED) + " You cannot link to yourself.");
                return true;
            }
            this.createOrAddToGroup(player, target);
            return true;
        }
        if (subCmd.equals("unlink")) {
            this.handleUnlink(player);
            return true;
        }
        return false;
    }

    private void createOrAddToGroup(Player leader, Player newMember) {
        if (this.playerToLeader.containsKey(newMember.getUniqueId())) {
            leader.sendMessage(String.valueOf(ChatColor.GRAY) + "[" + String.valueOf(ChatColor.DARK_RED) + "SharedLife" + String.valueOf(ChatColor.GRAY) + "]" + String.valueOf(ChatColor.RED) + newMember.getName() + " is already in a group (or is a leader). They must /sharedlife unlink first.");
            return;
        }
        if (this.playerToLeader.containsKey(leader.getUniqueId()) && !this.playerToLeader.get(leader.getUniqueId()).equals(leader.getUniqueId())) {
            leader.sendMessage(String.valueOf(ChatColor.GRAY) + "[" + String.valueOf(ChatColor.DARK_RED) + "SharedLife" + String.valueOf(ChatColor.GRAY) + "]" + String.valueOf(ChatColor.RED) + " You are a member of another group. Leave it first.");
            return;
        }
        UUID leaderId = leader.getUniqueId();
        if (!this.groups.containsKey(leaderId)) {
            HashSet<UUID> newGroup = new HashSet<UUID>();
            newGroup.add(leaderId);
            this.groups.put(leaderId, newGroup);
            this.playerToLeader.put(leaderId, leaderId);
            leader.sendMessage(String.valueOf(ChatColor.GRAY) + "[" + String.valueOf(ChatColor.DARK_RED) + "SharedLife" + String.valueOf(ChatColor.GRAY) + "]" + String.valueOf(ChatColor.GREEN) + " Group created!");
        }
        this.groups.get(leaderId).add(newMember.getUniqueId());
        this.playerToLeader.put(newMember.getUniqueId(), leaderId);
        this.syncToPlayer(leader);
        leader.sendMessage(String.valueOf(ChatColor.GRAY) + "[" + String.valueOf(ChatColor.DARK_RED) + "SharedLife" + String.valueOf(ChatColor.GRAY) + "]" + String.valueOf(ChatColor.GREEN) + " You are now linked with " + newMember.getName());
        newMember.sendMessage(String.valueOf(ChatColor.GRAY) + "[" + String.valueOf(ChatColor.DARK_RED) + "SharedLife" + String.valueOf(ChatColor.GRAY) + "]" + String.valueOf(ChatColor.GREEN) + " You joined " + leader.getName() + "'s life group.");
    }

    private void handleUnlink(Player player) {
        UUID playerId = player.getUniqueId();
        if (!this.playerToLeader.containsKey(playerId)) {
            player.sendMessage(String.valueOf(ChatColor.GRAY) + "[" + String.valueOf(ChatColor.DARK_RED) + "SharedLife" + String.valueOf(ChatColor.GRAY) + "]" + String.valueOf(ChatColor.RED) + " You are not in a group.");
            return;
        }
        UUID leaderId = this.playerToLeader.get(playerId);
        if (leaderId.equals(playerId)) {
            Set<UUID> members = this.groups.get(leaderId);
            if (members != null) {
                for (UUID memberId : members) {
                    this.playerToLeader.remove(memberId);
                    Player member = Bukkit.getPlayer((UUID)memberId);
                    if (member == null) continue;
                    member.sendMessage(String.valueOf(ChatColor.GRAY) + "[" + String.valueOf(ChatColor.DARK_RED) + "SharedLife" + String.valueOf(ChatColor.GRAY) + "]" + String.valueOf(ChatColor.RED) + " The group was disbanded by the leader.");
                }
            }
            this.groups.remove(leaderId);
            player.sendMessage(String.valueOf(ChatColor.GRAY) + "[" + String.valueOf(ChatColor.DARK_RED) + "SharedLife" + String.valueOf(ChatColor.GRAY) + "]" + String.valueOf(ChatColor.RED) + " Group closed.");
        } else {
            Set<UUID> members = this.groups.get(leaderId);
            if (members != null) {
                members.remove(playerId);
                Player leader = Bukkit.getPlayer((UUID)leaderId);
                if (leader != null) {
                    leader.sendMessage(String.valueOf(ChatColor.GRAY) + "[" + String.valueOf(ChatColor.DARK_RED) + "SharedLife" + String.valueOf(ChatColor.GRAY) + "]" + String.valueOf(ChatColor.YELLOW) + player.getName() + " left the group.");
                }
            }
            this.playerToLeader.remove(playerId);
            player.sendMessage(String.valueOf(ChatColor.GRAY) + "[" + String.valueOf(ChatColor.DARK_RED) + "SharedLife" + String.valueOf(ChatColor.GRAY) + "]" + String.valueOf(ChatColor.GREEN) + " You left the group.");
        }
    }

    @EventHandler
    public void onQuit(PlayerQuitEvent event) {
    }

    private void syncToPlayer(Player source) {
        if (this.isSyncing || !this.isEnabled) {
            return;
        }
        UUID sourceId = source.getUniqueId();
        if (!this.playerToLeader.containsKey(sourceId)) {
            return;
        }
        UUID leaderId = this.playerToLeader.get(sourceId);
        Set<UUID> group = this.groups.get(leaderId);
        if (group == null || group.size() <= 1) {
            return;
        }
        this.isSyncing = true;
        double sourceHealth = source.getHealth();
        double sourceAbsorption = source.getAbsorptionAmount();
        for (UUID memberId : group) {
            Player member;
            if (memberId.equals(sourceId) || (member = Bukkit.getPlayer((UUID)memberId)) == null || !member.isOnline()) continue;
            double maxH = member.getAttribute(Attribute.MAX_HEALTH).getValue();
            member.setHealth(Math.min(sourceHealth, maxH));
            member.setAbsorptionAmount(sourceAbsorption);
        }
        this.isSyncing = false;
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onDamage(EntityDamageEvent event) {
        if (!this.isEnabled) {
            return;
        }
        if (!(event.getEntity() instanceof Player)) {
            return;
        }
        Player victim = (Player)event.getEntity();
        Bukkit.getScheduler().runTask((Plugin)this, () -> {
            if (victim.isDead() || victim.getHealth() <= 0.0) {
                this.killGroup(victim);
            } else {
                this.syncToPlayer(victim);
            }
        });
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onPlayerDeath(PlayerDeathEvent event) {
        if (!this.isEnabled) {
            return;
        }
        this.killGroup(event.getEntity());
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onRegen(EntityRegainHealthEvent event) {
        if (!this.isEnabled) {
            return;
        }
        if (!(event.getEntity() instanceof Player)) {
            return;
        }
        Player player = (Player)event.getEntity();
        UUID playerId = player.getUniqueId();
        if (!this.playerToLeader.containsKey(playerId)) {
            return;
        }
        if (event.getRegainReason() == EntityRegainHealthEvent.RegainReason.SATIATED) {
            UUID leaderId = this.playerToLeader.get(playerId);
            Set<UUID> group = this.groups.get(leaderId);
            boolean everyoneHasFood = true;
            if (group != null) {
                for (UUID memberId : group) {
                    Player member = Bukkit.getPlayer((UUID)memberId);
                    if (member != null && member.getFoodLevel() >= 18) continue;
                    everyoneHasFood = false;
                    break;
                }
            }
            if (!everyoneHasFood) {
                event.setCancelled(true);
                return;
            }
        }
        if (!event.isCancelled()) {
            Bukkit.getScheduler().runTask((Plugin)this, () -> this.syncToPlayer(player));
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onConsume(PlayerItemConsumeEvent event) {
        if (!this.isEnabled) {
            return;
        }
        Player player = event.getPlayer();
        if (event.getItem().getType().name().contains("GOLDEN_APPLE")) {
            UUID playerId = player.getUniqueId();
            if (!this.playerToLeader.containsKey(playerId)) {
                return;
            }
            UUID leaderId = this.playerToLeader.get(playerId);
            Set<UUID> group = this.groups.get(leaderId);
            Bukkit.getScheduler().runTaskLater((Plugin)this, () -> {
                PotionEffect absorptionEffect = player.getPotionEffect(PotionEffectType.ABSORPTION);
                if (absorptionEffect != null && group != null) {
                    for (UUID memberId : group) {
                        Player member;
                        if (memberId.equals(playerId) || (member = Bukkit.getPlayer((UUID)memberId)) == null) continue;
                        member.addPotionEffect(absorptionEffect);
                    }
                }
                this.syncToPlayer(player);
            }, 5L);
        }
    }

    private void killGroup(Player source) {
        UUID leaderId;
        Set<UUID> group;
        if (this.isSyncing) {
            return;
        }
        this.isSyncing = true;
        UUID sourceId = source.getUniqueId();
        if (this.playerToLeader.containsKey(sourceId) && (group = this.groups.get(leaderId = this.playerToLeader.get(sourceId))) != null) {
            for (UUID memberId : group) {
                Player member = Bukkit.getPlayer((UUID)memberId);
                if (member == null || member.isDead() || !(member.getHealth() > 0.0)) continue;
                member.setHealth(0.0);
            }
        }
        this.isSyncing = false;
    }
}

