/*
 * Decompiled with CFR 0.152.
 */
package house.greenhouse.enchiridion.api.datagen.recipe;

import house.greenhouse.enchiridion.api.EnchantmentCategory;
import house.greenhouse.enchiridion.recipe.SiphoningRecipe;
import house.greenhouse.enchiridion.registry.EnchiridionItems;
import house.greenhouse.enchiridion.util.SiphoningBookCategory;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_161;
import net.minecraft.class_170;
import net.minecraft.class_175;
import net.minecraft.class_1792;
import net.minecraft.class_1802;
import net.minecraft.class_1856;
import net.minecraft.class_1860;
import net.minecraft.class_1887;
import net.minecraft.class_1935;
import net.minecraft.class_2066;
import net.minecraft.class_2073;
import net.minecraft.class_2119;
import net.minecraft.class_2960;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_8782;
import net.minecraft.class_8790;
import net.minecraft.class_9304;
import org.jetbrains.annotations.Nullable;

public class SiphoningRecipeBuilder {
    private final List<SiphoningRecipe.IngredientWithAmount> ingredients;
    private final int experienceCost;
    private final int time;
    private final Map<class_6880<EnchantmentCategory>, class_9304> enchantments = new HashMap<class_6880<EnchantmentCategory>, class_9304>();
    private final Map<String, class_175<?>> criteria = new LinkedHashMap();
    private SiphoningBookCategory category = SiphoningBookCategory.TOOLS;
    @Nullable
    private String group;

    public SiphoningRecipeBuilder(List<SiphoningRecipe.IngredientWithAmount> ingredients, int experienceCost, int time) {
        this.ingredients = ingredients;
        this.experienceCost = experienceCost;
        this.time = time;
    }

    public static SiphoningRecipeBuilder siphoning(class_1856 ingredient, int ingredientCount, int lapisCount) {
        return SiphoningRecipeBuilder.siphoning(ingredient, ingredientCount, lapisCount, 5);
    }

    public static SiphoningRecipeBuilder siphoning(class_1856 ingredient, int ingredientCount, int lapisCount, int experienceCost) {
        return SiphoningRecipeBuilder.siphoning(ingredient, ingredientCount, lapisCount, experienceCost, 4800);
    }

    public static SiphoningRecipeBuilder siphoning(class_1856 ingredient, int ingredientCount, int lapisCount, int experienceCost, int time) {
        return new SiphoningRecipeBuilder(List.of(new SiphoningRecipe.IngredientWithAmount(ingredient, ingredientCount), new SiphoningRecipe.IngredientWithAmount(class_1856.method_8091((class_1935[])new class_1935[]{class_1802.field_8759}), lapisCount)), experienceCost, time);
    }

    public SiphoningRecipeBuilder withGroup(String group) {
        this.group = group;
        return this;
    }

    public SiphoningRecipeBuilder withCategory(SiphoningBookCategory category) {
        this.category = category;
        return this;
    }

    public SiphoningRecipeBuilder enchantment(class_6880<EnchantmentCategory> category, class_6880<class_1887> enchantment, int level) {
        this.enchantments.compute(category, (categoryHolder, enchantments) -> {
            class_9304.class_9305 mutable = new class_9304.class_9305(enchantments != null ? enchantments : class_9304.field_49385);
            mutable.method_57547(enchantment, level);
            return mutable.method_57549();
        });
        return this;
    }

    public SiphoningRecipeBuilder unlocksWithSiphoningTable() {
        return this.unlocksWithItem((class_1792)EnchiridionItems.SIPHONING_TABLE);
    }

    public SiphoningRecipeBuilder unlocksWithItem(class_1792 item) {
        return this.unlocks("has_" + item.method_40131().method_40237().method_29177().method_12832(), class_2066.class_2068.method_8959((class_1935[])new class_1935[]{item}));
    }

    public SiphoningRecipeBuilder unlocksWithTag(class_6862<class_1792> tag) {
        return this.unlocks("has_" + tag.comp_327().method_12832(), class_2066.class_2068.method_53160((class_2073.class_2074[])new class_2073.class_2074[]{class_2073.class_2074.method_8973().method_8975(tag)}));
    }

    public SiphoningRecipeBuilder unlocks(String key, class_175<?> criterion) {
        this.criteria.put(key, criterion);
        return this;
    }

    public void save(class_8790 output, class_2960 recipeId) {
        this.ensureValid(recipeId);
        class_161.class_162 advancement$builder = output.method_53818().method_705("has_the_recipe", class_2119.method_27847((class_2960)recipeId)).method_703(class_170.class_171.method_753((class_2960)recipeId)).method_704(class_8782.class_8797.field_1257);
        this.criteria.forEach((arg_0, arg_1) -> ((class_161.class_162)advancement$builder).method_705(arg_0, arg_1));
        SiphoningRecipe recipe = new SiphoningRecipe(this.group != null ? this.group : (this.enchantments.size() == 1 && this.enchantments.values().stream().flatMap(enchantments1 -> enchantments1.method_57539().stream()).toList().size() == 1 ? ((class_6880)((Object2IntMap.Entry)((class_9304)((Map.Entry)this.enchantments.entrySet().stream().findFirst().orElseThrow()).getValue()).method_57539().stream().findFirst().orElseThrow()).getKey()).method_55840() : null), this.category, this.ingredients, this.enchantments, this.experienceCost, this.time);
        output.method_53819(recipeId.method_45138("siphoning/"), (class_1860)recipe, advancement$builder.method_695(recipeId.method_45138("recipes/siphoning/" + this.category.method_15434() + "/")));
    }

    private void ensureValid(class_2960 location) {
        if (this.criteria.isEmpty()) {
            throw new IllegalStateException("No way of obtaining recipe " + String.valueOf(location));
        }
        if (this.enchantments.isEmpty()) {
            throw new IllegalStateException("No enchantments in result for recipe " + String.valueOf(location));
        }
    }
}

