/*
 * Decompiled with CFR 0.152.
 */
package house.greenhouse.enchiridion.api.enchantment.effect;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import house.greenhouse.enchiridion.api.registry.EnchiridionEnchantmentEffectComponents;
import house.greenhouse.enchiridion.util.MathUtil;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_173;
import net.minecraft.class_1799;
import net.minecraft.class_181;
import net.minecraft.class_1887;
import net.minecraft.class_1937;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_47;
import net.minecraft.class_5819;
import net.minecraft.class_6880;
import net.minecraft.class_8567;
import net.minecraft.class_9698;
import net.minecraft.class_9723;

public class AttributeTransferEffect {
    public static final Codec<AttributeTransferEffect> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)class_1320.field_51575.fieldOf("from").forGetter(AttributeTransferEffect::from), (App)class_1320.field_51575.fieldOf("to").forGetter(AttributeTransferEffect::to), (App)class_2960.field_25139.fieldOf("id").forGetter(AttributeTransferEffect::id), (App)class_1322.class_1323.field_45742.fieldOf("operation").forGetter(AttributeTransferEffect::operation), (App)class_9723.field_51709.fieldOf("value").forGetter(AttributeTransferEffect::modifier)).apply((Applicative)inst, AttributeTransferEffect::new));
    private final class_6880<class_1320> from;
    private final class_6880<class_1320> to;
    private final class_2960 id;
    private final class_1322.class_1323 operation;
    private final class_9723 modifier;
    private double previousModifierValue = Double.NaN;

    public AttributeTransferEffect(class_6880<class_1320> from, class_6880<class_1320> to, class_2960 id, class_1322.class_1323 operation, class_9723 modifier) {
        this.from = from;
        this.to = to;
        this.id = id;
        this.operation = operation;
        this.modifier = modifier;
    }

    public static void apply(class_1309 entity) {
        class_1937 class_19372 = entity.method_37908();
        if (!(class_19372 instanceof class_3218)) {
            return;
        }
        class_3218 level = (class_3218)class_19372;
        class_8567.class_8568 params = new class_8567.class_8568(level).method_51874(class_181.field_1226, (Object)entity).method_51874(class_181.field_24424, (Object)entity.method_19538());
        List<Object2IntMap.Entry> enchantments = Stream.of(class_1304.values()).flatMap(slot -> entity.method_6118(slot).method_58657().method_57539().stream().filter(entry -> ((class_6880)entry.getKey()).method_40227() && ((class_1887)((class_6880)entry.getKey()).comp_349()).method_60026(slot))).filter(enchantment -> ((class_6880)enchantment.getKey()).method_40227() && !((class_1887)((class_6880)enchantment.getKey()).comp_349()).method_60034(EnchiridionEnchantmentEffectComponents.ATTRIBUTE_TRANSFER).isEmpty()).toList();
        for (Object2IntMap.Entry enchantment2 : enchantments) {
            params.method_51874(class_181.field_51805, (Object)enchantment2.getIntValue());
            class_47 context = new class_47.class_48(params.method_51875(class_173.field_51804)).method_309(Optional.empty());
            List effects = ((class_1887)((class_6880)enchantment2.getKey()).comp_349()).method_60034(EnchiridionEnchantmentEffectComponents.ATTRIBUTE_TRANSFER);
            for (class_9698 effect : effects) {
                if (!effect.method_60006(context)) {
                    if (!entity.method_6127().method_45331(((AttributeTransferEffect)effect.comp_2680()).to) || !entity.method_5996(((AttributeTransferEffect)effect.comp_2680()).to).method_6196(((AttributeTransferEffect)effect.comp_2680()).id)) continue;
                    entity.method_5996(((AttributeTransferEffect)effect.comp_2680()).to).method_6200(((AttributeTransferEffect)effect.comp_2680()).id);
                    ((AttributeTransferEffect)effect.comp_2680()).previousModifierValue = Double.NaN;
                    continue;
                }
                ((AttributeTransferEffect)effect.comp_2680()).applyAttribute(context, entity, enchantment2.getIntValue());
            }
        }
    }

    public static void clearInvalidEffects(class_1309 entity, class_1799 stack) {
        class_1937 class_19372 = entity.method_37908();
        if (!(class_19372 instanceof class_3218)) {
            return;
        }
        class_3218 level = (class_3218)class_19372;
        List<Object2IntMap.Entry> enchantments = stack.method_58657().method_57539().stream().filter(holderEntry -> ((class_6880)holderEntry.getKey()).method_40227() && !((class_1887)((class_6880)holderEntry.getKey()).comp_349()).method_60034(EnchiridionEnchantmentEffectComponents.ATTRIBUTE_TRANSFER).isEmpty()).toList();
        for (Object2IntMap.Entry enchantment : enchantments) {
            List effects = ((class_1887)((class_6880)enchantment.getKey()).comp_349()).method_60034(EnchiridionEnchantmentEffectComponents.ATTRIBUTE_TRANSFER);
            for (class_9698 effect : effects) {
                if (!entity.method_6127().method_45331(((AttributeTransferEffect)effect.comp_2680()).to())) continue;
                entity.method_5996(((AttributeTransferEffect)effect.comp_2680()).to).method_6200(((AttributeTransferEffect)effect.comp_2680()).id);
                ((AttributeTransferEffect)effect.comp_2680()).previousModifierValue = Double.NaN;
            }
        }
    }

    private void applyAttribute(class_47 context, class_1309 entity, int enchantmentLevel) {
        if (!entity.method_6127().method_45331(this.to) || MathUtil.areDoublesEqual(this.previousModifierValue, entity.method_45325(this.from))) {
            return;
        }
        if (!MathUtil.areDoublesEqual(this.previousModifierValue, entity.method_45325(this.from))) {
            entity.method_5996(this.to).method_6200(this.id);
            this.previousModifierValue = entity.method_45326(this.from);
        }
        entity.method_5996(this.to).method_55696(this.constructModifier(context.method_294(), entity.method_45325(this.from), enchantmentLevel));
    }

    private class_1322 constructModifier(class_5819 random, double fromValue, int enchantmentLevel) {
        return new class_1322(this.id, (double)this.modifier.method_60213(enchantmentLevel, random, (float)fromValue), this.operation);
    }

    public class_6880<class_1320> from() {
        return this.from;
    }

    public class_6880<class_1320> to() {
        return this.to;
    }

    public class_2960 id() {
        return this.id;
    }

    public class_1322.class_1323 operation() {
        return this.operation;
    }

    public class_9723 modifier() {
        return this.modifier;
    }
}

