/*
 * Decompiled with CFR 0.152.
 */
package house.greenhouse.enchiridion.enchantment.provider;

import com.google.common.collect.Lists;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import house.greenhouse.enchiridion.Enchiridion;
import house.greenhouse.enchiridion.api.EnchantmentCategory;
import house.greenhouse.enchiridion.enchantment.category.ItemEnchantmentCategories;
import house.greenhouse.enchiridion.registry.EnchiridionDataComponents;
import house.greenhouse.enchiridion.util.EnchantmentInstanceWithCategory;
import house.greenhouse.enchiridion.util.WeightedEnchantmentCategories;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1266;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1887;
import net.minecraft.class_1889;
import net.minecraft.class_1890;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_5819;
import net.minecraft.class_6008;
import net.minecraft.class_6012;
import net.minecraft.class_6016;
import net.minecraft.class_6017;
import net.minecraft.class_6880;
import net.minecraft.class_6885;
import net.minecraft.class_6895;
import net.minecraft.class_7924;
import net.minecraft.class_9304;
import net.minecraft.class_9741;
import org.jetbrains.annotations.Nullable;

public class EnchantFromTable
implements class_9741 {
    public static final class_2960 ID = Enchiridion.asResource("enchant_from_table");
    public static final MapCodec<EnchantFromTable> CODEC = RecordCodecBuilder.mapCodec(inst -> inst.group((App)class_6017.field_33451.optionalFieldOf("amount", (Object)class_6016.method_34998((int)1)).forGetter(EnchantFromTable::getAmount), (App)class_6895.method_40340((class_5321)class_7924.field_41265).fieldOf("enchantments").forGetter(EnchantFromTable::getEnchantments), (App)class_6012.method_34991(WeightedEnchantmentCategories.CODEC).fieldOf("categories").forGetter(EnchantFromTable::getCategories), (App)Codec.BOOL.optionalFieldOf("allow_duplicate_categories", (Object)false).forGetter(EnchantFromTable::shouldAllowDuplicateCategories)).apply((Applicative)inst, EnchantFromTable::new));
    private final class_6017 amount;
    private final class_6885<class_1887> enchantments;
    private final class_6012<WeightedEnchantmentCategories> categories;
    private final boolean allowDuplicateCategories;
    private int level = 0;

    public EnchantFromTable(class_6017 amount, class_6885<class_1887> enchantments, class_6012<WeightedEnchantmentCategories> categories, boolean allowDuplicateCategories) {
        this.amount = amount;
        this.enchantments = enchantments;
        this.categories = categories;
        this.allowDuplicateCategories = allowDuplicateCategories;
    }

    public class_6017 getAmount() {
        return this.amount;
    }

    public class_6885<class_1887> getEnchantments() {
        return this.enchantments;
    }

    public class_6012<WeightedEnchantmentCategories> getCategories() {
        return this.categories;
    }

    public boolean shouldAllowDuplicateCategories() {
        return this.allowDuplicateCategories;
    }

    public void setLevel(int level) {
        this.level = level;
    }

    public void method_60266(class_1799 stack, class_9304.class_9305 mutable, class_5819 random, class_1266 difficulty) {
        if (this.level > 0) {
            boolean hasAddedAdditionalEnchantment = false;
            ArrayList<class_6880<class_1887>> operatedEnchantments = new ArrayList<class_6880<class_1887>>();
            ArrayList<class_6880<EnchantmentCategory>> operatedCategories = new ArrayList<class_6880<EnchantmentCategory>>();
            ArrayList<EnchantmentInstanceWithCategory> instances = new ArrayList<EnchantmentInstanceWithCategory>();
            int am = this.amount.method_35008(random);
            for (int i = 0; i < am; ++i) {
                EnchantmentInstanceWithCategory inst;
                ArrayList<class_1889> allowedEnchantments = new ArrayList<class_1889>(this.getAllowedEnchantments(stack).stream().filter(enchantmentInstance -> !operatedEnchantments.contains(enchantmentInstance.field_9093) && operatedEnchantments.stream().noneMatch(enchantmentHolder -> ((class_1887)enchantmentHolder.comp_349()).comp_2688().method_40241(enchantmentInstance.field_9093))).toList());
                if (allowedEnchantments.isEmpty() || (inst = this.handleEnchantment(operatedCategories, operatedEnchantments, allowedEnchantments, random)) == null) continue;
                instances.add(inst);
                allowedEnchantments.removeIf(allowedInst -> allowedInst.field_9093.method_55838(inst.field_9093));
                while (!hasAddedAdditionalEnchantment && random.method_43048(50) <= this.level) {
                    EnchantmentInstanceWithCategory extraInst;
                    if (!allowedEnchantments.isEmpty()) {
                        class_1890.method_8231(allowedEnchantments, (class_1889)inst);
                    }
                    if (allowedEnchantments.isEmpty() || (extraInst = this.handleEnchantment(operatedCategories, operatedEnchantments, allowedEnchantments, random)) == null) break;
                    instances.add(extraInst);
                    hasAddedAdditionalEnchantment = true;
                }
                this.level = (int)((double)this.level / 1.5);
            }
            for (EnchantmentInstanceWithCategory instance : instances) {
                if (mutable.method_57546(instance.field_9093) >= instance.field_9094) continue;
                mutable.method_57550(instance.field_9093, instance.field_9094);
                ItemEnchantmentCategories itemCategories = (ItemEnchantmentCategories)stack.method_57825(EnchiridionDataComponents.ENCHANTMENT_CATEGORIES, (Object)new ItemEnchantmentCategories());
                itemCategories.overwrite(instance.category, (class_6880<class_1887>)instance.field_9093);
                stack.method_57379(EnchiridionDataComponents.ENCHANTMENT_CATEGORIES, (Object)itemCategories);
            }
        }
        this.level = 0;
    }

    private EnchantmentInstanceWithCategory handleEnchantment(List<class_6880<EnchantmentCategory>> operatedCategories, List<class_6880<class_1887>> operatedEnchantments, List<class_1889> allowedEnchantments, class_5819 random) {
        class_6880<EnchantmentCategory> category = this.chooseCategory(operatedCategories, allowedEnchantments, random);
        if (category == null) {
            return null;
        }
        class_6880<EnchantmentCategory> finalCategory = category;
        List<EnchantmentInstanceWithCategory> filteredCategoricalEnchantment = allowedEnchantments.stream().map(enchantmentInstance -> new EnchantmentInstanceWithCategory((class_1889)enchantmentInstance, category)).filter(enchantmentHolder -> ((EnchantmentCategory)finalCategory.comp_349()).acceptedEnchantments().method_40241(enchantmentHolder.field_9093)).toList();
        if (filteredCategoricalEnchantment.isEmpty()) {
            return null;
        }
        EnchantmentInstanceWithCategory enchantment = filteredCategoricalEnchantment.get(random.method_43048(filteredCategoricalEnchantment.size()));
        operatedCategories.add(category);
        operatedEnchantments.add((class_6880<class_1887>)enchantment.field_9093);
        return enchantment;
    }

    @Nullable
    private class_6880<EnchantmentCategory> chooseCategory(List<class_6880<EnchantmentCategory>> operatedCategories, List<class_1889> allowedEnchantments, class_5819 random) {
        class_6012 potentialCategories = class_6012.method_34988(this.categories.method_34994().stream().flatMap(categories -> categories.getCategories().method_40239().map(categoryHolder -> class_6008.method_34980((Object)categoryHolder, (int)categories.method_34979().method_34976()))).filter(category -> ((class_6880)category.comp_2542()).method_40227() && ((EnchantmentCategory)((class_6880)category.comp_2542()).comp_349()).acceptedEnchantments().method_40239().anyMatch(enchantmentHolder -> allowedEnchantments.stream().anyMatch(enchantmentInstance -> enchantmentHolder.method_55838(enchantmentInstance.field_9093))) && (this.allowDuplicateCategories || new HashSet(operatedCategories).containsAll(this.categories.method_34994().stream().flatMap(categories -> categories.getCategories().method_40239()).toList()) || !operatedCategories.contains(category.comp_2542())) && this.enchantments.method_40239().anyMatch(enchantment -> ((EnchantmentCategory)((class_6880)category.comp_2542()).comp_349()).acceptedEnchantments().method_40241(enchantment))).sorted(Comparator.comparingInt(value -> ((EnchantmentCategory)((class_6880)value.comp_2542()).comp_349()).priority())).toList());
        if (potentialCategories.method_34993()) {
            return null;
        }
        Optional optional = potentialCategories.method_34992(random);
        return optional.map(class_6008.class_6010::comp_2542).orElse(null);
    }

    private List<class_1889> getAllowedEnchantments(class_1799 stack) {
        ArrayList list = Lists.newArrayList();
        boolean flag = stack.method_31574(class_1802.field_8529);
        this.enchantments.method_40239().filter(enchantment -> Enchiridion.getHelper().isPrimaryItem(stack, (class_6880<class_1887>)enchantment) || flag).forEach(holder -> {
            class_1887 enchantment = (class_1887)holder.comp_349();
            for (int i = enchantment.method_8183(); i >= enchantment.method_8187(); --i) {
                if (this.level < enchantment.method_8182(i) || this.level > enchantment.method_20742(i)) continue;
                list.add(new class_1889(holder, i));
                break;
            }
        });
        return list;
    }

    public MapCodec<EnchantFromTable> method_60265() {
        return CODEC;
    }
}

