/*
 * Decompiled with CFR 0.152.
 */
package house.greenhouse.enchiridion.entity;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DynamicOps;
import house.greenhouse.enchiridion.api.registry.EnchiridionDamageTypes;
import house.greenhouse.enchiridion.client.sound.WhirlpoolLoopSoundInstance;
import house.greenhouse.enchiridion.client.util.ClientEntityUtil;
import house.greenhouse.enchiridion.duck.Duck_Whirlpool;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_173;
import net.minecraft.class_181;
import net.minecraft.class_1937;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2509;
import net.minecraft.class_2520;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_47;
import net.minecraft.class_5341;
import net.minecraft.class_6880;
import net.minecraft.class_6903;
import net.minecraft.class_7225;
import net.minecraft.class_7924;
import net.minecraft.class_8046;
import net.minecraft.class_8567;
import org.jetbrains.annotations.Nullable;

public class Whirlpool
extends class_1297
implements class_8046 {
    private static final class_2940<Float> WIDTH = class_2945.method_12791(Whirlpool.class, (class_2941)class_2943.field_13320);
    private static final class_2940<Float> HEIGHT = class_2945.method_12791(Whirlpool.class, (class_2941)class_2943.field_13320);
    private static final class_2940<Float> TARGET_WIDTH = class_2945.method_12791(Whirlpool.class, (class_2941)class_2943.field_13320);
    private static final class_2940<Float> TARGET_HEIGHT = class_2945.method_12791(Whirlpool.class, (class_2941)class_2943.field_13320);
    private static final class_2940<Float> SUMMON_SPEED = class_2945.method_12791(Whirlpool.class, (class_2941)class_2943.field_13320);
    private static final class_2940<Boolean> SHOULD_DISPERSE = class_2945.method_12791(Whirlpool.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Optional<UUID>> OWNER = class_2945.method_12791(Whirlpool.class, (class_2941)class_2943.field_13313);
    private int lifetime = 80;
    private float damageAmount = 4.0f;
    private class_1297 cachedOwner;
    private int enchantmentLevel;
    private class_5341 disperseCondition;
    private boolean isDispersing = false;
    private boolean hasInitializedSound = false;
    private final Object2IntMap<class_1309> affectedEntityTimer = new Object2IntOpenHashMap();

    public Whirlpool(class_1299<?> entityType, class_1937 level) {
        super(entityType, level);
    }

    public void method_5773() {
        super.method_5773();
        if (this.isDispersing || this.shouldDisperse() || this.field_6012 > this.lifetime) {
            if ((double)this.getCurrentWidth() < 0.01 && (double)this.getCurrentHeight() < 0.01) {
                this.method_31472();
                return;
            }
            if (!this.isDispersing) {
                this.isDispersing = true;
            }
        }
        if (this.method_24921() != null) {
            ((Duck_Whirlpool)this.method_24921()).enchiridion$setWhirlpoolPercentage(Math.max(this.getCurrentWidth() / this.getTargetWidth(), this.getCurrentHeight() / this.getTargetHeight()));
        }
        if (this.method_37908().field_9236) {
            this.method_18382();
            if (!this.hasInitializedSound) {
                WhirlpoolLoopSoundInstance.start(this);
                this.hasInitializedSound = true;
            }
            return;
        }
        float width = this.getCurrentWidth();
        float height = this.getCurrentHeight();
        if (this.isDispersing && (double)width > 0.01 || width < this.getTargetWidth()) {
            this.setCurrentWidth(width += this.getTargetWidth() * (this.isDispersing ? -this.getSummonSpeed() : this.getSummonSpeed()));
        }
        if (this.isDispersing && (double)height > 0.01 || height < this.getTargetHeight()) {
            this.setCurrentHeight(height += this.getTargetHeight() * (this.isDispersing ? -this.getSummonSpeed() : this.getSummonSpeed()));
        }
        if (this.getOwnerUUID() != null && this.method_24921() == null || this.method_24921() != null && (!this.method_24921().method_5805() || this.method_24921().method_31481())) {
            this.setToDisperse();
        }
        this.method_18382();
        for (Object2IntMap.Entry entry2 : this.affectedEntityTimer.object2IntEntrySet()) {
            entry2.setValue(entry2.getIntValue() + 1);
        }
        this.affectedEntityTimer.object2IntEntrySet().removeIf(entry -> entry.getIntValue() > 20);
        if (this.isDispersing ^ height > this.getTargetHeight()) {
            List<class_1309> entities = this.method_37908().method_18467(class_1309.class, this.method_5829()).stream().filter(entity -> !entity.method_5779(this.method_24921())).toList();
            for (class_1309 entity2 : entities) {
                if (this.affectedEntityTimer.containsKey((Object)entity2)) continue;
                if (this.method_24921() != null) {
                    entity2.method_5643(new class_1282((class_6880)this.method_37908().method_30349().method_30530(class_7924.field_42534).method_40290(EnchiridionDamageTypes.WHIRLPOOL), (class_1297)this, this.method_24921(), entity2.method_19538()), this.damageAmount);
                } else {
                    entity2.method_5643(new class_1282((class_6880)this.method_37908().method_30349().method_30530(class_7924.field_42534).method_40290(EnchiridionDamageTypes.WHIRLPOOL)), this.damageAmount);
                }
                this.affectedEntityTimer.put((Object)entity2, 0);
            }
        }
        if (!this.isDispersing && this.method_24921() != null && this.disperseCondition != null) {
            class_8567.class_8568 params = new class_8567.class_8568((class_3218)this.method_37908()).method_51874(class_181.field_1226, (Object)this.method_24921()).method_51874(class_181.field_24424, (Object)this.method_24921().method_19538()).method_51874(class_181.field_51805, (Object)this.enchantmentLevel);
            if (this.disperseCondition.test((Object)new class_47.class_48(params.method_51875(class_173.field_51804)).method_309(Optional.empty()))) {
                this.setToDisperse();
            }
        } else if (this.method_24921() != null) {
            this.method_33574(this.method_24921().method_19538());
        }
    }

    public class_238 method_33332() {
        return class_238.method_30048((class_243)this.method_19538().method_1031(0.0, this.method_24921() == null ? 0.0 : this.method_24921().method_23323(0.5) - this.method_24921().method_23318(), 0.0), (double)this.getCurrentWidth(), (double)this.getCurrentHeight(), (double)this.getCurrentWidth());
    }

    protected void method_5693(class_2945.class_9222 builder) {
        builder.method_56912(WIDTH, (Object)Float.valueOf(0.0f));
        builder.method_56912(HEIGHT, (Object)Float.valueOf(0.0f));
        builder.method_56912(TARGET_WIDTH, (Object)Float.valueOf(0.0f));
        builder.method_56912(TARGET_HEIGHT, (Object)Float.valueOf(0.0f));
        builder.method_56912(SUMMON_SPEED, (Object)Float.valueOf(0.0f));
        builder.method_56912(SHOULD_DISPERSE, (Object)false);
        builder.method_56912(OWNER, Optional.empty());
    }

    protected void method_5749(class_2487 compound) {
        this.setCurrentWidth(compound.method_10583("width"));
        if (compound.method_10545("target_width")) {
            this.setTargetWidth(compound.method_10583("target_width"));
        }
        this.setCurrentHeight(compound.method_10583("height"));
        if (compound.method_10545("target_height")) {
            this.setTargetHeight(compound.method_10583("target_height"));
        }
        if (compound.method_10545("summon_speed")) {
            this.setSummonSpeed(compound.method_10583("summon_speed"));
        }
        if (compound.method_10545("age")) {
            this.field_6012 = compound.method_10550("age");
        }
        if (compound.method_10545("lifetime")) {
            this.lifetime = compound.method_10550("lifetime");
        }
        this.field_6011.method_12778(SHOULD_DISPERSE, (Object)compound.method_10577("should_disperse"));
        this.isDispersing = compound.method_10577("is_dispersing");
        if (compound.method_10545("damage_amount")) {
            this.damageAmount = compound.method_10583("damage_amount");
        }
        if (!this.method_37908().field_9236 && compound.method_10545("disperse_condition")) {
            this.disperseCondition = (class_5341)((Pair)class_5341.field_51809.decode((DynamicOps)class_6903.method_46632((DynamicOps)class_2509.field_11560, (class_7225.class_7874)this.method_37908().method_30349()), (Object)compound.method_10580("disperse_condition")).getOrThrow()).getFirst();
        }
        if (compound.method_10545("owner")) {
            this.setOwner(compound.method_25926("owner"));
        }
        if (compound.method_10545("enchantment_level")) {
            this.enchantmentLevel = compound.method_10550("enchantment_level");
        }
    }

    protected void method_5652(class_2487 compound) {
        compound.method_10548("width", this.getCurrentWidth());
        compound.method_10548("target_width", this.getTargetWidth());
        compound.method_10548("height", this.getCurrentHeight());
        compound.method_10548("target_height", this.getTargetHeight());
        compound.method_10548("summon_speed", this.getSummonSpeed());
        compound.method_10569("age", this.field_6012);
        compound.method_10569("lifetime", this.lifetime);
        compound.method_10548("damage_amount", this.damageAmount);
        compound.method_10556("should_disperse", this.shouldDisperse());
        compound.method_10556("is_dispersing", this.isDispersing);
        if (!this.method_37908().field_9236 && this.disperseCondition != null) {
            compound.method_10566("disperse_condition", (class_2520)class_5341.field_51809.encodeStart((DynamicOps)class_6903.method_46632((DynamicOps)class_2509.field_11560, (class_7225.class_7874)this.method_37908().method_30349()), (Object)this.disperseCondition).getOrThrow());
        }
        if (this.getOwnerUUID() != null) {
            compound.method_25927("owner", this.getOwnerUUID());
        }
        if (this.enchantmentLevel > 0) {
            compound.method_10569("enchantment_level", this.enchantmentLevel);
        }
    }

    public float getCurrentWidth() {
        return this.getCurrentWidth(0.0f);
    }

    public float getCurrentWidth(float tickOffset) {
        boolean decreasing = this.getTargetWidth() < ((Float)this.field_6011.method_12789(WIDTH)).floatValue();
        float value = ((Float)this.field_6011.method_12789(WIDTH)).floatValue() + (float)(decreasing ? -1 : 1) * this.getSummonSpeed() * tickOffset;
        return decreasing ? Math.max(value, this.getTargetWidth()) : Math.min(value, this.getTargetWidth());
    }

    private float getRawWidth() {
        return ((Float)this.field_6011.method_12789(WIDTH)).floatValue();
    }

    public void setCurrentWidth(float value) {
        this.field_6011.method_12778(WIDTH, (Object)Float.valueOf(value));
    }

    public float getTargetWidth() {
        return ((Float)this.field_6011.method_12789(TARGET_WIDTH)).floatValue();
    }

    public void setTargetWidth(float value) {
        this.field_6011.method_12778(TARGET_WIDTH, (Object)Float.valueOf(value));
    }

    public float getCurrentHeight() {
        return this.getCurrentHeight(0.0f);
    }

    public float getCurrentHeight(float tickOffset) {
        boolean decreasing = this.getTargetHeight() < ((Float)this.field_6011.method_12789(HEIGHT)).floatValue();
        float value = ((Float)this.field_6011.method_12789(HEIGHT)).floatValue() + (float)(decreasing ? -1 : 1) * this.getSummonSpeed() * tickOffset;
        return decreasing ? Math.max(value, this.getTargetHeight()) : Math.min(value, this.getTargetHeight());
    }

    public void setCurrentHeight(float value) {
        this.field_6011.method_12778(HEIGHT, (Object)Float.valueOf(value));
    }

    public float getTargetHeight() {
        return ((Float)this.field_6011.method_12789(TARGET_HEIGHT)).floatValue();
    }

    public void setTargetHeight(float value) {
        this.field_6011.method_12778(TARGET_HEIGHT, (Object)Float.valueOf(value));
    }

    private float getSummonSpeed() {
        return ((Float)this.field_6011.method_12789(SUMMON_SPEED)).floatValue();
    }

    public void setSummonSpeed(float value) {
        this.field_6011.method_12778(SUMMON_SPEED, (Object)Float.valueOf(value));
    }

    public void setLifetime(int value) {
        this.lifetime = value;
    }

    public void setDamageAmount(float value) {
        this.damageAmount = value;
    }

    public void setDisperseCondition(class_5341 value) {
        this.disperseCondition = value;
    }

    public void setEnchantmentLevel(int enchantmentLevel) {
        this.enchantmentLevel = enchantmentLevel;
    }

    private boolean shouldDisperse() {
        return (Boolean)this.field_6011.method_12789(SHOULD_DISPERSE);
    }

    private void setToDisperse() {
        this.field_6011.method_12778(SHOULD_DISPERSE, (Object)true);
    }

    @Nullable
    private UUID getOwnerUUID() {
        return ((Optional)this.field_6011.method_12789(OWNER)).orElse(null);
    }

    private void setOwner(UUID uuid) {
        this.field_6011.method_12778(OWNER, Optional.of(uuid));
    }

    public void setOwner(class_1297 entity) {
        this.field_6011.method_12778(OWNER, Optional.of(entity.method_5667()));
    }

    @Nullable
    public class_1297 method_24921() {
        if (this.cachedOwner != null && !this.cachedOwner.method_31481()) {
            return this.cachedOwner;
        }
        if (this.getOwnerUUID() != null) {
            class_1937 var2 = this.method_37908();
            if (var2 instanceof class_3218) {
                class_3218 serverlevel = (class_3218)var2;
                this.cachedOwner = serverlevel.method_14190(this.getOwnerUUID());
                if (this.cachedOwner != null) {
                    ((Duck_Whirlpool)this.cachedOwner).enchiridion$setConnectedWhirlpool(this);
                }
                return this.cachedOwner;
            }
            if (this.method_37908().method_8608()) {
                this.cachedOwner = ClientEntityUtil.getEntityFromUUID(this.method_37908(), this.getOwnerUUID());
                if (this.cachedOwner != null) {
                    ((Duck_Whirlpool)this.cachedOwner).enchiridion$setConnectedWhirlpool(this);
                }
                return this.cachedOwner;
            }
        }
        return null;
    }

    public boolean method_49108() {
        return true;
    }
}

