/*
 * Decompiled with CFR 0.152.
 */
package house.greenhouse.enchiridion.fabric.util;

import com.google.common.collect.Maps;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import house.greenhouse.enchiridion.Enchiridion;
import house.greenhouse.enchiridion.EnchiridionTags;
import java.io.BufferedReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_2248;
import net.minecraft.class_2960;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_3503;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import net.minecraft.class_7225;
import net.minecraft.class_7475;
import net.minecraft.class_7654;
import net.minecraft.class_7924;

public class TagUtil {
    private static Collection<class_6880<class_2248>> EARLY_BASE_STONE_TAG;
    private static final class_7654 CONVERTER;

    public static boolean isInBaseStoneTag(class_6880<class_2248> block, class_3300 manager, class_7225<class_2248> lookup) {
        Map<class_2960, List<class_3503.class_5145>> stoneTagMap;
        class_3503 loader;
        Map loaded;
        if (EARLY_BASE_STONE_TAG == null && (EARLY_BASE_STONE_TAG = (Collection)(loaded = (loader = new class_3503(rl -> lookup.method_46746(class_5321.method_29179((class_5321)class_7924.field_41254, (class_2960)rl)), "tags/block")).method_18242(stoneTagMap = TagUtil.loadBaseStoneTag(manager))).get(EnchiridionTags.BlockTags.BASE_STONE.comp_327())) == null) {
            EARLY_BASE_STONE_TAG = List.of();
        }
        return EARLY_BASE_STONE_TAG.contains(block);
    }

    private static Map<class_2960, List<class_3503.class_5145>> loadBaseStoneTag(class_3300 manager) {
        HashMap map = Maps.newHashMap();
        for (Map.Entry<class_2960, List<class_3298>> entry : manager.method_41265("tags/block/base_stone.json", resourceLocation -> resourceLocation.method_12836().equals("enchiridion")).entrySet()) {
            TagUtil.loadIndividualTag(manager, entry, map);
        }
        return map;
    }

    private static void loadIndividualTag(class_3300 manager, Map.Entry<class_2960, List<class_3298>> entry, Map<class_2960, List<class_3503.class_5145>> map) {
        class_2960 fileKey = entry.getKey();
        class_2960 fileToId = CONVERTER.method_45115(fileKey);
        for (class_3298 resource : entry.getValue()) {
            try {
                BufferedReader reader = resource.method_43039();
                try {
                    JsonElement jsonElement = JsonParser.parseReader((Reader)reader);
                    List list = map.getOrDefault(fileToId, new ArrayList());
                    class_7475 tagFile = (class_7475)class_7475.field_39269.parse(new Dynamic((DynamicOps)JsonOps.INSTANCE, (Object)jsonElement)).getOrThrow();
                    if (tagFile.comp_812()) {
                        list.clear();
                    }
                    tagFile.comp_811().forEach(tagEntry -> tagEntry.method_32832(resourceLocation -> {
                        list.add(new class_3503.class_5145(tagEntry, resource.method_14480()));
                        return false;
                    }, resourceLocation -> {
                        for (Map.Entry<class_2960, List<class_3298>> entry : manager.method_41265(CONVERTER.method_45112(resourceLocation).method_12832(), resourceLocation1 -> resourceLocation1.method_12836().equals(resourceLocation.method_12836())).entrySet()) {
                            TagUtil.loadIndividualTag(manager, entry, map);
                        }
                        list.add(new class_3503.class_5145(tagEntry, resource.method_14480()));
                        return false;
                    }));
                    map.putIfAbsent(fileToId, list);
                }
                finally {
                    if (reader == null) continue;
                    ((Reader)reader).close();
                }
            }
            catch (Exception exception) {
                Enchiridion.LOG.error("Couldn't read tag list {} from {} in data pack {}. Referenced in checking 'enchiridion:base_stone' block tag for loot purposes.", new Object[]{fileToId, fileKey, resource.method_14480(), exception});
            }
        }
    }

    public static void resetEarlyBaseStoneTag() {
        EARLY_BASE_STONE_TAG = null;
    }

    static {
        CONVERTER = class_7654.method_45114((String)"tags/block");
    }
}

