/*
 * Decompiled with CFR 0.152.
 */
package house.greenhouse.enchiridion.util;

import com.mojang.datafixers.util.Pair;
import house.greenhouse.enchiridion.Enchiridion;
import house.greenhouse.enchiridion.api.EnchantmentCategory;
import house.greenhouse.enchiridion.api.registry.EnchiridionRegistries;
import house.greenhouse.enchiridion.enchantment.category.ItemEnchantmentCategories;
import house.greenhouse.enchiridion.mixin.Invoker_EnchantmentHelper;
import house.greenhouse.enchiridion.registry.EnchiridionDataComponents;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.class_1799;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_5321;
import net.minecraft.class_5819;
import net.minecraft.class_6880;
import net.minecraft.class_6885;
import net.minecraft.class_7225;
import net.minecraft.class_7876;
import net.minecraft.class_7924;
import net.minecraft.class_9304;
import net.minecraft.class_9331;
import net.minecraft.class_9334;
import net.minecraft.class_9636;
import org.jetbrains.annotations.Nullable;

public class EnchiridionUtil {
    public static void enchantFromCategory(class_5819 random, class_1799 stack, int level, Stream<class_6880<class_1887>> enchantments, class_6880<EnchantmentCategory> category) {
        EnchiridionUtil.enchantFromCategories(random, stack, level, enchantments, List.of(category));
    }

    public static void enchantFromCategories(class_5819 random, class_1799 stack, int level, Stream<class_6880<class_1887>> enchantments, List<class_6880<EnchantmentCategory>> categories) {
        class_1890.method_8233((class_5819)random, (class_1799)stack, (int)level, enchantments.filter(enchantmentHolder -> categories.stream().anyMatch(holder -> holder.method_40227() && ((EnchantmentCategory)holder.comp_349()).acceptedEnchantments().method_40241(enchantmentHolder))));
    }

    public static void categoriseEnchantmentsOnItem(class_1799 stack) {
        class_9331<class_9304> enchantmentComponent = Invoker_EnchantmentHelper.enchiridion$invokeGetComponentType(stack);
        EnchiridionUtil.categoriseEnchantmentsOnItem((class_9304)stack.method_57824(enchantmentComponent), stack, enchantmentComponent);
    }

    private static void categoriseEnchantmentsOnItem(class_9304 enchantments, class_1799 stack, class_9331<class_9304> componentType) {
        if (enchantments.method_57543()) {
            return;
        }
        if (componentType == class_9334.field_49643) {
            EnchiridionUtil.categoriseStoredEnchantmentsOnItem(enchantments, stack);
            return;
        }
        ItemEnchantmentCategories categories = (ItemEnchantmentCategories)stack.method_57825(EnchiridionDataComponents.ENCHANTMENT_CATEGORIES, (Object)new ItemEnchantmentCategories());
        enchantments.method_57534().forEach(enchantment -> {
            class_6880<EnchantmentCategory> category = EnchiridionUtil.getFirstEnchantmentCategory((class_7225.class_7874)Enchiridion.getHelper().getReqistryAccess(), (class_6880<class_1887>)enchantment);
            if (category.method_40227() && !EnchiridionUtil.isValidInCategory(category, categories.get(category), (class_6880<class_1887>)enchantment)) {
                categories.remove(category, (class_6880<class_1887>)enchantment);
                return;
            }
            if (!category.method_40227() || categories.getCategories().containsKey(enchantment) && ((ObjectArrayList)categories.getCategories().get(category)).contains(enchantment) || !EnchiridionUtil.categoryAcceptsNewEnchantments(category, categories)) {
                return;
            }
            categories.add(category, (class_6880<class_1887>)enchantment);
        });
        if (enchantments.method_57534().stream().anyMatch(enchantment -> !categories.contains((class_6880<class_1887>)enchantment))) {
            class_9304.class_9305 mutable = new class_9304.class_9305(enchantments);
            mutable.method_57548(enchantment -> !categories.contains((class_6880<class_1887>)enchantment));
            stack.method_57379(componentType, (Object)mutable.method_57549());
        }
        if (!categories.equals(stack.method_57825(EnchiridionDataComponents.ENCHANTMENT_CATEGORIES, (Object)ItemEnchantmentCategories.EMPTY))) {
            if (categories.isEmpty()) {
                stack.method_57381(EnchiridionDataComponents.ENCHANTMENT_CATEGORIES);
            } else {
                stack.method_57379(EnchiridionDataComponents.ENCHANTMENT_CATEGORIES, (Object)categories);
            }
        }
    }

    private static void categoriseStoredEnchantmentsOnItem(class_9304 enchantments, class_1799 stack) {
        ItemEnchantmentCategories categories = (ItemEnchantmentCategories)stack.method_57825(EnchiridionDataComponents.ENCHANTMENT_CATEGORIES, (Object)new ItemEnchantmentCategories());
        HashMap usedEnchantmentTags = new HashMap();
        enchantments.method_57534().forEach(enchantment -> {
            block2: {
                List<class_6880<EnchantmentCategory>> applicableCategories = EnchiridionUtil.getAllEnchantmentCategories((class_7225.class_7874)Enchiridion.getHelper().getReqistryAccess(), (class_6880<class_1887>)enchantment);
                Iterator<class_6880<EnchantmentCategory>> iterator = applicableCategories.iterator();
                if (!iterator.hasNext()) break block2;
                class_6880<EnchantmentCategory> category = iterator.next();
                class_6885 tag = ((class_1887)enchantment.comp_349()).comp_2687().comp_2507().orElse(((class_1887)enchantment.comp_349()).comp_2687().comp_2506());
                if (category.method_40227() && usedEnchantmentTags.containsKey(category) && ((Set)usedEnchantmentTags.get(category)).stream().anyMatch(holders -> holders.method_40239().anyMatch(arg_0 -> ((class_6885)tag).method_40241(arg_0)))) {
                    categories.remove(category, (class_6880<class_1887>)enchantment);
                    return;
                }
                if (!category.method_40227() || categories.getCategories().containsKey(enchantment) && ((ObjectArrayList)categories.getCategories().get(category)).contains(enchantment) || usedEnchantmentTags.containsKey(category) && ((Set)usedEnchantmentTags.get(category)).stream().anyMatch(holders -> holders.method_40239().anyMatch(arg_0 -> ((class_6885)tag).method_40241(arg_0)))) {
                    return;
                }
                categories.add(category, (class_6880<class_1887>)enchantment);
                usedEnchantmentTags.computeIfAbsent(category, c -> new HashSet()).add(tag);
            }
        });
        if (enchantments.method_57534().stream().anyMatch(enchantment -> !categories.contains((class_6880<class_1887>)enchantment))) {
            class_9304.class_9305 mutable = new class_9304.class_9305(enchantments);
            mutable.method_57548(enchantment -> !EnchiridionUtil.getAllEnchantmentCategories((class_7225.class_7874)Enchiridion.getHelper().getReqistryAccess(), (class_6880<class_1887>)enchantment).isEmpty() && !categories.contains((class_6880<class_1887>)enchantment));
            stack.method_57379(class_9334.field_49643, (Object)mutable.method_57549());
        }
        if (!categories.equals(stack.method_57825(EnchiridionDataComponents.ENCHANTMENT_CATEGORIES, (Object)ItemEnchantmentCategories.EMPTY))) {
            if (categories.isEmpty()) {
                stack.method_57381(EnchiridionDataComponents.ENCHANTMENT_CATEGORIES);
            } else {
                stack.method_57379(EnchiridionDataComponents.ENCHANTMENT_CATEGORIES, (Object)categories);
            }
        }
    }

    @Nullable
    public static Pair<class_6880<class_1887>, Integer> getFirstEnchantmentAndLevel(class_7225.class_7874 registries, class_9304 enchantments) {
        Optional tooltipOrderTag = registries.method_46762(class_7924.field_41265).method_46733(class_9636.field_51362);
        if (tooltipOrderTag.isEmpty()) {
            return null;
        }
        Optional<Pair> enchantment = ((class_6885.class_6888)tooltipOrderTag.get()).method_40239().filter(holder -> enchantments.method_57534().contains(holder)).map(holder -> Pair.of((Object)holder, (Object)enchantments.method_57536(holder))).findFirst();
        if (enchantment.isEmpty()) {
            enchantment = enchantments.method_57534().stream().findFirst().map(holder -> Pair.of((Object)holder, (Object)enchantments.method_57536(holder)));
        }
        return enchantment.orElse(null);
    }

    public static class_6880<EnchantmentCategory> lookupFirstEnchantmentCategory(class_7225.class_7874 registries, class_6880<class_1887> enchantment, ItemEnchantmentCategories categories) {
        List<class_6880.class_6883> applicable = registries.method_46762(EnchiridionRegistries.ENCHANTMENT_CATEGORY).method_42017().filter(category -> categories.isValid((class_6880<EnchantmentCategory>)category, enchantment)).toList();
        return applicable.stream().max(Comparator.comparingInt(value -> ((EnchantmentCategory)value.comp_349()).priority())).orElse(null);
    }

    @Nullable
    public static class_6880<EnchantmentCategory> getFirstEnchantmentCategory(class_7225.class_7874 registries, class_9304 enchantments, ItemEnchantmentCategories categories) {
        if (enchantments.method_57543()) {
            return null;
        }
        List tooltipOrderTag = registries.method_46762(class_7924.field_41265).method_46733(class_9636.field_51362).orElse(class_6885.method_45924((class_7876)registries.method_46762(class_7924.field_41265), null)).method_40239().toList();
        ArrayList<class_6880> enchantment = new ArrayList<class_6880>(enchantments.method_57534().stream().toList());
        enchantment.sort(Comparator.comparingInt(v -> {
            if (tooltipOrderTag.contains(v)) {
                return tooltipOrderTag.indexOf(v);
            }
            return Integer.MAX_VALUE;
        }));
        if (enchantment.isEmpty()) {
            return enchantments.method_57534().stream().map(categories::findFirstCategory).filter(holder -> holder != null && holder.method_40227()).max(Comparator.comparingInt(value -> ((EnchantmentCategory)value.comp_349()).priority())).orElse(null);
        }
        return enchantment.stream().map(categories::findFirstCategory).filter(holder -> holder != null && holder.method_40227()).max(Comparator.comparingInt(value -> ((EnchantmentCategory)value.comp_349()).priority())).orElse(null);
    }

    public static class_6880<EnchantmentCategory> getFirstEnchantmentCategory(class_7225.class_7874 registries, class_6880<class_1887> enchantment) {
        return registries.method_46762(EnchiridionRegistries.ENCHANTMENT_CATEGORY).method_42017().filter(category -> category.method_40227() && ((EnchantmentCategory)category.comp_349()).acceptedEnchantments().method_40241(enchantment)).max(Comparator.comparingInt(value -> ((EnchantmentCategory)value.comp_349()).priority())).orElse(null);
    }

    public static List<class_6880<EnchantmentCategory>> getAllEnchantmentCategories(class_7225.class_7874 registries, class_6880<class_1887> enchantment) {
        List<Object> categories = registries.method_46762(EnchiridionRegistries.ENCHANTMENT_CATEGORY).method_42017().filter(category -> category.method_40227() && ((EnchantmentCategory)category.comp_349()).acceptedEnchantments().method_40241(enchantment)).collect(Collectors.toList());
        if (categories.isEmpty()) {
            categories = List.of();
        }
        return categories;
    }

    public static boolean isValidInCategory(class_7225.class_7874 registries, ItemEnchantmentCategories categories, class_6880<class_1887> enchantment) {
        Optional<class_6880.class_6883> category = registries.method_46762(EnchiridionRegistries.ENCHANTMENT_CATEGORY).method_42017().filter(c -> c.method_40227() && ((EnchantmentCategory)c.comp_349()).acceptedEnchantments().method_40241(enchantment)).max(Comparator.comparingInt(o -> ((EnchantmentCategory)o.comp_349()).priority()));
        return category.map(enchantmentCategory -> EnchiridionUtil.isValidInCategory((class_6880<EnchantmentCategory>)enchantmentCategory, categories.get((class_6880<EnchantmentCategory>)enchantmentCategory), enchantment)).orElse(true);
    }

    public static boolean isValidInCategory(class_6880<EnchantmentCategory> category, List<class_6880<class_1887>> enchantments, class_6880<class_1887> enchantment) {
        if (!(enchantments = new ArrayList<class_6880<class_1887>>(enchantments)).contains(enchantment)) {
            enchantments.add(enchantment);
        }
        return category.method_40227() && (((EnchantmentCategory)category.comp_349()).limit().isEmpty() || enchantments.subList(0, enchantments.indexOf(enchantment)).size() < ((EnchantmentCategory)category.comp_349()).limit().get());
    }

    public static boolean categoryAcceptsNewEnchantments(class_6880<EnchantmentCategory> category, ItemEnchantmentCategories categories) {
        if (!category.method_40227() || ((EnchantmentCategory)category.comp_349()).limit().isEmpty() || !categories.getCategories().containsKey(category)) {
            return true;
        }
        return EnchiridionUtil.categoryAcceptsNewEnchantmentsInternal(category, List.copyOf((Collection)categories.getCategories().get(category)));
    }

    public static boolean categoryAcceptsNewEnchantmentsWithValue(class_6880<EnchantmentCategory> category, ItemEnchantmentCategories categories, class_6880<class_1887> enchantment) {
        if (!category.method_40227() || ((EnchantmentCategory)category.comp_349()).limit().isEmpty() || !categories.getCategories().containsKey(category)) {
            return true;
        }
        ArrayList<class_6880<class_1887>> enchantments = new ArrayList<class_6880<class_1887>>((Collection)categories.getCategories().get(category));
        if (!enchantments.contains(enchantment)) {
            enchantments.add(enchantment);
        }
        return EnchiridionUtil.categoryAcceptsNewEnchantmentsInternal(category, enchantments);
    }

    private static boolean categoryAcceptsNewEnchantmentsInternal(class_6880<EnchantmentCategory> category, List<class_6880<class_1887>> holders) {
        return category.method_40227() && (((EnchantmentCategory)category.comp_349()).limit().isEmpty() || holders.size() <= ((EnchantmentCategory)category.comp_349()).limit().get());
    }

    public static int compareEnchantments(class_6880<class_1887> enchantment, class_6880<class_1887> enchantment2, ItemEnchantmentCategories categories) {
        int o2CategoryPriority;
        if (!enchantment.method_40227() && !enchantment2.method_40227()) {
            return 0;
        }
        if (!enchantment.method_40227() && enchantment2.method_40227()) {
            return -1;
        }
        if (enchantment.method_40227() && !enchantment2.method_40227()) {
            return 1;
        }
        int o1CategoryPriority = Optional.ofNullable(categories.findFirstCategory(enchantment)).map(category -> {
            if (!category.method_40227()) {
                return Integer.MIN_VALUE;
            }
            return ((EnchantmentCategory)category.comp_349()).priority();
        }).orElse(0);
        if (o1CategoryPriority == (o2CategoryPriority = Optional.ofNullable(categories.findFirstCategory(enchantment2)).map(category -> {
            if (!category.method_40227()) {
                return Integer.MIN_VALUE;
            }
            return ((EnchantmentCategory)category.comp_349()).priority();
        }).orElse(0).intValue())) {
            return EnchiridionUtil.compareEnchantmentNames(enchantment, enchantment2);
        }
        return Integer.compare(o2CategoryPriority, o1CategoryPriority);
    }

    public static int compareEnchantmentNames(class_6880<class_1887> enchantment, class_6880<class_1887> enchantment2) {
        if (enchantment.method_40230().isPresent() && ((class_5321)enchantment.method_40230().get()).method_29177().method_12836().equals("minecraft") && enchantment2.method_40230().isPresent() && !((class_5321)enchantment2.method_40230().get()).method_29177().method_12836().equals("minecraft")) {
            return -1;
        }
        if (enchantment.method_40230().isPresent() && !((class_5321)enchantment.method_40230().get()).method_29177().method_12836().equals("minecraft") && enchantment2.method_40230().isPresent() && ((class_5321)enchantment2.method_40230().get()).method_29177().method_12836().equals("minecraft")) {
            return 1;
        }
        if (enchantment.method_40230().isPresent() && enchantment2.method_40230().isPresent()) {
            return ((class_5321)enchantment.method_40230().get()).method_29177().method_12833(((class_5321)enchantment2.method_40230().get()).method_29177());
        }
        return Integer.compare(enchantment.hashCode(), enchantment2.hashCode());
    }
}

