/*
 * Decompiled with CFR 0.152.
 */
package house.greenhouse.enchiridion.util;

import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.Set;
import java.util.function.Function;
import net.minecraft.class_169;
import net.minecraft.class_3532;
import net.minecraft.class_44;
import net.minecraft.class_47;
import net.minecraft.class_5658;
import net.minecraft.class_5659;
import org.jetbrains.annotations.Nullable;

public class FloatRange {
    private static final Codec<FloatRange> RECORD_CODEC = RecordCodecBuilder.create(inst -> inst.group((App)class_5659.field_45888.optionalFieldOf("min").forGetter(range -> Optional.ofNullable(range.min)), (App)class_5659.field_45888.optionalFieldOf("max").forGetter(range -> Optional.ofNullable(range.max))).apply((Applicative)inst, FloatRange::new));
    public static final Codec<FloatRange> CODEC = Codec.either((Codec)Codec.DOUBLE, RECORD_CODEC).xmap(either -> (FloatRange)either.map(aDouble -> FloatRange.exact(aDouble.floatValue()), Function.identity()), range -> {
        OptionalDouble optionalDouble = range.unpackExact();
        return optionalDouble.isPresent() ? Either.left((Object)optionalDouble.getAsDouble()) : Either.right((Object)range);
    });
    @Nullable
    private final class_5658 min;
    @Nullable
    private final class_5658 max;
    private final DoubleLimiter limiter;
    private final DoubleChecker predicate;

    public Set<class_169<?>> getReferencedContextParams() {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        if (this.min != null) {
            builder.addAll((Iterable)this.min.method_293());
        }
        if (this.max != null) {
            builder.addAll((Iterable)this.max.method_293());
        }
        return builder.build();
    }

    private FloatRange(Optional<class_5658> min, Optional<class_5658> max) {
        this((class_5658)min.orElse(null), (class_5658)max.orElse(null));
    }

    private FloatRange(@Nullable class_5658 min, @Nullable class_5658 max) {
        this.min = min;
        this.max = max;
        if (min == null) {
            if (max == null) {
                this.limiter = (context, value) -> value;
                this.predicate = (context, value) -> true;
            } else {
                this.limiter = (context, value) -> Math.min(max.method_32454(context), value);
                this.predicate = (context, value) -> value <= max.method_32454(context);
            }
        } else if (max == null) {
            this.limiter = (context, value) -> Math.max(min.method_32454(context), value);
            this.predicate = (context, value) -> value >= min.method_32454(context);
        } else {
            this.limiter = (context, value) -> class_3532.method_15363((float)value, (float)min.method_32454(context), (float)max.method_32454(context));
            this.predicate = (context, value) -> value >= min.method_32454(context) && value <= max.method_32454(context);
        }
    }

    public static FloatRange exact(float exactValue) {
        class_44 constantvalue = class_44.method_32448((float)exactValue);
        return new FloatRange(Optional.of(constantvalue), Optional.of(constantvalue));
    }

    public static FloatRange range(float min, float max) {
        return new FloatRange(Optional.of(class_44.method_32448((float)min)), Optional.of(class_44.method_32448((float)max)));
    }

    public static FloatRange lowerBound(float min) {
        return new FloatRange(Optional.of(class_44.method_32448((float)min)), Optional.empty());
    }

    public static FloatRange upperBound(float max) {
        return new FloatRange(Optional.empty(), Optional.of(class_44.method_32448((float)max)));
    }

    public float clamp(class_47 context, float value) {
        return this.limiter.apply(context, value);
    }

    public boolean test(class_47 context, float value) {
        return this.predicate.test(context, value);
    }

    public double difference(class_47 context, float value) {
        if (this.max != null) {
            if (this.min != null) {
                return Math.min(Math.abs(this.min.method_32454(context) - value), Math.abs(this.max.method_32454(context) - value));
            }
            return Math.abs(this.max.method_32454(context) - value);
        }
        return Math.abs(this.min.method_32454(context) - value);
    }

    private OptionalDouble unpackExact() {
        OptionalDouble optionalDouble;
        class_5658 class_56582;
        if (Objects.equals(this.min, this.max) && (class_56582 = this.min) instanceof class_44) {
            class_44 constantvalue = (class_44)class_56582;
            optionalDouble = OptionalDouble.of((int)constantvalue.comp_1895());
        } else {
            optionalDouble = OptionalDouble.empty();
        }
        return optionalDouble;
    }

    @FunctionalInterface
    static interface DoubleLimiter {
        public float apply(class_47 var1, float var2);
    }

    @FunctionalInterface
    static interface DoubleChecker {
        public boolean test(class_47 var1, float var2);
    }
}

