/*
 * Decompiled with CFR 0.152.
 */
package house.greenhouse.enchiridion.util;

import com.mojang.datafixers.util.Pair;
import house.greenhouse.enchiridion.api.enchantment.category.EnchantmentCategory;
import house.greenhouse.enchiridion.api.enchantment.category.ItemEnchantmentCategories;
import house.greenhouse.enchiridion.registry.EnchiridionDataComponents;
import house.greenhouse.enchiridion.registry.EnchiridionItems;
import house.greenhouse.enchiridion.util.EnchantmentCategoryUtil;
import house.greenhouse.enchiridion.util.EnchantmentComparisonUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.IntStream;
import net.minecraft.class_1761;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_6880;
import net.minecraft.class_7225;
import net.minecraft.class_9304;

public class CreativeTabUtil {
    public static void addSiphoningTableToCreativeMenu(InsertionConsumer consumer) {
        consumer.insert(class_1802.field_8657.method_7854(), EnchiridionItems.SIPHONING_TABLE.method_7854(), class_1761.class_7705.field_40191);
    }

    public static void sortEnchantmentsBasedOnCategory(List<class_1799> stacks, Consumer<List<class_1799>> addConsumer, class_7225.class_7874 provider) {
        if (stacks.stream().allMatch(stack -> class_1890.method_57532((class_1799)stack).method_57543())) {
            return;
        }
        ArrayList<Pair> indexList = new ArrayList<Pair>(IntStream.range(0, stacks.size()).mapToObj(i -> Pair.of((Object)i, (Object)((class_1799)stacks.get(i)))).toList());
        List<class_1792> itemList = indexList.stream().map(pair -> ((class_1799)pair.getSecond()).method_7909()).toList();
        ArrayList<class_1799> stackList = new ArrayList<class_1799>(indexList.stream().map(Pair::getSecond).toList());
        stackList.sort((stack, otherStack) -> {
            class_9304 enchantments = class_1890.method_57532((class_1799)stack);
            class_9304 otherEnchantments = class_1890.method_57532((class_1799)otherStack);
            ItemEnchantmentCategories categories = (ItemEnchantmentCategories)stack.method_57825(EnchiridionDataComponents.ENCHANTMENT_CATEGORIES, (Object)ItemEnchantmentCategories.EMPTY);
            ItemEnchantmentCategories otherCategories = (ItemEnchantmentCategories)otherStack.method_57825(EnchiridionDataComponents.ENCHANTMENT_CATEGORIES, (Object)ItemEnchantmentCategories.EMPTY);
            if (stack.method_7909() != otherStack.method_7909() || enchantments.method_57543() || otherEnchantments.method_57543()) {
                return Integer.compare(itemList.indexOf(stack.method_7909()), itemList.indexOf(otherStack.method_7909()));
            }
            Pair<class_6880<class_1887>, Integer> enchantment = EnchantmentCategoryUtil.getFirstEnchantmentAndLevel(provider, enchantments, categories);
            Pair<class_6880<class_1887>, Integer> otherEnchantment = EnchantmentCategoryUtil.getFirstEnchantmentAndLevel(provider, otherEnchantments, otherCategories);
            int categoryPriority = Optional.ofNullable(EnchantmentCategoryUtil.getFirstEnchantmentCategory(provider, enchantments, categories)).map(category -> {
                if (!category.method_40227()) {
                    return Integer.MIN_VALUE;
                }
                return ((EnchantmentCategory)category.comp_349()).priority();
            }).orElse(0);
            int otherCategoryPriority = Optional.ofNullable(EnchantmentCategoryUtil.getFirstEnchantmentCategory(provider, otherEnchantments, otherCategories)).map(category -> {
                if (!category.method_40227()) {
                    return Integer.MIN_VALUE;
                }
                return ((EnchantmentCategory)category.comp_349()).priority();
            }).orElse(0);
            if (enchantment != null && otherEnchantment != null && ((class_6880)enchantment.getFirst()).equals(otherEnchantment.getFirst())) {
                return Integer.compare((Integer)enchantment.getSecond(), (Integer)otherEnchantment.getSecond());
            }
            if (categoryPriority == otherCategoryPriority && enchantment != null && otherEnchantment != null) {
                return EnchantmentComparisonUtil.compareEnchantmentNames((class_6880<class_1887>)((class_6880)enchantment.getFirst()), (class_6880<class_1887>)((class_6880)otherEnchantment.getFirst()));
            }
            return Integer.compare(otherCategoryPriority, categoryPriority);
        });
        addConsumer.accept(stackList);
    }

    public static interface InsertionConsumer {
        public void insert(class_1799 var1, class_1799 var2, class_1761.class_7705 var3);
    }
}

