/*
 * Decompiled with CFR 0.152.
 */
package house.greenhouse.enchiridion;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import house.greenhouse.enchiridion.Enchiridion;
import house.greenhouse.enchiridion.api.enchantment.category.CategoryVisuals;
import house.greenhouse.enchiridion.api.enchantment.category.EnchantmentCategory;
import house.greenhouse.greenhouseconfig.api.util.DefaultFieldUtil;
import house.greenhouse.greenhouseconfig.api.util.LateHolder;
import house.greenhouse.greenhouseconfig.impl.codec.OrderCorrectedRecordCodec;
import it.unimi.dsi.fastutil.objects.Object2ObjectMaps;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public record EnchiridionConfig(Common common, EnchantingTable enchantingTable, VillagerTrades villagerTrades, @Nullable Client client) {
    public static final EnchiridionConfig SERVER_DEFAULT = new EnchiridionConfig(Common.DEFAULT, EnchantingTable.DEFAULT, VillagerTrades.DEFAULT);
    public static final Codec<EnchiridionConfig> SERVER_CODEC = OrderCorrectedRecordCodec.wrap((Codec)RecordCodecBuilder.create(inst -> inst.group((App)Common.CODEC.forGetter(EnchiridionConfig::common), (App)DefaultFieldUtil.codecWithComments(EnchantingTable.CODEC, (String)"enchanting_table", (Object)EnchantingTable.DEFAULT, (String[])new String[]{"Config values relating to the Enchanting Table."}).forGetter(EnchiridionConfig::enchantingTable), (App)DefaultFieldUtil.codecWithComments(VillagerTrades.CODEC, (String)"villager_trades", (Object)VillagerTrades.DEFAULT, (String[])new String[]{"Config values relating to Villagers' trades."}).forGetter(EnchiridionConfig::villagerTrades)).apply((Applicative)inst, EnchiridionConfig::new)));
    public static final EnchiridionConfig CLIENT_DEFAULT = new EnchiridionConfig(Common.DEFAULT, EnchantingTable.DEFAULT, VillagerTrades.DEFAULT, Client.DEFAULT);
    public static final Codec<EnchiridionConfig> CLIENT_CODEC = OrderCorrectedRecordCodec.wrap((Codec)RecordCodecBuilder.create(inst -> inst.group((App)Common.CODEC.forGetter(EnchiridionConfig::common), (App)DefaultFieldUtil.codecWithComments(EnchantingTable.CODEC, (String)"enchanting_table", (Object)EnchantingTable.DEFAULT, (String[])new String[]{"Config values relating to the Enchanting Table."}).forGetter(EnchiridionConfig::enchantingTable), (App)DefaultFieldUtil.codecWithComments(VillagerTrades.CODEC, (String)"villager_trades", (Object)VillagerTrades.DEFAULT, (String[])new String[]{"Config values relating to Villagers' trades."}).forGetter(EnchiridionConfig::villagerTrades), (App)Client.CODEC.forGetter(EnchiridionConfig::client)).apply((Applicative)inst, EnchiridionConfig::new)));

    public EnchiridionConfig(Common common, EnchantingTable enchantingTable, VillagerTrades villagerTrades) {
        this(common, enchantingTable, villagerTrades, null);
    }

    public static class_9139<class_2540, EnchiridionConfig> streamCodec(Client client) {
        return class_9139.method_56436(Common.STREAM_CODEC, EnchiridionConfig::common, EnchantingTable.STREAM_CODEC, EnchiridionConfig::enchantingTable, VillagerTrades.STREAM_CODEC, EnchiridionConfig::villagerTrades, (common, enchantingTable, villagerTrades) -> new EnchiridionConfig((Common)common, (EnchantingTable)enchantingTable, (VillagerTrades)villagerTrades, client));
    }

    public record Common(boolean enableCategories) {
        private static final Common DEFAULT = new Common(true);
        public static final MapCodec<Common> CODEC = OrderCorrectedRecordCodec.wrap((MapCodec)RecordCodecBuilder.mapCodec(inst -> inst.group((App)DefaultFieldUtil.codecWithComments((Codec)Codec.BOOL, (String)"enable_categories", (Object)DEFAULT.enableCategories(), (String[])new String[]{"Whether Enchiridion's categorical enchantment system is enabled.", "", "Categories modify the applicability of enchantments, making them mutually exclusive with ones of the same category."}).forGetter(Common::enableCategories)).apply((Applicative)inst, Common::new)));
        public static final class_9139<class_2540, Common> STREAM_CODEC = class_9139.method_56434((class_9139)class_9135.field_48547, Common::enableCategories, Common::new);
    }

    public record EnchantingTable(boolean modifyEnchantingTableLogic, CostLogic costLogic, boolean allowEnchantingTableLevelUps) {
        private static final EnchantingTable DEFAULT = new EnchantingTable(true, CostLogic.DEFAULT, true);
        public static final Codec<EnchantingTable> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)DefaultFieldUtil.codecWithComments((Codec)Codec.BOOL, (String)"modify_enchanting_table_logic", (Object)DEFAULT.modifyEnchantingTableLogic(), (String[])new String[]{"Whether Enchiridion should modify enchanting table logic.", "", "If enabled, the enchanting table will always provide you with a specific amount of enchantments when", "rolling on the enchanting table depending on the enchant level, with a chance to get an extra enchantment.", "", "If categories are enabled, the same category will never roll twice."}).forGetter(EnchantingTable::modifyEnchantingTableLogic), (App)DefaultFieldUtil.codecWithComments(CostLogic.CODEC, (String)"cost_logic", (Object)DEFAULT.costLogic(), (String[])new String[]{"Fields regarding the Enchanting Table's costs and what is gained from those costs."}).forGetter(EnchantingTable::costLogic), (App)DefaultFieldUtil.codecWithComments((Codec)Codec.BOOL, (String)"allow_enchanting_table_level_ups", (Object)DEFAULT.allowEnchantingTableLevelUps(), (String[])new String[]{"Whether Enchiridion should modify the enchanting table to allow levelling up enchanted items."}).forGetter(EnchantingTable::allowEnchantingTableLevelUps)).apply((Applicative)inst, EnchantingTable::new));
        public static final class_9139<class_2540, EnchantingTable> STREAM_CODEC = class_9139.method_56436((class_9139)class_9135.field_48547, EnchantingTable::modifyEnchantingTableLogic, CostLogic.STREAM_CODEC, EnchantingTable::costLogic, (class_9139)class_9135.field_48547, EnchantingTable::allowEnchantingTableLevelUps, EnchantingTable::new);

        public record CostLogic(float costMultiplier, float effectivenessMultiplier, int mediumLevelMin, int highLevelMin) {
            public static final CostLogic DEFAULT = new CostLogic(0.67f, 0.75f, 7, 15);
            public static final Codec<CostLogic> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)DefaultFieldUtil.codecWithComments((Codec)Codec.FLOAT, (String)"cost_multiplier", (Object)Float.valueOf(DEFAULT.costMultiplier()), (String[])new String[]{"A multiplier for determining the cost of a singular enchant."}).forGetter(CostLogic::costMultiplier), (App)DefaultFieldUtil.codecWithComments((Codec)Codec.FLOAT, (String)"effectiveness_multiplier", (Object)Float.valueOf(DEFAULT.effectivenessMultiplier()), (String[])new String[]{"A multiplier for determining which level to enchant at, relative to the unmodified enchantment cost."}).forGetter(CostLogic::effectivenessMultiplier), (App)DefaultFieldUtil.codecWithComments((Codec)Codec.INT, (String)"medium_level_minimum", (Object)DEFAULT.mediumLevelMin(), (String[])new String[]{"The minimum level for an Enchanting Table enchant to be considered a medium level enchant.", "Medium level enchants by default will roll for two enchantments.", "", "If modify_enchanting_table_logic is disabled, this will not come into effect."}).forGetter(CostLogic::mediumLevelMin), (App)DefaultFieldUtil.codecWithComments((Codec)Codec.INT, (String)"high_level_minimum", (Object)DEFAULT.highLevelMin(), (String[])new String[]{"The minimum level for an Enchanting Table enchant to be considered a high level enchant.", "High level enchants by default will roll for three enchantments.", "", "If modify_enchanting_table_logic is disabled, this will not come into effect."}).forGetter(CostLogic::highLevelMin)).apply((Applicative)inst, CostLogic::new));
            public static final class_9139<class_2540, CostLogic> STREAM_CODEC = class_9139.method_56905((class_9139)class_9135.field_48552, CostLogic::costMultiplier, (class_9139)class_9135.field_48552, CostLogic::effectivenessMultiplier, (class_9139)class_9135.field_49675, CostLogic::mediumLevelMin, (class_9139)class_9135.field_49675, CostLogic::highLevelMin, CostLogic::new);
        }
    }

    public record VillagerTrades(ModifiedTrades modifyTrades, boolean simplifyExperimentalArmorerTrades) {
        private static final VillagerTrades DEFAULT = new VillagerTrades(ModifiedTrades.DEFAULT, true);
        public static final Codec<VillagerTrades> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)DefaultFieldUtil.codecWithComments(ModifiedTrades.CODEC, (String)"enable_modified_trades", (Object)ModifiedTrades.DEFAULT, (String[])new String[]{"Whether Enchiridion should modify specific villager profession trades.", "NOTICE: Existing villager trades will not be updated to match these config settings."}).forGetter(VillagerTrades::modifyTrades), (App)DefaultFieldUtil.codecWithComments((Codec)Codec.BOOL, (String)"simplify_experimental_armorer_trades", (Object)DEFAULT.simplifyExperimentalArmorerTrades(), (String[])new String[]{"Whether Enchiridion should simplify the Experimental Datapack's Armorer trades.", "NOTICE: Existing villager trades will not be updated to match this config setting.", "", "When enabled whilst using the Experimental Feature Toggle...", "Expert Armorer Villagers will always trade two pieces of either Iron or Chainmail Armor", "depending on their biome variant.", "Master Armorer villagers will always trade two specific pieces of Diamond armor", "using Enchiridion's enchantment pool for their biome variant.", "", "This will automatically be disabled if Enchiridion Armorer trades are disabled."}).forGetter(VillagerTrades::simplifyExperimentalArmorerTrades)).apply((Applicative)inst, VillagerTrades::new));
        public static final class_9139<class_2540, VillagerTrades> STREAM_CODEC = class_9139.method_56435(ModifiedTrades.STREAM_CODEC, VillagerTrades::modifyTrades, (class_9139)class_9135.field_48547, VillagerTrades::simplifyExperimentalArmorerTrades, VillagerTrades::new);

        public record ModifiedTrades(boolean librarian, boolean armorer, boolean toolsmith, boolean weaponsmith) {
            private static final ModifiedTrades DEFAULT = new ModifiedTrades(true, true, true, true);
            public static final Codec<ModifiedTrades> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)DefaultFieldUtil.codecWithComments((Codec)Codec.BOOL, (String)"librarian", (Object)DEFAULT.librarian(), (String[])new String[]{"Whether Librarian trades should be modified by Enchiridion.", "", "When modified by Enchiridion, Librarian book trades before Master profession level are", "biome variant dependent Primaries, Secondaries and Tertiaries.", "", "At Master level, Librarians will trade either Unbreaking or Mending depending", "on their biome variant.", "", "Book prices are far less swingy, gossip affects book prices less.", "Additionally, Librarians will generally trade lower levelled enchantments.", "At least one Book trade is guaranteed to exist at each new profession level."}).forGetter(ModifiedTrades::librarian), (App)DefaultFieldUtil.codecWithComments((Codec)Codec.BOOL, (String)"armorer", (Object)DEFAULT.armorer(), (String[])new String[]{"Whether Armorer trades should be modified by Enchiridion.", "", "When modified by Enchiridion, Armorer armor trades will use specific", "enchantments from the Librarian pool, with expert trades enchanting with", "this pool at a very low level, and master trades enchanting with this pool", "at a low level."}).forGetter(ModifiedTrades::armorer), (App)DefaultFieldUtil.codecWithComments((Codec)Codec.BOOL, (String)"toolsmith", (Object)DEFAULT.toolsmith(), (String[])new String[]{"Whether Toolsmith trades should be modified by Enchiridion.", "", "When modified by Enchiridion, Toolsmith tool trades will use specific", "enchantments from the Librarian pool, with expert trades enchanting with", "this pool at a very low level, and master trades enchanting with this pool", "at a low level."}).forGetter(ModifiedTrades::toolsmith), (App)DefaultFieldUtil.codecWithComments((Codec)Codec.BOOL, (String)"weaponsmith", (Object)DEFAULT.weaponsmith(), (String[])new String[]{"Whether Weaponsmith trades should be modified by Enchiridion.", "", "When modified by Enchiridion, Weaponsmith weapon trades will use specific", "enchantments from the Librarian pool, with expert trades enchanting with", "this pool at a very low level, and master trades enchanting with this pool", "at a low level."}).forGetter(ModifiedTrades::weaponsmith)).apply((Applicative)inst, ModifiedTrades::new));
            public static final class_9139<class_2540, ModifiedTrades> STREAM_CODEC = class_9139.method_56905((class_9139)class_9135.field_48547, ModifiedTrades::librarian, (class_9139)class_9135.field_48547, ModifiedTrades::armorer, (class_9139)class_9135.field_48547, ModifiedTrades::toolsmith, (class_9139)class_9135.field_48547, ModifiedTrades::weaponsmith, ModifiedTrades::new);
        }
    }

    public record Client(Map<LateHolder<EnchantmentCategory>, CategoryVisuals> categoryColorOverrides) {
        private static final Client DEFAULT = new Client((Map<LateHolder<EnchantmentCategory>, CategoryVisuals>)Object2ObjectMaps.emptyMap());
        public static final MapCodec<Client> CODEC = RecordCodecBuilder.mapCodec(inst -> inst.group((App)DefaultFieldUtil.codecWithComments((Codec)Codec.unboundedMap((Codec)LateHolder.codec((class_5321)class_5321.method_29180((class_2960)Enchiridion.id("enchantment_category"))), CategoryVisuals.CODEC), (String)"category_visual_overrides", DEFAULT.categoryColorOverrides(), (String[])new String[]{"Overrides for setting the visuals of enchantment categories.", "", "This can affect the text color and the book color/model for the enchanted book.", "You may either specify a string to set both text and book color,", "or an object with 'text_color', 'book_color' and 'item_model_index' fields.", "", "'item_model_index' may be used through the 'enchiridion:first_enchantment_category' model override predicate.", "", "If an 'item_model_index' field is not specified, a generic model will be used, which is tinted based on the", "'book_color' field or the 'color' field if the 'book_color' field is not specified.", "", "Examples:", "{", "\t\"enchiridion:primary\": \"red\",", "\t\"enchiridion:secondary\": {", "\t\t\"text_color\": \"#00FF00\",", "\t\t\"book_color\": \"#00AA00\"", "\t},", "\t\"enchiridion:tertiary\": {", "\t\t\"text_color\": \"#00AA00\"", "\t\t\"item_model_index\": 0.6", "\t}", "}"}).forGetter(Client::categoryColorOverrides)).apply((Applicative)inst, Client::new));

        @NotNull
        public Optional<CategoryVisuals> getBookVisuals(class_6880<EnchantmentCategory> category) {
            return this.categoryColorOverrides.entrySet().stream().filter(entry -> ((LateHolder)entry.getKey()).method_55838(category)).map(Map.Entry::getValue).findFirst();
        }
    }
}

