/*
 * Decompiled with CFR 0.152.
 */
package house.greenhouse.enchiridion.api.enchantment.category;

import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.UnboundedMapCodec;
import house.greenhouse.enchiridion.api.enchantment.category.EnchantmentCategory;
import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectMaps;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectList;
import it.unimi.dsi.fastutil.objects.ObjectLists;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.class_1887;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import net.minecraft.class_6885;
import net.minecraft.class_7924;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import net.minecraft.class_9304;
import net.minecraft.class_9331;
import net.minecraft.class_9334;
import org.jetbrains.annotations.Nullable;

public class ItemEnchantmentCategories {
    public static final ItemEnchantmentCategories EMPTY = new ItemEnchantmentCategories((Object2ObjectMap<class_6880<EnchantmentCategory>, ObjectList<class_6880<class_1887>>>)Object2ObjectMaps.emptyMap());
    public static final Codec<ItemEnchantmentCategories> CODEC = new UnboundedMapCodec(EnchantmentCategory.CODEC, class_1887.field_51644.listOf().xmap(ObjectArrayList::new, Function.identity())).xmap(Object2ObjectArrayMap::new, Function.identity()).xmap(ItemEnchantmentCategories::new, categories -> (Object2ObjectArrayMap)categories.enchantmentCategories);
    public static final class_9139<class_9129, ItemEnchantmentCategories> STREAM_CODEC = class_9135.method_56377(Object2ObjectArrayMap::new, EnchantmentCategory.STREAM_CODEC, (class_9139)class_9135.method_56383((class_5321)class_7924.field_41265).method_56433(class_9135.method_56363()).method_56432(ObjectArrayList::new, Function.identity())).method_56432(ItemEnchantmentCategories::new, categories -> new Object2ObjectArrayMap(categories.enchantmentCategories));
    private final Object2ObjectMap<class_6880<EnchantmentCategory>, ObjectList<class_6880<class_1887>>> enchantmentCategories;

    private ItemEnchantmentCategories(Object2ObjectMap<class_6880<EnchantmentCategory>, ObjectList<class_6880<class_1887>>> enchantmentCategories) {
        this.enchantmentCategories = enchantmentCategories;
    }

    public Object2ObjectMap<class_6880<EnchantmentCategory>, ObjectList<class_6880<class_1887>>> getCategories() {
        return Object2ObjectMaps.unmodifiable(this.enchantmentCategories);
    }

    @Nullable
    public class_6880<EnchantmentCategory> findFirstCategory(class_6880<class_1887> enchantment) {
        return this.enchantmentCategories.entrySet().stream().filter(entry -> ((ObjectList)entry.getValue()).contains((Object)enchantment)).max(Comparator.comparingInt(value -> !((class_6880)value.getKey()).method_40227() ? -1 : ((EnchantmentCategory)((class_6880)value.getKey()).comp_349()).priority())).map(Map.Entry::getKey).orElse(null);
    }

    public boolean hasCategory(class_6880<EnchantmentCategory> category) {
        return this.enchantmentCategories.keySet().stream().anyMatch(categoryHolder -> categoryHolder.method_55838(category));
    }

    public List<class_6880<class_1887>> get(class_6880<EnchantmentCategory> category) {
        if (!this.enchantmentCategories.containsKey(category)) {
            return List.of();
        }
        return List.copyOf((Collection)this.enchantmentCategories.get(category));
    }

    public boolean isValid(class_6880<EnchantmentCategory> category, class_6880<class_1887> enchantment, class_9331<class_9304> type) {
        if (type == class_9334.field_49643) {
            return this.isStoredValid(category, enchantment);
        }
        return this.isValid(category, enchantment);
    }

    public boolean isValid(class_6880<EnchantmentCategory> category, class_6880<class_1887> enchantment) {
        if (!category.method_40227()) {
            return false;
        }
        if (!((EnchantmentCategory)category.comp_349()).acceptedEnchantments().method_40241(enchantment)) {
            return false;
        }
        if (((EnchantmentCategory)category.comp_349()).limit().isEmpty() || !this.enchantmentCategories.containsKey(category)) {
            return true;
        }
        return ((ObjectList)this.enchantmentCategories.get(category)).size() < ((EnchantmentCategory)category.comp_349()).limit().get();
    }

    public boolean isStoredValid(class_6880<EnchantmentCategory> category, class_6880<class_1887> enchantment) {
        if (!category.method_40227()) {
            return false;
        }
        if (!((EnchantmentCategory)category.comp_349()).acceptedEnchantments().method_40241(enchantment)) {
            return false;
        }
        if (((EnchantmentCategory)category.comp_349()).limit().isEmpty() || !this.enchantmentCategories.containsKey(category)) {
            return true;
        }
        class_6885 holders = ((class_1887)enchantment.comp_349()).comp_2687().comp_2507().orElse(((class_1887)enchantment.comp_349()).comp_2687().comp_2506());
        long count = ((ObjectList)this.enchantmentCategories.get(category)).stream().filter(e -> {
            class_6885 enchantmentItems = ((class_1887)e.comp_349()).comp_2687().comp_2507().orElse(((class_1887)e.comp_349()).comp_2687().comp_2506());
            return enchantmentItems.method_40239().anyMatch(arg_0 -> ((class_6885)holders).method_40241(arg_0));
        }).count();
        return count < (long)((EnchantmentCategory)category.comp_349()).limit().get().intValue();
    }

    public boolean contains(class_6880<class_1887> enchantment) {
        return this.enchantmentCategories.values().stream().anyMatch(holders -> holders.contains((Object)enchantment));
    }

    public boolean isEmpty() {
        return this.enchantmentCategories.isEmpty();
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ItemEnchantmentCategories)) {
            return false;
        }
        ItemEnchantmentCategories categories = (ItemEnchantmentCategories)other;
        return categories.enchantmentCategories.equals(this.enchantmentCategories);
    }

    public int hashCode() {
        return this.enchantmentCategories.hashCode();
    }

    public String toString() {
        return "ItemEnchantmentCategories{" + String.valueOf(this.enchantmentCategories) + "}";
    }

    public static class Mutable {
        private final Object2ObjectMap<class_6880<EnchantmentCategory>, ObjectList<class_6880<class_1887>>> enchantmentCategories;

        public Mutable(ItemEnchantmentCategories categories) {
            this.enchantmentCategories = new Object2ObjectArrayMap(categories.enchantmentCategories);
        }

        public int size() {
            return this.enchantmentCategories.size();
        }

        public boolean isEmpty() {
            return this.enchantmentCategories.isEmpty();
        }

        public boolean contains(class_6880<EnchantmentCategory> category, class_6880<class_1887> enchantment) {
            return ((ObjectList)this.enchantmentCategories.getOrDefault(category, (Object)ObjectLists.emptyList())).contains(enchantment);
        }

        public boolean contains(class_6880<class_1887> enchantment) {
            return this.enchantmentCategories.values().stream().anyMatch(holders -> holders.contains((Object)enchantment));
        }

        public void overwrite(class_6880<EnchantmentCategory> category, class_6880<class_1887> enchantment) {
            this.remove(category, enchantment);
            this.add(category, enchantment);
        }

        public void add(class_6880<EnchantmentCategory> category, class_6880<class_1887> enchantment) {
            if (this.contains(enchantment)) {
                return;
            }
            List categoryList = (List)this.enchantmentCategories.computeIfAbsent(category, category1 -> new ObjectArrayList());
            if (!categoryList.contains(enchantment)) {
                categoryList.add(enchantment);
            }
        }

        public void remove(class_6880<EnchantmentCategory> category, class_6880<class_1887> enchantment) {
            if (!this.contains(enchantment)) {
                return;
            }
            ((ObjectList)this.enchantmentCategories.computeIfAbsent(category, category1 -> new ObjectArrayList())).remove(enchantment);
            if (((ObjectList)this.enchantmentCategories.get(category)).isEmpty()) {
                this.enchantmentCategories.remove(category);
            }
        }

        public boolean isValid(class_6880<EnchantmentCategory> category, class_6880<class_1887> enchantment, class_9331<class_9304> type) {
            if (type == class_9334.field_49643) {
                return this.isStoredValid(category, enchantment);
            }
            return this.isValid(category, enchantment);
        }

        private boolean isValid(class_6880<EnchantmentCategory> category, class_6880<class_1887> enchantment) {
            if (!category.method_40227()) {
                return false;
            }
            if (!((EnchantmentCategory)category.comp_349()).acceptedEnchantments().method_40241(enchantment)) {
                return false;
            }
            if (((EnchantmentCategory)category.comp_349()).limit().isEmpty() || !this.enchantmentCategories.containsKey(category)) {
                return true;
            }
            return ((ObjectList)this.enchantmentCategories.get(category)).size() < ((EnchantmentCategory)category.comp_349()).limit().get();
        }

        private boolean isStoredValid(class_6880<EnchantmentCategory> category, class_6880<class_1887> enchantment) {
            if (!category.method_40227()) {
                return false;
            }
            if (!((EnchantmentCategory)category.comp_349()).acceptedEnchantments().method_40241(enchantment)) {
                return false;
            }
            if (((EnchantmentCategory)category.comp_349()).limit().isEmpty() || !this.enchantmentCategories.containsKey(category)) {
                return true;
            }
            class_6885 holders = ((class_1887)enchantment.comp_349()).comp_2687().comp_2507().orElse(((class_1887)enchantment.comp_349()).comp_2687().comp_2506());
            long count = ((ObjectList)this.enchantmentCategories.get(category)).stream().filter(e -> {
                class_6885 enchantmentItems = ((class_1887)e.comp_349()).comp_2687().comp_2507().orElse(((class_1887)e.comp_349()).comp_2687().comp_2506());
                return enchantmentItems.method_40239().anyMatch(arg_0 -> ((class_6885)holders).method_40241(arg_0));
            }).count();
            return count < (long)((EnchantmentCategory)category.comp_349()).limit().get().intValue();
        }

        public ItemEnchantmentCategories toImmutable() {
            if (this.enchantmentCategories.isEmpty()) {
                return EMPTY;
            }
            return new ItemEnchantmentCategories(this.enchantmentCategories);
        }

        public int hashCode() {
            return this.enchantmentCategories.hashCode();
        }

        public String toString() {
            return "ItemEnchantmentCategories.Mutable{" + String.valueOf(this.enchantmentCategories) + "}";
        }
    }
}

