/*
 * Decompiled with CFR 0.152.
 */
package house.greenhouse.enchiridion.api.enchantment.effect;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import house.greenhouse.enchiridion.Enchiridion;
import house.greenhouse.enchiridion.api.enchantment.effect.entity.common.AllOfSidedEnchantmentEntityEffect;
import house.greenhouse.enchiridion.api.enchantment.effect.entity.common.SidedEnchantmentEntityEffectInstance;
import house.greenhouse.enchiridion.api.enchantment.effect.entity.common.VanillaEnchantmentEntityEffectWrapper;
import house.greenhouse.enchiridion.api.util.Side;
import house.greenhouse.enchiridion.network.clientbound.SyncClientEnchantmentEntityEffectsClientboundPacket;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_173;
import net.minecraft.class_176;
import net.minecraft.class_1799;
import net.minecraft.class_181;
import net.minecraft.class_1887;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_3218;
import net.minecraft.class_47;
import net.minecraft.class_5321;
import net.minecraft.class_5341;
import net.minecraft.class_6880;
import net.minecraft.class_7225;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.class_8567;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import net.minecraft.class_9331;
import net.minecraft.class_9698;
import net.minecraft.class_9699;
import net.minecraft.class_9721;
import org.jetbrains.annotations.Nullable;

public class ConditionalSidedEnchantmentEntityEffect {
    public static final Codec<Map<class_9331<?>, List<Pair<SidedEnchantmentEntityEffectInstance, Integer>>>> CLIENT_ATTACHMENT_CODEC = Codec.unboundedMap((Codec)class_7923.field_49658.method_39673(), (Codec)Codec.pair(SidedEnchantmentEntityEffectInstance.CODEC, (Codec)Codec.INT).listOf());
    public static final class_9139<class_9129, Pair<SidedEnchantmentEntityEffectInstance, Integer>> INSTANCE_WITH_LEVEL_STREAM_CODEC = class_9139.method_56435(SidedEnchantmentEntityEffectInstance.STREAM_CODEC, Pair::getFirst, (class_9139)class_9135.field_49675, Pair::getSecond, Pair::of);
    public static final class_9139<class_9129, Map<class_9331<?>, List<Pair<SidedEnchantmentEntityEffectInstance, Integer>>>> CLIENT_ATTACHMENT_STREAM_CODEC = class_9135.method_56377(Object2ObjectArrayMap::new, (class_9139)class_9135.method_56365((class_5321)class_7924.field_51838), (class_9139)INSTANCE_WITH_LEVEL_STREAM_CODEC.method_56433(class_9135.method_56363()));
    private final SidedEnchantmentEntityEffectInstance effect;
    @Nullable
    private final class_5341 requirements;
    @Nullable
    private final Side side;
    private boolean previousValue = false;

    public ConditionalSidedEnchantmentEntityEffect(SidedEnchantmentEntityEffectInstance effect, @Nullable class_5341 requirements, @Nullable Side side) {
        this.requirements = requirements;
        this.effect = effect;
        this.side = side;
    }

    public static Codec<ConditionalSidedEnchantmentEntityEffect> codec(class_176 params) {
        return RecordCodecBuilder.create(inst -> inst.group((App)SidedEnchantmentEntityEffectInstance.CODEC.fieldOf("effect").forGetter(ConditionalSidedEnchantmentEntityEffect::effect), (App)class_9698.method_60007((class_176)params).optionalFieldOf("requirements").forGetter(ConditionalSidedEnchantmentEntityEffect::requirements), (App)Side.CODEC.optionalFieldOf("side").forGetter(ConditionalSidedEnchantmentEntityEffect::side)).apply((Applicative)inst, (t1, t2, t3) -> new ConditionalSidedEnchantmentEntityEffect((SidedEnchantmentEntityEffectInstance)t1, t2.orElse(null), t3.orElse(null)))).validate(eff -> {
            if (eff.side().isPresent() && !eff.effect().validSides().contains((Object)eff.side().get())) {
                return DataResult.error(() -> "Side " + eff.side().orElseThrow().method_15434() + " is invalid for effect class: " + eff.effect.getClass().getCanonicalName());
            }
            return DataResult.success((Object)eff);
        });
    }

    public static ConditionalSidedEnchantmentEntityEffect client(SidedEnchantmentEntityEffectInstance effect, class_5341.class_210 requirements) {
        return new ConditionalSidedEnchantmentEntityEffect(effect, requirements.build(), Side.CLIENT);
    }

    public static ConditionalSidedEnchantmentEntityEffect server(SidedEnchantmentEntityEffectInstance effect, class_5341.class_210 requirements) {
        return new ConditionalSidedEnchantmentEntityEffect(effect, requirements.build(), Side.SERVER);
    }

    public static ConditionalSidedEnchantmentEntityEffect vanilla(class_9721 effect, class_5341.class_210 requirements) {
        return new ConditionalSidedEnchantmentEntityEffect(new VanillaEnchantmentEntityEffectWrapper(effect), requirements.build(), Side.SERVER);
    }

    public static ConditionalSidedEnchantmentEntityEffect allOf(List<SidedEnchantmentEntityEffectInstance> effects, class_5341.class_210 requirements) {
        return new ConditionalSidedEnchantmentEntityEffect(new AllOfSidedEnchantmentEntityEffect(effects), requirements.build(), null);
    }

    @SafeVarargs
    public static void tickConditionsWithEntityParamSet(class_1309 entity, class_243 pos, class_9331<List<ConditionalSidedEnchantmentEntityEffect>> ... effectComponents) {
        class_1937 class_19372 = entity.method_37908();
        if (!(class_19372 instanceof class_3218)) {
            return;
        }
        class_3218 serverLevel = (class_3218)class_19372;
        boolean sync = false;
        Map<class_9331<?>, List<Pair<SidedEnchantmentEntityEffectInstance, Integer>>> map = Enchiridion.getHelper().getClientEntityEffectComponents((class_1297)entity);
        for (class_9331<List<ConditionalSidedEnchantmentEntityEffect>> effectComponent : effectComponents) {
            int previousSize = map.getOrDefault(effectComponent, Collections.emptyList()).size();
            map.remove(effectComponent);
            for (class_1304 slot : class_1304.values()) {
                class_1799 stack = entity.method_6118(slot);
                if (Enchiridion.getHelper().getEnchantments((class_7225.class_7226<class_1887>)entity.method_37908().method_30349().method_46762(class_7924.field_41265), stack).method_57543()) continue;
                for (Pair effect : Enchiridion.getHelper().getEnchantments((class_7225.class_7226<class_1887>)entity.method_37908().method_30349().method_46762(class_7924.field_41265), stack).method_57539().stream().filter(entry -> ((class_6880)entry.getKey()).method_40227()).flatMap(entry -> ((class_1887)((class_6880)entry.getKey()).comp_349()).method_60034(effectComponent).stream().map(effects -> Pair.of((Object)entry, (Object)effects))).toList()) {
                    boolean currentValue;
                    boolean previousValue = ((ConditionalSidedEnchantmentEntityEffect)effect.getSecond()).previousValue;
                    boolean bl = currentValue = ((ConditionalSidedEnchantmentEntityEffect)effect.getSecond()).requirements == null;
                    if (!currentValue) {
                        class_8567 params = new class_8567.class_8568(serverLevel).method_51874(class_181.field_1226, (Object)entity).method_51874(class_181.field_24424, (Object)pos).method_51874(class_181.field_51805, (Object)((Object2IntMap.Entry)effect.getFirst()).getIntValue()).method_51875(class_173.field_51804);
                        currentValue = ((ConditionalSidedEnchantmentEntityEffect)effect.getSecond()).requirements.test((Object)new class_47.class_48(params).method_309(Optional.empty()));
                    }
                    if (currentValue) {
                        map.compute(effectComponent, (component, instances) -> {
                            if (instances == null) {
                                instances = new ArrayList<Pair>();
                            }
                            instances.add(Pair.of((Object)((ConditionalSidedEnchantmentEntityEffect)effect.getSecond()).effect(), (Object)((Object2IntMap.Entry)effect.getFirst()).getIntValue()));
                            return instances;
                        });
                    }
                    if (previousValue != currentValue) {
                        sync = true;
                    }
                    ((ConditionalSidedEnchantmentEntityEffect)effect.getSecond()).previousValue = currentValue;
                }
            }
            if (previousSize == map.getOrDefault(effectComponent, Collections.emptyList()).size()) continue;
            sync = true;
        }
        if (sync) {
            Enchiridion.getHelper().setClientEntityEffectComponents((class_1297)entity, map);
            Enchiridion.getHelper().sendClientboundTracking((class_1297)entity, new SyncClientEnchantmentEntityEffectsClientboundPacket(entity.method_5628(), map));
        }
    }

    public static void clientApply(class_9331<?> componentType, class_1297 entity, class_9699 enchantedItemInUse, class_1937 level, class_243 origin) {
        for (Pair<SidedEnchantmentEntityEffectInstance, Integer> inst : Enchiridion.getHelper().getClientEntityEffectComponents(entity, componentType)) {
            ((SidedEnchantmentEntityEffectInstance)inst.getFirst()).apply(level, (Integer)inst.getSecond(), enchantedItemInUse, entity, origin);
        }
    }

    public static void removeAllOfType(class_9331<?> componentType, class_1297 entity) {
        HashMap newMap = new HashMap(Enchiridion.getHelper().getClientEntityEffectComponents(entity));
        newMap.remove(componentType);
        Enchiridion.getHelper().setClientEntityEffectComponents(entity, newMap);
    }

    public SidedEnchantmentEntityEffectInstance effect() {
        return this.effect;
    }

    public Optional<class_5341> requirements() {
        return Optional.ofNullable(this.requirements);
    }

    public Optional<Side> side() {
        return Optional.ofNullable(this.side);
    }

    public boolean validOnSide(Side side) {
        return this.effect.validSides().contains((Object)side) && (this.side == null || this.side == side);
    }

    public boolean matches(class_47 context) {
        return this.requirements == null || this.requirements.test((Object)context);
    }

    public void apply(class_1937 level, int enchantmentLevel, class_9699 enchantedItemInUse, class_1297 entity, class_243 origin) {
        if (level.method_8608() && this.validOnSide(Side.CLIENT) || !level.method_8608() && this.validOnSide(Side.SERVER)) {
            this.effect.apply(level, enchantmentLevel, enchantedItemInUse, entity, origin);
        }
    }
}

