/*
 * Decompiled with CFR 0.152.
 */
package house.greenhouse.enchiridion.api.enchantment.effect.entity;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.EnumSet;
import java.util.List;
import java.util.function.BiPredicate;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_243;
import net.minecraft.class_3218;
import net.minecraft.class_3542;
import net.minecraft.class_5575;
import net.minecraft.class_6025;
import net.minecraft.class_8046;
import net.minecraft.class_9699;
import net.minecraft.class_9704;
import net.minecraft.class_9721;
import org.jetbrains.annotations.NotNull;

public record AreaEffect(class_9704 radius, class_9721 effect, EnumSet<AreaTarget> unaffected) implements class_9721
{
    public static final MapCodec<AreaEffect> CODEC = RecordCodecBuilder.mapCodec(inst -> inst.group((App)class_9704.field_51690.fieldOf("width").forGetter(AreaEffect::radius), (App)class_9721.field_51707.fieldOf("effect").forGetter(AreaEffect::effect), (App)AreaTarget.SET_CODEC.optionalFieldOf("unaffected", EnumSet.of(AreaTarget.THIS)).forGetter(AreaEffect::unaffected)).apply((Applicative)inst, AreaEffect::new));

    public void method_60220(class_3218 serverLevel, int i, @NotNull class_9699 enchantedItemInUse, @NotNull class_1297 entity, @NotNull class_243 vec3) {
        serverLevel.method_18198(class_5575.method_31795(class_1309.class), living -> this.unaffected.stream().noneMatch(areaTarget -> areaTarget.canTarget((class_1297)enchantedItemInUse.comp_2684(), (class_1309)living)) && living.method_5739(entity) < this.radius.method_60188(i)).forEach(living -> this.effect.method_60220(serverLevel, i, enchantedItemInUse, (class_1297)living, vec3));
    }

    @NotNull
    public MapCodec<? extends class_9721> method_60219() {
        return CODEC;
    }

    public static enum AreaTarget implements class_3542
    {
        THIS("this", class_1297::method_5779),
        ATTACKER("attacker", (entity, entity2) -> {
            class_1309 living;
            if (entity instanceof class_1309 && (living = (class_1309)entity).method_6081().method_5529() != null) {
                return living.method_6081().method_5529().method_5779((class_1297)entity2);
            }
            return false;
        }),
        DAMAGING_ENTITY("damaging_entity", (entity, entity2) -> {
            class_1309 living;
            if (entity instanceof class_1309 && (living = (class_1309)entity).method_6081().method_5526() != null) {
                return living.method_6081().method_5526().method_5779((class_1297)entity2);
            }
            return false;
        }),
        TARGET("target", (entity, living) -> living.method_6081().method_5529().method_5779(entity)),
        OWNER("owner", AreaTarget::isOwner),
        TAMED("tamed", (entity, living) -> AreaTarget.isOwner((class_1297)living, entity)),
        ALLIED("allied", (entity, living) -> entity.method_5722((class_1297)living));

        private String name;
        private BiPredicate<class_1297, class_1309> predicate;
        public static final Codec<AreaTarget> CODEC;
        public static final Codec<EnumSet<AreaTarget>> SET_CODEC;

        private AreaTarget(String name, BiPredicate<class_1297, class_1309> predicate) {
            this.name = name;
            this.predicate = predicate;
        }

        private static boolean isOwner(class_1297 entity, class_1297 living) {
            class_8046 traceable;
            class_6025 ownable;
            if (entity instanceof class_6025 && (ownable = (class_6025)entity).method_35057() != null) {
                return ownable.method_35057().method_5779(living);
            }
            if (entity instanceof class_8046 && (traceable = (class_8046)entity).method_24921() != null) {
                return traceable.method_24921().method_5779(living);
            }
            return false;
        }

        public boolean canTarget(class_1297 entity, class_1309 target) {
            return this.predicate.test(entity, target);
        }

        public String method_15434() {
            return this.name;
        }

        static {
            CODEC = class_3542.method_28140(AreaTarget::values);
            SET_CODEC = CODEC.listOf().xmap(EnumSet::copyOf, List::copyOf);
        }
    }
}

