/*
 * Decompiled with CFR 0.152.
 */
package house.greenhouse.enchiridion.api.value;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_5819;
import net.minecraft.class_9704;
import net.minecraft.class_9723;
import org.apache.commons.lang3.mutable.MutableFloat;
import org.jetbrains.annotations.NotNull;

public record RangeEnchantmentValue(List<Pair<Range, class_9723>> values) implements class_9723
{
    public static final MapCodec<RangeEnchantmentValue> CODEC = RecordCodecBuilder.mapCodec(inst -> inst.group((App)Range.VALUE_CODEC.listOf().fieldOf("values").forGetter(RangeEnchantmentValue::values)).apply((Applicative)inst, RangeEnchantmentValue::new));

    public static Builder builder() {
        return new Builder();
    }

    public float method_60213(int enchantmentLevel, @NotNull class_5819 random, float value) {
        MutableFloat newVal = new MutableFloat(value);
        List<Pair> applicable = this.values.stream().filter(e -> {
            float min = ((Range)e.getFirst()).minInclusive().map(levelBasedValue -> Float.valueOf(levelBasedValue.method_60188(enchantmentLevel))).orElse(Float.valueOf(0.0f)).floatValue();
            if (((Range)e.getFirst()).minInclusive().isPresent() && min > newVal.getValue().floatValue()) {
                return false;
            }
            float max = ((Range)e.getFirst()).maxExclusive().map(levelBasedValue -> Float.valueOf(levelBasedValue.method_60188(enchantmentLevel))).orElse(Float.valueOf(0.0f)).floatValue();
            return ((Range)e.getFirst()).maxExclusive().isEmpty() || max > newVal.getValue().floatValue();
        }).toList();
        for (Pair entry : applicable) {
            newVal.setValue(((class_9723)entry.getSecond()).method_60213(enchantmentLevel, random, newVal.getValue().floatValue()));
        }
        return newVal.getValue().floatValue();
    }

    @NotNull
    public MapCodec<? extends class_9723> method_60211() {
        return CODEC;
    }

    public static class Builder {
        private final List<Pair<Range, class_9723>> values = new ArrayList<Pair<Range, class_9723>>();

        private Builder() {
        }

        public Builder minInclusive(class_9704 minInclusive, class_9723 value) {
            this.values.add((Pair<Range, class_9723>)Pair.of((Object)new Range(Optional.of(minInclusive), Optional.empty()), (Object)value));
            return this;
        }

        public Builder maxExclusive(class_9704 maxExclusive, class_9723 value) {
            this.values.add((Pair<Range, class_9723>)Pair.of((Object)new Range(Optional.empty(), Optional.of(maxExclusive)), (Object)value));
            return this;
        }

        public Builder betweenClamped(class_9704 minInclusive, class_9704 maxExclusive, class_9723 value) {
            this.values.add((Pair<Range, class_9723>)Pair.of((Object)new Range(Optional.of(minInclusive), Optional.of(maxExclusive)), (Object)value));
            return this;
        }

        public RangeEnchantmentValue build() {
            return new RangeEnchantmentValue(this.values);
        }
    }

    private record Range(Optional<class_9704> minInclusive, Optional<class_9704> maxExclusive) {
        private static final Codec<Range> DIRECT_CODEC = RecordCodecBuilder.create(inst -> inst.group((App)class_9704.field_51690.optionalFieldOf("min_inclusive").forGetter(Range::minInclusive), (App)class_9704.field_51690.optionalFieldOf("max_exclusive").forGetter(Range::maxExclusive)).apply((Applicative)inst, Range::new));
        private static final Codec<Range> CODEC = DIRECT_CODEC.validate(range -> {
            if (range.minInclusive().isEmpty() && range.maxExclusive().isEmpty()) {
                return DataResult.error(() -> "Cannot create range without either a 'min_inclusive' or 'max_exclusive' value.");
            }
            if (range.maxExclusive().isPresent() && range.minInclusive().isPresent() && range.maxExclusive().get().method_60188(1) < range.minInclusive().get().method_60188(1)) {
                return DataResult.error(() -> "Cannot create range that has a 'max_exclusive' value that is smaller than the 'min_inclusive' value.");
            }
            return DataResult.success((Object)range);
        });
        private static final Codec<Pair<Range, class_9723>> VALUE_CODEC = RecordCodecBuilder.create(inst -> inst.group((App)CODEC.fieldOf("range").forGetter(Pair::getFirst), (App)class_9723.field_51709.fieldOf("value").forGetter(Pair::getSecond)).apply((Applicative)inst, Pair::of));
    }
}

