/*
 * Decompiled with CFR 0.152.
 */
package house.greenhouse.enchiridion.util;

import com.mojang.datafixers.util.Pair;
import house.greenhouse.enchiridion.Enchiridion;
import house.greenhouse.enchiridion.EnchiridionConfig;
import house.greenhouse.enchiridion.api.enchantment.category.EnchantmentCategory;
import house.greenhouse.enchiridion.api.enchantment.category.ItemEnchantmentCategories;
import house.greenhouse.enchiridion.api.registry.EnchiridionRegistries;
import house.greenhouse.enchiridion.mixin.Invoker_EnchantmentHelper;
import house.greenhouse.enchiridion.registry.EnchiridionDataComponents;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.class_1799;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_5819;
import net.minecraft.class_6880;
import net.minecraft.class_6885;
import net.minecraft.class_7225;
import net.minecraft.class_7924;
import net.minecraft.class_9304;
import net.minecraft.class_9331;
import net.minecraft.class_9334;
import net.minecraft.class_9636;
import org.jetbrains.annotations.Nullable;

public class EnchantmentCategoryUtil {
    public static ItemEnchantmentCategories updateCategories(class_1799 stack, Consumer<ItemEnchantmentCategories.Mutable> consumer) {
        if (Enchiridion.CONFIG.get() != null && !((EnchiridionConfig)Enchiridion.CONFIG.get()).common().enableCategories()) {
            consumer.accept(new ItemEnchantmentCategories.Mutable(ItemEnchantmentCategories.EMPTY));
            return ItemEnchantmentCategories.EMPTY;
        }
        return (ItemEnchantmentCategories)stack.method_57368(EnchiridionDataComponents.ENCHANTMENT_CATEGORIES, (Object)ItemEnchantmentCategories.EMPTY, categories -> {
            ItemEnchantmentCategories.Mutable mutable = new ItemEnchantmentCategories.Mutable((ItemEnchantmentCategories)categories);
            consumer.accept(mutable);
            return mutable.toImmutable();
        });
    }

    public static void enchantFromCategory(class_5819 random, class_1799 stack, int level, Stream<class_6880<class_1887>> enchantments, class_6880<EnchantmentCategory> category) {
        EnchantmentCategoryUtil.enchantFromCategories(random, stack, level, enchantments, List.of(category));
    }

    public static void enchantFromCategories(class_5819 random, class_1799 stack, int level, Stream<class_6880<class_1887>> enchantments, List<class_6880<EnchantmentCategory>> categories) {
        class_1890.method_8233((class_5819)random, (class_1799)stack, (int)level, Enchiridion.CONFIG.get() != null && !((EnchiridionConfig)Enchiridion.CONFIG.get()).common().enableCategories() ? enchantments : enchantments.filter(enchantmentHolder -> categories.stream().anyMatch(holder -> holder.method_40227() && ((EnchantmentCategory)holder.comp_349()).acceptedEnchantments().method_40241(enchantmentHolder))));
    }

    public static void categoriseEnchantmentsOnItem(class_1799 stack) {
        class_9331<class_9304> enchantmentComponent = Invoker_EnchantmentHelper.enchiridion$invokeGetComponentType(stack);
        EnchantmentCategoryUtil.categoriseEnchantmentsOnItem((class_9304)stack.method_57825(enchantmentComponent, (Object)class_9304.field_49385), stack, enchantmentComponent);
    }

    public static void categoriseEnchantmentsOnItem(class_9304 enchantments, class_1799 stack, class_9331<class_9304> componentType) {
        if (enchantments.method_57543() || Enchiridion.CONFIG.get() != null && !((EnchiridionConfig)Enchiridion.CONFIG.get()).common().enableCategories()) {
            return;
        }
        if (componentType == class_9334.field_49643) {
            EnchantmentCategoryUtil.categoriseStoredEnchantmentsOnItem(enchantments, stack);
            return;
        }
        EnchantmentCategoryUtil.updateCategories(stack, mutable -> enchantments.method_57534().forEach(enchantment -> {
            class_6880<EnchantmentCategory> category = EnchantmentCategoryUtil.getFirstEnchantmentCategory((class_7225.class_7874)Enchiridion.getHelper().getReqistryAccess(), (class_6880<class_1887>)enchantment);
            if (category == null) {
                return;
            }
            if (!category.method_40227() || mutable.contains((class_6880<class_1887>)enchantment) && mutable.contains(category, (class_6880<class_1887>)enchantment) || !EnchantmentCategoryUtil.categoryAcceptsNewEnchantments(category, mutable.toImmutable())) {
                return;
            }
            mutable.add(category, (class_6880<class_1887>)enchantment);
        }));
    }

    public static void removeInvalidEnchantmentsFromItem(class_1799 stack) {
        class_9331<class_9304> enchantmentComponent = Invoker_EnchantmentHelper.enchiridion$invokeGetComponentType(stack);
        if (((class_9304)stack.method_57825(enchantmentComponent, (Object)class_9304.field_49385)).method_57543() || Enchiridion.CONFIG.get() != null && !((EnchiridionConfig)Enchiridion.CONFIG.get()).common().enableCategories()) {
            return;
        }
        class_9331<class_9304> enchantmentsComponentType = Invoker_EnchantmentHelper.enchiridion$invokeGetComponentType(stack);
        stack.method_57368(enchantmentsComponentType, (Object)class_9304.field_49385, itemEnchantments -> {
            class_9304.class_9305 mutable = new class_9304.class_9305(itemEnchantments);
            mutable.method_57548(enchantmentHolder -> !((ItemEnchantmentCategories)stack.method_57825(EnchiridionDataComponents.ENCHANTMENT_CATEGORIES, (Object)ItemEnchantmentCategories.EMPTY)).contains((class_6880<class_1887>)enchantmentHolder));
            return mutable.method_57549();
        });
    }

    private static void categoriseStoredEnchantmentsOnItem(class_9304 enchantments, class_1799 stack) {
        if (Enchiridion.CONFIG.get() != null && !((EnchiridionConfig)Enchiridion.CONFIG.get()).common().enableCategories()) {
            return;
        }
        HashMap usedEnchantmentTags = new HashMap();
        EnchantmentCategoryUtil.updateCategories(stack, categories -> enchantments.method_57534().forEach(enchantment -> {
            block1: {
                List<class_6880> applicableCategories = EnchantmentCategoryUtil.getAllEnchantmentCategories((class_7225.class_7874)Enchiridion.getHelper().getReqistryAccess(), (class_6880<class_1887>)enchantment).stream().sorted(Comparator.comparingInt(value -> ((EnchantmentCategory)value.comp_349()).priority())).toList();
                Iterator<class_6880> iterator = applicableCategories.iterator();
                if (!iterator.hasNext()) break block1;
                class_6880 category = iterator.next();
                class_6885 tag = ((class_1887)enchantment.comp_349()).comp_2687().comp_2507().orElse(((class_1887)enchantment.comp_349()).comp_2687().comp_2506());
                if (!category.method_40227() || categories.contains((class_6880<class_1887>)enchantment) && categories.contains((class_6880<EnchantmentCategory>)category, (class_6880<class_1887>)enchantment) || usedEnchantmentTags.containsKey(category) && ((Set)usedEnchantmentTags.get(category)).stream().anyMatch(holders -> holders.method_40239().anyMatch(arg_0 -> ((class_6885)tag).method_40241(arg_0)))) {
                    return;
                }
                categories.add((class_6880<EnchantmentCategory>)category, (class_6880<class_1887>)enchantment);
                usedEnchantmentTags.computeIfAbsent(category, c -> new HashSet()).add(tag);
            }
        }));
    }

    @Nullable
    public static Pair<class_6880<class_1887>, Integer> getFirstEnchantmentAndLevel(class_7225.class_7874 registries, class_9304 enchantments, ItemEnchantmentCategories categories) {
        Optional tooltipOrderTag = registries.method_46762(class_7924.field_41265).method_46733(class_9636.field_51362);
        Optional<Pair> enchantment = Stream.concat(tooltipOrderTag.map(holders -> holders.method_40239()).orElse(Stream.empty()), registries.method_46762(class_7924.field_41265).method_42017().filter(e -> tooltipOrderTag == null || !((class_6885.class_6888)tooltipOrderTag.get()).method_40241((class_6880)e))).filter(holder -> enchantments.method_57534().contains(holder)).sorted((o1, o2) -> {
            class_6880<EnchantmentCategory> firstCategory = categories.findFirstCategory((class_6880<class_1887>)o1);
            class_6880<EnchantmentCategory> secondCategory = categories.findFirstCategory((class_6880<class_1887>)o2);
            int firstCategoryPriority = firstCategory != null ? ((EnchantmentCategory)firstCategory.comp_349()).priority() : 0;
            int secondCategoryPriority = secondCategory != null ? ((EnchantmentCategory)secondCategory.comp_349()).priority() : 0;
            return Integer.compare(secondCategoryPriority, firstCategoryPriority);
        }).findFirst().map(holder -> Pair.of((Object)holder, (Object)enchantments.method_57536(holder)));
        return enchantment.orElse(null);
    }

    @Nullable
    public static class_6880<EnchantmentCategory> getFirstEnchantmentCategory(class_7225.class_7874 registries, class_9304 enchantments, ItemEnchantmentCategories categories) {
        if (enchantments.method_57543()) {
            return null;
        }
        Pair<class_6880<class_1887>, Integer> enchantment = EnchantmentCategoryUtil.getFirstEnchantmentAndLevel(registries, enchantments, categories);
        return Optional.ofNullable(enchantment).map(pair -> categories.findFirstCategory((class_6880<class_1887>)((class_6880)pair.getFirst()))).filter(holder -> holder != null && holder.method_40227()).orElse(null);
    }

    public static class_6880<EnchantmentCategory> getFirstEnchantmentCategory(class_7225.class_7874 registries, class_6880<class_1887> enchantment) {
        return registries.method_46762(EnchiridionRegistries.ENCHANTMENT_CATEGORY).method_42017().filter(category -> category.method_40227() && ((EnchantmentCategory)category.comp_349()).acceptedEnchantments().method_40241(enchantment)).max(Comparator.comparingInt(value -> ((EnchantmentCategory)value.comp_349()).priority())).orElse(null);
    }

    public static List<class_6880<EnchantmentCategory>> getAllEnchantmentCategories(class_7225.class_7874 registries, class_6880<class_1887> enchantment) {
        if (!((EnchiridionConfig)Enchiridion.CONFIG.get()).common().enableCategories()) {
            return Collections.emptyList();
        }
        return registries.method_46762(EnchiridionRegistries.ENCHANTMENT_CATEGORY).method_42017().filter(category -> category.method_40227() && ((EnchantmentCategory)category.comp_349()).acceptedEnchantments().method_40241(enchantment)).collect(Collectors.toList());
    }

    public static boolean isValidInCategory(class_7225.class_7874 registries, ItemEnchantmentCategories categories, class_6880<class_1887> enchantment) {
        Optional<class_6880.class_6883> category = registries.method_46762(EnchiridionRegistries.ENCHANTMENT_CATEGORY).method_42017().filter(c -> c.method_40227() && ((EnchantmentCategory)c.comp_349()).acceptedEnchantments().method_40241(enchantment)).max(Comparator.comparingInt(o -> ((EnchantmentCategory)o.comp_349()).priority()));
        return category.map(enchantmentCategory -> EnchantmentCategoryUtil.isValidInCategory((class_6880<EnchantmentCategory>)enchantmentCategory, categories.get((class_6880<EnchantmentCategory>)enchantmentCategory), enchantment)).orElse(true);
    }

    public static boolean isValidInCategory(class_6880<EnchantmentCategory> category, List<class_6880<class_1887>> enchantments, class_6880<class_1887> enchantment) {
        if (!(enchantments = new ArrayList<class_6880<class_1887>>(enchantments)).contains(enchantment)) {
            enchantments.add(enchantment);
        }
        return category.method_40227() && (((EnchantmentCategory)category.comp_349()).limit().isEmpty() || enchantments.subList(0, enchantments.indexOf(enchantment)).size() < ((EnchantmentCategory)category.comp_349()).limit().get());
    }

    public static boolean categoryAcceptsNewEnchantments(class_6880<EnchantmentCategory> category, ItemEnchantmentCategories categories) {
        if (!category.method_40227() || ((EnchantmentCategory)category.comp_349()).limit().isEmpty() || !categories.getCategories().containsKey(category)) {
            return true;
        }
        return EnchantmentCategoryUtil.categoryAcceptsNewEnchantmentsInternal(category, List.copyOf((Collection)categories.getCategories().get(category)));
    }

    public static boolean categoryAcceptsNewEnchantmentsWithValue(class_6880<EnchantmentCategory> category, ItemEnchantmentCategories categories, class_6880<class_1887> enchantment) {
        if (!category.method_40227() || ((EnchantmentCategory)category.comp_349()).limit().isEmpty() || !categories.getCategories().containsKey(category)) {
            return true;
        }
        ArrayList<class_6880<class_1887>> enchantments = new ArrayList<class_6880<class_1887>>((Collection)categories.getCategories().get(category));
        if (!enchantments.contains(enchantment)) {
            enchantments.add(enchantment);
        }
        return EnchantmentCategoryUtil.categoryAcceptsNewEnchantmentsInternal(category, enchantments);
    }

    private static boolean categoryAcceptsNewEnchantmentsInternal(class_6880<EnchantmentCategory> category, List<class_6880<class_1887>> holders) {
        return category.method_40227() && (((EnchantmentCategory)category.comp_349()).limit().isEmpty() || holders.size() <= ((EnchantmentCategory)category.comp_349()).limit().get());
    }
}

