/*
 * Decompiled with CFR 0.152.
 */
package house.greenhouse.enchiridion.api.enchantment.category;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import house.greenhouse.enchiridion.api.enchantment.category.CategoryVisuals;
import house.greenhouse.enchiridion.api.registry.EnchiridionRegistries;
import io.netty.buffer.ByteBuf;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.class_1887;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import net.minecraft.class_6885;
import net.minecraft.class_6895;
import net.minecraft.class_6899;
import net.minecraft.class_7924;
import net.minecraft.class_8824;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;

public record EnchantmentCategory(class_6885<class_1887> acceptedEnchantments, class_2561 name, CategoryVisuals visuals, Optional<Integer> limit, float tradeChance, int priority) {
    public static final Codec<class_6880<EnchantmentCategory>> CODEC = class_6899.method_40400(EnchiridionRegistries.ENCHANTMENT_CATEGORY);
    public static final class_9139<class_9129, class_6880<EnchantmentCategory>> STREAM_CODEC = class_9135.method_56383(EnchiridionRegistries.ENCHANTMENT_CATEGORY);
    public static final Codec<EnchantmentCategory> DIRECT_CODEC = RecordCodecBuilder.create(inst -> inst.group((App)class_6895.method_40341((class_5321)class_7924.field_41265, (Codec)class_1887.field_51643).fieldOf("accepted_enchantments").forGetter(EnchantmentCategory::acceptedEnchantments), (App)class_8824.field_46597.fieldOf("name").forGetter(EnchantmentCategory::name), (App)CategoryVisuals.DIRECT_CODEC.fieldOf("visuals").forGetter(EnchantmentCategory::visuals), (App)Codec.intRange((int)1, (int)Integer.MAX_VALUE).optionalFieldOf("limit").forGetter(EnchantmentCategory::limit), (App)Codec.FLOAT.optionalFieldOf("trade_chance", (Object)Float.valueOf(0.5f)).forGetter(EnchantmentCategory::tradeChance), (App)Codec.INT.optionalFieldOf("priority", (Object)0).forGetter(EnchantmentCategory::priority)).apply((Applicative)inst, EnchantmentCategory::new));
    public static final Codec<class_5321<EnchantmentCategory>> RESOURCE_KEY_CODEC = class_5321.method_39154(EnchiridionRegistries.ENCHANTMENT_CATEGORY);
    public static final class_9139<ByteBuf, class_5321<EnchantmentCategory>> RESOURCE_KEY_STREAM_CODEC = class_5321.method_56038(EnchiridionRegistries.ENCHANTMENT_CATEGORY);

    public static Builder builder(class_6885<class_1887> acceptedEnchantments, CategoryVisuals visuals) {
        return new Builder(acceptedEnchantments, visuals);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object obj) {
        int n;
        float f;
        class_2561 otherEnchantments;
        Object object;
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof EnchantmentCategory)) return false;
        EnchantmentCategory enchantmentCategory = (EnchantmentCategory)obj;
        try {
            object = enchantmentCategory.acceptedEnchantments();
            otherEnchantments = object;
        }
        catch (Throwable throwable) {
            throw new MatchException(throwable.toString(), throwable);
        }
        object = enchantmentCategory.name();
        class_2561 otherName = object;
        Object otherVisuals = object = enchantmentCategory.visuals();
        Object otherLimit = object = enchantmentCategory.limit();
        float otherChance = f = enchantmentCategory.tradeChance();
        int otherPriority = n = enchantmentCategory.priority();
        if (!otherEnchantments.equals(this.acceptedEnchantments)) return false;
        if (!otherName.equals((Object)this.name)) return false;
        if (!((CategoryVisuals)otherVisuals).equals(this.visuals)) return false;
        if (!((Optional)otherLimit).equals(this.limit)) return false;
        if (otherChance != this.tradeChance) return false;
        if (otherPriority != this.priority) return false;
        return true;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.acceptedEnchantments, this.name, this.visuals, this.limit, Float.valueOf(this.tradeChance), this.priority);
    }

    public static class Builder {
        private final class_6885<class_1887> acceptedEnchantments;
        private CategoryVisuals visuals;
        private Optional<Integer> limit = Optional.empty();
        private float modelIndex = Float.NEGATIVE_INFINITY;
        private float tradeChance = 0.5f;
        private int priority = 0;

        protected Builder(class_6885<class_1887> acceptedEnchantments, CategoryVisuals visuals) {
            this.acceptedEnchantments = acceptedEnchantments;
            this.visuals = visuals;
        }

        public Builder limit(int limit) {
            this.limit = Optional.of(limit);
            return this;
        }

        public Builder tradeChance(float tradeChance) {
            this.tradeChance = tradeChance;
            return this;
        }

        public Builder priority(int priority) {
            this.priority = priority;
            return this;
        }

        public EnchantmentCategory build(class_2960 id) {
            return new EnchantmentCategory(this.acceptedEnchantments, (class_2561)class_2561.method_43471((String)("enchiridion.category." + id.method_42094())), this.visuals, this.limit, this.tradeChance, this.priority);
        }
    }
}

