/*
 * Decompiled with CFR 0.152.
 */
package house.greenhouse.enchiridion.fabric.util;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.util.Either;
import house.greenhouse.enchiridion.EnchiridionTags;
import house.greenhouse.enchiridion.api.registry.EnchiridionEnchantments;
import house.greenhouse.enchiridion.fabric.mixin.Accessor_EnchantRandomlyFunction;
import house.greenhouse.enchiridion.fabric.mixin.Accessor_EnchantWithLevelsFunction;
import house.greenhouse.enchiridion.fabric.mixin.Accessor_LootItem;
import house.greenhouse.enchiridion.fabric.mixin.Accessor_LootPoolBuilder;
import house.greenhouse.enchiridion.fabric.mixin.Accessor_LootPoolSingletonContainer;
import house.greenhouse.enchiridion.fabric.mixin.Accessor_LootTableBuilder;
import house.greenhouse.enchiridion.fabric.util.EnchiridionTagUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import net.fabricmc.fabric.api.loot.v3.LootTableEvents;
import net.minecraft.class_106;
import net.minecraft.class_109;
import net.minecraft.class_117;
import net.minecraft.class_131;
import net.minecraft.class_1802;
import net.minecraft.class_1887;
import net.minecraft.class_1893;
import net.minecraft.class_1935;
import net.minecraft.class_2035;
import net.minecraft.class_207;
import net.minecraft.class_2073;
import net.minecraft.class_2096;
import net.minecraft.class_223;
import net.minecraft.class_2248;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_39;
import net.minecraft.class_3902;
import net.minecraft.class_52;
import net.minecraft.class_5321;
import net.minecraft.class_5341;
import net.minecraft.class_55;
import net.minecraft.class_5658;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_6885;
import net.minecraft.class_7225;
import net.minecraft.class_77;
import net.minecraft.class_79;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.class_85;
import net.minecraft.class_9356;
import net.minecraft.class_9360;
import net.minecraft.class_9361;

public class EnchiridionLootTableUtil {
    private static class_3300 lootTableResourceManager;

    public static void modifyTables() {
        LootTableEvents.MODIFY.register((key, table, source, provider) -> {
            class_2960 location = key.method_29177();
            if (location.method_12832().startsWith("blocks/")) {
                Optional blockHolder = provider.method_46762(class_7924.field_41254).method_46746(class_5321.method_29179((class_5321)class_7924.field_41254, (class_2960)location.method_45134(string -> string.split("/", 2)[1])));
                Optional enchantmentHolder = provider.method_46762(class_7924.field_41265).method_46746(EnchiridionEnchantments.CRUMBLE);
                if (enchantmentHolder.isPresent() && blockHolder.isPresent() && EnchiridionTagUtil.isInBaseStoneTag((class_6880<class_2248>)((class_6880)blockHolder.get()), lootTableResourceManager, (class_7225<class_2248>)class_7923.field_41175.method_46771())) {
                    table.modifyPools(builder -> {
                        class_2035 predicate = new class_2035((class_6880)enchantmentHolder.get(), class_2096.class_2100.method_9053((int)1));
                        builder.method_356(class_207.method_889((class_5341.class_210)class_223.method_945((class_2073.class_2074)class_2073.class_2074.method_8973().method_58179(class_9361.field_49807, (class_9360)class_9356.method_58173(List.of(predicate))))));
                    });
                }
            }
        });
    }

    private static void addEnchantedLoot(class_5321<class_52> targetKey, class_5321<class_52> key, class_52.class_53 builder, class_7225.class_7874 provider, class_6862<class_1887> tag, int weight) {
        if (!targetKey.equals(key)) {
            return;
        }
        class_7225.class_7226 enchantmentLookup = provider.method_46762(class_7924.field_41265);
        Optional tagSet = enchantmentLookup.method_46733(tag);
        if (tagSet.isEmpty()) {
            return;
        }
        ImmutableList pools = ((Accessor_LootTableBuilder)builder).enchiridion$getPools().build();
        boolean noEnchantmentsInTable = pools.stream().noneMatch(lootPool -> lootPool.field_953.stream().noneMatch(container -> {
            Accessor_LootPoolSingletonContainer accessor;
            return container instanceof Accessor_LootPoolSingletonContainer && (accessor = (Accessor_LootPoolSingletonContainer)container).enchiridion$getFunctions().stream().anyMatch(function -> function.method_29321() == class_131.field_25216 || function.method_29321() == class_131.field_25215);
        }));
        class_3902[] applied = new class_3902[1];
        builder.modifyPools(poolBuilder -> {
            if (applied[0] == class_3902.field_17274) {
                return;
            }
            class_55 pool = poolBuilder.method_355();
            if (!noEnchantmentsInTable && pool.field_953.stream().noneMatch(container -> {
                Accessor_LootPoolSingletonContainer accessor;
                return container instanceof Accessor_LootPoolSingletonContainer && (accessor = (Accessor_LootPoolSingletonContainer)container).enchiridion$getFunctions().stream().anyMatch(function -> function.method_29321() == class_131.field_25216 || function.method_29321() == class_131.field_25215);
            })) {
                return;
            }
            poolBuilder.method_351((class_79.class_80)class_77.method_411((class_1935)class_1802.field_8529).method_437(weight).method_438((class_117.class_118)class_109.method_35520().method_60293((class_6885)tagSet.get())));
            applied[0] = class_3902.field_17274;
        });
    }

    private static void replaceEnchantWithLevelsFunction(class_5321<class_52> targetKey, class_5321<class_52> key, class_52.class_53 builder, class_7225.class_7874 provider, class_6862<class_1887> tag, class_5658 level) {
        if (!targetKey.equals(key)) {
            return;
        }
        class_7225.class_7226 enchantmentLookup = provider.method_46762(class_7924.field_41265);
        Optional tagSet = enchantmentLookup.method_46733(tag);
        if (tagSet.isEmpty()) {
            return;
        }
        builder.modifyPools(poolBuilder -> {
            class_55 previous = poolBuilder.method_355();
            ImmutableList.Builder entries = ImmutableList.builder();
            for (class_79 entry : previous.field_953) {
                if (entry instanceof class_85) {
                    class_85 singletonEntry = (class_85)entry;
                    ImmutableList.Builder functions = ImmutableList.builder();
                    for (class_117 function : ((Accessor_LootPoolSingletonContainer)singletonEntry).enchiridion$getFunctions()) {
                        if (function instanceof class_106) {
                            class_106 levelsFunction = (class_106)function;
                            functions.add((Object)new class_106.class_107(level).method_60295((class_6885)tagSet.get()).method_515());
                            continue;
                        }
                        functions.add((Object)function);
                    }
                    ((Accessor_LootPoolSingletonContainer)singletonEntry).enchiridion$setFunctions((List<class_117>)functions.build());
                }
                entries.add((Object)entry);
            }
            ((Accessor_LootPoolBuilder)poolBuilder).enchiridion$setEntries((ImmutableList.Builder<class_79>)entries);
        });
    }

    private static void replaceEnchantRandomlyFunction(class_5321<class_52> targetKey, class_5321<class_52> key, class_52.class_53 builder, class_7225.class_7874 provider, class_6862<class_1887> tag, class_5658 level) {
        if (!targetKey.equals(key)) {
            return;
        }
        class_7225.class_7226 enchantmentLookup = provider.method_46762(class_7924.field_41265);
        Optional enchantmentSet = enchantmentLookup.method_46733(tag);
        if (enchantmentSet.isEmpty()) {
            return;
        }
        builder.modifyPools(poolBuilder -> {
            class_55 previous = poolBuilder.method_355();
            ImmutableList.Builder entries = ImmutableList.builder();
            for (class_79 entry : previous.field_953) {
                if (entry instanceof class_85) {
                    class_85 singletonEntry = (class_85)entry;
                    ImmutableList.Builder functions = ImmutableList.builder();
                    for (class_117 function : ((Accessor_LootPoolSingletonContainer)singletonEntry).enchiridion$getFunctions()) {
                        if (function instanceof class_109) {
                            functions.add((Object)new class_106.class_107(level).method_60295((class_6885)enchantmentSet.get()).method_515());
                            continue;
                        }
                        functions.add((Object)function);
                    }
                    ((Accessor_LootPoolSingletonContainer)singletonEntry).enchiridion$setFunctions((List<class_117>)functions.build());
                }
                entries.add((Object)entry);
            }
            ((Accessor_LootPoolBuilder)poolBuilder).enchiridion$setEntries((ImmutableList.Builder<class_79>)entries);
        });
    }

    private static void replaceEnchantWithLevelsFunctionAndWeight(class_5321<class_52> targetKey, class_5321<class_52> key, class_52.class_53 builder, class_7225.class_7874 provider, class_6862<class_1887> tag, int weight, class_5658 level) {
        if (!targetKey.equals(key)) {
            return;
        }
        class_7225.class_7226 enchantmentLookup = provider.method_46762(class_7924.field_41265);
        Optional enchantmentSet = enchantmentLookup.method_46733(tag);
        if (enchantmentSet.isEmpty()) {
            return;
        }
        builder.modifyPools(poolBuilder -> {
            class_55 previous = poolBuilder.method_355();
            ImmutableList.Builder entries = ImmutableList.builder();
            block0: for (class_79 entry : previous.field_953) {
                if (entry instanceof class_85) {
                    class_85 singletonEntry = (class_85)entry;
                    ImmutableList.Builder functions = ImmutableList.builder();
                    for (class_117 function : ((Accessor_LootPoolSingletonContainer)singletonEntry).enchiridion$getFunctions()) {
                        class_77 lootItem;
                        if (!(entry instanceof class_77) || class_1802.field_8529 != ((Accessor_LootItem)(lootItem = (class_77)entry)).enchiridion$getItem().comp_349() || !(function instanceof class_106)) continue;
                        class_79 newEntry = class_77.method_411((class_1935)class_1802.field_8529).method_437(weight).method_438((class_117.class_118)new class_106.class_107(level).method_60295((class_6885)enchantmentSet.get())).method_419();
                        entries.add((Object)newEntry);
                        continue block0;
                    }
                }
                entries.add((Object)entry);
            }
            ((Accessor_LootPoolBuilder)poolBuilder).enchiridion$setEntries((ImmutableList.Builder<class_79>)entries);
        });
    }

    private static void replaceEnchantRandomlyFunctionAndWeight(class_5321<class_52> targetKey, class_5321<class_52> key, class_52.class_53 builder, class_7225.class_7874 provider, class_6862<class_1887> tag, int weight, class_5658 level) {
        if (!targetKey.equals(key)) {
            return;
        }
        class_7225.class_7226 enchantmentLookup = provider.method_46762(class_7924.field_41265);
        Optional enchantmentSet = enchantmentLookup.method_46733(EnchiridionTags.EnchantmentTags.JUNGLE_TEMPLE_COMMON);
        if (enchantmentSet.isEmpty()) {
            return;
        }
        builder.modifyPools(poolBuilder -> {
            class_55 previous = poolBuilder.method_355();
            ImmutableList.Builder entries = ImmutableList.builder();
            block0: for (class_79 entry : previous.field_953) {
                if (entry instanceof class_85) {
                    class_85 singletonEntry = (class_85)entry;
                    ImmutableList.Builder functions = ImmutableList.builder();
                    for (class_117 function : ((Accessor_LootPoolSingletonContainer)singletonEntry).enchiridion$getFunctions()) {
                        class_77 lootItem;
                        if (!(entry instanceof class_77) || class_1802.field_8529 != ((Accessor_LootItem)(lootItem = (class_77)entry)).enchiridion$getItem().comp_349() || !(function instanceof class_109)) continue;
                        class_79 newEntry = class_77.method_411((class_1935)class_1802.field_8529).method_437(weight).method_438((class_117.class_118)new class_106.class_107(level).method_60295((class_6885)enchantmentSet.get())).method_419();
                        entries.add((Object)newEntry);
                        continue block0;
                    }
                }
                entries.add((Object)entry);
            }
            ((Accessor_LootPoolBuilder)poolBuilder).enchiridion$setEntries((ImmutableList.Builder<class_79>)entries);
        });
    }

    private static void modifyRareVaultRewards(class_5321<class_52> key, class_52.class_53 builder, class_7225.class_7874 provider) {
        if (!class_39.field_49845.equals(key)) {
            return;
        }
        class_7225.class_7226 enchantmentLookup = provider.method_46762(class_7924.field_41265);
        Optional equipmentSet = enchantmentLookup.method_46733(EnchiridionTags.EnchantmentTags.TRIAL_CHAMBERS_REWARD_RARE_COMMON);
        builder.modifyPools(poolBuilder -> {
            class_55 previous = poolBuilder.method_355();
            ImmutableList.Builder entries = ImmutableList.builder();
            for (class_79 entry : previous.field_953) {
                if (entry instanceof class_85) {
                    class_85 singletonEntry = (class_85)entry;
                    ImmutableList.Builder functions = ImmutableList.builder();
                    for (class_117 function : ((Accessor_LootPoolSingletonContainer)singletonEntry).enchiridion$getFunctions()) {
                        if (function instanceof class_106) {
                            class_106 levelsFunction = (class_106)function;
                            if (equipmentSet.isPresent()) {
                                functions.add((Object)new class_106.class_107(((Accessor_EnchantWithLevelsFunction)levelsFunction).enchiridion$getLevels()).method_60295((class_6885)equipmentSet.get()).method_515());
                                continue;
                            }
                        }
                        if (function instanceof class_109) {
                            class_109 randomlyFunction = (class_109)function;
                            functions.add((Object)EnchiridionLootTableUtil.addToRandomFunction((class_5321<class_1887>)class_1893.field_9104, (class_7225.class_7226<class_1887>)enchantmentLookup, randomlyFunction, EnchiridionEnchantments.WHIRLPOOL));
                            continue;
                        }
                        functions.add((Object)function);
                    }
                    ((Accessor_LootPoolSingletonContainer)singletonEntry).enchiridion$setFunctions((List<class_117>)functions.build());
                }
                entries.add((Object)entry);
            }
            ((Accessor_LootPoolBuilder)poolBuilder).enchiridion$setEntries((ImmutableList.Builder<class_79>)entries);
        });
    }

    private static void modifyRareOminousVaultRewards(class_5321<class_52> key, class_52.class_53 builder, class_7225.class_7874 provider) {
        if (!class_39.field_50196.equals(key)) {
            return;
        }
        class_7225.class_7226 enchantmentLookup = provider.method_46762(class_7924.field_41265);
        Optional equipmentSet = enchantmentLookup.method_46733(EnchiridionTags.EnchantmentTags.TRIAL_CHAMBERS_REWARD_OMINOUS_RARE_COMMON);
        builder.modifyPools(poolBuilder -> {
            class_55 previous = poolBuilder.method_355();
            ImmutableList.Builder entries = ImmutableList.builder();
            for (class_79 entry : previous.field_953) {
                if (entry instanceof class_85) {
                    class_85 singletonEntry = (class_85)entry;
                    List<class_117> oldFunctions = ((Accessor_LootPoolSingletonContainer)singletonEntry).enchiridion$getFunctions();
                    ImmutableList.Builder functions = ImmutableList.builder();
                    for (class_117 function : oldFunctions) {
                        if (function instanceof class_106) {
                            class_106 levelsFunction = (class_106)function;
                            if (equipmentSet.isPresent()) {
                                functions.add((Object)new class_106.class_107(((Accessor_EnchantWithLevelsFunction)levelsFunction).enchiridion$getLevels()).method_60295((class_6885)equipmentSet.get()).method_515());
                                continue;
                            }
                        }
                        if (function instanceof class_109) {
                            class_109 randomlyFunction = (class_109)function;
                            functions.add((Object)EnchiridionLootTableUtil.addToRandomFunction((class_5321<class_1887>)class_1893.field_9121, (class_7225.class_7226<class_1887>)enchantmentLookup, randomlyFunction, EnchiridionEnchantments.AGILE, EnchiridionEnchantments.COYOTE, EnchiridionEnchantments.LONGSHOT, EnchiridionEnchantments.VAULTING));
                            functions.add((Object)EnchiridionLootTableUtil.addToRandomFunction((class_5321<class_1887>)class_1893.field_50159, (class_7225.class_7226<class_1887>)enchantmentLookup, randomlyFunction, EnchiridionEnchantments.EARTHQUAKE));
                            continue;
                        }
                        functions.add((Object)function);
                    }
                    ((Accessor_LootPoolSingletonContainer)singletonEntry).enchiridion$setFunctions((List<class_117>)functions.build());
                }
                entries.add((Object)entry);
            }
            ((Accessor_LootPoolBuilder)poolBuilder).enchiridion$setEntries((ImmutableList.Builder<class_79>)entries);
            poolBuilder.method_351((class_79.class_80)class_77.method_411((class_1935)class_1802.field_8529).method_437(2).method_438((class_117.class_118)new class_109.class_4954().method_60293((class_6885)class_6885.method_40246((class_6880[])new class_6880[]{enchantmentLookup.method_46747(EnchiridionEnchantments.TAILWIND)}))));
        });
    }

    private static void modifyAncientCityLoot(class_5321<class_52> key, class_52.class_53 builder, class_7225.class_7874 provider) {
        if (!class_39.field_38438.equals(key)) {
            return;
        }
        class_7225.class_7226 enchantmentLookup = provider.method_46762(class_7924.field_41265);
        Optional equipmentSet = enchantmentLookup.method_46733(EnchiridionTags.EnchantmentTags.TRIAL_CHAMBERS_REWARD_OMINOUS_RARE_COMMON);
        builder.modifyPools(poolBuilder -> {
            class_55 previous = poolBuilder.method_355();
            ImmutableList.Builder entries = ImmutableList.builder();
            for (class_79 entry : previous.field_953) {
                if (entry instanceof class_85) {
                    class_85 singletonEntry = (class_85)entry;
                    List<class_117> oldFunctions = ((Accessor_LootPoolSingletonContainer)singletonEntry).enchiridion$getFunctions();
                    ImmutableList.Builder functions = ImmutableList.builder();
                    for (class_117 function : oldFunctions) {
                        if (function instanceof class_106) {
                            class_106 levelsFunction = (class_106)function;
                            if (equipmentSet.isPresent()) {
                                functions.add((Object)new class_106.class_107(((Accessor_EnchantWithLevelsFunction)levelsFunction).enchiridion$getLevels()).method_60295((class_6885)equipmentSet.get()).method_515());
                                continue;
                            }
                        }
                        if (function instanceof class_109) {
                            class_109 randomlyFunction = (class_109)function;
                            functions.add((Object)EnchiridionLootTableUtil.addToRandomFunction((class_5321<class_1887>)class_1893.field_9121, (class_7225.class_7226<class_1887>)enchantmentLookup, randomlyFunction, EnchiridionEnchantments.AGILE, EnchiridionEnchantments.COYOTE, EnchiridionEnchantments.LONGSHOT, EnchiridionEnchantments.VAULTING));
                            functions.add((Object)EnchiridionLootTableUtil.addToRandomFunction((class_5321<class_1887>)class_1893.field_50159, (class_7225.class_7226<class_1887>)enchantmentLookup, randomlyFunction, EnchiridionEnchantments.EARTHQUAKE));
                            continue;
                        }
                        functions.add((Object)function);
                    }
                    ((Accessor_LootPoolSingletonContainer)singletonEntry).enchiridion$setFunctions((List<class_117>)functions.build());
                }
                entries.add((Object)entry);
            }
            ((Accessor_LootPoolBuilder)poolBuilder).enchiridion$setEntries((ImmutableList.Builder<class_79>)entries);
            poolBuilder.method_351((class_79.class_80)class_77.method_411((class_1935)class_1802.field_8529).method_437(2).method_438((class_117.class_118)new class_109.class_4954().method_60293((class_6885)class_6885.method_40246((class_6880[])new class_6880[]{enchantmentLookup.method_46747(EnchiridionEnchantments.TAILWIND)}))));
        });
    }

    @SafeVarargs
    private static class_117 addToRandomFunction(class_5321<class_1887> identityKey, class_7225.class_7226<class_1887> enchantmentLookup, class_109 original, class_5321<class_1887> ... addedEnchantments) {
        Optional<class_6885<class_1887>> options = ((Accessor_EnchantRandomlyFunction)original).enchiridion$getOptions();
        Optional identityHolder = enchantmentLookup.method_46746(identityKey);
        if (options.isEmpty() || identityHolder.isEmpty() || !options.get().method_40241((class_6880)identityHolder.get())) {
            return original;
        }
        Either enchantmentsEither = options.get().method_40248();
        if (enchantmentsEither.right().isEmpty()) {
            return original;
        }
        ArrayList<class_6880.class_6883> enchantments = new ArrayList<class_6880.class_6883>((Collection)enchantmentsEither.right().orElseThrow());
        for (class_5321<class_1887> enchantmentKey : addedEnchantments) {
            enchantments.add(enchantmentLookup.method_46747(enchantmentKey));
        }
        return class_109.method_35520().method_60293((class_6885)class_6885.method_40242(enchantments)).method_515();
    }

    public static void setLootTableResourceManager(class_3300 manager) {
        lootTableResourceManager = manager;
    }
}

