/*
 * Decompiled with CFR 0.152.
 */
package house.greenhouse.enchiridion.util;

import com.google.common.collect.Lists;
import house.greenhouse.enchiridion.Enchiridion;
import house.greenhouse.enchiridion.EnchiridionConfig;
import house.greenhouse.enchiridion.api.enchantment.category.EnchantmentCategory;
import house.greenhouse.enchiridion.api.enchantment.category.ItemEnchantmentCategories;
import house.greenhouse.enchiridion.api.enchantment.provider.EnchantFromTable;
import house.greenhouse.enchiridion.registry.EnchiridionDataComponents;
import house.greenhouse.enchiridion.registry.EnchiridionEnchantmentProviders;
import house.greenhouse.enchiridion.util.EnchantmentInstanceWithCategory;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1887;
import net.minecraft.class_1889;
import net.minecraft.class_1890;
import net.minecraft.class_1936;
import net.minecraft.class_2338;
import net.minecraft.class_3532;
import net.minecraft.class_5321;
import net.minecraft.class_5819;
import net.minecraft.class_6880;
import net.minecraft.class_7924;
import net.minecraft.class_9304;
import net.minecraft.class_9741;

public class EnchantingTableUtil {
    public static int getLevelUpCost(int level, int maxLevel) {
        return (int)((float)level / (float)maxLevel * 25.0f) - (int)((float)(21 - 4 * level) / 3.0f);
    }

    public static int getMinimumBookshelfAmountForLevelling(int level, int maxLevel) {
        return (int)((float)level / (float)maxLevel * 15.0f) - (int)((float)(15.0 - 2.7 * (double)level) / 3.0f);
    }

    public static int getLapisCountForLevelling(int level, int maxLevel) {
        return Math.max(1, (int)((float)level / (float)maxLevel * (float)Math.min(maxLevel, 3)));
    }

    public static int getEnchantmentCost(int value) {
        return Math.round((float)value * ((EnchiridionConfig)Enchiridion.CONFIG.getOrThrow()).enchantingTable().costLogic().costMultiplier());
    }

    public static int getEnchantmentEffectiveness(int value) {
        return Math.round((float)value / ((EnchiridionConfig)Enchiridion.CONFIG.getOrThrow()).enchantingTable().costLogic().costMultiplier() * ((EnchiridionConfig)Enchiridion.CONFIG.getOrThrow()).enchantingTable().costLogic().effectivenessMultiplier());
    }

    public static List<class_1889> getEnchantments(class_5819 random, class_1936 levelAccessor, class_2338 pos, class_1799 stack, int slot, int cost, int enchantmentSeed) {
        random.method_43052((long)(enchantmentSeed + slot));
        List<class_1889> list = EnchantingTableUtil.selectEnchantment(random, levelAccessor, stack, cost, pos);
        if (stack.method_31574(class_1802.field_8529) && list.size() > 1) {
            list.remove(random.method_43048(list.size()));
        }
        return list;
    }

    private static List<class_1889> selectEnchantment(class_5819 random, class_1936 levelAccessor, class_1799 stack, int level, class_2338 pos) {
        ArrayList list = Lists.newArrayList();
        class_1792 item = stack.method_7909();
        int i = item.method_7837();
        if (i <= 0) {
            return list;
        }
        level += 1 + random.method_43048(i / 4 + 1) + random.method_43048(i / 4 + 1);
        float f = (random.method_43057() + random.method_43057() - 1.0f) * 0.15f;
        level = class_3532.method_15340((int)Math.round((float)level + (float)level * f), (int)1, (int)Integer.MAX_VALUE);
        class_5321<class_9741> providerKey = EnchiridionEnchantmentProviders.ENCHANTING_LOW_LEVEL;
        if (level > EnchantingTableUtil.getEnchantmentEffectiveness(((EnchiridionConfig)Enchiridion.CONFIG.getOrThrow()).enchantingTable().costLogic().highLevelMin())) {
            providerKey = EnchiridionEnchantmentProviders.ENCHANTING_HIGH_LEVEL;
        } else if (level > EnchantingTableUtil.getEnchantmentEffectiveness(((EnchiridionConfig)Enchiridion.CONFIG.getOrThrow()).enchantingTable().costLogic().mediumLevelMin())) {
            providerKey = EnchiridionEnchantmentProviders.ENCHANTING_MEDIUM_LEVEL;
        }
        Optional provider = levelAccessor.method_30349().method_30530(class_7924.field_51839).method_40264(providerKey);
        if (provider.isEmpty()) {
            return list;
        }
        Object object = ((class_6880.class_6883)provider.get()).comp_349();
        if (object instanceof EnchantFromTable) {
            EnchantFromTable enchantingTableProvider = (EnchantFromTable)object;
            enchantingTableProvider.setLevel(level);
        }
        class_1799 copied = stack.method_7972();
        class_1890.method_57531((class_1799)copied, mutable -> ((class_9741)((class_6880.class_6883)provider.get()).comp_349()).method_60266(copied, mutable, random, levelAccessor.method_8404(pos)));
        class_9304 originalEnchantments = class_1890.method_57532((class_1799)stack);
        class_9304 newEnchantments = class_1890.method_57532((class_1799)copied);
        for (Object2IntMap.Entry entry : newEnchantments.method_57539()) {
            if (originalEnchantments.method_57536((class_6880)entry.getKey()) >= entry.getIntValue()) continue;
            class_6880<EnchantmentCategory> category = ((ItemEnchantmentCategories)copied.method_57825(EnchiridionDataComponents.ENCHANTMENT_CATEGORIES, (Object)ItemEnchantmentCategories.EMPTY)).findFirstCategory((class_6880<class_1887>)((class_6880)entry.getKey()));
            if (category != null) {
                list.add(new EnchantmentInstanceWithCategory((class_6880<class_1887>)((class_6880)entry.getKey()), entry.getIntValue(), category));
                continue;
            }
            list.add(new class_1889((class_6880)entry.getKey(), entry.getIntValue()));
        }
        return list;
    }
}

