/*
 * Decompiled with CFR 0.152.
 */
package house.greenhouse.enchiridion.api.datagen.recipe;

import house.greenhouse.enchiridion.api.enchantment.category.EnchantmentCategory;
import house.greenhouse.enchiridion.recipe.SiphoningRecipe;
import house.greenhouse.enchiridion.registry.EnchiridionItems;
import house.greenhouse.enchiridion.util.SiphoningBookCategory;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementRequirements;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.critereon.InventoryChangeTrigger;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.advancements.critereon.RecipeUnlockedTrigger;
import net.minecraft.core.Holder;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.Nullable;

public class SiphoningRecipeBuilder {
    private final List<SiphoningRecipe.IngredientWithAmount> ingredients;
    private final int experienceCost;
    private final int time;
    private final Map<Holder<EnchantmentCategory>, ItemEnchantments> enchantments = new HashMap<Holder<EnchantmentCategory>, ItemEnchantments>();
    private final Map<String, Criterion<?>> criteria = new LinkedHashMap();
    private SiphoningBookCategory category = SiphoningBookCategory.TOOLS;
    @Nullable
    private String group;

    public SiphoningRecipeBuilder(List<SiphoningRecipe.IngredientWithAmount> ingredients, int experienceCost, int time) {
        this.ingredients = ingredients;
        this.experienceCost = experienceCost;
        this.time = time;
    }

    public static SiphoningRecipeBuilder siphoning(Ingredient ingredient, int ingredientCount, int lapisCount) {
        return SiphoningRecipeBuilder.siphoning(ingredient, ingredientCount, lapisCount, 5);
    }

    public static SiphoningRecipeBuilder siphoning(Ingredient ingredient, int ingredientCount, int lapisCount, int experienceCost) {
        return SiphoningRecipeBuilder.siphoning(ingredient, ingredientCount, lapisCount, experienceCost, 4800);
    }

    public static SiphoningRecipeBuilder siphoning(Ingredient ingredient, int ingredientCount, int lapisCount, int experienceCost, int time) {
        return new SiphoningRecipeBuilder(List.of(new SiphoningRecipe.IngredientWithAmount(ingredient, ingredientCount), new SiphoningRecipe.IngredientWithAmount(Ingredient.of((ItemLike[])new ItemLike[]{Items.LAPIS_LAZULI}), lapisCount)), experienceCost, time);
    }

    public SiphoningRecipeBuilder withGroup(String group) {
        this.group = group;
        return this;
    }

    public SiphoningRecipeBuilder withCategory(SiphoningBookCategory category) {
        this.category = category;
        return this;
    }

    public SiphoningRecipeBuilder enchantment(Holder<EnchantmentCategory> category, Holder<Enchantment> enchantment, int level) {
        this.enchantments.compute(category, (categoryHolder, enchantments) -> {
            ItemEnchantments.Mutable mutable = new ItemEnchantments.Mutable(enchantments != null ? enchantments : ItemEnchantments.EMPTY);
            mutable.set(enchantment, level);
            return mutable.toImmutable();
        });
        return this;
    }

    public SiphoningRecipeBuilder unlocksWithSiphoningTable() {
        return this.unlocksWithItem((Item)EnchiridionItems.SIPHONING_TABLE);
    }

    public SiphoningRecipeBuilder unlocksWithItem(Item item) {
        return this.unlocks("has_" + item.builtInRegistryHolder().key().location().getPath(), InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{item}));
    }

    public SiphoningRecipeBuilder unlocksWithTag(TagKey<Item> tag) {
        return this.unlocks("has_" + tag.location().getPath(), InventoryChangeTrigger.TriggerInstance.hasItems((ItemPredicate.Builder[])new ItemPredicate.Builder[]{ItemPredicate.Builder.item().of(tag)}));
    }

    public SiphoningRecipeBuilder unlocks(String key, Criterion<?> criterion) {
        this.criteria.put(key, criterion);
        return this;
    }

    public void save(RecipeOutput output, ResourceLocation recipeId) {
        this.ensureValid(recipeId);
        Advancement.Builder advancement$builder = output.advancement().addCriterion("has_the_recipe", RecipeUnlockedTrigger.unlocked((ResourceLocation)recipeId)).rewards(AdvancementRewards.Builder.recipe((ResourceLocation)recipeId)).requirements(AdvancementRequirements.Strategy.OR);
        this.criteria.forEach((arg_0, arg_1) -> ((Advancement.Builder)advancement$builder).addCriterion(arg_0, arg_1));
        SiphoningRecipe recipe = new SiphoningRecipe(this.group != null ? this.group : (this.enchantments.size() == 1 && this.enchantments.values().stream().flatMap(enchantments1 -> enchantments1.entrySet().stream()).toList().size() == 1 ? ((Holder)((Object2IntMap.Entry)((ItemEnchantments)((Map.Entry)this.enchantments.entrySet().stream().findFirst().orElseThrow()).getValue()).entrySet().stream().findFirst().orElseThrow()).getKey()).getRegisteredName() : null), this.category, this.ingredients, this.enchantments, this.experienceCost, this.time);
        output.accept(recipeId.withPrefix("siphoning/"), (Recipe)recipe, advancement$builder.build(recipeId.withPrefix("recipes/siphoning/" + this.category.getSerializedName() + "/")));
    }

    private void ensureValid(ResourceLocation location) {
        if (this.criteria.isEmpty()) {
            throw new IllegalStateException("No way of obtaining recipe " + String.valueOf(location));
        }
        if (this.enchantments.isEmpty()) {
            throw new IllegalStateException("No enchantments in result for recipe " + String.valueOf(location));
        }
    }
}

