/*
 * Decompiled with CFR 0.152.
 */
package house.greenhouse.enchiridion.api.enchantment.category;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.TextColor;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import org.jetbrains.annotations.Nullable;

public record CategoryVisuals(TextColor textColor, TextColor bookColor, @Nullable Float itemModelIndex) {
    public static final Codec<CategoryVisuals> DIRECT_CODEC = RecordCodecBuilder.create(inst -> inst.group((App)TextColor.CODEC.optionalFieldOf("color").forGetter(visuals -> {
        if (visuals.textColor != null && visuals.textColor.equals((Object)visuals.bookColor)) {
            return Optional.of(visuals.textColor);
        }
        return Optional.empty();
    }), (App)TextColor.CODEC.optionalFieldOf("text_color").dependent(TextColor.CODEC.optionalFieldOf("color"), textColor -> Pair.of(Optional.empty(), (Object)TextColor.CODEC.optionalFieldOf("color")), (textColor, color) -> {
        if (textColor.isPresent()) {
            return textColor;
        }
        return color;
    }).forGetter(visuals -> {
        if (visuals.textColor != null && !visuals.textColor.equals((Object)visuals.bookColor)) {
            return Optional.of(visuals.textColor);
        }
        return Optional.empty();
    }), (App)TextColor.CODEC.optionalFieldOf("book_color").dependent(TextColor.CODEC.optionalFieldOf("color"), bookColor -> Pair.of(Optional.empty(), (Object)TextColor.CODEC.optionalFieldOf("color")), (bookColor, color) -> {
        if (bookColor.isPresent()) {
            return bookColor;
        }
        return color;
    }).forGetter(visuals -> {
        if (visuals.bookColor != null && !visuals.bookColor.equals((Object)visuals.textColor)) {
            return Optional.of(visuals.bookColor);
        }
        return Optional.empty();
    }), (App)Codec.FLOAT.optionalFieldOf("item_model_index").forGetter(CategoryVisuals::getItemModelIndex)).apply((Applicative)inst, (color, textColor, bookColor, itemModelIndex) -> new CategoryVisuals(textColor.orElse(null), bookColor.orElse(null), itemModelIndex.orElse(null))));
    public static final Codec<CategoryVisuals> CODEC = Codec.either((Codec)TextColor.CODEC, DIRECT_CODEC).xmap(either -> (CategoryVisuals)either.map(CategoryVisuals::new, Function.identity()), visuals -> {
        if (visuals.textColor() != null && visuals.textColor().equals((Object)visuals.bookColor()) && visuals.itemModelIndex == null) {
            return Either.left((Object)visuals.textColor());
        }
        return Either.right((Object)visuals);
    });
    public static final StreamCodec<FriendlyByteBuf, CategoryVisuals> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.fromCodec((Codec)TextColor.CODEC), CategoryVisuals::textColor, (StreamCodec)ByteBufCodecs.fromCodec((Codec)TextColor.CODEC), CategoryVisuals::bookColor, (StreamCodec)ByteBufCodecs.optional((StreamCodec)ByteBufCodecs.FLOAT), CategoryVisuals::getItemModelIndex, (textColor, bookColor, itemModelIndex) -> new CategoryVisuals((TextColor)textColor, (TextColor)bookColor, itemModelIndex.orElse(null)));

    public CategoryVisuals(TextColor textColor) {
        this(textColor, textColor, null);
    }

    public CategoryVisuals(TextColor textColor, float itemModelIndex) {
        this(textColor, null, Float.valueOf(itemModelIndex));
    }

    private Optional<Float> getItemModelIndex() {
        return Optional.ofNullable(this.itemModelIndex);
    }
}

