/*
 * Decompiled with CFR 0.152.
 */
package house.greenhouse.enchiridion.api.enchantment.effect;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import house.greenhouse.enchiridion.Enchiridion;
import house.greenhouse.enchiridion.api.enchantment.effect.entity.common.AllOfSidedEnchantmentEntityEffect;
import house.greenhouse.enchiridion.api.enchantment.effect.entity.common.SidedEnchantmentEntityEffectInstance;
import house.greenhouse.enchiridion.api.enchantment.effect.entity.common.VanillaEnchantmentEntityEffectWrapper;
import house.greenhouse.enchiridion.api.util.Side;
import house.greenhouse.enchiridion.network.clientbound.SyncClientEnchantmentEntityEffectsClientboundPacket;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.ConditionalEffect;
import net.minecraft.world.item.enchantment.EnchantedItemInUse;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.effects.EnchantmentEntityEffect;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSet;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class ConditionalSidedEnchantmentEntityEffect {
    public static final Codec<Map<DataComponentType<?>, List<Pair<SidedEnchantmentEntityEffectInstance, Integer>>>> CLIENT_ATTACHMENT_CODEC = Codec.unboundedMap((Codec)BuiltInRegistries.DATA_COMPONENT_TYPE.byNameCodec(), (Codec)Codec.pair(SidedEnchantmentEntityEffectInstance.CODEC, (Codec)Codec.INT).listOf());
    public static final StreamCodec<RegistryFriendlyByteBuf, Pair<SidedEnchantmentEntityEffectInstance, Integer>> INSTANCE_WITH_LEVEL_STREAM_CODEC = StreamCodec.composite(SidedEnchantmentEntityEffectInstance.STREAM_CODEC, Pair::getFirst, (StreamCodec)ByteBufCodecs.INT, Pair::getSecond, Pair::of);
    public static final StreamCodec<RegistryFriendlyByteBuf, Map<DataComponentType<?>, List<Pair<SidedEnchantmentEntityEffectInstance, Integer>>>> CLIENT_ATTACHMENT_STREAM_CODEC = ByteBufCodecs.map(Object2ObjectArrayMap::new, (StreamCodec)ByteBufCodecs.registry((ResourceKey)Registries.ENCHANTMENT_EFFECT_COMPONENT_TYPE), (StreamCodec)INSTANCE_WITH_LEVEL_STREAM_CODEC.apply(ByteBufCodecs.list()));
    private final SidedEnchantmentEntityEffectInstance effect;
    @Nullable
    private final LootItemCondition requirements;
    @Nullable
    private final Side side;
    private boolean previousValue = false;

    public ConditionalSidedEnchantmentEntityEffect(SidedEnchantmentEntityEffectInstance effect, @Nullable LootItemCondition requirements, @Nullable Side side) {
        this.requirements = requirements;
        this.effect = effect;
        this.side = side;
    }

    public static Codec<ConditionalSidedEnchantmentEntityEffect> codec(LootContextParamSet params) {
        return RecordCodecBuilder.create(inst -> inst.group((App)SidedEnchantmentEntityEffectInstance.CODEC.fieldOf("effect").forGetter(ConditionalSidedEnchantmentEntityEffect::effect), (App)ConditionalEffect.conditionCodec((LootContextParamSet)params).optionalFieldOf("requirements").forGetter(ConditionalSidedEnchantmentEntityEffect::requirements), (App)Side.CODEC.optionalFieldOf("side").forGetter(ConditionalSidedEnchantmentEntityEffect::side)).apply((Applicative)inst, (t1, t2, t3) -> new ConditionalSidedEnchantmentEntityEffect((SidedEnchantmentEntityEffectInstance)t1, t2.orElse(null), t3.orElse(null)))).validate(eff -> {
            if (eff.side().isPresent() && !eff.effect().validSides().contains((Object)eff.side().get())) {
                return DataResult.error(() -> "Side " + eff.side().orElseThrow().getSerializedName() + " is invalid for effect class: " + eff.effect.getClass().getCanonicalName());
            }
            return DataResult.success((Object)eff);
        });
    }

    public static ConditionalSidedEnchantmentEntityEffect client(SidedEnchantmentEntityEffectInstance effect, LootItemCondition.Builder requirements) {
        return new ConditionalSidedEnchantmentEntityEffect(effect, requirements.build(), Side.CLIENT);
    }

    public static ConditionalSidedEnchantmentEntityEffect server(SidedEnchantmentEntityEffectInstance effect, LootItemCondition.Builder requirements) {
        return new ConditionalSidedEnchantmentEntityEffect(effect, requirements.build(), Side.SERVER);
    }

    public static ConditionalSidedEnchantmentEntityEffect vanilla(EnchantmentEntityEffect effect, LootItemCondition.Builder requirements) {
        return new ConditionalSidedEnchantmentEntityEffect(new VanillaEnchantmentEntityEffectWrapper(effect), requirements.build(), Side.SERVER);
    }

    public static ConditionalSidedEnchantmentEntityEffect allOf(List<SidedEnchantmentEntityEffectInstance> effects, LootItemCondition.Builder requirements) {
        return new ConditionalSidedEnchantmentEntityEffect(new AllOfSidedEnchantmentEntityEffect(effects), requirements.build(), null);
    }

    @SafeVarargs
    public static void tickConditionsWithEntityParamSet(LivingEntity entity, Vec3 pos, DataComponentType<List<ConditionalSidedEnchantmentEntityEffect>> ... effectComponents) {
        Level level = entity.level();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        boolean sync = false;
        Map<DataComponentType<?>, List<Pair<SidedEnchantmentEntityEffectInstance, Integer>>> map = Enchiridion.getHelper().getClientEntityEffectComponents((Entity)entity);
        for (DataComponentType<List<ConditionalSidedEnchantmentEntityEffect>> effectComponent : effectComponents) {
            int previousSize = map.getOrDefault(effectComponent, Collections.emptyList()).size();
            map.remove(effectComponent);
            for (EquipmentSlot slot : EquipmentSlot.values()) {
                ItemStack stack = entity.getItemBySlot(slot);
                if (Enchiridion.getHelper().getEnchantments((HolderLookup.RegistryLookup<Enchantment>)entity.level().registryAccess().lookupOrThrow(Registries.ENCHANTMENT), stack).isEmpty()) continue;
                for (Pair effect : Enchiridion.getHelper().getEnchantments((HolderLookup.RegistryLookup<Enchantment>)entity.level().registryAccess().lookupOrThrow(Registries.ENCHANTMENT), stack).entrySet().stream().filter(entry -> ((Holder)entry.getKey()).isBound()).flatMap(entry -> ((Enchantment)((Holder)entry.getKey()).value()).getEffects(effectComponent).stream().map(effects -> Pair.of((Object)entry, (Object)effects))).toList()) {
                    boolean currentValue;
                    boolean previousValue = ((ConditionalSidedEnchantmentEntityEffect)effect.getSecond()).previousValue;
                    boolean bl = currentValue = ((ConditionalSidedEnchantmentEntityEffect)effect.getSecond()).requirements == null;
                    if (!currentValue) {
                        LootParams params = new LootParams.Builder(serverLevel).withParameter(LootContextParams.THIS_ENTITY, (Object)entity).withParameter(LootContextParams.ORIGIN, (Object)pos).withParameter(LootContextParams.ENCHANTMENT_LEVEL, (Object)((Object2IntMap.Entry)effect.getFirst()).getIntValue()).create(LootContextParamSets.ENCHANTED_ENTITY);
                        currentValue = ((ConditionalSidedEnchantmentEntityEffect)effect.getSecond()).requirements.test((Object)new LootContext.Builder(params).create(Optional.empty()));
                    }
                    if (currentValue) {
                        map.compute(effectComponent, (component, instances) -> {
                            if (instances == null) {
                                instances = new ArrayList<Pair>();
                            }
                            instances.add(Pair.of((Object)((ConditionalSidedEnchantmentEntityEffect)effect.getSecond()).effect(), (Object)((Object2IntMap.Entry)effect.getFirst()).getIntValue()));
                            return instances;
                        });
                    }
                    if (previousValue != currentValue) {
                        sync = true;
                    }
                    ((ConditionalSidedEnchantmentEntityEffect)effect.getSecond()).previousValue = currentValue;
                }
            }
            if (previousSize == map.getOrDefault(effectComponent, Collections.emptyList()).size()) continue;
            sync = true;
        }
        if (sync) {
            Enchiridion.getHelper().setClientEntityEffectComponents((Entity)entity, map);
            Enchiridion.getHelper().sendClientboundTracking((Entity)entity, new SyncClientEnchantmentEntityEffectsClientboundPacket(entity.getId(), map));
        }
    }

    public static void clientApply(DataComponentType<?> componentType, Entity entity, EnchantedItemInUse enchantedItemInUse, Level level, Vec3 origin) {
        for (Pair<SidedEnchantmentEntityEffectInstance, Integer> inst : Enchiridion.getHelper().getClientEntityEffectComponents(entity, componentType)) {
            ((SidedEnchantmentEntityEffectInstance)inst.getFirst()).apply(level, (Integer)inst.getSecond(), enchantedItemInUse, entity, origin);
        }
    }

    public static void removeAllOfType(DataComponentType<?> componentType, Entity entity) {
        HashMap newMap = new HashMap(Enchiridion.getHelper().getClientEntityEffectComponents(entity));
        newMap.remove(componentType);
        Enchiridion.getHelper().setClientEntityEffectComponents(entity, newMap);
    }

    public SidedEnchantmentEntityEffectInstance effect() {
        return this.effect;
    }

    public Optional<LootItemCondition> requirements() {
        return Optional.ofNullable(this.requirements);
    }

    public Optional<Side> side() {
        return Optional.ofNullable(this.side);
    }

    public boolean validOnSide(Side side) {
        return this.effect.validSides().contains((Object)side) && (this.side == null || this.side == side);
    }

    public boolean matches(LootContext context) {
        return this.requirements == null || this.requirements.test((Object)context);
    }

    public void apply(Level level, int enchantmentLevel, EnchantedItemInUse enchantedItemInUse, Entity entity, Vec3 origin) {
        if (level.isClientSide() && this.validOnSide(Side.CLIENT) || !level.isClientSide() && this.validOnSide(Side.SERVER)) {
            this.effect.apply(level, enchantmentLevel, enchantedItemInUse, entity, origin);
        }
    }
}

