/*
 * Decompiled with CFR 0.152.
 */
package house.greenhouse.enchiridion.api.enchantment.effect;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import house.greenhouse.enchiridion.Enchiridion;
import house.greenhouse.enchiridion.api.registry.EnchiridionEnchantmentEffectComponents;
import house.greenhouse.enchiridion.network.clientbound.SyncSprintDirectionsClientboundPacket;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.ConditionalEffect;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;

public record DirectionalSprintEffect(List<Direction> relativeDirections) {
    public static final List<Direction> DEFAULT = List.of(Direction.NORTH);
    public static final Codec<DirectionalSprintEffect> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)Direction.CODEC.listOf().comapFlatMap(directions -> {
        if (directions.stream().anyMatch(direction -> direction.getAxis().isVertical())) {
            return DataResult.error(() -> "DirectionalSprintEffect does not support vertical directions.");
        }
        return DataResult.success((Object)directions);
    }, Function.identity()).fieldOf("relative_directions").forGetter(DirectionalSprintEffect::relativeDirections)).apply((Applicative)inst, DirectionalSprintEffect::new));

    public static void serverTick(ServerPlayer entity) {
        if (entity.level().isClientSide()) {
            return;
        }
        boolean hasEffect = false;
        ArrayList<Direction> directions = new ArrayList<Direction>();
        LootParams.Builder params = new LootParams.Builder((ServerLevel)entity.level());
        params.withParameter(LootContextParams.THIS_ENTITY, (Object)entity);
        params.withParameter(LootContextParams.ORIGIN, (Object)entity.position());
        for (EquipmentSlot slot : EquipmentSlot.values()) {
            ItemStack stack = entity.getItemBySlot(slot);
            for (Object2IntMap.Entry entry2 : Enchiridion.getHelper().getEnchantments((HolderLookup.RegistryLookup<Enchantment>)entity.level().registryAccess().lookupOrThrow(Registries.ENCHANTMENT), stack).entrySet().stream().filter(entry -> ((Holder)entry.getKey()).isBound() && !((Enchantment)((Holder)entry.getKey()).value()).getEffects(EnchiridionEnchantmentEffectComponents.DIRECTIONAL_SPRINT).isEmpty() && ((Enchantment)((Holder)entry.getKey()).value()).matchingSlot(slot)).toList()) {
                hasEffect = true;
                Holder enchantment = (Holder)entry2.getKey();
                params.withParameter(LootContextParams.ENCHANTMENT_LEVEL, (Object)entry2.getIntValue());
                LootContext context = new LootContext.Builder(params.create(LootContextParamSets.ENCHANTED_ENTITY)).create(Optional.empty());
                for (ConditionalEffect effect : ((Enchantment)enchantment.value()).getEffects(EnchiridionEnchantmentEffectComponents.DIRECTIONAL_SPRINT)) {
                    if (!effect.matches(context)) continue;
                    directions.addAll(((DirectionalSprintEffect)effect.effect()).relativeDirections());
                }
            }
        }
        if (!hasEffect) {
            if (Enchiridion.getHelper().hasSprintDirectionAttachment((Entity)entity)) {
                Enchiridion.getHelper().removeSprintDirections((Entity)entity);
                Enchiridion.getHelper().sendClientbound(entity, new SyncSprintDirectionsClientboundPacket(entity.getId(), List.of(), true));
            }
            return;
        }
        Enchiridion.getHelper().setAbleToSprintInDirection((Entity)entity, directions);
        Enchiridion.getHelper().sendClientbound(entity, new SyncSprintDirectionsClientboundPacket(entity.getId(), directions, false));
    }
}

