/*
 * Decompiled with CFR 0.152.
 */
package house.greenhouse.enchiridion.api.enchantment.effect;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import house.greenhouse.enchiridion.Enchiridion;
import house.greenhouse.enchiridion.api.registry.EnchiridionEnchantmentEffectComponents;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;

public record PreventHungerConsumptionEffect(boolean sprinting, boolean mining, boolean jumping) {
    public static final Codec<PreventHungerConsumptionEffect> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)Codec.BOOL.optionalFieldOf("sprinting", (Object)false).forGetter(PreventHungerConsumptionEffect::sprinting), (App)Codec.BOOL.optionalFieldOf("mining", (Object)false).forGetter(PreventHungerConsumptionEffect::mining), (App)Codec.BOOL.optionalFieldOf("jumping", (Object)false).forGetter(PreventHungerConsumptionEffect::jumping)).apply((Applicative)inst, PreventHungerConsumptionEffect::new));

    public static boolean shouldPreventSprintingConsumption(LivingEntity entity) {
        Level level = entity.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            LootParams.Builder params = new LootParams.Builder(serverLevel).withParameter(LootContextParams.THIS_ENTITY, (Object)entity).withParameter(LootContextParams.ORIGIN, (Object)entity.position());
            for (EquipmentSlot slot : EquipmentSlot.values()) {
                boolean bl = Enchiridion.getHelper().getEnchantments((HolderLookup.RegistryLookup<Enchantment>)entity.registryAccess().lookupOrThrow(Registries.ENCHANTMENT), entity.getItemBySlot(slot)).entrySet().stream().anyMatch(entry -> ((Holder)entry.getKey()).isBound() && ((Enchantment)((Holder)entry.getKey()).value()).matchingSlot(slot) && ((Enchantment)((Holder)entry.getKey()).value()).getEffects(EnchiridionEnchantmentEffectComponents.PREVENT_HUNGER_CONSUMPTION).stream().anyMatch(effect -> {
                    if (!((PreventHungerConsumptionEffect)effect.effect()).jumping()) {
                        return false;
                    }
                    params.withParameter(LootContextParams.ENCHANTMENT_LEVEL, (Object)entry.getIntValue());
                    return effect.matches(new LootContext.Builder(params.create(LootContextParamSets.ENCHANTED_ENTITY)).create(Optional.empty()));
                }));
                if (!bl) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean shouldPreventMiningConsumption(ItemStack stack, Player player, BlockPos blockPos) {
        Level level = player.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            LootParams.Builder params = new LootParams.Builder(serverLevel).withParameter(LootContextParams.THIS_ENTITY, (Object)player).withParameter(LootContextParams.ORIGIN, (Object)blockPos.getCenter());
            return Enchiridion.getHelper().getEnchantments((HolderLookup.RegistryLookup<Enchantment>)player.level().registryAccess().lookupOrThrow(Registries.ENCHANTMENT), stack).entrySet().stream().anyMatch(entry -> ((Holder)entry.getKey()).isBound() && ((Enchantment)((Holder)entry.getKey()).value()).getEffects(EnchiridionEnchantmentEffectComponents.PREVENT_HUNGER_CONSUMPTION).stream().anyMatch(effect -> {
                if (!((PreventHungerConsumptionEffect)effect.effect()).mining()) {
                    return false;
                }
                params.withParameter(LootContextParams.ENCHANTMENT_LEVEL, (Object)entry.getIntValue());
                return effect.matches(new LootContext.Builder(params.create(LootContextParamSets.ENCHANTED_ENTITY)).create(Optional.empty()));
            }));
        }
        return false;
    }

    public static boolean shouldPreventJumpingConsumption(LivingEntity entity) {
        Level level = entity.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            LootParams.Builder params = new LootParams.Builder(serverLevel).withParameter(LootContextParams.THIS_ENTITY, (Object)entity).withParameter(LootContextParams.ORIGIN, (Object)entity.position());
            for (EquipmentSlot slot : EquipmentSlot.values()) {
                boolean bl = Enchiridion.getHelper().getEnchantments((HolderLookup.RegistryLookup<Enchantment>)entity.registryAccess().lookupOrThrow(Registries.ENCHANTMENT), entity.getItemBySlot(slot)).entrySet().stream().anyMatch(entry -> ((Holder)entry.getKey()).isBound() && ((Enchantment)((Holder)entry.getKey()).value()).matchingSlot(slot) && ((Enchantment)((Holder)entry.getKey()).value()).getEffects(EnchiridionEnchantmentEffectComponents.PREVENT_HUNGER_CONSUMPTION).stream().anyMatch(effect -> {
                    if (!((PreventHungerConsumptionEffect)effect.effect()).jumping()) {
                        return false;
                    }
                    params.withParameter(LootContextParams.ENCHANTMENT_LEVEL, (Object)entry.getIntValue());
                    return effect.matches(new LootContext.Builder(params.create(LootContextParamSets.ENCHANTED_ENTITY)).create(Optional.empty()));
                }));
                if (!bl) continue;
                return true;
            }
        }
        return false;
    }
}

