/*
 * Decompiled with CFR 0.152.
 */
package house.greenhouse.enchiridion.api.enchantment.effect;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.enchantment.effects.EnchantmentValueEffect;
import net.minecraft.world.phys.Vec3;

public record ProjectileTrajectoryEffect(Optional<EnchantmentValueEffect> x, Optional<EnchantmentValueEffect> y, Optional<EnchantmentValueEffect> z) {
    private static final Codec<ProjectileTrajectoryEffect> DIRECT_CODEC = RecordCodecBuilder.create(inst -> inst.group((App)EnchantmentValueEffect.CODEC.optionalFieldOf("x").forGetter(ProjectileTrajectoryEffect::x), (App)EnchantmentValueEffect.CODEC.optionalFieldOf("y").forGetter(ProjectileTrajectoryEffect::y), (App)EnchantmentValueEffect.CODEC.optionalFieldOf("z").forGetter(ProjectileTrajectoryEffect::z)).apply((Applicative)inst, ProjectileTrajectoryEffect::new));
    public static final Codec<ProjectileTrajectoryEffect> CODEC = DIRECT_CODEC.validate(effect -> {
        if (effect.x().isEmpty() && effect.y().isEmpty() && effect.z().isEmpty()) {
            return DataResult.error(() -> "ProjectileTrajectoryEffect must have at least one of the following fields: 'x', 'y', or 'z'.");
        }
        return DataResult.success((Object)effect);
    });

    public Vec3 modifyTrajectory(Vec3 original, int enchantmentLevel, RandomSource random) {
        return new Vec3(this.x.map(xEffect -> xEffect.process(enchantmentLevel, random, (float)original.x())).orElse(original.x()).doubleValue(), this.y.map(yEffect -> yEffect.process(enchantmentLevel, random, (float)original.y())).orElse(original.y()).doubleValue(), this.z.map(zEffect -> zEffect.process(enchantmentLevel, random, (float)original.z())).orElse(original.z()).doubleValue());
    }
}

