/*
 * Decompiled with CFR 0.152.
 */
package house.greenhouse.enchiridion.api.enchantment.effect;

import com.mojang.serialization.Codec;
import java.util.List;
import java.util.function.Function;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.entity.Entity;
import org.jetbrains.annotations.NotNull;

public enum RidingTarget implements StringRepresentable
{
    THIS("this", List::of),
    PASSENGER("passenger", entity -> entity.getFirstPassenger() == null ? List.of() : List.of(entity.getFirstPassenger())),
    ALL_PASSENGERS("passengers", Entity::getPassengers),
    VEHICLE("vehicle", entity -> entity.getVehicle() == null ? List.of() : List.of(entity.getVehicle()));

    public static final Codec<RidingTarget> CODEC;
    private final String name;
    private final Function<Entity, List<Entity>> getter;

    private RidingTarget(String name, Function<Entity, List<Entity>> getter) {
        this.name = name;
        this.getter = getter;
    }

    public List<Entity> getEntities(Entity entity) {
        return this.getter.apply(entity);
    }

    @NotNull
    public String getSerializedName() {
        return this.name;
    }

    static {
        CODEC = StringRepresentable.fromEnum(RidingTarget::values);
    }
}

