/*
 * Decompiled with CFR 0.152.
 */
package house.greenhouse.enchiridion.api.enchantment.effect.entity;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.enchantment.EnchantedItemInUse;
import net.minecraft.world.item.enchantment.LevelBasedValue;
import net.minecraft.world.item.enchantment.effects.EnchantmentEntityEffect;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public record ApplyCooldownEffect(LevelBasedValue time) implements EnchantmentEntityEffect
{
    public static final MapCodec<ApplyCooldownEffect> CODEC = RecordCodecBuilder.mapCodec(inst -> inst.group((App)LevelBasedValue.CODEC.optionalFieldOf("time", (Object)LevelBasedValue.constant((float)1.0f)).forGetter(ApplyCooldownEffect::time)).apply((Applicative)inst, ApplyCooldownEffect::new));

    public void apply(@NotNull ServerLevel serverLevel, int enchantmentLevel, @NotNull EnchantedItemInUse item, @NotNull Entity entity, @NotNull Vec3 vec3) {
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        player.getCooldowns().addCooldown(item.itemStack().getItem(), Mth.floor((float)this.time.calculate(enchantmentLevel)));
    }

    @NotNull
    public MapCodec<? extends EnchantmentEntityEffect> codec() {
        return CODEC;
    }
}

