/*
 * Decompiled with CFR 0.152.
 */
package house.greenhouse.enchiridion.api.enchantment.effect.entity;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.CompressorHolder;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.Lifecycle;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.MapDecoder;
import com.mojang.serialization.MapEncoder;
import com.mojang.serialization.MapLike;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import house.greenhouse.enchiridion.mixin.Accessor_RegistryOps;
import house.greenhouse.enchiridion.util.EnchiridionCodecs;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.enchantment.EnchantedItemInUse;
import net.minecraft.world.item.enchantment.LevelBasedValue;
import net.minecraft.world.item.enchantment.effects.EnchantmentEntityEffect;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.phys.Vec3;

public record RaycastReplaceDiskEffect(LevelBasedValue radius, LevelBasedValue height, Vec3 direction, ClipContext.Block blockContext, ClipContext.Fluid fluidContext, Optional<BlockPredicate> predicate, BlockStateProvider blockState, Optional<CompoundTag> blockEntityTag, Optional<Holder<GameEvent>> triggerGameEvent) implements EnchantmentEntityEffect
{
    public static final MapCodec<RaycastReplaceDiskEffect> CODEC = RecordCodecBuilder.mapCodec(inst -> inst.group((App)LevelBasedValue.CODEC.fieldOf("radius").forGetter(RaycastReplaceDiskEffect::radius), (App)LevelBasedValue.CODEC.fieldOf("height").forGetter(RaycastReplaceDiskEffect::height), (App)Vec3.CODEC.fieldOf("direction").forGetter(RaycastReplaceDiskEffect::direction), (App)EnchiridionCodecs.BLOCK_RAYCAST_CONTEXT_CODEC.optionalFieldOf("block_context", (Object)ClipContext.Block.COLLIDER).forGetter(RaycastReplaceDiskEffect::blockContext), (App)EnchiridionCodecs.FLUID_RAYCAST_CONTEXT_CODEC.optionalFieldOf("fluid_context", (Object)ClipContext.Fluid.ANY).forGetter(RaycastReplaceDiskEffect::fluidContext), (App)BlockPredicate.CODEC.optionalFieldOf("predicate").forGetter(RaycastReplaceDiskEffect::predicate), (App)BlockStateProvider.CODEC.fieldOf("block_state").forGetter(RaycastReplaceDiskEffect::blockState), (App)BlockStateProvider.CODEC.fieldOf("block_state").forGetter(RaycastReplaceDiskEffect::blockState).dependent(RaycastReplaceDiskEffect::blockEntityTag, (MapEncoder)CompoundTag.CODEC.optionalFieldOf("block_entity"), blockState -> {
        BlockState state = blockState.getState(RandomSource.create((long)0L), BlockPos.ZERO);
        return new BlockEntityDecoder(state);
    }), (App)GameEvent.CODEC.optionalFieldOf("trigger_game_event").forGetter(RaycastReplaceDiskEffect::triggerGameEvent)).apply((Applicative)inst, RaycastReplaceDiskEffect::new));

    public void apply(ServerLevel level, int enchantmentLevel, EnchantedItemInUse item, Entity entity, Vec3 origin) {
        BlockPos blockPos = level.clip(new ClipContext(origin, origin.add(this.direction), this.blockContext, this.fluidContext, entity)).getBlockPos();
        RandomSource randomSource = entity.getRandom();
        int j = (int)this.radius.calculate(enchantmentLevel);
        int k = (int)this.height.calculate(enchantmentLevel);
        for (BlockPos blockPos2 : BlockPos.betweenClosed((BlockPos)blockPos.offset(-j, 0, -j), (BlockPos)blockPos.offset(j, Math.min(k - 1, 0), j))) {
            BlockState state;
            if (!(blockPos2.distToCenterSqr(origin.x(), (double)blockPos2.getY() + 0.5, origin.z()) < (double)Mth.square((int)j)) || !this.predicate.map(blockPredicate -> blockPredicate.test((Object)level, (Object)blockPos2)).orElse(true).booleanValue() || !level.setBlockAndUpdate(blockPos2, state = this.blockState.getState(randomSource, blockPos2))) continue;
            if (level.getBlockEntity(blockPos2) != null && this.blockEntityTag.isPresent()) {
                level.getBlockEntity(blockPos2).loadCustomOnly(this.blockEntityTag.get(), (HolderLookup.Provider)level.registryAccess());
            }
            this.triggerGameEvent.ifPresent(holder -> level.gameEvent(entity, holder, blockPos2));
        }
    }

    public MapCodec<RaycastReplaceDiskEffect> codec() {
        return CODEC;
    }

    private static class BlockEntityDecoder
    extends CompressorHolder
    implements MapDecoder<Optional<CompoundTag>> {
        private final BlockState blockState;

        public BlockEntityDecoder(BlockState blockState) {
            this.blockState = blockState;
        }

        public <T> DataResult<Optional<CompoundTag>> decode(DynamicOps<T> ops, MapLike<T> input) {
            if (input.get("block_entity") == null) {
                return DataResult.success(Optional.empty());
            }
            if (!(ops instanceof RegistryOps)) {
                return DataResult.error(() -> "BlockEntityDecoder requires registry context.");
            }
            final RegistryOps registryOps = (RegistryOps)ops;
            Block block = this.blockState.getBlock();
            if (!(block instanceof EntityBlock)) {
                return DataResult.error(() -> "Block " + String.valueOf(BuiltInRegistries.BLOCK.getKey((Object)this.blockState.getBlock())) + " does not have a block entity.");
            }
            EntityBlock entityBlock = (EntityBlock)block;
            BlockEntity blockEntity = entityBlock.newBlockEntity(BlockPos.ZERO, this.blockState);
            DataResult tagResult = CompoundTag.CODEC.decode(ops, input.get("block_entity"));
            try {
                if (tagResult.hasResultOrPartial()) {
                    blockEntity.loadCustomOnly((CompoundTag)((Pair)tagResult.resultOrPartial().get()).getFirst(), new HolderLookup.Provider(){

                        public Stream<ResourceKey<? extends Registry<?>>> listRegistries() {
                            throw new UnsupportedOperationException("listRegistries is not implemented.");
                        }

                        public <T> Optional<HolderLookup.RegistryLookup<T>> lookup(final ResourceKey<? extends Registry<? extends T>> registryKey) {
                            final Optional lookup = ((Accessor_RegistryOps)registryOps).enchiridion$getLookupProvider().lookup(registryKey);
                            if (lookup.isEmpty()) {
                                return Optional.empty();
                            }
                            return Optional.of(new HolderLookup.RegistryLookup<T>(){

                                public Optional<Holder.Reference<T>> get(ResourceKey<T> resourceKey) {
                                    return ((RegistryOps.RegistryInfo)lookup.get()).getter().get(resourceKey);
                                }

                                public Optional<HolderSet.Named<T>> get(TagKey<T> tagKey) {
                                    return ((RegistryOps.RegistryInfo)lookup.get()).getter().get(tagKey);
                                }

                                public Stream<Holder.Reference<T>> listElements() {
                                    HolderGetter holderGetter = ((RegistryOps.RegistryInfo)lookup.get()).getter();
                                    if (!(holderGetter instanceof Registry)) {
                                        return Stream.empty();
                                    }
                                    Registry registry = (Registry)holderGetter;
                                    return registry.holders().map(reference -> reference);
                                }

                                public Stream<HolderSet.Named<T>> listTags() {
                                    HolderGetter holderGetter = ((RegistryOps.RegistryInfo)lookup.get()).getter();
                                    if (!(holderGetter instanceof Registry)) {
                                        return Stream.empty();
                                    }
                                    Registry registry = (Registry)holderGetter;
                                    return registry.getTags().map(tagKeyNamedPair -> (HolderSet.Named)tagKeyNamedPair.getSecond());
                                }

                                public ResourceKey<? extends Registry<T>> key() {
                                    return registryKey;
                                }

                                public Lifecycle registryLifecycle() {
                                    return ((RegistryOps.RegistryInfo)lookup.get()).elementsLifecycle();
                                }
                            });
                        }
                    });
                }
            }
            catch (Exception ex) {
                return DataResult.error(() -> "Exception whilst validating block entity tag. " + ex.getMessage());
            }
            return tagResult.map(pair -> Optional.of((CompoundTag)pair.getFirst()));
        }

        public <T> Stream<T> keys(DynamicOps<T> ops) {
            return Stream.empty();
        }
    }
}

