/*
 * Decompiled with CFR 0.152.
 */
package house.greenhouse.enchiridion.api.enchantment.effect.entity;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.EnchantedItemInUse;
import net.minecraft.world.item.enchantment.LevelBasedValue;
import net.minecraft.world.item.enchantment.effects.EnchantmentEntityEffect;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public record ShieldDisableEffect(LevelBasedValue duration) implements EnchantmentEntityEffect
{
    public static final MapCodec<ShieldDisableEffect> CODEC = RecordCodecBuilder.mapCodec(inst -> inst.group((App)LevelBasedValue.CODEC.fieldOf("duration").forGetter(ShieldDisableEffect::duration)).apply((Applicative)inst, ShieldDisableEffect::new));

    public void apply(@NotNull ServerLevel serverLevel, int level, @NotNull EnchantedItemInUse enchantedItem, @NotNull Entity entity, @NotNull Vec3 origin) {
        int i = Mth.floor((float)this.duration.calculate(level));
        if (entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            if (living instanceof Player) {
                Player player = (Player)living;
                player.getCooldowns().addCooldown(Items.SHIELD, i);
            }
            if (living.isBlocking()) {
                living.stopUsingItem();
                living.level().broadcastEntityEvent((Entity)living, (byte)30);
            }
        }
    }

    @NotNull
    public MapCodec<ShieldDisableEffect> codec() {
        return CODEC;
    }
}

