/*
 * Decompiled with CFR 0.152.
 */
package house.greenhouse.enchiridion.api.enchantment.effect.entity;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import house.greenhouse.enchiridion.entity.Whirlpool;
import house.greenhouse.enchiridion.registry.EnchiridionEntityTypes;
import java.util.Optional;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.enchantment.EnchantedItemInUse;
import net.minecraft.world.item.enchantment.LevelBasedValue;
import net.minecraft.world.item.enchantment.effects.EnchantmentEntityEffect;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public record SummonWhirlpoolEffect(LevelBasedValue width, LevelBasedValue height, LevelBasedValue summonSpeed, LevelBasedValue lifetime, LevelBasedValue damageAmount, Optional<LootItemCondition> disperseCondition) implements EnchantmentEntityEffect
{
    public static final MapCodec<SummonWhirlpoolEffect> CODEC = RecordCodecBuilder.mapCodec(inst -> inst.group((App)LevelBasedValue.CODEC.fieldOf("width").forGetter(SummonWhirlpoolEffect::width), (App)LevelBasedValue.CODEC.fieldOf("height").forGetter(SummonWhirlpoolEffect::height), (App)LevelBasedValue.CODEC.optionalFieldOf("summon_speed", (Object)LevelBasedValue.constant((float)0.04f)).forGetter(SummonWhirlpoolEffect::summonSpeed), (App)LevelBasedValue.CODEC.fieldOf("lifetime").forGetter(SummonWhirlpoolEffect::lifetime), (App)LevelBasedValue.CODEC.fieldOf("damage_amount").forGetter(SummonWhirlpoolEffect::damageAmount), (App)LootItemCondition.DIRECT_CODEC.optionalFieldOf("disperse_condition").forGetter(SummonWhirlpoolEffect::disperseCondition)).apply((Applicative)inst, SummonWhirlpoolEffect::new));

    public void apply(@NotNull ServerLevel level, int enchantmentLevel, @NotNull EnchantedItemInUse item, @NotNull Entity entity, @NotNull Vec3 origin) {
        Whirlpool whirlpool = (Whirlpool)EnchiridionEntityTypes.WHIRLPOOL.create((Level)level);
        if (whirlpool == null) {
            return;
        }
        whirlpool.setPos(entity.position());
        whirlpool.setOwner(entity);
        whirlpool.setEnchantmentLevel(enchantmentLevel);
        whirlpool.setCurrentWidth(0.0f);
        whirlpool.setTargetWidth(this.width.calculate(enchantmentLevel));
        whirlpool.setCurrentHeight(0.0f);
        whirlpool.setTargetHeight(this.height.calculate(enchantmentLevel));
        whirlpool.setSummonSpeed(this.summonSpeed.calculate(enchantmentLevel));
        whirlpool.setLifetime(Mth.floor((float)this.lifetime.calculate(enchantmentLevel)));
        whirlpool.setDamageAmount(this.damageAmount.calculate(enchantmentLevel));
        this.disperseCondition.ifPresent(whirlpool::setDisperseCondition);
        level.addFreshEntity((Entity)whirlpool);
    }

    @NotNull
    public MapCodec<? extends EnchantmentEntityEffect> codec() {
        return CODEC;
    }
}

