/*
 * Decompiled with CFR 0.152.
 */
package house.greenhouse.enchiridion.api.enchantment.provider;

import com.google.common.collect.Lists;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import house.greenhouse.enchiridion.Enchiridion;
import house.greenhouse.enchiridion.EnchiridionConfig;
import house.greenhouse.enchiridion.api.enchantment.category.EnchantmentCategory;
import house.greenhouse.enchiridion.util.EnchantmentCategoryUtil;
import house.greenhouse.enchiridion.util.EnchantmentInstanceWithCategory;
import house.greenhouse.enchiridion.util.WeightedEnchantmentCategories;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.RegistryCodecs;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.random.WeightedEntry;
import net.minecraft.util.random.WeightedRandomList;
import net.minecraft.util.valueproviders.ConstantInt;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.EnchantmentInstance;
import net.minecraft.world.item.enchantment.providers.EnchantmentProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EnchantFromTable
implements EnchantmentProvider {
    public static final ResourceLocation ID = Enchiridion.id("enchant_from_table");
    public static final MapCodec<EnchantFromTable> CODEC = RecordCodecBuilder.mapCodec(inst -> inst.group((App)IntProvider.POSITIVE_CODEC.optionalFieldOf("amount", (Object)ConstantInt.of((int)1)).forGetter(EnchantFromTable::getAmount), (App)RegistryCodecs.homogeneousList((ResourceKey)Registries.ENCHANTMENT).fieldOf("enchantments").forGetter(EnchantFromTable::getEnchantments), (App)WeightedRandomList.codec(WeightedEnchantmentCategories.CODEC).fieldOf("categories").forGetter(EnchantFromTable::getCategories), (App)Codec.BOOL.optionalFieldOf("allow_duplicate_categories", (Object)false).forGetter(EnchantFromTable::shouldAllowDuplicateCategories)).apply((Applicative)inst, EnchantFromTable::new));
    private final IntProvider amount;
    private final HolderSet<Enchantment> enchantments;
    private final WeightedRandomList<WeightedEnchantmentCategories> categories;
    private final boolean allowDuplicateCategories;
    private int level = 0;

    public EnchantFromTable(IntProvider amount, HolderSet<Enchantment> enchantments, WeightedRandomList<WeightedEnchantmentCategories> categories, boolean allowDuplicateCategories) {
        this.amount = amount;
        this.enchantments = enchantments;
        this.categories = categories;
        this.allowDuplicateCategories = allowDuplicateCategories;
    }

    public IntProvider getAmount() {
        return this.amount;
    }

    public HolderSet<Enchantment> getEnchantments() {
        return this.enchantments;
    }

    public WeightedRandomList<WeightedEnchantmentCategories> getCategories() {
        return this.categories;
    }

    public boolean shouldAllowDuplicateCategories() {
        return this.allowDuplicateCategories;
    }

    public void setLevel(int level) {
        this.level = level;
    }

    public void enchant(@NotNull ItemStack stack, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull ItemEnchantments.Mutable mutable, @NotNull RandomSource random, @NotNull DifficultyInstance difficulty) {
        if (this.level > 0) {
            boolean hasAddedAdditionalEnchantment = false;
            ArrayList<Holder<Enchantment>> operatedEnchantments = new ArrayList<Holder<Enchantment>>();
            ArrayList<Holder<EnchantmentCategory>> operatedCategories = new ArrayList<Holder<EnchantmentCategory>>();
            ArrayList<EnchantmentInstance> instances = new ArrayList<EnchantmentInstance>();
            int am = this.amount.sample(random);
            for (int i = 0; i < am; ++i) {
                EnchantmentInstance inst;
                ArrayList<EnchantmentInstance> allowedEnchantments = new ArrayList<EnchantmentInstance>(this.getAllowedEnchantments(stack).stream().filter(enchantmentInstance -> !operatedEnchantments.contains(enchantmentInstance.enchantment)).toList());
                if (allowedEnchantments.isEmpty() || (inst = this.handleEnchantment(operatedCategories, operatedEnchantments, allowedEnchantments, random)) == null) continue;
                instances.add(inst);
                allowedEnchantments.removeIf(allowedInst -> allowedInst.enchantment.equals((Object)inst.enchantment));
                if (!hasAddedAdditionalEnchantment && random.nextInt(50) <= Mth.floor((float)((float)this.level / 1.5f))) {
                    EnchantmentInstance extraInst;
                    if (!allowedEnchantments.isEmpty()) {
                        EnchantmentHelper.filterCompatibleEnchantments(allowedEnchantments, (EnchantmentInstance)inst);
                    }
                    if (allowedEnchantments.isEmpty() || (extraInst = this.handleEnchantment(operatedCategories, operatedEnchantments, allowedEnchantments, random)) == null) break;
                    instances.add(extraInst);
                    hasAddedAdditionalEnchantment = true;
                }
                this.level = Mth.floor((float)((float)this.level / 1.5f));
            }
            for (EnchantmentInstance instance : instances) {
                if (mutable.getLevel(instance.enchantment) >= instance.level) continue;
                mutable.upgrade(instance.enchantment, instance.level);
                if (!(instance instanceof EnchantmentInstanceWithCategory)) continue;
                EnchantmentInstanceWithCategory categoryInstance = (EnchantmentInstanceWithCategory)instance;
                EnchantmentCategoryUtil.updateCategories(stack, categories -> categories.overwrite(categoryInstance.category, (Holder<Enchantment>)instance.enchantment));
            }
        }
        this.level = 0;
    }

    private EnchantmentInstance handleEnchantment(List<Holder<EnchantmentCategory>> operatedCategories, List<Holder<Enchantment>> operatedEnchantments, List<EnchantmentInstance> allowedEnchantments, RandomSource random) {
        List<EnchantmentInstance> filteredCategoricalEnchantment;
        Holder<EnchantmentCategory> category = this.chooseCategory(operatedCategories, allowedEnchantments, random);
        if (category == null) {
            return null;
        }
        Holder<EnchantmentCategory> finalCategory = category;
        List<EnchantmentInstance> list = filteredCategoricalEnchantment = ((EnchiridionConfig)Enchiridion.CONFIG.getOrThrow()).common().enableCategories() ? allowedEnchantments.stream().filter(enchantmentInstance -> ((EnchantmentCategory)finalCategory.value()).acceptedEnchantments().contains(enchantmentInstance.enchantment)).map(enchantmentInstance -> new EnchantmentInstanceWithCategory((EnchantmentInstance)enchantmentInstance, category)).toList() : allowedEnchantments;
        if (filteredCategoricalEnchantment.isEmpty()) {
            return null;
        }
        EnchantmentInstance enchantment = filteredCategoricalEnchantment.get(random.nextInt(filteredCategoricalEnchantment.size()));
        operatedCategories.add(category);
        operatedEnchantments.add((Holder<Enchantment>)enchantment.enchantment);
        return enchantment;
    }

    @Nullable
    private Holder<EnchantmentCategory> chooseCategory(List<Holder<EnchantmentCategory>> operatedCategories, List<EnchantmentInstance> allowedEnchantments, RandomSource random) {
        WeightedRandomList potentialCategories = WeightedRandomList.create(this.categories.unwrap().stream().flatMap(categories -> categories.getCategories().stream().map(categoryHolder -> WeightedEntry.wrap((Object)categoryHolder, (int)categories.getWeight().asInt()))).filter(category -> ((Holder)category.data()).isBound() && ((EnchantmentCategory)((Holder)category.data()).value()).acceptedEnchantments().stream().anyMatch(enchantmentHolder -> allowedEnchantments.stream().anyMatch(enchantmentInstance -> enchantmentHolder.equals((Object)enchantmentInstance.enchantment))) && (this.allowDuplicateCategories || new HashSet(operatedCategories).containsAll(this.categories.unwrap().stream().flatMap(categories -> categories.getCategories().stream()).toList()) || !operatedCategories.contains(category.data())) && this.enchantments.stream().anyMatch(enchantment -> ((EnchantmentCategory)((Holder)category.data()).value()).acceptedEnchantments().contains(enchantment))).sorted(Comparator.comparingInt(value -> ((EnchantmentCategory)((Holder)value.data()).value()).priority())).toList());
        if (potentialCategories.isEmpty()) {
            return null;
        }
        Optional optional = potentialCategories.getRandom(random);
        return optional.map(WeightedEntry.Wrapper::data).orElse(null);
    }

    private List<EnchantmentInstance> getAllowedEnchantments(ItemStack stack) {
        ArrayList list = Lists.newArrayList();
        boolean flag = stack.is(Items.BOOK);
        this.enchantments.stream().filter(enchantment -> Enchiridion.getHelper().isPrimaryItem(stack, (Holder<Enchantment>)enchantment) || flag).forEach(holder -> {
            Enchantment enchantment = (Enchantment)holder.value();
            for (int i = enchantment.getMaxLevel(); i >= enchantment.getMinLevel(); --i) {
                if (this.level < enchantment.getMinCost(i) || this.level > enchantment.getMaxCost(i)) continue;
                list.add(new EnchantmentInstance(holder, i));
                break;
            }
        });
        return list;
    }

    @NotNull
    public MapCodec<EnchantFromTable> codec() {
        return CODEC;
    }
}

