/*
 * Decompiled with CFR 0.152.
 */
package house.greenhouse.enchiridion.api.loot.condition;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParam;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionType;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public record CollidingLootCondition(Vec3 expansion, boolean expandsTowardsMovement, BlockPredicate predicate) implements LootItemCondition
{
    public static final MapCodec<CollidingLootCondition> CODEC = RecordCodecBuilder.mapCodec(inst -> inst.group((App)Vec3.CODEC.optionalFieldOf("expansion", (Object)Vec3.ZERO).forGetter(CollidingLootCondition::expansion), (App)Codec.BOOL.optionalFieldOf("expands_towards_movement", (Object)false).forGetter(CollidingLootCondition::expandsTowardsMovement), (App)BlockPredicate.CODEC.fieldOf("predicate").forGetter(CollidingLootCondition::predicate)).apply((Applicative)inst, CollidingLootCondition::new));
    public static final LootItemConditionType TYPE = new LootItemConditionType(CODEC);

    public LootItemConditionType getType() {
        return TYPE;
    }

    public boolean test(LootContext lootContext) {
        Entity entity = (Entity)lootContext.getParam(LootContextParams.THIS_ENTITY);
        AABB boundingBox = entity.getBoundingBox().inflate(this.expansion.x(), this.expansion.y(), this.expansion.z());
        if (this.expandsTowardsMovement) {
            boundingBox = boundingBox.expandTowards(entity.getDeltaMovement());
        }
        return BlockPos.betweenClosedStream((AABB)boundingBox).anyMatch(pos -> this.predicate.test((Object)lootContext.getLevel(), (Object)pos.immutable()));
    }

    public Set<LootContextParam<?>> getReferencedContextParams() {
        return Set.of(LootContextParams.THIS_ENTITY);
    }

    public static class Builder
    implements LootItemCondition.Builder {
        private Vec3 expansion = Vec3.ZERO;
        private boolean expandsTowardsMovement = false;
        private BlockPredicate predicate = BlockPredicate.alwaysTrue();

        protected Builder(BlockPredicate predicate) {
            this.predicate = predicate;
        }

        public static Builder builder(BlockPredicate predicate) {
            return new Builder(predicate);
        }

        public Builder expansion(Vec3 expansion) {
            this.expansion = expansion;
            return this;
        }

        public Builder expandTowardsMovement() {
            this.expandsTowardsMovement = true;
            return this;
        }

        public Builder predicate(BlockPredicate predicate) {
            this.predicate = predicate;
            return this;
        }

        public CollidingLootCondition build() {
            return new CollidingLootCondition(this.expansion, this.expandsTowardsMovement, this.predicate);
        }
    }
}

