/*
 * Decompiled with CFR 0.152.
 */
package house.greenhouse.enchiridion.api.loot.condition;

import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Set;
import net.minecraft.core.Holder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.LevelBasedValue;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParam;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionType;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.NumberProviders;

public record EnchiridionLootItemRandomChanceWithAddedEnchantedBonusCondition(NumberProvider unenchantedChance, LevelBasedValue enchantedChance, Holder<Enchantment> enchantment) implements LootItemCondition
{
    public static final MapCodec<EnchiridionLootItemRandomChanceWithAddedEnchantedBonusCondition> CODEC = RecordCodecBuilder.mapCodec(inst -> inst.group((App)NumberProviders.CODEC.fieldOf("unenchanted_chance").forGetter(EnchiridionLootItemRandomChanceWithAddedEnchantedBonusCondition::unenchantedChance), (App)LevelBasedValue.CODEC.fieldOf("enchanted_chance").forGetter(EnchiridionLootItemRandomChanceWithAddedEnchantedBonusCondition::enchantedChance), (App)Enchantment.CODEC.fieldOf("enchantment").forGetter(EnchiridionLootItemRandomChanceWithAddedEnchantedBonusCondition::enchantment)).apply((Applicative)inst, EnchiridionLootItemRandomChanceWithAddedEnchantedBonusCondition::new));
    public static final LootItemConditionType TYPE = new LootItemConditionType(CODEC);

    public LootItemConditionType getType() {
        return TYPE;
    }

    public Set<LootContextParam<?>> getReferencedContextParams() {
        return ImmutableSet.of((Object)LootContextParams.ATTACKING_ENTITY);
    }

    public boolean test(LootContext context) {
        int n;
        Entity entity = (Entity)context.getParamOrNull(LootContextParams.ATTACKING_ENTITY);
        if (entity instanceof LivingEntity) {
            LivingEntity livingentity = (LivingEntity)entity;
            n = EnchantmentHelper.getEnchantmentLevel(this.enchantment, (LivingEntity)livingentity);
        } else {
            n = 0;
        }
        int i = n;
        float f = this.enchantedChance.calculate(i) + this.unenchantedChance.getFloat(context);
        return context.getRandom().nextFloat() < f;
    }
}

